(ns materia.middleware.db
  (:require [materia.db :as db]))

(defn wrap-with-connection-source
  [handler connection-source]
  (fn [req]
    (db/with-connection-source connection-source
      (handler req))))

(defn wrap-sql-logger [handler]
  (fn [req]
    (db/with-sql-logger
      (handler req))))
