(ns materia.logging
  (:require [io.aviso.logging :refer [install-pretty-logging
                                      install-uncaught-exception-handler]]
            [materia.util.namespace :refer [import-ns]]
            [unilog.config :as unilog]))

(def default-conf {:level "info"
                   :console "%d{yyyy-MM-dd HH:mm:ss.SSS} %highlight(%5p) [%15.15t] %cyan(%-40.40logger{39}) : %m%n"})

(defn start-logging! [conf]
  (unilog/start-logging! (merge default-conf conf)))

(start-logging! nil)

(import-ns clojure.tools.logging)
(install-pretty-logging)
(install-uncaught-exception-handler)
