(ns materia.util.namespace
  (:require [potemkin.namespaces :refer [import-vars]])
  (:import java.io.FileNotFoundException))

(defmacro import-ns
  "Imports all vars in another namespace."
  [ns]
  (require ns)
  `(do
     (require (quote ~ns))
     (import-vars ~(into [ns] (keys (ns-publics ns))))))

(defn contains-tagged-var? [ns meta-key]
  (some? (some #(get (meta %) meta-key) (vals (ns-interns ns)))))

(defn find-ns-contains-tagged-var [meta-keys]
  (->> (all-ns)
       (filter (apply some-fn (map #(fn [ns]
                                      (contains-tagged-var? ns %))
                                   meta-keys)))
       (map ns-name)))

(defn find-tagged-vars [meta-key]
  (->> (all-ns)
       (mapcat #(vals (ns-interns %)))
       (filter #(get (meta %) meta-key))))
