(ns materia.component.db
  (:require [com.stuartsierra.component :as c]
            [hikari-cp.core :as pool]
            [jdbc.proto :as jproto]
            [materia.logging :as log]
            [materia.util.db :as ud]))

(defn- make-datasource [{:keys [use-pool?] :as spec}]
  (let [spec (dissoc spec :use-pool?)]
    (if use-pool?
      (pool/make-datasource (ud/dbspec->hikari-cp-spec spec))
      (ud/make-simple-datasource spec))))

(defrecord Database [dbspec datasource]
  jproto/IConnection
  (connection [this]
    (jproto/connection datasource))
  c/Lifecycle
  (start [this]
    (log/info "Starting database")
    (if datasource
      this
      (assoc this :datasource (make-datasource dbspec))))
  (stop [this]
    (log/info "Stopping database")
    (if (not datasource)
      this
      (do
        (if (instance? java.io.Closeable datasource)
          (.close datasource))
        (assoc this :datasource nil)))))

(defn new-database [conf]
  (map->Database {:dbspec (:db conf)}))
