(ns materia.middleware.routing
  (:require [materia.routing :as routing]))

(defn- remove-trailing-slash [s]
  (if (and (string? s)
           (not= s "/")
           (.endsWith ^String s "/"))
    (apply str (butlast s))
    s))

(defn wrap-ignore-trailing-slash
  "Modifies the request uri before calling the handler. Removes a
  single trailing slash from the end of the uri if present."
  [handler]
  (fn [req]
    (handler (-> req
                 (update-in [:uri] remove-trailing-slash)
                 (update-in [:path-info] remove-trailing-slash)))))

(defn wrap-routing
  [handler route]
  (fn [req]
    (let [req (assoc req :materia/route route)]
      (if-let [{:keys [route-params] :as matched} (routing/match-request route req)]
        (-> req
            (update-in [:route-params] (fnil merge {}) route-params)
            (update-in [:params] (fnil merge {}) route-params)
            (assoc :materia/routing (select-keys matched [:handler :route-params]))
            (handler))
        (handler req)))))
