(ns matross.mapspace
  (:import clojure.lang.Associative
           clojure.lang.IFn
           clojure.lang.ILookup
           clojure.lang.IPersistentCollection
           clojure.lang.IPersistentMap
           clojure.lang.MapEntry
           clojure.lang.Seqable
           clojure.lang.SeqIterator))

(defn- full-key [ms k]
  (let [ks (name k)
        ns-sep (. ms ns-sep)
        ns-pos (. ks indexOf ns-sep)]
    (if (not (= ns-pos -1))
      (if (= ns-pos (. ks lastIndexOf ns-sep))
        k
        (throw (IllegalArgumentException. "Can't deal with nested namespaces"))        )
      (->> [(. ms default-ns) k]
          (map name)
          (clojure.string/join (str (. ms ns-sep)))
          keyword))))

(deftype Mapspace [value default-ns ns-sep]
  ILookup
  (valAt [this k] (. this valAt k nil))
  (valAt [this k not-found]
    (get value (full-key this k) not-found))

  Associative
  (containsKey [this k]
    (contains? value (full-key this k)))

  (entryAt [this k]
    (. value entryAt (full-key this k)))
  
  (assoc [this k v]
    (Mapspace. (assoc value (full-key this k) v) default-ns ns-sep))

  IFn
  (invoke [this k] (. this valAt k))
  (invoke [this k not-found] (. this valAt k not-found))

  Seqable
  (seq [this] (. value seq))

  IPersistentCollection
  (count [this] (count value))
  (empty [this] (Mapspace. {} default-ns ns-sep))
  (equiv [this o] (= value o))
  (cons [this o] (Mapspace. (conj value (MapEntry. (full-key this (key o)) (val o)))
                            default-ns
                            ns-sep))

  IPersistentMap
  (assocEx [this k v] (. value assocEx (full-key this k) v))
  (without [this k] (. value without (full-key this k)))

  Iterable
  (iterator [this] (SeqIterator. (.seq this)))

)



(defn mapspace
  ([] (mapspace {}))
  ([value] (Mapspace. value :default "::"))
  ([value default-ns] (Mapspace. value default-ns "::"))
  ([value default-ns ns-sep] (Mapspace. value default-ns ns-sep)))
