(ns qliksense.api
  (:require
   [clojure.java.io :as io]
   [hato.client :as hc]
   [clojure.tools.logging :as log]
   [cheshire.core :refer :all]
            )
)

(defn request
  [system_map params opts]
  (log/info (opts :url))
  (let [client (merge opts
                      {:as :json
                       :connect-timeout 5000
                       :content-type :json
                       :query-params (merge params {:xrfkey "0123456789abcdef"})
                       :headers {"x-qlik-xrfkey" "0123456789abcdef" "X-Qlik-User" "UserDirectory=internal;UserId=sa_repository"}
                       :http-client {:ssl-context  {:keystore (io/resource (system_map "keystore"))
                                                    :keystore-pass (system_map "keystore-pass")
                                                    :trust-store (io/resource (system_map "trust-store"))
                                                    :trust-store-pass (system_map "trust-store-pass")
                                                    }}
                       :redirect-policy :always})]
    (hc/request client)))

;;(println (slurp (:body response)))))

(defn get-request
  "http get request"
  [system_map path params & args]
  (request system_map params {:url (str (system_map "base-url") path)
                       :method :get}))

(defn post-request
  "http get request"
  [system_map path params body & args]
  (let [body-str (if (string? body)
                   body
                   (generate-string body))]
    (request system_map
             params
             {:url (str (system_map "base-url") path)
              :method :post
              :body body-str})))

(defn put-request
  "http get request"
  [system_map path params body & args]
  (request system_map
           params
           {:url (str (system_map "base-url") path)
            :method :put
            :body body}))

(defn delete-request
  "http get request"
  [system_map path params & args]
  (request system_map
           params
           {:url (str (system_map "base-url") path)
            :method :delete}))
