(ns qliksense.license
  (:require
   [cheshire.core :refer :all]
   [qliksense.api :as api])
)

(defn extract-user-userids
  ""
  [list]
  (map :user list))

(defn deallocate-license
  "remove-analyzer-licenses-for-professiona-users"
  [{:keys [config system licensetype id]}]
  (let [system_map ((config "systems") system)
        url (str "/qrs/license/" licensetype "accesstype/" id)
        resp (api/delete-request system_map url {})
        ]
    (println resp)
    ))

(defn filter-licenses-by-user
  ""
  [licenses user]
  (nth (filter #(= (get-in % [:user :name]) user) licenses) 0) )

(defn remove-analyzer-licenses-for-professional-users
  "remove-analyzer-licenses-for-professiona-users"
  [{:keys [config system run]}]
  (let [system_map ((config "systems") system)
        ;; extract professional users
        professional-licenses-resp (api/get-request system_map "/qrs/license/professionalaccesstype/full" {})
        professional-licenses (professional-licenses-resp :body)
        professional-users (map #(get-in % [:user :name])
                                professional-licenses)

        ;; extract analyzer users
        analyzer-licenses-resp (api/get-request system_map "/qrs/license/analyzeraccesstype/full" {})
        analyzer-licenses (analyzer-licenses-resp :body)
        analyzer-users (map #(get-in % [:user :name])
                            analyzer-licenses)

        ;; users in both lists have double licenses
        tobe-deleted-users (clojure.set/intersection (set analyzer-users)
                                                     (set professional-users))
        tobe-deleted-licenses (map #(filter-licenses-by-user analyzer-licenses %)
                                   tobe-deleted-users)
        urls (map #(str "/qrs/license/analyzeraccesstype/" (get-in % [:id]))
                  tobe-deleted-licenses)
        ]
    (println (generate-string tobe-deleted-users {:pretty true}))

    (if run
      (doseq [u urls]
        (api/delete-request system_map (str u) {})))))
