(ns qliksense.user
  (:require
   [cheshire.core :refer :all]
   [qliksense.api :as api])
)



(defn rm-externally-removed-users
  "remove-analyzer-licenses-for-professiona-users"
  [{:keys [config system run]}]
  (let [system_map ((config "systems") system)
        users-resp (api/get-request system_map
                                    "/qrs/user"
                                    {:filter "removedExternally eq True"})
        users (users-resp :body)
        ]
    (println (generate-string users {:pretty true}))

    (if run
      (doseq [u users]
        (api/delete-request system_map (str "/qrs/user/" (u :id)) {})))))
