(ns matteoredaelli.qliksense.api
  (:require
   [clojure.java.io :as io]
   [hato.client :as hc]
   [clojure.tools.logging :as log]
   [cheshire.core :refer :all]
            )
)

(defn request
  [system_map params opts]
  (log/info (opts :url))
  (let [client (merge opts
                      {:as :json
                       :connect-timeout 5000
                       :content-type :json
                       :query-params (merge params {:xrfkey "0123456789abcdef"})
                       :headers {"x-qlik-xrfkey" "0123456789abcdef" "X-Qlik-User" "UserDirectory=internal;UserId=sa_repository"}
                       :http-client {:ssl-context  {:keystore (io/file (:keystore system_map))
                                                    :keystore-pass (:keystore-pass system_map)
                                                    :trust-store (io/file (:trust-store system_map ))
                                                    :trust-store-pass (:trust-store-pass system_map)
                                                    }}
                       :redirect-policy :always})]
    (hc/request client)))

;;(println (slurp (:body response)))))

(defn get-request
  "http get request"
  [system_map url params & args]
  (request system_map params {:url url
                              :method :get}))

(defn post-request
  "http get request"
  [system_map url params body & args]
  (let [body-str (if (string? body)
                   body
                   (generate-string body))]
    (request system_map
             params
             {:url url
              :method :post
              :body body-str})))

(defn put-request
  "http get request"
  [system_map url params body & args]
  (request system_map
           params
           {:url url
            :method :put
            :body body}))

(defn delete-request
  "http get request"
  [system_map url params & args]
  (request system_map
           params
           {:url url
            :method :delete}))
