(ns matteoredaelli.qliksense.import
  (:require
   [cheshire.core :refer :all]
   [matteoredaelli.qliksense.custom-property :as cp]
   [matteoredaelli.qliksense.utils :as utils]
   [matteoredaelli.qliksense.api :as api])
)

(defn import-many
  ""
  [{:keys [config system ids infile run outfile]}]
  (let [system_map ((config "systems") system)
        body-id (if ids
                  infile
                  (utils/remove-ids infile))
        body (utils/entity-with-keywords body-id)
        schemaPath (utils/get-entity-type body)
        path (str "/qrs/" (clojure.string/lower-case schemaPath))
        ]
    (println (encode body ))
    (println path)
    (if run
      (doseq [b body]
        (println (encode b))
        (let [resp (api/post-request system_map path {} b)]
          (utils/out-string resp outfile))))))

(defn safe-import-entity
  "TODO: remove /update owner?!?! what happens if he/she does not exists"
  [{:keys [entity entity-type target-entities custom-property-definitions system_map run]}]

  (let [entity-with-new-custom-properties
        (if custom-property-definitions
          (cp/copy-custom-properties-from-entity entity custom-property-definitions)
          (dissoc entity :customProperties))
        find-resp (utils/find-corresponding-target-entity entity-with-new-custom-properties
                                                    target-entities)
        path (str "/qrs/" entity-type)]
    (if run
       (case find-resp
         :not-found
         (api/post-request system_map
                           path
                           {}
                           entity-with-new-custom-properties)
         :not-found-but-1-with-same-id
         (api/post-request system_map
                           path
                           {}
                           (dissoc entity-with-new-custom-properties :id))
         ;; else
         (api/put-request system_map
                           (str path "/" (:id find-resp))
                           {}
                           (assoc entity-with-new-custom-properties (:id find-resp)))))))


(defn safe-import-entities
  [source-entities system_map  & {:keys [with-custom-properties run]}]
  (let [entity-type (utils/get-entity-type source-entities)
        path (str "/qrs/" entity-type "/full")
        target-entities  (api/get-request system_map path {})
        custom-property-definitions (if (and with-custom-properties
                                              (not= "customPropertyDefinition" entity-type))
                                       (api/get-request system_map (str "/qrs/customPropertyDefinition/full") {})
                                       false)]
    (doseq [entity source-entities]
       (safe-import-entity
        {:entity entity
         :entity-type entity-type
         :target-entities target-entities
         :custom-property-definitions custom-property-definitions
         :system_map system_map
         :run run})
    )))
