(ns matteoredaelli.qliksense.user
  (:require
   [cheshire.core :refer :all]
   [matteoredaelli.qliksense.api :as api])
)

(defn rm-externally-removed-users
  "remove-analyzer-licenses-for-professiona-users"
  [{:keys [config system url run]}]
  (let [system_map (get-in config [:systems system])
        users-resp (api/get-request system_map
                                    (str url "/qrs/user")
                                    {:filter "removedExternally eq True"})
        users (users-resp :body)
        ]
    (println (generate-string users {:pretty true}))

    (if run
      (doseq [u users]
        (api/delete-request system_map (str url "/qrs/user/" (u :id)) {})))))
