(ns matteoredaelli.qliksense.utils
  (:require
   [cheshire.core :refer :all]
   [matteoredaelli.qliksense.api :as api])
)

(defn remove-ids
  "remove id from list"
  [a-list]
  (map #(dissoc % :id) a-list))


(defn out-string
  "s"
  [data filename]
  (let [string (if-not (string? data)
                       (generate-string data {:pretty true})
                       data)]
    (if filename
      (spit filename string)
      (println string))))

(defn get-entity-type
  [list_or_map]
  (let [entity (if (map? list_or_map)
                 list_or_map
                 (nth list_or_map 0))
        schema-path (:schemaPath entity)]
    (if schema-path
      schema-path
      (if (:choiceValues entity)
        "customPropertyDefinition"
        :unkwnon))))

(defn get-entity-name
  [entity]
  (let [name (:name entity)
        entity-type (:schemaPath entity)]
    (if name
      name
     (case entity-type
      :virtualProxyConfig (get :description entity)
      :proxyService (get-in entity [:serverNodeConfiguration :name]))
     ;; TODO
     )))



(defn filter-entities-by-name
  ""
  [entities name]
  (filter #(= (get-entity-name %)
              name)
          entities))

(defn filter-entities-by-key-value
  ""
  [entities key value]
  (filter #(= (key %) value)
          entities))

(defn filter-entities-by-id
  ""
  [entities value]
  (filter #(= (:id %) value)
          entities))


(defn same-name-entities
  [entity1 entity2]
  (= (get-entity-name entity1) (get-entity-name entity2)))


(defn entity-with-keywords
  "transform a vector/map into a vector/map with keywords. "
  [amap]
  (-> amap
      generate-string
      (parse-string true)))


(defn find-corresponding-target-entity
  [entity target-entities]
  (let [id (:id entity)
        name (get-entity-name entity)
        entities-with-same-id (filter-entities-by-id target-entities id)
        count-same-id (count entities-with-same-id)
        entities-with-same-name (filter-entities-by-name target-entities name)
        count-same-name (count entities-with-same-name)
        ]
    (assert (<= count-same-id 1))
    (assert (<= count-same-name 1))
    (cond
        (= count-same-name 1) (nth entities-with-same-name 0)
        (= count-same-id 1) :not-found-but-1-with-same-id
        :else :not-found)))

(defn diff-entities
  "compare entities"
  [source-entities target-entities]
  ())
