(ns matthiasn.systems-toolbox.log
        (:gen-class)
  (:require [matthiasn.systems-toolbox.component :as comp]
                  [clojure.tools.logging :as log]))

                              

(defn mk-state
  "Return clean initial component state atom."
  [_]
  (atom {}))

(defn in-handler
  "Handle incoming messages: process / add to application state."
  [_ _ msg]
        (log/info (meta msg) msg)
                                             )

(defn component
  [cmp-id]
  (comp/make-component cmp-id mk-state in-handler nil))

;;;;;;;;;;;; This file autogenerated from src/cljx/matthiasn/systems_toolbox/log.cljx
