/*
 * Decompiled with CFR 0.152.
 */
package maven.clojure.extractor;

import clojure.lang.RT;
import clojure.lang.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;

public class ClojureMojoDescriptorExtractor
implements MojoDescriptorExtractor {
    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        return this.execute((PluginToolsRequest)new DefaultPluginToolsRequest(project, pluginDescriptor));
    }

    public List execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        MavenProject project = request.getProject();
        ArrayList<String> sources = new ArrayList<String>();
        Iterator i = project.getCompileSourceRoots().iterator();
        while (i.hasNext()) {
            String source = (String)i.next();
            sources.add(source);
            if (!source.endsWith("/java")) continue;
            sources.add(source.replace("/java", "/clojure"));
        }
        try {
            Var require = RT.var((String)"clojure.core", (String)"require");
            Var symbol = RT.var((String)"clojure.core", (String)"symbol");
            require.invoke(symbol.invoke((Object)"maven.clojure.extractor.clojure-plugin-extractor"));
            Var plugins = RT.var((String)"maven.clojure.extractor.clojure-plugin-extractor", (String)"plugin-classes");
            return (List)plugins.invoke((Object)request.getPluginDescriptor(), sources);
        }
        catch (Exception e) {
            throw new ExtractionException("Error extracting mojo descriptor from clojure: ", (Throwable)e);
        }
    }
}

