(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m3417]
  (clojure.core/let
   [bean3416 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/when-let
    [v3418 (:snapshot-id m3417)]
    (. bean3416 setSnapshotId (clojure.core/str v3418)))
   (clojure.core/when-let
    [v3418 (:volume-size m3417)]
    (. bean3416 setVolumeSize (clojure.core/int v3418)))
   (clojure.core/when-let
    [v3418 (:volume-type m3417)]
    (. bean3416 setVolumeType (clojure.core/str v3418)))
   (clojure.core/when-let
    [v3418 (:delete-on-termination m3417)]
    (. bean3416 setDeleteOnTermination (clojure.core/boolean v3418)))
   (clojure.core/when-let
    [v3418 (:iops m3417)]
    (. bean3416 setIops (clojure.core/int v3418)))
   bean3416))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m3420]
  (clojure.core/let
   [bean3419 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/when-let
    [v3421 (:resource-id m3420)]
    (. bean3419 setResourceId (clojure.core/str v3421)))
   (clojure.core/when-let
    [v3421 (:resource-type m3420)]
    (. bean3419 setResourceType (clojure.core/str v3421)))
   (clojure.core/when-let
    [v3421 (:key m3420)]
    (. bean3419 setKey (clojure.core/str v3421)))
   (clojure.core/when-let
    [v3421 (:propagate-at-launch m3420)]
    (. bean3419 setPropagateAtLaunch (clojure.core/boolean v3421)))
   (clojure.core/when-let
    [v3421 (:value m3420)]
    (. bean3419 setValue (clojure.core/str v3421)))
   bean3419))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m3423]
  (clojure.core/let
   [bean3422
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v3424 (:virtual-name m3423)]
    (. bean3422 setVirtualName (clojure.core/str v3424)))
   (clojure.core/when-let
    [v3424 (:device-name m3423)]
    (. bean3422 setDeviceName (clojure.core/str v3424)))
   (clojure.core/when-let
    [v3424 (:ebs m3423)]
    (. bean3422 setEbs (autoscaling/ebs v3424)))
   (clojure.core/when-let
    [v3424 (:no-device m3423)]
    (. bean3422 setNoDevice (clojure.core/boolean v3424)))
   bean3422))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m3426]
  (clojure.core/let
   [bean3425
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/when-let
    [v3427 (:enabled m3426)]
    (. bean3425 setEnabled (clojure.core/boolean v3427)))
   bean3425))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m3429]
  (clojure.core/let
   [bean3428 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/when-let
    [v3430 (:name m3429)]
    (. bean3428 setName (clojure.core/str v3430)))
   (clojure.core/when-let
    [v3430 (:values m3429)]
    (.
     bean3428
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3539] (clojure.core/str arg3539))
 v3430)))
   bean3428))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m3432]
  (clojure.core/let
   [bean3431
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/when-let
    [v3433 (:desired-capacity m3432)]
    (. bean3431 setDesiredCapacity (clojure.core/int v3433)))
   (clojure.core/when-let
    [v3433 (:auto-scaling-group-name m3432)]
    (. bean3431 setAutoScalingGroupName (clojure.core/str v3433)))
   (clojure.core/when-let
    [v3433 (:honor-cooldown m3432)]
    (. bean3431 setHonorCooldown (clojure.core/boolean v3433)))
   bean3431))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m3435]
  (clojure.core/let
   [bean3434
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v3436 (:auto-scaling-group-name m3435)]
    (. bean3434 setAutoScalingGroupName (clojure.core/str v3436)))
   (clojure.core/when-let
    [v3436 (:metrics m3435)]
    (.
     bean3434
     setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3540] (clojure.core/str arg3540))
 v3436)))
   (clojure.core/when-let
    [v3436 (:granularity m3435)]
    (. bean3434 setGranularity (clojure.core/str v3436)))
   bean3434))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m3438]
  (clojure.core/let
   [bean3437
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/when-let
    [v3439 (:auto-scaling-group-name m3438)]
    (. bean3437 setAutoScalingGroupName (clojure.core/str v3439)))
   (clojure.core/when-let
    [v3439 (:policy-name m3438)]
    (. bean3437 setPolicyName (clojure.core/str v3439)))
   bean3437))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m3441]
  (clojure.core/let
   [bean3440
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/when-let
    [v3442 (:instance-id m3441)]
    (. bean3440 setInstanceId (clojure.core/str v3442)))
   (clojure.core/when-let
    [v3442 (:health-status m3441)]
    (. bean3440 setHealthStatus (clojure.core/str v3442)))
   (clojure.core/when-let
    [v3442 (:should-respect-grace-period m3441)]
    (.
     bean3440
     setShouldRespectGracePeriod
     (clojure.core/boolean v3442)))
   bean3440))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m3444]
  (clojure.core/let
   [bean3443
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/when-let
    [v3445 (:max-records m3444)]
    (. bean3443 setMaxRecords (clojure.core/int v3445)))
   (clojure.core/when-let
    [v3445 (:launch-configuration-names m3444)]
    (.
     bean3443
     setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3541] (clojure.core/str arg3541))
 v3445)))
   (clojure.core/when-let
    [v3445 (:next-token m3444)]
    (. bean3443 setNextToken (clojure.core/str v3445)))
   bean3443))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m3447]
  (clojure.core/let
   [bean3446
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v3448 (:tags m3447)]
    (.
     bean3446
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3542] (autoscaling/tag arg3542))
 v3448)))
   bean3446))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m3450]
  (clojure.core/let
   [bean3449
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/when-let
    [v3451 (:max-records m3450)]
    (. bean3449 setMaxRecords (clojure.core/int v3451)))
   (clojure.core/when-let
    [v3451 (:instance-ids m3450)]
    (.
     bean3449
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3543] (clojure.core/str arg3543))
 v3451)))
   (clojure.core/when-let
    [v3451 (:next-token m3450)]
    (. bean3449 setNextToken (clojure.core/str v3451)))
   bean3449))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m3453]
  (clojure.core/let
   [bean3452
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean3452))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m3456]
  (clojure.core/let
   [bean3455
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/when-let
    [v3457 (:max-records m3456)]
    (. bean3455 setMaxRecords (clojure.core/int v3457)))
   (clojure.core/when-let
    [v3457 (:auto-scaling-group-names m3456)]
    (.
     bean3455
     setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3544] (clojure.core/str arg3544))
 v3457)))
   (clojure.core/when-let
    [v3457 (:next-token m3456)]
    (. bean3455 setNextToken (clojure.core/str v3457)))
   bean3455))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m3459]
  (clojure.core/let
   [bean3458
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean3458))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m3462]
  (clojure.core/let
   [bean3461
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v3463 (:auto-scaling-group-name m3462)]
    (. bean3461 setAutoScalingGroupName (clojure.core/str v3463)))
   (clojure.core/when-let
    [v3463 (:topic-arn m3462)]
    (. bean3461 setTopicARN (clojure.core/str v3463)))
   (clojure.core/when-let
    [v3463 (:notification-types m3462)]
    (.
     bean3461
     setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3545] (clojure.core/str arg3545))
 v3463)))
   bean3461))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m3465]
  (clojure.core/let
   [bean3464
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/when-let
    [v3466 (:max-records m3465)]
    (. bean3464 setMaxRecords (clojure.core/int v3466)))
   (clojure.core/when-let
    [v3466 (:auto-scaling-group-name m3465)]
    (. bean3464 setAutoScalingGroupName (clojure.core/str v3466)))
   (clojure.core/when-let
    [v3466 (:policy-names m3465)]
    (.
     bean3464
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3546] (clojure.core/str arg3546))
 v3466)))
   (clojure.core/when-let
    [v3466 (:next-token m3465)]
    (. bean3464 setNextToken (clojure.core/str v3466)))
   bean3464))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m3468]
  (clojure.core/let
   [bean3467
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/when-let
    [v3469 (:auto-scaling-group-name m3468)]
    (. bean3467 setAutoScalingGroupName (clojure.core/str v3469)))
   (clojure.core/when-let
    [v3469 (:scaling-processes m3468)]
    (.
     bean3467
     setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3547] (clojure.core/str arg3547))
 v3469)))
   bean3467))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m3471]
  (clojure.core/let
   [bean3470
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3472 (:max-size m3471)]
    (. bean3470 setMaxSize (clojure.core/int v3472)))
   (clojure.core/when-let
    [v3472 (:health-check-type m3471)]
    (. bean3470 setHealthCheckType (clojure.core/str v3472)))
   (clojure.core/when-let
    [v3472 (:default-cooldown m3471)]
    (. bean3470 setDefaultCooldown (clojure.core/int v3472)))
   (clojure.core/when-let
    [v3472 (:load-balancer-names m3471)]
    (.
     bean3470
     setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3548] (clojure.core/str arg3548))
 v3472)))
   (clojure.core/when-let
    [v3472 (:availability-zones m3471)]
    (.
     bean3470
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3549] (clojure.core/str arg3549))
 v3472)))
   (clojure.core/when-let
    [v3472 (:launch-configuration-name m3471)]
    (. bean3470 setLaunchConfigurationName (clojure.core/str v3472)))
   (clojure.core/when-let
    [v3472 (:health-check-grace-period m3471)]
    (. bean3470 setHealthCheckGracePeriod (clojure.core/int v3472)))
   (clojure.core/when-let
    [v3472 (:min-size m3471)]
    (. bean3470 setMinSize (clojure.core/int v3472)))
   (clojure.core/when-let
    [v3472 (:desired-capacity m3471)]
    (. bean3470 setDesiredCapacity (clojure.core/int v3472)))
   (clojure.core/when-let
    [v3472 (:termination-policies m3471)]
    (.
     bean3470
     setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3550] (clojure.core/str arg3550))
 v3472)))
   (clojure.core/when-let
    [v3472 (:instance-id m3471)]
    (. bean3470 setInstanceId (clojure.core/str v3472)))
   (clojure.core/when-let
    [v3472 (:auto-scaling-group-name m3471)]
    (. bean3470 setAutoScalingGroupName (clojure.core/str v3472)))
   (clojure.core/when-let
    [v3472 (:tags m3471)]
    (.
     bean3470
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3551] (autoscaling/tag arg3551))
 v3472)))
   (clojure.core/when-let
    [v3472 (:vpczone-identifier m3471)]
    (. bean3470 setVPCZoneIdentifier (clojure.core/str v3472)))
   (clojure.core/when-let
    [v3472 (:placement-group m3471)]
    (. bean3470 setPlacementGroup (clojure.core/str v3472)))
   bean3470))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m3474]
  (clojure.core/let
   [bean3473
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/when-let
    [v3475 (:max-records m3474)]
    (. bean3473 setMaxRecords (clojure.core/int v3475)))
   (clojure.core/when-let
    [v3475 (:auto-scaling-group-names m3474)]
    (.
     bean3473
     setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3552] (clojure.core/str arg3552))
 v3475)))
   (clojure.core/when-let
    [v3475 (:next-token m3474)]
    (. bean3473 setNextToken (clojure.core/str v3475)))
   bean3473))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m3477]
  (clojure.core/let
   [bean3476
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/when-let
    [v3478 (:auto-scaling-group-name m3477)]
    (. bean3476 setAutoScalingGroupName (clojure.core/str v3478)))
   (clojure.core/when-let
    [v3478 (:policy-name m3477)]
    (. bean3476 setPolicyName (clojure.core/str v3478)))
   (clojure.core/when-let
    [v3478 (:scaling-adjustment m3477)]
    (. bean3476 setScalingAdjustment (clojure.core/int v3478)))
   (clojure.core/when-let
    [v3478 (:adjustment-type m3477)]
    (. bean3476 setAdjustmentType (clojure.core/str v3478)))
   (clojure.core/when-let
    [v3478 (:cooldown m3477)]
    (. bean3476 setCooldown (clojure.core/int v3478)))
   (clojure.core/when-let
    [v3478 (:min-adjustment-step m3477)]
    (. bean3476 setMinAdjustmentStep (clojure.core/int v3478)))
   bean3476))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m3480]
  (clojure.core/let
   [bean3479
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/when-let
    [v3481 (:auto-scaling-group-name m3480)]
    (. bean3479 setAutoScalingGroupName (clojure.core/str v3481)))
   (clojure.core/when-let
    [v3481 (:policy-name m3480)]
    (. bean3479 setPolicyName (clojure.core/str v3481)))
   (clojure.core/when-let
    [v3481 (:honor-cooldown m3480)]
    (. bean3479 setHonorCooldown (clojure.core/boolean v3481)))
   bean3479))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m3483]
  (clojure.core/let
   [bean3482
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v3484 (:iam-instance-profile m3483)]
    (. bean3482 setIamInstanceProfile (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:spot-price m3483)]
    (. bean3482 setSpotPrice (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:block-device-mappings m3483)]
    (.
     bean3482
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3553]
  (autoscaling/block-device-mapping arg3553))
 v3484)))
   (clojure.core/when-let
    [v3484 (:key-name m3483)]
    (. bean3482 setKeyName (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:associate-public-ip-address m3483)]
    (.
     bean3482
     setAssociatePublicIpAddress
     (clojure.core/boolean v3484)))
   (clojure.core/when-let
    [v3484 (:launch-configuration-name m3483)]
    (. bean3482 setLaunchConfigurationName (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:instance-type m3483)]
    (. bean3482 setInstanceType (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:instance-id m3483)]
    (. bean3482 setInstanceId (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:ebs-optimized m3483)]
    (. bean3482 setEbsOptimized (clojure.core/boolean v3484)))
   (clojure.core/when-let
    [v3484 (:image-id m3483)]
    (. bean3482 setImageId (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:ramdisk-id m3483)]
    (. bean3482 setRamdiskId (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:security-groups m3483)]
    (.
     bean3482
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3554] (clojure.core/str arg3554))
 v3484)))
   (clojure.core/when-let
    [v3484 (:user-data m3483)]
    (. bean3482 setUserData (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:kernel-id m3483)]
    (. bean3482 setKernelId (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:placement-tenancy m3483)]
    (. bean3482 setPlacementTenancy (clojure.core/str v3484)))
   (clojure.core/when-let
    [v3484 (:instance-monitoring m3483)]
    (.
     bean3482
     setInstanceMonitoring
     (autoscaling/instance-monitoring v3484)))
   bean3482))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m3486]
  (clojure.core/let
   [bean3485
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean3485))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m3489]
  (clojure.core/let
   [bean3488
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/when-let
    [v3490 (:max-records m3489)]
    (. bean3488 setMaxRecords (clojure.core/int v3490)))
   (clojure.core/when-let
    [v3490 (:auto-scaling-group-name m3489)]
    (. bean3488 setAutoScalingGroupName (clojure.core/str v3490)))
   (clojure.core/when-let
    [v3490 (:activity-ids m3489)]
    (.
     bean3488
     setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3555] (clojure.core/str arg3555))
 v3490)))
   (clojure.core/when-let
    [v3490 (:next-token m3489)]
    (. bean3488 setNextToken (clojure.core/str v3490)))
   bean3488))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m3492]
  (clojure.core/let
   [bean3491
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/when-let
    [v3493 (:max-records m3492)]
    (. bean3491 setMaxRecords (clojure.core/int v3493)))
   (clojure.core/when-let
    [v3493 (:start-time m3492)]
    (.
     bean3491
     setStartTime
     (com.palletops.awaze.common/to-date v3493)))
   (clojure.core/when-let
    [v3493 (:end-time m3492)]
    (. bean3491 setEndTime (com.palletops.awaze.common/to-date v3493)))
   (clojure.core/when-let
    [v3493 (:auto-scaling-group-name m3492)]
    (. bean3491 setAutoScalingGroupName (clojure.core/str v3493)))
   (clojure.core/when-let
    [v3493 (:scheduled-action-names m3492)]
    (.
     bean3491
     setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3556] (clojure.core/str arg3556))
 v3493)))
   (clojure.core/when-let
    [v3493 (:next-token m3492)]
    (. bean3491 setNextToken (clojure.core/str v3493)))
   bean3491))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m3495]
  (clojure.core/let
   [bean3494
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean3494))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m3498]
  (clojure.core/let
   [bean3497
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v3499 (:max-records m3498)]
    (. bean3497 setMaxRecords (clojure.core/int v3499)))
   (clojure.core/when-let
    [v3499 (:filters m3498)]
    (.
     bean3497
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3557] (autoscaling/filter arg3557))
 v3499)))
   (clojure.core/when-let
    [v3499 (:next-token m3498)]
    (. bean3497 setNextToken (clojure.core/str v3499)))
   bean3497))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m3501]
  (clojure.core/let
   [bean3500
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/when-let
    [v3502 (:auto-scaling-group-name m3501)]
    (. bean3500 setAutoScalingGroupName (clojure.core/str v3502)))
   (clojure.core/when-let
    [v3502 (:scaling-processes m3501)]
    (.
     bean3500
     setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3558] (clojure.core/str arg3558))
 v3502)))
   bean3500))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m3504]
  (clojure.core/let
   [bean3503
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v3505 (:launch-configuration-name m3504)]
    (. bean3503 setLaunchConfigurationName (clojure.core/str v3505)))
   bean3503))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m3507]
  (clojure.core/let
   [bean3506
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v3508 (:auto-scaling-group-name m3507)]
    (. bean3506 setAutoScalingGroupName (clojure.core/str v3508)))
   (clojure.core/when-let
    [v3508 (:metrics m3507)]
    (.
     bean3506
     setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3559] (clojure.core/str arg3559))
 v3508)))
   bean3506))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m3510]
  (clojure.core/let
   [bean3509
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/when-let
    [v3511 (:max-size m3510)]
    (. bean3509 setMaxSize (clojure.core/int v3511)))
   (clojure.core/when-let
    [v3511 (:end-time m3510)]
    (. bean3509 setEndTime (com.palletops.awaze.common/to-date v3511)))
   (clojure.core/when-let
    [v3511 (:scheduled-action-name m3510)]
    (. bean3509 setScheduledActionName (clojure.core/str v3511)))
   (clojure.core/when-let
    [v3511 (:start-time m3510)]
    (.
     bean3509
     setStartTime
     (com.palletops.awaze.common/to-date v3511)))
   (clojure.core/when-let
    [v3511 (:time m3510)]
    (. bean3509 setTime (com.palletops.awaze.common/to-date v3511)))
   (clojure.core/when-let
    [v3511 (:min-size m3510)]
    (. bean3509 setMinSize (clojure.core/int v3511)))
   (clojure.core/when-let
    [v3511 (:desired-capacity m3510)]
    (. bean3509 setDesiredCapacity (clojure.core/int v3511)))
   (clojure.core/when-let
    [v3511 (:recurrence m3510)]
    (. bean3509 setRecurrence (clojure.core/str v3511)))
   (clojure.core/when-let
    [v3511 (:auto-scaling-group-name m3510)]
    (. bean3509 setAutoScalingGroupName (clojure.core/str v3511)))
   bean3509))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m3513]
  (clojure.core/let
   [bean3512
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean3512))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m3516]
  (clojure.core/let
   [bean3515
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean3515))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m3519]
  (clojure.core/let
   [bean3518
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/when-let
    [v3520 (:auto-scaling-group-name m3519)]
    (. bean3518 setAutoScalingGroupName (clojure.core/str v3520)))
   (clojure.core/when-let
    [v3520 (:scheduled-action-name m3519)]
    (. bean3518 setScheduledActionName (clojure.core/str v3520)))
   bean3518))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m3522]
  (clojure.core/let
   [bean3521
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3523 (:max-size m3522)]
    (. bean3521 setMaxSize (clojure.core/int v3523)))
   (clojure.core/when-let
    [v3523 (:health-check-type m3522)]
    (. bean3521 setHealthCheckType (clojure.core/str v3523)))
   (clojure.core/when-let
    [v3523 (:default-cooldown m3522)]
    (. bean3521 setDefaultCooldown (clojure.core/int v3523)))
   (clojure.core/when-let
    [v3523 (:availability-zones m3522)]
    (.
     bean3521
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3560] (clojure.core/str arg3560))
 v3523)))
   (clojure.core/when-let
    [v3523 (:launch-configuration-name m3522)]
    (. bean3521 setLaunchConfigurationName (clojure.core/str v3523)))
   (clojure.core/when-let
    [v3523 (:health-check-grace-period m3522)]
    (. bean3521 setHealthCheckGracePeriod (clojure.core/int v3523)))
   (clojure.core/when-let
    [v3523 (:min-size m3522)]
    (. bean3521 setMinSize (clojure.core/int v3523)))
   (clojure.core/when-let
    [v3523 (:desired-capacity m3522)]
    (. bean3521 setDesiredCapacity (clojure.core/int v3523)))
   (clojure.core/when-let
    [v3523 (:termination-policies m3522)]
    (.
     bean3521
     setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3561] (clojure.core/str arg3561))
 v3523)))
   (clojure.core/when-let
    [v3523 (:auto-scaling-group-name m3522)]
    (. bean3521 setAutoScalingGroupName (clojure.core/str v3523)))
   (clojure.core/when-let
    [v3523 (:vpczone-identifier m3522)]
    (. bean3521 setVPCZoneIdentifier (clojure.core/str v3523)))
   (clojure.core/when-let
    [v3523 (:placement-group m3522)]
    (. bean3521 setPlacementGroup (clojure.core/str v3523)))
   bean3521))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m3525]
  (clojure.core/let
   [bean3524
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/when-let
    [v3526 (:auto-scaling-group-name m3525)]
    (. bean3524 setAutoScalingGroupName (clojure.core/str v3526)))
   (clojure.core/when-let
    [v3526 (:instance-ids m3525)]
    (.
     bean3524
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3562] (clojure.core/str arg3562))
 v3526)))
   bean3524))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m3528]
  (clojure.core/let
   [bean3527
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v3529 (:auto-scaling-group-name m3528)]
    (. bean3527 setAutoScalingGroupName (clojure.core/str v3529)))
   (clojure.core/when-let
    [v3529 (:topic-arn m3528)]
    (. bean3527 setTopicARN (clojure.core/str v3529)))
   bean3527))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m3531]
  (clojure.core/let
   [bean3530
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3532 (:instance-id m3531)]
    (. bean3530 setInstanceId (clojure.core/str v3532)))
   (clojure.core/when-let
    [v3532 (:should-decrement-desired-capacity m3531)]
    (.
     bean3530
     setShouldDecrementDesiredCapacity
     (clojure.core/boolean v3532)))
   bean3530))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m3534]
  (clojure.core/let
   [bean3533
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3535 (:auto-scaling-group-name m3534)]
    (. bean3533 setAutoScalingGroupName (clojure.core/str v3535)))
   (clojure.core/when-let
    [v3535 (:force-delete m3534)]
    (. bean3533 setForceDelete (clojure.core/boolean v3535)))
   bean3533))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m3537]
  (clojure.core/let
   [bean3536
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/when-let
    [v3538 (:tags m3537)]
    (.
     bean3536
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3563] (autoscaling/tag arg3563))
 v3538)))
   bean3536))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m3564]
   (clojure.core/let
    [credentials3565 (:credentials m3564) args3566 (:args m3564)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3567
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3565)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3567
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args3566 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-desired-capacity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials3569 & args3570]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3571
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3569)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3571
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args3570 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m3572]
   (clojure.core/let
    [credentials3573 (:credentials m3572) args3574 (:args m3572)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3575
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3573)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3575
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args3574 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :enable-metrics-collection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials3577 & args3578]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3579
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3577)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3579
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args3578 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m3580]
   (clojure.core/let
    [credentials3581 (:credentials m3580) args3582 (:args m3580)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3583
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3581)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3583
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args3582 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials3585 & args3586]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3587
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3585)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3587
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args3586 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m3588]
   (clojure.core/let
    [credentials3589 (:credentials m3588) args3590 (:args m3588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3591
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3589)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3591
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args3590 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-instance-health,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Call setInstanceHealth"}
   [credentials3593 & args3594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3595
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3593)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3595
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args3594 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m3596]
   (clojure.core/let
    [credentials3597 (:credentials m3596) args3598 (:args m3596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3599
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3597)]
     (clojure.core/case
      (clojure.core/count args3598)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3599
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args3598 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3599
        describeLaunchConfigurations))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials3601 & args3602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3603
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3601)]
    (clojure.core/case
     (clojure.core/count args3602)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3603
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args3602 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3603
       describeLaunchConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m3604]
   (clojure.core/let
    [credentials3605 (:credentials m3604) args3606 (:args m3604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3607
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3605)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3607
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args3606 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials3609 & args3610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3611
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3609)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3611
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args3610 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m3612]
   (clojure.core/let
    [credentials3613 (:credentials m3612) args3614 (:args m3612)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3615
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3613)]
     (clojure.core/case
      (clojure.core/count args3614)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3615
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3615
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args3614 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials3617 & args3618]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3619
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3617)]
    (clojure.core/case
     (clojure.core/count args3618)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3619
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3619
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args3618 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m3620]
   (clojure.core/let
    [credentials3621 (:credentials m3620) args3622 (:args m3620)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3623
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3621)]
     (clojure.core/case
      (clojure.core/count args3622)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3623
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args3622 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3623
        describeAccountLimits))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials3625 & args3626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3627
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3625)]
    (clojure.core/case
     (clojure.core/count args3626)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3627
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args3626 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3627
       describeAccountLimits))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m3628]
   (clojure.core/let
    [credentials3629 (:credentials m3628) args3630 (:args m3628)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3631
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3629)]
     (clojure.core/case
      (clojure.core/count args3630)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3631
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args3630 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3631
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials3633 & args3634]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3635
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3633)]
    (clojure.core/case
     (clojure.core/count args3634)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3635
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args3634 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3635
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m3636]
   (clojure.core/let
    [credentials3637 (:credentials m3636) args3638 (:args m3636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3639
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3637)]
     (clojure.core/case
      (clojure.core/count args3638)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3639
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3639
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args3638 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials3641 & args3642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3643
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3641)]
    (clojure.core/case
     (clojure.core/count args3642)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3643
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3643
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args3642 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m3644]
   (clojure.core/let
    [credentials3645 (:credentials m3644) args3646 (:args m3644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3647
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3645)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3647
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args3646 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-notification-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials3649 & args3650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3651
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3649)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3651
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args3650 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m3652]
   (clojure.core/let
    [credentials3653 (:credentials m3652) args3654 (:args m3652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3655
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3653)]
     (clojure.core/case
      (clojure.core/count args3654)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3655
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args3654 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3655
        describePolicies))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials3657 & args3658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3659
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3657)]
    (clojure.core/case
     (clojure.core/count args3658)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3659
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args3658 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3659
       describePolicies))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m3660]
   (clojure.core/let
    [credentials3661 (:credentials m3660) args3662 (:args m3660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3663
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3661)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3663
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args3662 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :suspend-processes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials3665 & args3666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3667
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3665)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3667
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args3666 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m3668]
   (clojure.core/let
    [credentials3669 (:credentials m3668) args3670 (:args m3668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3671
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3669)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3671
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args3670 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-auto-scaling-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials3673 & args3674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3675
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3673)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3675
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args3674 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m3676]
   (clojure.core/let
    [credentials3677 (:credentials m3676) args3678 (:args m3676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3679
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3677)]
     (clojure.core/case
      (clojure.core/count args3678)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3679
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args3678 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3679
        describeAutoScalingGroups))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials3681 & args3682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3683
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3681)]
    (clojure.core/case
     (clojure.core/count args3682)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3683
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args3682 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3683
       describeAutoScalingGroups))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m3684]
   (clojure.core/let
    [credentials3685 (:credentials m3684) args3686 (:args m3684)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3687
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3685)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3687
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args3686 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scaling-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Call putScalingPolicy"}
   [credentials3689 & args3690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3691
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3689)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3691
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args3690 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m3692]
   (clojure.core/let
    [credentials3693 (:credentials m3692) args3694 (:args m3692)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3695
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3693)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3695
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args3694 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :execute-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials3697 & args3698]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3699
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3697)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3699
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args3698 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m3700]
   (clojure.core/let
    [credentials3701 (:credentials m3700) args3702 (:args m3700)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3703
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3701)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3703
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args3702 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-launch-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials3705 & args3706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3707
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3705)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3707
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args3706 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m3708]
   (clojure.core/let
    [credentials3709 (:credentials m3708) args3710 (:args m3708)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3711
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3709)]
     (clojure.core/case
      (clojure.core/count args3710)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3711
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args3710 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3711
        describeTerminationPolicyTypes))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials3713 & args3714]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3715
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3713)]
    (clojure.core/case
     (clojure.core/count args3714)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3715
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args3714 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3715
       describeTerminationPolicyTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m3716]
   (clojure.core/let
    [credentials3717 (:credentials m3716) args3718 (:args m3716)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3719
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3717)]
     (clojure.core/case
      (clojure.core/count args3718)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3719
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args3718 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3719
        describeScalingActivities))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]
                [credentials]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]
                [credentials]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials3721 & args3722]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3723
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3721)]
    (clojure.core/case
     (clojure.core/count args3722)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3723
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args3722 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3723
       describeScalingActivities))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m3724]
   (clojure.core/let
    [credentials3725 (:credentials m3724) args3726 (:args m3724)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3727
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3725)]
     (clojure.core/case
      (clojure.core/count args3726)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3727
        describeScheduledActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3727
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args3726 0))))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials3729 & args3730]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3731
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3729)]
    (clojure.core/case
     (clojure.core/count args3730)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3731
       describeScheduledActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3731
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args3730 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m3732]
   (clojure.core/let
    [credentials3733 (:credentials m3732) args3734 (:args m3732)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3735
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3733)]
     (clojure.core/case
      (clojure.core/count args3734)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3735
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3735
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args3734 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials3737 & args3738]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3739
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3737)]
    (clojure.core/case
     (clojure.core/count args3738)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3739
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3739
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args3738 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m3740]
   (clojure.core/let
    [credentials3741 (:credentials m3740) args3742 (:args m3740)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3743
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3741)]
     (clojure.core/case
      (clojure.core/count args3742)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3743
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3743
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args3742 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials3745 & args3746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3747
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3745)]
    (clojure.core/case
     (clojure.core/count args3746)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3747
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3747
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args3746 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m3748]
   (clojure.core/let
    [credentials3749 (:credentials m3748) args3750 (:args m3748)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3751
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3749)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3751
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args3750 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :resume-processes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials3753 & args3754]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3755
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3753)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3755
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args3754 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m3756]
   (clojure.core/let
    [credentials3757 (:credentials m3756) args3758 (:args m3756)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3759
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3757)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3759
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args3758 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-launch-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials3761 & args3762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3763
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3761)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3763
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args3762 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m3764]
   (clojure.core/let
    [credentials3765 (:credentials m3764) args3766 (:args m3764)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3767
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3765)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3767
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args3766 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :disable-metrics-collection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials3769 & args3770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3771
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3769)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3771
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args3770 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m3772]
   (clojure.core/let
    [credentials3773 (:credentials m3772) args3774 (:args m3772)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3775
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3773)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3775
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args3774 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials3777 & args3778]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3779
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3777)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3779
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args3778 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m3780]
   (clojure.core/let
    [credentials3781 (:credentials m3780) args3782 (:args m3780)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3783
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3781)]
     (clojure.core/case
      (clojure.core/count args3782)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3783
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3783
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args3782 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials3785 & args3786]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3787
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3785)]
    (clojure.core/case
     (clojure.core/count args3786)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3787
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3787
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args3786 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m3788]
   (clojure.core/let
    [credentials3789 (:credentials m3788) args3790 (:args m3788)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3791
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3789)]
     (clojure.core/case
      (clojure.core/count args3790)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3791
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3791
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args3790 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials3793 & args3794]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3795
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3793)]
    (clojure.core/case
     (clojure.core/count args3794)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3795
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3795
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args3794 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m3796]
   (clojure.core/let
    [credentials3797 (:credentials m3796) args3798 (:args m3796)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3799
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3797)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3799
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args3798 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-scheduled-action,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials3801 & args3802]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3803
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3801)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3803
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args3802 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m3804]
   (clojure.core/let
    [credentials3805 (:credentials m3804) args3806 (:args m3804)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3807
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3805)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3807
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args3806 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :update-auto-scaling-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials3809 & args3810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3811
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3811
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args3810 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m3812]
   (clojure.core/let
    [credentials3813 (:credentials m3812) args3814 (:args m3812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3815
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3815
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args3814 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :attach-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials3817 & args3818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3819
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3819
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args3818 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m3820]
   (clojure.core/let
    [credentials3821 (:credentials m3820) args3822 (:args m3820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3823
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3821)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3823
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args3822 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-notification-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials3825 & args3826]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3827
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3825)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3827
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args3826 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m3828]
   (clojure.core/let
    [credentials3829 (:credentials m3828) args3830 (:args m3828)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3831
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3829)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3831
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args3830 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials3833 & args3834]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3835
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3833)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3835
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args3834 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m3836]
   (clojure.core/let
    [credentials3837 (:credentials m3836) args3838 (:args m3836)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3839
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3837)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3839
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args3838 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-auto-scaling-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials3841 & args3842]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3843
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3841)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3843
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args3842 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m3844]
   (clojure.core/let
    [credentials3845 (:credentials m3844) args3846 (:args m3844)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3847
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3845)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3847
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args3846 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-or-update-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials3849 & args3850]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3851
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3849)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3851
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args3850 0))))))))
