(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m8750]
  (clojure.core/let
   [bean8749
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/when-let
    [v8751 (:parameter-value m8750)]
    (. bean8749 setParameterValue (clojure.core/str v8751)))
   (clojure.core/when-let
    [v8751 (:parameter-key m8750)]
    (. bean8749 setParameterKey (clojure.core/str v8751)))
   (clojure.core/when-let
    [v8751 (:use-previous-value m8750)]
    (. bean8749 setUsePreviousValue (clojure.core/boolean v8751)))
   bean8749))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m8753]
  (clojure.core/let
   [bean8752 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/when-let
    [v8754 (:key m8753)]
    (. bean8752 setKey (clojure.core/str v8754)))
   (clojure.core/when-let
    [v8754 (:value m8753)]
    (. bean8752 setValue (clojure.core/str v8754)))
   bean8752))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m8756]
  (clojure.core/let
   [bean8755
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/when-let
    [v8757 (:next-token m8756)]
    (. bean8755 setNextToken (clojure.core/str v8757)))
   (clojure.core/when-let
    [v8757 (:stack-name m8756)]
    (. bean8755 setStackName (clojure.core/str v8757)))
   bean8755))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m8759]
  (clojure.core/let
   [bean8758
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/when-let
    [v8760 (:next-token m8759)]
    (. bean8758 setNextToken (clojure.core/str v8760)))
   (clojure.core/when-let
    [v8760 (:stack-name m8759)]
    (. bean8758 setStackName (clojure.core/str v8760)))
   bean8758))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m8762]
  (clojure.core/let
   [bean8761
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/when-let
    [v8763 (:stack-name m8762)]
    (. bean8761 setStackName (clojure.core/str v8763)))
   bean8761))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m8765]
  (clojure.core/let
   [bean8764
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/when-let
    [v8766 (:stack-name m8765)]
    (. bean8764 setStackName (clojure.core/str v8766)))
   bean8764))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m8768]
  (clojure.core/let
   [bean8767
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/when-let
    [v8769 (:next-token m8768)]
    (. bean8767 setNextToken (clojure.core/str v8769)))
   (clojure.core/when-let
    [v8769 (:stack-status-filters m8768)]
    (.
     bean8767
     setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8800] (clojure.core/str arg8800))
 v8769)))
   bean8767))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m8771]
  (clojure.core/let
   [bean8770
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/when-let
    [v8772 (:stack-name m8771)]
    (. bean8770 setStackName (clojure.core/str v8772)))
   bean8770))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m8774]
  (clojure.core/let
   [bean8773
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/when-let
    [v8775 (:parameters m8774)]
    (.
     bean8773
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8801] (cloudformation/parameter arg8801))
 v8775)))
   (clojure.core/when-let
    [v8775 (:template-body m8774)]
    (. bean8773 setTemplateBody (clojure.core/str v8775)))
   (clojure.core/when-let
    [v8775 (:template-url m8774)]
    (. bean8773 setTemplateURL (clojure.core/str v8775)))
   bean8773))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m8777]
  (clojure.core/let
   [bean8776
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/when-let
    [v8778 (:template-body m8777)]
    (. bean8776 setTemplateBody (clojure.core/str v8778)))
   (clojure.core/when-let
    [v8778 (:template-url m8777)]
    (. bean8776 setTemplateURL (clojure.core/str v8778)))
   bean8776))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m8780]
  (clojure.core/let
   [bean8779
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/when-let
    [v8781 (:notification-arns m8780)]
    (.
     bean8779
     setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8802] (clojure.core/str arg8802))
 v8781)))
   (clojure.core/when-let
    [v8781 (:stack-policy-during-update-body m8780)]
    (.
     bean8779
     setStackPolicyDuringUpdateBody
     (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:parameters m8780)]
    (.
     bean8779
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8803] (cloudformation/parameter arg8803))
 v8781)))
   (clojure.core/when-let
    [v8781 (:stack-policy-during-update-url m8780)]
    (.
     bean8779
     setStackPolicyDuringUpdateURL
     (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:stack-name m8780)]
    (. bean8779 setStackName (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:template-url m8780)]
    (. bean8779 setTemplateURL (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:use-previous-template m8780)]
    (. bean8779 setUsePreviousTemplate (clojure.core/boolean v8781)))
   (clojure.core/when-let
    [v8781 (:stack-policy-url m8780)]
    (. bean8779 setStackPolicyURL (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:capabilities m8780)]
    (.
     bean8779
     setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8804] (clojure.core/str arg8804))
 v8781)))
   (clojure.core/when-let
    [v8781 (:stack-policy-body m8780)]
    (. bean8779 setStackPolicyBody (clojure.core/str v8781)))
   (clojure.core/when-let
    [v8781 (:template-body m8780)]
    (. bean8779 setTemplateBody (clojure.core/str v8781)))
   bean8779))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m8783]
  (clojure.core/let
   [bean8782
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/when-let
    [v8784 (:stack-name m8783)]
    (. bean8782 setStackName (clojure.core/str v8784)))
   (clojure.core/when-let
    [v8784 (:physical-resource-id m8783)]
    (. bean8782 setPhysicalResourceId (clojure.core/str v8784)))
   (clojure.core/when-let
    [v8784 (:logical-resource-id m8783)]
    (. bean8782 setLogicalResourceId (clojure.core/str v8784)))
   bean8782))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m8786]
  (clojure.core/let
   [bean8785
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/when-let
    [v8787 (:stack-name m8786)]
    (. bean8785 setStackName (clojure.core/str v8787)))
   bean8785))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m8789]
  (clojure.core/let
   [bean8788
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/when-let
    [v8790 (:notification-arns m8789)]
    (.
     bean8788
     setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8805] (clojure.core/str arg8805))
 v8790)))
   (clojure.core/when-let
    [v8790 (:on-failure m8789)]
    (. bean8788 setOnFailure (clojure.core/str v8790)))
   (clojure.core/when-let
    [v8790 (:disable-rollback m8789)]
    (. bean8788 setDisableRollback (clojure.core/boolean v8790)))
   (clojure.core/when-let
    [v8790 (:parameters m8789)]
    (.
     bean8788
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8806] (cloudformation/parameter arg8806))
 v8790)))
   (clojure.core/when-let
    [v8790 (:stack-name m8789)]
    (. bean8788 setStackName (clojure.core/str v8790)))
   (clojure.core/when-let
    [v8790 (:template-url m8789)]
    (. bean8788 setTemplateURL (clojure.core/str v8790)))
   (clojure.core/when-let
    [v8790 (:stack-policy-url m8789)]
    (. bean8788 setStackPolicyURL (clojure.core/str v8790)))
   (clojure.core/when-let
    [v8790 (:capabilities m8789)]
    (.
     bean8788
     setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8807] (clojure.core/str arg8807))
 v8790)))
   (clojure.core/when-let
    [v8790 (:stack-policy-body m8789)]
    (. bean8788 setStackPolicyBody (clojure.core/str v8790)))
   (clojure.core/when-let
    [v8790 (:timeout-in-minutes m8789)]
    (. bean8788 setTimeoutInMinutes (clojure.core/int v8790)))
   (clojure.core/when-let
    [v8790 (:tags m8789)]
    (.
     bean8788
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8808] (cloudformation/tag arg8808))
 v8790)))
   (clojure.core/when-let
    [v8790 (:template-body m8789)]
    (. bean8788 setTemplateBody (clojure.core/str v8790)))
   bean8788))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m8792]
  (clojure.core/let
   [bean8791
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/when-let
    [v8793 (:stack-name m8792)]
    (. bean8791 setStackName (clojure.core/str v8793)))
   (clojure.core/when-let
    [v8793 (:stack-policy-body m8792)]
    (. bean8791 setStackPolicyBody (clojure.core/str v8793)))
   (clojure.core/when-let
    [v8793 (:stack-policy-url m8792)]
    (. bean8791 setStackPolicyURL (clojure.core/str v8793)))
   bean8791))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m8795]
  (clojure.core/let
   [bean8794
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/when-let
    [v8796 (:stack-name m8795)]
    (. bean8794 setStackName (clojure.core/str v8796)))
   (clojure.core/when-let
    [v8796 (:logical-resource-id m8795)]
    (. bean8794 setLogicalResourceId (clojure.core/str v8796)))
   bean8794))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m8798]
  (clojure.core/let
   [bean8797
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/when-let
    [v8799 (:next-token m8798)]
    (. bean8797 setNextToken (clojure.core/str v8799)))
   (clojure.core/when-let
    [v8799 (:stack-name m8798)]
    (. bean8797 setStackName (clojure.core/str v8799)))
   bean8797))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m8809]
   (clojure.core/let
    [credentials8810 (:credentials m8809) args8811 (:args m8809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8812
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8810)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8812
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args8811 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call describeStackEvents"}
   [credentials8814 & args8815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8816
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8814)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8816
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args8815 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m8817]
   (clojure.core/let
    [credentials8818 (:credentials m8817) args8819 (:args m8817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8820
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8818)]
     (clojure.core/case
      (clojure.core/count args8819)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8820
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8820
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args8819 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials8822 & args8823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8824
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8822)]
    (clojure.core/case
     (clojure.core/count args8823)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8824
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8824
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args8823 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m8825]
   (clojure.core/let
    [credentials8826 (:credentials m8825) args8827 (:args m8825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8828
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8828
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args8827 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-stack-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getStackPolicy"}
   [credentials8830 & args8831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8832
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8832
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args8831 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m8833]
   (clojure.core/let
    [credentials8834 (:credentials m8833) args8835 (:args m8833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8836
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8836
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args8835 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-template,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getTemplate"}
   [credentials8838 & args8839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8840
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8840
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args8839 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m8841]
   (clojure.core/let
    [credentials8842 (:credentials m8841) args8843 (:args m8841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8844
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8842)]
     (clojure.core/case
      (clojure.core/count args8843)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8844
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args8843 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8844
        listStacks))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listStacks, listStacks"}
   [credentials8846 & args8847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8848
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8846)]
    (clojure.core/case
     (clojure.core/count args8847)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8848
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args8847 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8848
       listStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m8849]
   (clojure.core/let
    [credentials8850 (:credentials m8849) args8851 (:args m8849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8852
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8852
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args8851 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :delete-stack,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call deleteStack"}
   [credentials8854 & args8855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8856
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8856
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args8855 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m8857]
   (clojure.core/let
    [credentials8858 (:credentials m8857) args8859 (:args m8857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8860
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8858)]
     (clojure.core/case
      (clojure.core/count args8859)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8860
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args8859 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8860
        estimateTemplateCost))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials8862 & args8863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8864
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8862)]
    (clojure.core/case
     (clojure.core/count args8863)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8864
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args8863 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8864
       estimateTemplateCost))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m8865]
   (clojure.core/let
    [credentials8866 (:credentials m8865) args8867 (:args m8865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8868
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8868
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args8867 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :validate-template,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Call validateTemplate"}
   [credentials8870 & args8871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8872
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8872
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args8871 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m8873]
   (clojure.core/let
    [credentials8874 (:credentials m8873) args8875 (:args m8873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8876
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8876
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args8875 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :update-stack,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Call updateStack"}
   [credentials8878 & args8879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8880
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8880
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args8879 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m8881]
   (clojure.core/let
    [credentials8882 (:credentials m8881) args8883 (:args m8881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8884
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8884
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args8883 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResources"}
   [credentials8886 & args8887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8888
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8888
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args8887 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m8889]
   (clojure.core/let
    [credentials8890 (:credentials m8889) args8891 (:args m8889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8892
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8892
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args8891 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :cancel-update-stack,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials8894 & args8895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8896
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8896
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args8895 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m8897]
   (clojure.core/let
    [credentials8898 (:credentials m8897) args8899 (:args m8897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8900
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8900
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args8899 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :create-stack,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Call createStack"}
   [credentials8902 & args8903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8904
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8904
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args8903 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m8905]
   (clojure.core/let
    [credentials8906 (:credentials m8905) args8907 (:args m8905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8908
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8908
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args8907 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :set-stack-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Call setStackPolicy"}
   [credentials8910 & args8911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8912
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8912
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args8911 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m8913]
   (clojure.core/let
    [credentials8914 (:credentials m8913) args8915 (:args m8913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8916
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8916
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args8915 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resource,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResource"}
   [credentials8918 & args8919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8920
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8920
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args8919 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m8921]
   (clojure.core/let
    [credentials8922 (:credentials m8921) args8923 (:args m8921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8924
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8924
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args8923 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stack-resources,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listStackResources"}
   [credentials8926 & args8927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8928
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8928
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args8927 0))))))))
