(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m1978]
  (clojure.core/let
   [bean1977
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/when-let
    [v1979 (:quantity m1978)]
    (. bean1977 setQuantity (clojure.core/int v1979)))
   (clojure.core/when-let
    [v1979 (:items m1978)]
    (.
     bean1977
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2127] (clojure.core/str arg2127))
 v1979)))
   bean1977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m1981]
  (clojure.core/let
   [bean1980 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/when-let
    [v1982 (:quantity m1981)]
    (. bean1980 setQuantity (clojure.core/int v1982)))
   (clojure.core/when-let
    [v1982 (:items m1981)]
    (.
     bean1980
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2128] (clojure.core/str arg2128))
 v1982)))
   bean1980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m1984]
  (clojure.core/let
   [bean1983
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/when-let
    [v1985 (:forward m1984)]
    (. bean1983 setForward (clojure.core/str v1985)))
   (clojure.core/when-let
    [v1985 (:whitelisted-names m1984)]
    (. bean1983 setWhitelistedNames (cloudfront/cookie-names v1985)))
   bean1983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m1987]
  (clojure.core/let
   [bean1986
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/when-let
    [v1988 (:headers m1987)]
    (. bean1986 setHeaders (cloudfront/headers v1988)))
   (clojure.core/when-let
    [v1988 (:query-string m1987)]
    (. bean1986 setQueryString (clojure.core/boolean v1988)))
   (clojure.core/when-let
    [v1988 (:cookies m1987)]
    (. bean1986 setCookies (cloudfront/cookie-preference v1988)))
   bean1986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m1990]
  (clojure.core/let
   [bean1989
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/when-let
    [v1991 (:quantity m1990)]
    (. bean1989 setQuantity (clojure.core/int v1991)))
   (clojure.core/when-let
    [v1991 (:items m1990)]
    (.
     bean1989
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2129] (clojure.core/str arg2129))
 v1991)))
   bean1989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m1993]
  (clojure.core/let
   [bean1992
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/when-let
    [v1994 (:quantity m1993)]
    (. bean1992 setQuantity (clojure.core/int v1994)))
   (clojure.core/when-let
    [v1994 (:items m1993)]
    (.
     bean1992
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2130] (clojure.core/str arg2130))
 v1994)))
   (clojure.core/when-let
    [v1994 (:enabled m1993)]
    (. bean1992 setEnabled (clojure.core/boolean v1994)))
   bean1992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestrictionType}
geo-restriction-type
  [m1996]
  (.
   com.amazonaws.services.cloudfront.model.GeoRestrictionType
   fromValue
   (clojure.core/name m1996)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m1999]
  (clojure.core/let
   [bean1998
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/when-let
    [v2000 (:origin-access-identity m1999)]
    (. bean1998 setOriginAccessIdentity (clojure.core/str v2000)))
   bean1998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m2002]
  (clojure.core/let
   [bean2001
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/when-let
    [v2003 (:httpport m2002)]
    (. bean2001 setHTTPPort (clojure.core/int v2003)))
   (clojure.core/when-let
    [v2003 (:httpsport m2002)]
    (. bean2001 setHTTPSPort (clojure.core/int v2003)))
   (clojure.core/when-let
    [v2003 (:origin-protocol-policy m2002)]
    (. bean2001 setOriginProtocolPolicy (clojure.core/str v2003)))
   bean2001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m2005]
  (clojure.core/let
   [bean2004
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/when-let
    [v2006 (:target-origin-id m2005)]
    (. bean2004 setTargetOriginId (clojure.core/str v2006)))
   (clojure.core/when-let
    [v2006 (:forwarded-values m2005)]
    (.
     bean2004
     setForwardedValues
     (cloudfront/forwarded-values v2006)))
   (clojure.core/when-let
    [v2006 (:viewer-protocol-policy m2005)]
    (. bean2004 setViewerProtocolPolicy (clojure.core/str v2006)))
   (clojure.core/when-let
    [v2006 (:min-ttl m2005)]
    (. bean2004 setMinTTL (clojure.core/long v2006)))
   (clojure.core/when-let
    [v2006 (:allowed-methods m2005)]
    (. bean2004 setAllowedMethods (cloudfront/allowed-methods v2006)))
   (clojure.core/when-let
    [v2006 (:smooth-streaming m2005)]
    (. bean2004 setSmoothStreaming (clojure.core/boolean v2006)))
   (clojure.core/when-let
    [v2006 (:path-pattern m2005)]
    (. bean2004 setPathPattern (clojure.core/str v2006)))
   (clojure.core/when-let
    [v2006 (:trusted-signers m2005)]
    (. bean2004 setTrustedSigners (cloudfront/trusted-signers v2006)))
   bean2004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.SSLSupportMethod}
sslsupport-method
  [m2008]
  (.
   com.amazonaws.services.cloudfront.model.SSLSupportMethod
   fromValue
   (clojure.core/name m2008)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m2011]
  (clojure.core/let
   [bean2010
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/when-let
    [v2012 (:quantity m2011)]
    (. bean2010 setQuantity (clojure.core/int v2012)))
   (clojure.core/when-let
    [v2012 (:items m2011)]
    (.
     bean2010
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2131] (clojure.core/str arg2131))
 v2012)))
   (clojure.core/when-let
    [v2012 (:restriction-type m2011)]
    (.
     bean2010
     setRestrictionType
     (cloudfront/geo-restriction-type v2012)))
   bean2010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m2014]
  (clojure.core/let
   [bean2013 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/when-let
    [v2015 (:id m2014)]
    (. bean2013 setId (clojure.core/str v2015)))
   (clojure.core/when-let
    [v2015 (:domain-name m2014)]
    (. bean2013 setDomainName (clojure.core/str v2015)))
   (clojure.core/when-let
    [v2015 (:s3origin-config m2014)]
    (. bean2013 setS3OriginConfig (cloudfront/s3origin-config v2015)))
   (clojure.core/when-let
    [v2015 (:custom-origin-config m2014)]
    (.
     bean2013
     setCustomOriginConfig
     (cloudfront/custom-origin-config v2015)))
   bean2013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m2017]
  (clojure.core/let
   [bean2016
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/when-let
    [v2018 (:error-code m2017)]
    (. bean2016 setErrorCode (clojure.core/int v2018)))
   (clojure.core/when-let
    [v2018 (:response-page-path m2017)]
    (. bean2016 setResponsePagePath (clojure.core/str v2018)))
   (clojure.core/when-let
    [v2018 (:response-code m2017)]
    (. bean2016 setResponseCode (clojure.core/str v2018)))
   (clojure.core/when-let
    [v2018 (:error-caching-min-ttl m2017)]
    (. bean2016 setErrorCachingMinTTL (clojure.core/long v2018)))
   bean2016))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m2020]
  (clojure.core/let
   [bean2019 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/when-let
    [v2021 (:domain-name m2020)]
    (. bean2019 setDomainName (clojure.core/str v2021)))
   (clojure.core/when-let
    [v2021 (:origin-access-identity m2020)]
    (. bean2019 setOriginAccessIdentity (clojure.core/str v2021)))
   bean2019))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m2023]
  (clojure.core/let
   [bean2022 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/when-let
    [v2024 (:quantity m2023)]
    (. bean2022 setQuantity (clojure.core/int v2024)))
   (clojure.core/when-let
    [v2024 (:items m2023)]
    (.
     bean2022
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2132] (clojure.core/str arg2132))
 v2024)))
   bean2022))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m2026]
  (clojure.core/let
   [bean2025
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/when-let
    [v2027 (:prefix m2026)]
    (. bean2025 setPrefix (clojure.core/str v2027)))
   (clojure.core/when-let
    [v2027 (:bucket m2026)]
    (. bean2025 setBucket (clojure.core/str v2027)))
   (clojure.core/when-let
    [v2027 (:enabled m2026)]
    (. bean2025 setEnabled (clojure.core/boolean v2027)))
   bean2025))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m2029]
  (clojure.core/let
   [bean2028
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/when-let
    [v2030 (:quantity m2029)]
    (. bean2028 setQuantity (clojure.core/int v2030)))
   (clojure.core/when-let
    [v2030 (:items m2029)]
    (.
     bean2028
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2133] (cloudfront/cache-behavior arg2133))
 v2030)))
   bean2028))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m2032]
  (clojure.core/let
   [bean2031
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/when-let
    [v2033 (:iamcertificate-id m2032)]
    (. bean2031 setIAMCertificateId (clojure.core/str v2033)))
   (clojure.core/when-let
    [v2033 (:cloud-front-default-certificate m2032)]
    (.
     bean2031
     setCloudFrontDefaultCertificate
     (clojure.core/boolean v2033)))
   (clojure.core/when-let
    [v2033 (:sslsupport-method m2032)]
    (.
     bean2031
     setSSLSupportMethod
     (cloudfront/sslsupport-method v2033)))
   bean2031))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m2035]
  (clojure.core/let
   [bean2034
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/when-let
    [v2036 (:geo-restriction m2035)]
    (. bean2034 setGeoRestriction (cloudfront/geo-restriction v2036)))
   bean2034))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m2038]
  (clojure.core/let
   [bean2037 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/when-let
    [v2039 (:quantity m2038)]
    (. bean2037 setQuantity (clojure.core/int v2039)))
   (clojure.core/when-let
    [v2039 (:items m2038)]
    (.
     bean2037
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2134] (cloudfront/origin arg2134))
 v2039)))
   bean2037))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m2041]
  (clojure.core/let
   [bean2040
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/when-let
    [v2042 (:target-origin-id m2041)]
    (. bean2040 setTargetOriginId (clojure.core/str v2042)))
   (clojure.core/when-let
    [v2042 (:forwarded-values m2041)]
    (.
     bean2040
     setForwardedValues
     (cloudfront/forwarded-values v2042)))
   (clojure.core/when-let
    [v2042 (:viewer-protocol-policy m2041)]
    (. bean2040 setViewerProtocolPolicy (clojure.core/str v2042)))
   (clojure.core/when-let
    [v2042 (:min-ttl m2041)]
    (. bean2040 setMinTTL (clojure.core/long v2042)))
   (clojure.core/when-let
    [v2042 (:allowed-methods m2041)]
    (. bean2040 setAllowedMethods (cloudfront/allowed-methods v2042)))
   (clojure.core/when-let
    [v2042 (:smooth-streaming m2041)]
    (. bean2040 setSmoothStreaming (clojure.core/boolean v2042)))
   (clojure.core/when-let
    [v2042 (:trusted-signers m2041)]
    (. bean2040 setTrustedSigners (cloudfront/trusted-signers v2042)))
   bean2040))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m2044]
  (clojure.core/let
   [bean2043
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/when-let
    [v2045 (:quantity m2044)]
    (. bean2043 setQuantity (clojure.core/int v2045)))
   (clojure.core/when-let
    [v2045 (:items m2044)]
    (.
     bean2043
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2135]
  (cloudfront/custom-error-response arg2135))
 v2045)))
   bean2043))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m2047]
  (clojure.core/let
   [bean2046
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/when-let
    [v2048 (:prefix m2047)]
    (. bean2046 setPrefix (clojure.core/str v2048)))
   (clojure.core/when-let
    [v2048 (:bucket m2047)]
    (. bean2046 setBucket (clojure.core/str v2048)))
   (clojure.core/when-let
    [v2048 (:include-cookies m2047)]
    (. bean2046 setIncludeCookies (clojure.core/boolean v2048)))
   (clojure.core/when-let
    [v2048 (:enabled m2047)]
    (. bean2046 setEnabled (clojure.core/boolean v2048)))
   bean2046))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m2050]
  (clojure.core/let
   [bean2049 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/when-let
    [v2051 (:quantity m2050)]
    (. bean2049 setQuantity (clojure.core/int v2051)))
   (clojure.core/when-let
    [v2051 (:items m2050)]
    (.
     bean2049
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2136] (clojure.core/str arg2136))
 v2051)))
   bean2049))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m2053]
  (clojure.core/let
   [bean2052
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/when-let
    [v2054 (:comment m2053)]
    (. bean2052 setComment (clojure.core/str v2054)))
   (clojure.core/when-let
    [v2054 (:caller-reference m2053)]
    (. bean2052 setCallerReference (clojure.core/str v2054)))
   (clojure.core/when-let
    [v2054 (:s3origin m2053)]
    (. bean2052 setS3Origin (cloudfront/s3origin v2054)))
   (clojure.core/when-let
    [v2054 (:aliases m2053)]
    (. bean2052 setAliases (cloudfront/aliases v2054)))
   (clojure.core/when-let
    [v2054 (:logging m2053)]
    (.
     bean2052
     setLogging
     (cloudfront/streaming-logging-config v2054)))
   (clojure.core/when-let
    [v2054 (:trusted-signers m2053)]
    (. bean2052 setTrustedSigners (cloudfront/trusted-signers v2054)))
   (clojure.core/when-let
    [v2054 (:price-class m2053)]
    (. bean2052 setPriceClass (clojure.core/str v2054)))
   (clojure.core/when-let
    [v2054 (:enabled m2053)]
    (. bean2052 setEnabled (clojure.core/boolean v2054)))
   bean2052))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m2056]
  (clojure.core/let
   [bean2055
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/when-let
    [v2057 (:comment m2056)]
    (. bean2055 setComment (clojure.core/str v2057)))
   (clojure.core/when-let
    [v2057 (:caller-reference m2056)]
    (. bean2055 setCallerReference (clojure.core/str v2057)))
   bean2055))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m2059]
  (clojure.core/let
   [bean2058
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/when-let
    [v2060 (:default-root-object m2059)]
    (. bean2058 setDefaultRootObject (clojure.core/str v2060)))
   (clojure.core/when-let
    [v2060 (:cache-behaviors m2059)]
    (. bean2058 setCacheBehaviors (cloudfront/cache-behaviors v2060)))
   (clojure.core/when-let
    [v2060 (:viewer-certificate m2059)]
    (.
     bean2058
     setViewerCertificate
     (cloudfront/viewer-certificate v2060)))
   (clojure.core/when-let
    [v2060 (:restrictions m2059)]
    (. bean2058 setRestrictions (cloudfront/restrictions v2060)))
   (clojure.core/when-let
    [v2060 (:origins m2059)]
    (. bean2058 setOrigins (cloudfront/origins v2060)))
   (clojure.core/when-let
    [v2060 (:price-class m2059)]
    (. bean2058 setPriceClass (clojure.core/str v2060)))
   (clojure.core/when-let
    [v2060 (:default-cache-behavior m2059)]
    (.
     bean2058
     setDefaultCacheBehavior
     (cloudfront/default-cache-behavior v2060)))
   (clojure.core/when-let
    [v2060 (:aliases m2059)]
    (. bean2058 setAliases (cloudfront/aliases v2060)))
   (clojure.core/when-let
    [v2060 (:custom-error-responses m2059)]
    (.
     bean2058
     setCustomErrorResponses
     (cloudfront/custom-error-responses v2060)))
   (clojure.core/when-let
    [v2060 (:logging m2059)]
    (. bean2058 setLogging (cloudfront/logging-config v2060)))
   (clojure.core/when-let
    [v2060 (:comment m2059)]
    (. bean2058 setComment (clojure.core/str v2060)))
   (clojure.core/when-let
    [v2060 (:caller-reference m2059)]
    (. bean2058 setCallerReference (clojure.core/str v2060)))
   (clojure.core/when-let
    [v2060 (:enabled m2059)]
    (. bean2058 setEnabled (clojure.core/boolean v2060)))
   bean2058))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m2062]
  (clojure.core/let
   [bean2061
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/when-let
    [v2063 (:paths m2062)]
    (. bean2061 setPaths (cloudfront/paths v2063)))
   (clojure.core/when-let
    [v2063 (:caller-reference m2062)]
    (. bean2061 setCallerReference (clojure.core/str v2063)))
   bean2061))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m2065]
  (clojure.core/let
   [bean2064
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/when-let
    [v2066 (:max-items m2065)]
    (. bean2064 setMaxItems (clojure.core/str v2066)))
   (clojure.core/when-let
    [v2066 (:marker m2065)]
    (. bean2064 setMarker (clojure.core/str v2066)))
   bean2064))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m2068]
  (clojure.core/let
   [bean2067
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/when-let
    [v2069 (:id m2068)]
    (. bean2067 setId (clojure.core/str v2069)))
   bean2067))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m2071]
  (clojure.core/let
   [bean2070
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2072 (:id m2071)]
    (. bean2070 setId (clojure.core/str v2072)))
   (clojure.core/when-let
    [v2072 (:if-match m2071)]
    (. bean2070 setIfMatch (clojure.core/str v2072)))
   (clojure.core/when-let
    [v2072 (:streaming-distribution-config m2071)]
    (.
     bean2070
     setStreamingDistributionConfig
     (cloudfront/streaming-distribution-config v2072)))
   bean2070))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m2074]
  (clojure.core/let
   [bean2073
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2075 (:cloud-front-origin-access-identity-config m2074)]
    (.
     bean2073
     setCloudFrontOriginAccessIdentityConfig
     (cloudfront/cloud-front-origin-access-identity-config v2075)))
   bean2073))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m2077]
  (clojure.core/let
   [bean2076
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/when-let
    [v2078 (:max-items m2077)]
    (. bean2076 setMaxItems (clojure.core/str v2078)))
   (clojure.core/when-let
    [v2078 (:marker m2077)]
    (. bean2076 setMarker (clojure.core/str v2078)))
   bean2076))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m2080]
  (clojure.core/let
   [bean2079
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/when-let
    [v2081 (:id m2080)]
    (. bean2079 setId (clojure.core/str v2081)))
   bean2079))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m2083]
  (clojure.core/let
   [bean2082
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/when-let
    [v2084 (:id m2083)]
    (. bean2082 setId (clojure.core/str v2084)))
   bean2082))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m2086]
  (clojure.core/let
   [bean2085
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/when-let
    [v2087 (:distribution-config m2086)]
    (.
     bean2085
     setDistributionConfig
     (cloudfront/distribution-config v2087)))
   bean2085))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m2089]
  (clojure.core/let
   [bean2088
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/when-let
    [v2090 (:distribution-id m2089)]
    (. bean2088 setDistributionId (clojure.core/str v2090)))
   (clojure.core/when-let
    [v2090 (:invalidation-batch m2089)]
    (.
     bean2088
     setInvalidationBatch
     (cloudfront/invalidation-batch v2090)))
   bean2088))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m2092]
  (clojure.core/let
   [bean2091
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/when-let
    [v2093 (:id m2092)]
    (. bean2091 setId (clojure.core/str v2093)))
   (clojure.core/when-let
    [v2093 (:if-match m2092)]
    (. bean2091 setIfMatch (clojure.core/str v2093)))
   (clojure.core/when-let
    [v2093 (:distribution-config m2092)]
    (.
     bean2091
     setDistributionConfig
     (cloudfront/distribution-config v2093)))
   bean2091))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m2095]
  (clojure.core/let
   [bean2094
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2096 (:id m2095)]
    (. bean2094 setId (clojure.core/str v2096)))
   bean2094))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m2098]
  (clojure.core/let
   [bean2097
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/when-let
    [v2099 (:distribution-id m2098)]
    (. bean2097 setDistributionId (clojure.core/str v2099)))
   (clojure.core/when-let
    [v2099 (:max-items m2098)]
    (. bean2097 setMaxItems (clojure.core/str v2099)))
   (clojure.core/when-let
    [v2099 (:marker m2098)]
    (. bean2097 setMarker (clojure.core/str v2099)))
   bean2097))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m2101]
  (clojure.core/let
   [bean2100
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/when-let
    [v2102 (:id m2101)]
    (. bean2100 setId (clojure.core/str v2102)))
   (clojure.core/when-let
    [v2102 (:if-match m2101)]
    (. bean2100 setIfMatch (clojure.core/str v2102)))
   bean2100))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m2104]
  (clojure.core/let
   [bean2103
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2105 (:streaming-distribution-config m2104)]
    (.
     bean2103
     setStreamingDistributionConfig
     (cloudfront/streaming-distribution-config v2105)))
   bean2103))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m2107]
  (clojure.core/let
   [bean2106
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/when-let
    [v2108 (:max-items m2107)]
    (. bean2106 setMaxItems (clojure.core/str v2108)))
   (clojure.core/when-let
    [v2108 (:marker m2107)]
    (. bean2106 setMarker (clojure.core/str v2108)))
   bean2106))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m2110]
  (clojure.core/let
   [bean2109
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2111 (:id m2110)]
    (. bean2109 setId (clojure.core/str v2111)))
   (clojure.core/when-let
    [v2111 (:if-match m2110)]
    (. bean2109 setIfMatch (clojure.core/str v2111)))
   (clojure.core/when-let
    [v2111 (:cloud-front-origin-access-identity-config m2110)]
    (.
     bean2109
     setCloudFrontOriginAccessIdentityConfig
     (cloudfront/cloud-front-origin-access-identity-config v2111)))
   bean2109))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m2113]
  (clojure.core/let
   [bean2112
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/when-let
    [v2114 (:id m2113)]
    (. bean2112 setId (clojure.core/str v2114)))
   (clojure.core/when-let
    [v2114 (:distribution-id m2113)]
    (. bean2112 setDistributionId (clojure.core/str v2114)))
   bean2112))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m2116]
  (clojure.core/let
   [bean2115
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2117 (:id m2116)]
    (. bean2115 setId (clojure.core/str v2117)))
   (clojure.core/when-let
    [v2117 (:if-match m2116)]
    (. bean2115 setIfMatch (clojure.core/str v2117)))
   bean2115))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m2119]
  (clojure.core/let
   [bean2118
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/when-let
    [v2120 (:id m2119)]
    (. bean2118 setId (clojure.core/str v2120)))
   bean2118))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m2122]
  (clojure.core/let
   [bean2121
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2123 (:id m2122)]
    (. bean2121 setId (clojure.core/str v2123)))
   (clojure.core/when-let
    [v2123 (:if-match m2122)]
    (. bean2121 setIfMatch (clojure.core/str v2123)))
   bean2121))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m2125]
  (clojure.core/let
   [bean2124
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2126 (:id m2125)]
    (. bean2124 setId (clojure.core/str v2126)))
   bean2124))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m2137]
   (clojure.core/let
    [credentials2138 (:credentials m2137) args2139 (:args m2137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2140
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2140
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args2139 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-streaming-distributions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials2142 & args2143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2144
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2144
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args2143 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m2145]
   (clojure.core/let
    [credentials2146 (:credentials m2145) args2147 (:args m2145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2148
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2146)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2148
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args2147 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials2150 & args2151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2152
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2150)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2152
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args2151 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m2153]
   (clojure.core/let
    [credentials2154 (:credentials m2153) args2155 (:args m2153)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2156
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2154)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2156
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args2155 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         if-match
                         id
                         general-progress-listener]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-streaming-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         if-match
                         id
                         general-progress-listener]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials2158 & args2159]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2160
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2158)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2160
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args2159 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m2161]
   (clojure.core/let
    [credentials2162 (:credentials m2161) args2163 (:args m2161)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2164
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2162)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2164
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args2163 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials2166 & args2167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2168
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2166)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2168
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args2167 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m2169]
   (clojure.core/let
    [credentials2170 (:credentials m2169) args2171 (:args m2169)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2172
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2170)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2172
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args2171 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials2174 & args2175]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2176
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2174)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2176
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args2175 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m2177]
   (clojure.core/let
    [credentials2178 (:credentials m2177) args2179 (:args m2177)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2180
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2178)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2180
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args2179 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution-config,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getDistributionConfig"}
   [credentials2182 & args2183]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2184
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2182)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2184
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args2183 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m2185]
   (clojure.core/let
    [credentials2186 (:credentials m2185) args2187 (:args m2185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2188
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2186)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2188
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args2187 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution-config,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials2190 & args2191]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2192
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2190)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2192
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args2191 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m2193]
   (clojure.core/let
    [credentials2194 (:credentials m2193) args2195 (:args m2193)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2196
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2194)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2196
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args2195 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         distribution-config]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         distribution-config]}]]),
    :doc "Call createDistribution"}
   [credentials2198 & args2199]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2200
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2198)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2200
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args2199 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m2201]
   (clojure.core/let
    [credentials2202 (:credentials m2201) args2203 (:args m2201)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2204
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2202)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2204
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args2203 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-invalidation,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Call createInvalidation"}
   [credentials2206 & args2207]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2208
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2206)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2208
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args2207 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m2209]
   (clojure.core/let
    [credentials2210 (:credentials m2209) args2211 (:args m2209)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2212
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2210)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2212
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args2211 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         distribution-config]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         distribution-config]}]]),
    :doc "Call updateDistribution"}
   [credentials2214 & args2215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2216
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2214)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2216
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args2215 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m2217]
   (clojure.core/let
    [credentials2218 (:credentials m2217) args2219 (:args m2217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2220
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2218)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2220
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args2219 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials2222 & args2223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2224
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2222)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2224
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args2223 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m2225]
   (clojure.core/let
    [credentials2226 (:credentials m2225) args2227 (:args m2225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2228
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2226)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2228
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args2227 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-invalidations,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Call listInvalidations"}
   [credentials2230 & args2231]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2232
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2230)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2232
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args2231 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m2233]
   (clojure.core/let
    [credentials2234 (:credentials m2233) args2235 (:args m2233)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2236
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2234)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2236
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args2235 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteDistribution"}
   [credentials2238 & args2239]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2240
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2238)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2240
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args2239 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m2241]
   (clojure.core/let
    [credentials2242 (:credentials m2241) args2243 (:args m2241)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2244
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2242)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2244
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args2243 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         general-progress-listener]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-streaming-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         general-progress-listener]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials2246 & args2247]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2248
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2246)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2248
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args2247 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m2249]
   (clojure.core/let
    [credentials2250 (:credentials m2249) args2251 (:args m2249)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2252
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2250)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2252
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args2251 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-distributions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listDistributions"}
   [credentials2254 & args2255]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2256
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2254)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2256
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args2255 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m2257]
   (clojure.core/let
    [credentials2258 (:credentials m2257) args2259 (:args m2257)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2260
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2258)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2260
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args2259 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials2262 & args2263]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2264
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2262)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2264
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args2263 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m2265]
   (clojure.core/let
    [credentials2266 (:credentials m2265) args2267 (:args m2265)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2268
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2266)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2268
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args2267 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [id general-progress-listener distribution-id]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-invalidation,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [id general-progress-listener distribution-id]}]]),
    :doc "Call getInvalidation"}
   [credentials2270 & args2271]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2272
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2270)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2272
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args2271 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m2273]
   (clojure.core/let
    [credentials2274 (:credentials m2273) args2275 (:args m2273)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2276
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2274)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2276
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args2275 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-streaming-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials2278 & args2279]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2280
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2278)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2280
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args2279 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m2281]
   (clojure.core/let
    [credentials2282 (:credentials m2281) args2283 (:args m2281)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2284
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2282)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2284
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args2283 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getDistribution"}
   [credentials2286 & args2287]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2288
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2286)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2288
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args2287 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m2289]
   (clojure.core/let
    [credentials2290 (:credentials m2289) args2291 (:args m2289)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2292
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2290)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2292
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args2291 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials2294 & args2295]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2296
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2294)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2296
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args2295 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m2297]
   (clojure.core/let
    [credentials2298 (:credentials m2297) args2299 (:args m2297)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2300
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2298)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2300
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args2299 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials2302 & args2303]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2304
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2302)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2304
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args2303 0))))))))
