(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m9204]
  (clojure.core/let
   [bean9203 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/when-let
    [v9205 (:name m9204)]
    (. bean9203 setName (clojure.core/str v9205)))
   (clojure.core/when-let
    [v9205 (:value m9204)]
    (. bean9203 setValue (clojure.core/str v9205)))
   bean9203))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m9207]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m9207)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m9210]
  (clojure.core/let
   [bean9209
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/when-let
    [v9211 (:sample-count m9210)]
    (. bean9209 setSampleCount (clojure.core/double v9211)))
   (clojure.core/when-let
    [v9211 (:sum m9210)]
    (. bean9209 setSum (clojure.core/double v9211)))
   (clojure.core/when-let
    [v9211 (:minimum m9210)]
    (. bean9209 setMinimum (clojure.core/double v9211)))
   (clojure.core/when-let
    [v9211 (:maximum m9210)]
    (. bean9209 setMaximum (clojure.core/double v9211)))
   bean9209))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m9213]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m9213)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ComparisonOperator}
comparison-operator
  [m9216]
  (.
   com.amazonaws.services.cloudwatch.model.ComparisonOperator
   fromValue
   (clojure.core/name m9216)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.HistoryItemType}
history-item-type
  [m9219]
  (.
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   fromValue
   (clojure.core/name m9219)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StateValue}
state-value
  [m9222]
  (.
   com.amazonaws.services.cloudwatch.model.StateValue
   fromValue
   (clojure.core/name m9222)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m9225]
  (clojure.core/let
   [bean9224
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/when-let
    [v9226 (:name m9225)]
    (. bean9224 setName (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:value m9225)]
    (. bean9224 setValue (clojure.core/str v9226)))
   bean9224))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m9228]
  (clojure.core/let
   [bean9227
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/when-let
    [v9229 (:timestamp m9228)]
    (.
     bean9227
     setTimestamp
     (com.palletops.awaze.common/to-date v9229)))
   (clojure.core/when-let
    [v9229 (:metric-name m9228)]
    (. bean9227 setMetricName (clojure.core/str v9229)))
   (clojure.core/when-let
    [v9229 (:dimensions m9228)]
    (.
     bean9227
     setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9263] (cloudwatch/dimension arg9263))
 v9229)))
   (clojure.core/when-let
    [v9229 (:unit m9228)]
    (. bean9227 setUnit (cloudwatch/standard-unit v9229)))
   (clojure.core/when-let
    [v9229 (:statistic-values m9228)]
    (. bean9227 setStatisticValues (cloudwatch/statistic-set v9229)))
   (clojure.core/when-let
    [v9229 (:value m9228)]
    (. bean9227 setValue (clojure.core/double v9229)))
   bean9227))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m9231]
  (clojure.core/let
   [bean9230
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/when-let
    [v9232 (:period m9231)]
    (. bean9230 setPeriod (clojure.core/int v9232)))
   (clojure.core/when-let
    [v9232 (:actions-enabled m9231)]
    (. bean9230 setActionsEnabled (clojure.core/boolean v9232)))
   (clojure.core/when-let
    [v9232 (:unit m9231)]
    (. bean9230 setUnit (cloudwatch/standard-unit v9232)))
   (clojure.core/when-let
    [v9232 (:threshold m9231)]
    (. bean9230 setThreshold (clojure.core/double v9232)))
   (clojure.core/when-let
    [v9232 (:alarm-description m9231)]
    (. bean9230 setAlarmDescription (clojure.core/str v9232)))
   (clojure.core/when-let
    [v9232 (:alarm-actions m9231)]
    (.
     bean9230
     setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9264] (clojure.core/str arg9264))
 v9232)))
   (clojure.core/when-let
    [v9232 (:statistic m9231)]
    (. bean9230 setStatistic (cloudwatch/statistic v9232)))
   (clojure.core/when-let
    [v9232 (:insufficient-data-actions m9231)]
    (.
     bean9230
     setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9265] (clojure.core/str arg9265))
 v9232)))
   (clojure.core/when-let
    [v9232 (:dimensions m9231)]
    (.
     bean9230
     setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9266] (cloudwatch/dimension arg9266))
 v9232)))
   (clojure.core/when-let
    [v9232 (:comparison-operator m9231)]
    (.
     bean9230
     setComparisonOperator
     (cloudwatch/comparison-operator v9232)))
   (clojure.core/when-let
    [v9232 (:evaluation-periods m9231)]
    (. bean9230 setEvaluationPeriods (clojure.core/int v9232)))
   (clojure.core/when-let
    [v9232 (:namespace m9231)]
    (. bean9230 setNamespace (clojure.core/str v9232)))
   (clojure.core/when-let
    [v9232 (:alarm-name m9231)]
    (. bean9230 setAlarmName (clojure.core/str v9232)))
   (clojure.core/when-let
    [v9232 (:metric-name m9231)]
    (. bean9230 setMetricName (clojure.core/str v9232)))
   (clojure.core/when-let
    [v9232 (:okactions m9231)]
    (.
     bean9230
     setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9267] (clojure.core/str arg9267))
 v9232)))
   bean9230))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m9234]
  (clojure.core/let
   [bean9233
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/when-let
    [v9235 (:max-records m9234)]
    (. bean9233 setMaxRecords (clojure.core/int v9235)))
   (clojure.core/when-let
    [v9235 (:next-token m9234)]
    (. bean9233 setNextToken (clojure.core/str v9235)))
   (clojure.core/when-let
    [v9235 (:start-date m9234)]
    (.
     bean9233
     setStartDate
     (com.palletops.awaze.common/to-date v9235)))
   (clojure.core/when-let
    [v9235 (:end-date m9234)]
    (. bean9233 setEndDate (com.palletops.awaze.common/to-date v9235)))
   (clojure.core/when-let
    [v9235 (:alarm-name m9234)]
    (. bean9233 setAlarmName (clojure.core/str v9235)))
   (clojure.core/when-let
    [v9235 (:history-item-type m9234)]
    (.
     bean9233
     setHistoryItemType
     (cloudwatch/history-item-type v9235)))
   bean9233))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m9237]
  (clojure.core/let
   [bean9236
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/when-let
    [v9238 (:alarm-name m9237)]
    (. bean9236 setAlarmName (clojure.core/str v9238)))
   (clojure.core/when-let
    [v9238 (:state-value m9237)]
    (. bean9236 setStateValue (cloudwatch/state-value v9238)))
   (clojure.core/when-let
    [v9238 (:state-reason m9237)]
    (. bean9236 setStateReason (clojure.core/str v9238)))
   (clojure.core/when-let
    [v9238 (:state-reason-data m9237)]
    (. bean9236 setStateReasonData (clojure.core/str v9238)))
   bean9236))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m9240]
  (clojure.core/let
   [bean9239
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/when-let
    [v9241 (:next-token m9240)]
    (. bean9239 setNextToken (clojure.core/str v9241)))
   (clojure.core/when-let
    [v9241 (:namespace m9240)]
    (. bean9239 setNamespace (clojure.core/str v9241)))
   (clojure.core/when-let
    [v9241 (:metric-name m9240)]
    (. bean9239 setMetricName (clojure.core/str v9241)))
   (clojure.core/when-let
    [v9241 (:dimensions m9240)]
    (.
     bean9239
     setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9268] (cloudwatch/dimension-filter arg9268))
 v9241)))
   bean9239))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m9243]
  (clojure.core/let
   [bean9242
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/when-let
    [v9244 (:start-time m9243)]
    (.
     bean9242
     setStartTime
     (com.palletops.awaze.common/to-date v9244)))
   (clojure.core/when-let
    [v9244 (:end-time m9243)]
    (. bean9242 setEndTime (com.palletops.awaze.common/to-date v9244)))
   (clojure.core/when-let
    [v9244 (:namespace m9243)]
    (. bean9242 setNamespace (clojure.core/str v9244)))
   (clojure.core/when-let
    [v9244 (:metric-name m9243)]
    (. bean9242 setMetricName (clojure.core/str v9244)))
   (clojure.core/when-let
    [v9244 (:dimensions m9243)]
    (.
     bean9242
     setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9269] (cloudwatch/dimension arg9269))
 v9244)))
   (clojure.core/when-let
    [v9244 (:period m9243)]
    (. bean9242 setPeriod (clojure.core/int v9244)))
   (clojure.core/when-let
    [v9244 (:unit m9243)]
    (. bean9242 setUnit (cloudwatch/standard-unit v9244)))
   (clojure.core/when-let
    [v9244 (:statistics m9243)]
    (.
     bean9242
     setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9270] (clojure.core/str arg9270))
 v9244)))
   bean9242))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m9246]
  (clojure.core/let
   [bean9245
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/when-let
    [v9247 (:alarm-names m9246)]
    (.
     bean9245
     setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9271] (clojure.core/str arg9271))
 v9247)))
   bean9245))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m9249]
  (clojure.core/let
   [bean9248
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/when-let
    [v9250 (:alarm-names m9249)]
    (.
     bean9248
     setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9272] (clojure.core/str arg9272))
 v9250)))
   bean9248))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m9252]
  (clojure.core/let
   [bean9251
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/when-let
    [v9253 (:namespace m9252)]
    (. bean9251 setNamespace (clojure.core/str v9253)))
   (clojure.core/when-let
    [v9253 (:metric-data m9252)]
    (.
     bean9251
     setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9273] (cloudwatch/metric-datum arg9273))
 v9253)))
   bean9251))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m9255]
  (clojure.core/let
   [bean9254
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/when-let
    [v9256 (:namespace m9255)]
    (. bean9254 setNamespace (clojure.core/str v9256)))
   (clojure.core/when-let
    [v9256 (:metric-name m9255)]
    (. bean9254 setMetricName (clojure.core/str v9256)))
   (clojure.core/when-let
    [v9256 (:dimensions m9255)]
    (.
     bean9254
     setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9274] (cloudwatch/dimension arg9274))
 v9256)))
   (clojure.core/when-let
    [v9256 (:statistic m9255)]
    (. bean9254 setStatistic (clojure.core/str v9256)))
   (clojure.core/when-let
    [v9256 (:period m9255)]
    (. bean9254 setPeriod (clojure.core/int v9256)))
   (clojure.core/when-let
    [v9256 (:unit m9255)]
    (. bean9254 setUnit (cloudwatch/standard-unit v9256)))
   bean9254))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m9258]
  (clojure.core/let
   [bean9257
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/when-let
    [v9259 (:max-records m9258)]
    (. bean9257 setMaxRecords (clojure.core/int v9259)))
   (clojure.core/when-let
    [v9259 (:next-token m9258)]
    (. bean9257 setNextToken (clojure.core/str v9259)))
   (clojure.core/when-let
    [v9259 (:alarm-names m9258)]
    (.
     bean9257
     setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9275] (clojure.core/str arg9275))
 v9259)))
   (clojure.core/when-let
    [v9259 (:alarm-name-prefix m9258)]
    (. bean9257 setAlarmNamePrefix (clojure.core/str v9259)))
   (clojure.core/when-let
    [v9259 (:state-value m9258)]
    (. bean9257 setStateValue (cloudwatch/state-value v9259)))
   (clojure.core/when-let
    [v9259 (:action-prefix m9258)]
    (. bean9257 setActionPrefix (clojure.core/str v9259)))
   bean9257))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m9261]
  (clojure.core/let
   [bean9260
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/when-let
    [v9262 (:alarm-names m9261)]
    (.
     bean9260
     setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9276] (clojure.core/str arg9276))
 v9262)))
   bean9260))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m9277]
   (clojure.core/let
    [credentials9278 (:credentials m9277) args9279 (:args m9277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9280
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9280
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args9279 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         general-progress-listener
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-alarm,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         general-progress-listener
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Call putMetricAlarm"}
   [credentials9282 & args9283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9284
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9284
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args9283 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m9285]
   (clojure.core/let
    [credentials9286 (:credentials m9285) args9287 (:args m9285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9288
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9286)]
     (clojure.core/case
      (clojure.core/count args9287)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9288
        describeAlarmHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9288
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args9287 0))))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         end-date
                         max-records
                         history-item-type
                         alarm-name
                         start-date
                         next-token]}]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         end-date
                         max-records
                         history-item-type
                         alarm-name
                         start-date
                         next-token]}]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials9290 & args9291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9292
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9290)]
    (clojure.core/case
     (clojure.core/count args9291)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9292
       describeAlarmHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9292
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args9291 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m9293]
   (clojure.core/let
    [credentials9294 (:credentials m9293) args9295 (:args m9293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9296
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9296
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args9295 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         general-progress-listener
                         alarm-name]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :set-alarm-state,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         general-progress-listener
                         alarm-name]}]]),
    :doc "Call setAlarmState"}
   [credentials9298 & args9299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9300
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9300
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args9299 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m9301]
   (clojure.core/let
    [credentials9302 (:credentials m9301) args9303 (:args m9301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9304
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9302)]
     (clojure.core/case
      (clojure.core/count args9303)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9304
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args9303 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9304
        listMetrics))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         namespace
                         metric-name
                         general-progress-listener
                         dimensions]}]
                [credentials]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         namespace
                         metric-name
                         general-progress-listener
                         dimensions]}]
                [credentials]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials9306 & args9307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9308
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9306)]
    (clojure.core/case
     (clojure.core/count args9307)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9308
       listMetrics
       (cloudwatch/list-metrics-request (clojure.core/nth args9307 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9308
       listMetrics))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m9309]
   (clojure.core/let
    [credentials9310 (:credentials m9309) args9311 (:args m9309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9312
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9310)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9312
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args9311 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         general-progress-listener
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :get-metric-statistics,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         general-progress-listener
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Call getMetricStatistics"}
   [credentials9314 & args9315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9316
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9314)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9316
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args9315 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m9317]
   (clojure.core/let
    [credentials9318 (:credentials m9317) args9319 (:args m9317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9320
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9320
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args9319 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :disable-alarm-actions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call disableAlarmActions"}
   [credentials9322 & args9323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9324
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9324
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args9323 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m9325]
   (clojure.core/let
    [credentials9326 (:credentials m9325) args9327 (:args m9325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9328
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9328
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args9327 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :enable-alarm-actions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call enableAlarmActions"}
   [credentials9330 & args9331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9332
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9332
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args9331 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m9333]
   (clojure.core/let
    [credentials9334 (:credentials m9333) args9335 (:args m9333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9336
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9336
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args9335 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [namespace
                         metric-data
                         general-progress-listener]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-data,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [namespace
                         metric-data
                         general-progress-listener]}]]),
    :doc "Call putMetricData"}
   [credentials9338 & args9339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9340
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9340
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args9339 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m9341]
   (clojure.core/let
    [credentials9342 (:credentials m9341) args9343 (:args m9341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9344
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9344
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args9343 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [period
                         general-progress-listener
                         metric-name
                         namespace
                         statistic
                         unit
                         dimensions]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms-for-metric,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [period
                         general-progress-listener
                         metric-name
                         namespace
                         statistic
                         unit
                         dimensions]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials9346 & args9347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9348
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9348
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args9347 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m9349]
   (clojure.core/let
    [credentials9350 (:credentials m9349) args9351 (:args m9349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9352
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9350)]
     (clojure.core/case
      (clojure.core/count args9351)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9352
        describeAlarms))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9352
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args9351 0))))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name-prefix
                         general-progress-listener
                         action-prefix
                         state-value
                         max-records
                         next-token
                         alarm-names]}]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name-prefix
                         general-progress-listener
                         action-prefix
                         state-value
                         max-records
                         next-token
                         alarm-names]}]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials9354 & args9355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9356
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9354)]
    (clojure.core/case
     (clojure.core/count args9355)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9356
       describeAlarms))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9356
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args9355 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m9357]
   (clojure.core/let
    [credentials9358 (:credentials m9357) args9359 (:args m9357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9360
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9358)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9360
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args9359 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :delete-alarms,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call deleteAlarms"}
   [credentials9362 & args9363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9364
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9362)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9364
      deleteAlarms
      (cloudwatch/delete-alarms-request (clojure.core/nth args9363 0))))))))
