(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m9783]
  (clojure.core/let
   [bean9782 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/when-let
    [v9784 (:type m9783)]
    (. bean9782 setType (clojure.core/str v9784)))
   (clojure.core/when-let
    [v9784 (:values m9783)]
    (.
     bean9782
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9851] (clojure.core/str arg9851))
 v9784)))
   bean9782))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m9786]
  (clojure.core/let
   [bean9785 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/when-let
    [v9787 (:field-name m9786)]
    (. bean9785 setFieldName (clojure.core/str v9787)))
   (clojure.core/when-let
    [v9787 (:operator m9786)]
    (. bean9785 setOperator (datapipeline/operator v9787)))
   bean9785))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m9789]
  (clojure.core/let
   [bean9788 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/when-let
    [v9790 (:key m9789)]
    (. bean9788 setKey (clojure.core/str v9790)))
   (clojure.core/when-let
    [v9790 (:string-value m9789)]
    (. bean9788 setStringValue (clojure.core/str v9790)))
   (clojure.core/when-let
    [v9790 (:ref-value m9789)]
    (. bean9788 setRefValue (clojure.core/str v9790)))
   bean9788))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m9792]
  (clojure.core/let
   [bean9791 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/when-let
    [v9793 (:selectors m9792)]
    (.
     bean9791
     setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9852] (datapipeline/selector arg9852))
 v9793)))
   bean9791))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m9795]
  (clojure.core/let
   [bean9794
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/when-let
    [v9796 (:document m9795)]
    (. bean9794 setDocument (clojure.core/str v9796)))
   (clojure.core/when-let
    [v9796 (:signature m9795)]
    (. bean9794 setSignature (clojure.core/str v9796)))
   bean9794))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m9798]
  (clojure.core/let
   [bean9797
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/when-let
    [v9799 (:id m9798)]
    (. bean9797 setId (clojure.core/str v9799)))
   (clojure.core/when-let
    [v9799 (:name m9798)]
    (. bean9797 setName (clojure.core/str v9799)))
   (clojure.core/when-let
    [v9799 (:fields m9798)]
    (.
     bean9797
     setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9853] (datapipeline/field arg9853))
 v9799)))
   bean9797))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.TaskStatus}
task-status
  [m9801]
  (.
   com.amazonaws.services.datapipeline.model.TaskStatus
   fromValue
   (clojure.core/name m9801)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m9804]
  (clojure.core/let
   [bean9803
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/when-let
    [v9805 (:marker m9804)]
    (. bean9803 setMarker (clojure.core/str v9805)))
   (clojure.core/when-let
    [v9805 (:pipeline-id m9804)]
    (. bean9803 setPipelineId (clojure.core/str v9805)))
   (clojure.core/when-let
    [v9805 (:object-ids m9804)]
    (.
     bean9803
     setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9854] (clojure.core/str arg9854))
 v9805)))
   (clojure.core/when-let
    [v9805 (:evaluate-expressions m9804)]
    (. bean9803 setEvaluateExpressions (clojure.core/boolean v9805)))
   bean9803))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m9807]
  (clojure.core/let
   [bean9806
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/when-let
    [v9808 (:worker-group m9807)]
    (. bean9806 setWorkerGroup (clojure.core/str v9808)))
   (clojure.core/when-let
    [v9808 (:hostname m9807)]
    (. bean9806 setHostname (clojure.core/str v9808)))
   (clojure.core/when-let
    [v9808 (:taskrunner-id m9807)]
    (. bean9806 setTaskrunnerId (clojure.core/str v9808)))
   bean9806))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m9810]
  (clojure.core/let
   [bean9809
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/when-let
    [v9811 (:marker m9810)]
    (. bean9809 setMarker (clojure.core/str v9811)))
   (clojure.core/when-let
    [v9811 (:limit m9810)]
    (. bean9809 setLimit (clojure.core/int v9811)))
   (clojure.core/when-let
    [v9811 (:pipeline-id m9810)]
    (. bean9809 setPipelineId (clojure.core/str v9811)))
   (clojure.core/when-let
    [v9811 (:query m9810)]
    (. bean9809 setQuery (datapipeline/query v9811)))
   (clojure.core/when-let
    [v9811 (:sphere m9810)]
    (. bean9809 setSphere (clojure.core/str v9811)))
   bean9809))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m9813]
  (clojure.core/let
   [bean9812
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/when-let
    [v9814 (:pipeline-ids m9813)]
    (.
     bean9812
     setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9855] (clojure.core/str arg9855))
 v9814)))
   bean9812))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m9816]
  (clojure.core/let
   [bean9815
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/when-let
    [v9817 (:pipeline-id m9816)]
    (. bean9815 setPipelineId (clojure.core/str v9817)))
   bean9815))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m9819]
  (clojure.core/let
   [bean9818
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/when-let
    [v9820 (:status m9819)]
    (. bean9818 setStatus (clojure.core/str v9820)))
   (clojure.core/when-let
    [v9820 (:pipeline-id m9819)]
    (. bean9818 setPipelineId (clojure.core/str v9820)))
   (clojure.core/when-let
    [v9820 (:object-ids m9819)]
    (.
     bean9818
     setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9856] (clojure.core/str arg9856))
 v9820)))
   bean9818))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m9822]
  (clojure.core/let
   [bean9821
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9823 (:version m9822)]
    (. bean9821 setVersion (clojure.core/str v9823)))
   (clojure.core/when-let
    [v9823 (:pipeline-id m9822)]
    (. bean9821 setPipelineId (clojure.core/str v9823)))
   bean9821))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m9825]
  (clojure.core/let
   [bean9824
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/when-let
    [v9826 (:worker-group m9825)]
    (. bean9824 setWorkerGroup (clojure.core/str v9826)))
   (clojure.core/when-let
    [v9826 (:hostname m9825)]
    (. bean9824 setHostname (clojure.core/str v9826)))
   (clojure.core/when-let
    [v9826 (:instance-identity m9825)]
    (.
     bean9824
     setInstanceIdentity
     (datapipeline/instance-identity v9826)))
   bean9824))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m9828]
  (clojure.core/let
   [bean9827
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/when-let
    [v9829 (:task-id m9828)]
    (. bean9827 setTaskId (clojure.core/str v9829)))
   bean9827))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m9831]
  (clojure.core/let
   [bean9830
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/when-let
    [v9832 (:pipeline-id m9831)]
    (. bean9830 setPipelineId (clojure.core/str v9832)))
   bean9830))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m9834]
  (clojure.core/let
   [bean9833
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/when-let
    [v9835 (:name m9834)]
    (. bean9833 setName (clojure.core/str v9835)))
   (clojure.core/when-let
    [v9835 (:description m9834)]
    (. bean9833 setDescription (clojure.core/str v9835)))
   (clojure.core/when-let
    [v9835 (:unique-id m9834)]
    (. bean9833 setUniqueId (clojure.core/str v9835)))
   bean9833))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m9837]
  (clojure.core/let
   [bean9836
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/when-let
    [v9838 (:expression m9837)]
    (. bean9836 setExpression (clojure.core/str v9838)))
   (clojure.core/when-let
    [v9838 (:pipeline-id m9837)]
    (. bean9836 setPipelineId (clojure.core/str v9838)))
   (clojure.core/when-let
    [v9838 (:object-id m9837)]
    (. bean9836 setObjectId (clojure.core/str v9838)))
   bean9836))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m9840]
  (clojure.core/let
   [bean9839
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9841 (:pipeline-id m9840)]
    (. bean9839 setPipelineId (clojure.core/str v9841)))
   (clojure.core/when-let
    [v9841 (:pipeline-objects m9840)]
    (.
     bean9839
     setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9857] (datapipeline/pipeline-object arg9857))
 v9841)))
   bean9839))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m9843]
  (clojure.core/let
   [bean9842
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/when-let
    [v9844 (:marker m9843)]
    (. bean9842 setMarker (clojure.core/str v9844)))
   bean9842))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m9846]
  (clojure.core/let
   [bean9845
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/when-let
    [v9847 (:task-status m9846)]
    (. bean9845 setTaskStatus (datapipeline/task-status v9847)))
   (clojure.core/when-let
    [v9847 (:task-id m9846)]
    (. bean9845 setTaskId (clojure.core/str v9847)))
   (clojure.core/when-let
    [v9847 (:error-id m9846)]
    (. bean9845 setErrorId (clojure.core/str v9847)))
   (clojure.core/when-let
    [v9847 (:error-message m9846)]
    (. bean9845 setErrorMessage (clojure.core/str v9847)))
   (clojure.core/when-let
    [v9847 (:error-stack-trace m9846)]
    (. bean9845 setErrorStackTrace (clojure.core/str v9847)))
   bean9845))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m9849]
  (clojure.core/let
   [bean9848
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9850 (:pipeline-id m9849)]
    (. bean9848 setPipelineId (clojure.core/str v9850)))
   (clojure.core/when-let
    [v9850 (:pipeline-objects m9849)]
    (.
     bean9848
     setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9858] (datapipeline/pipeline-object arg9858))
 v9850)))
   bean9848))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m9859]
   (clojure.core/let
    [credentials9860 (:credentials m9859) args9861 (:args m9859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9862
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9862
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args9861 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-ids
                         marker
                         general-progress-listener
                         evaluate-expressions]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-objects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-ids
                         marker
                         general-progress-listener
                         evaluate-expressions]}]]),
    :doc "Call describeObjects"}
   [credentials9864 & args9865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9866
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9866
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args9865 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m9867]
   (clojure.core/let
    [credentials9868 (:credentials m9867) args9869 (:args m9867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9870
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9870
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args9869 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         hostname
                         general-progress-listener]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         hostname
                         general-progress-listener]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials9872 & args9873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9874
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9874
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args9873 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m9875]
   (clojure.core/let
    [credentials9876 (:credentials m9875) args9877 (:args m9875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9878
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9878
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args9877 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [query
                         sphere
                         marker
                         limit
                         general-progress-listener
                         pipeline-id]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :query-objects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [query
                         sphere
                         marker
                         limit
                         general-progress-listener
                         pipeline-id]}]]),
    :doc "Call queryObjects"}
   [credentials9880 & args9881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9882
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9882
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args9881 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m9883]
   (clojure.core/let
    [credentials9884 (:credentials m9883) args9885 (:args m9883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9886
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9886
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args9885 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-ids general-progress-listener]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-pipelines,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-ids general-progress-listener]}]]),
    :doc "Call describePipelines"}
   [credentials9888 & args9889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9890
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9890
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args9889 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m9891]
   (clojure.core/let
    [credentials9892 (:credentials m9891) args9893 (:args m9891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9894
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9894
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args9893 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :activate-pipeline,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Call activatePipeline"}
   [credentials9896 & args9897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9898
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9898
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args9897 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m9899]
   (clojure.core/let
    [credentials9900 (:credentials m9899) args9901 (:args m9899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9902
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9902
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args9901 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [status
                         pipeline-id
                         object-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [status
                         pipeline-id
                         object-ids
                         general-progress-listener]}]]),
    :doc "Call setStatus"}
   [credentials9904 & args9905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9906
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9906
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args9905 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m9907]
   (clojure.core/let
    [credentials9908 (:credentials m9907) args9909 (:args m9907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9910
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9910
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args9909 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [version
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :get-pipeline-definition,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [version
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials9912 & args9913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9914
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9914
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args9913 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m9915]
   (clojure.core/let
    [credentials9916 (:credentials m9915) args9917 (:args m9915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9918
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9918
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args9917 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         instance-identity
                         hostname
                         general-progress-listener]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :poll-for-task,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         instance-identity
                         hostname
                         general-progress-listener]}]]),
    :doc "Call pollForTask"}
   [credentials9920 & args9921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9922
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9922
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args9921 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m9923]
   (clojure.core/let
    [credentials9924 (:credentials m9923) args9925 (:args m9923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9926
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9926
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args9925 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id general-progress-listener]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-progress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id general-progress-listener]}]]),
    :doc "Call reportTaskProgress"}
   [credentials9928 & args9929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9930
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9930
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args9929 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m9931]
   (clojure.core/let
    [credentials9932 (:credentials m9931) args9933 (:args m9931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9934
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9934
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args9933 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :delete-pipeline,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Call deletePipeline"}
   [credentials9936 & args9937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9938
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9938
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args9937 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m9939]
   (clojure.core/let
    [credentials9940 (:credentials m9939) args9941 (:args m9939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9942
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9942
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args9941 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         name
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :create-pipeline,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         name
                         general-progress-listener
                         description]}]]),
    :doc "Call createPipeline"}
   [credentials9944 & args9945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9946
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9946
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args9945 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m9947]
   (clojure.core/let
    [credentials9948 (:credentials m9947) args9949 (:args m9947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9950
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9950
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args9949 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-id
                         general-progress-listener
                         expression]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :evaluate-expression,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-id
                         general-progress-listener
                         expression]}]]),
    :doc "Call evaluateExpression"}
   [credentials9952 & args9953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9954
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9954
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args9953 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m9955]
   (clojure.core/let
    [credentials9956 (:credentials m9955) args9957 (:args m9955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9958
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9958
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args9957 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :put-pipeline-definition,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials9960 & args9961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9962
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9962
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args9961 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m9963]
   (clojure.core/let
    [credentials9964 (:credentials m9963) args9965 (:args m9963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9966
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9964)]
     (clojure.core/case
      (clojure.core/count args9965)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9966
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9966
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args9965 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker general-progress-listener]}]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1649__auto__]
    {:args [],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker general-progress-listener]}]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials9968 & args9969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9970
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9968)]
    (clojure.core/case
     (clojure.core/count args9969)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9970
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9970
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args9969 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m9971]
   (clojure.core/let
    [credentials9972 (:credentials m9971) args9973 (:args m9971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9974
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9974
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args9973 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         general-progress-listener
                         error-message
                         error-stack-trace
                         error-id]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-task-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         general-progress-listener
                         error-message
                         error-stack-trace
                         error-id]}]]),
    :doc "Call setTaskStatus"}
   [credentials9976 & args9977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9978
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9978
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args9977 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m9979]
   (clojure.core/let
    [credentials9980 (:credentials m9979) args9981 (:args m9979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9982
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9980)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9982
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args9981 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :validate-pipeline-definition,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials9984 & args9985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9986
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9984)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9986
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args9985 0))))))))
