(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m5980]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m5980)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PermissionGroup}
permission-group
  [m5983]
  (.
   com.amazonaws.services.ec2.model.PermissionGroup
   fromValue
   (clojure.core/name m5983)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m5986]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m5986)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m5989]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m5989)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m5992]
  (clojure.core/let
   [bean5991 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/when-let
    [v5993 (:encrypted m5992)]
    (. bean5991 setEncrypted (clojure.core/boolean v5993)))
   (clojure.core/when-let
    [v5993 (:snapshot-id m5992)]
    (. bean5991 setSnapshotId (clojure.core/str v5993)))
   (clojure.core/when-let
    [v5993 (:volume-size m5992)]
    (. bean5991 setVolumeSize (clojure.core/int v5993)))
   (clojure.core/when-let
    [v5993 (:volume-type m5992)]
    (. bean5991 setVolumeType (ec2/volume-type v5993)))
   (clojure.core/when-let
    [v5993 (:delete-on-termination m5992)]
    (. bean5991 setDeleteOnTermination (clojure.core/boolean v5993)))
   (clojure.core/when-let
    [v5993 (:iops m5992)]
    (. bean5991 setIops (clojure.core/int v5993)))
   bean5991))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m5995]
  (clojure.core/let
   [bean5994
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/when-let
    [v5996 (:primary m5995)]
    (. bean5994 setPrimary (clojure.core/boolean v5996)))
   (clojure.core/when-let
    [v5996 (:private-ip-address m5995)]
    (. bean5994 setPrivateIpAddress (clojure.core/str v5996)))
   bean5994))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m5998]
  (clojure.core/let
   [bean5997 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/when-let
    [v5999 (:user-id m5998)]
    (. bean5997 setUserId (clojure.core/str v5999)))
   (clojure.core/when-let
    [v5999 (:group-name m5998)]
    (. bean5997 setGroupName (clojure.core/str v5999)))
   (clojure.core/when-let
    [v5999 (:group-id m5998)]
    (. bean5997 setGroupId (clojure.core/str v5999)))
   bean5997))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m6001]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m6001)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m6004]
  (clojure.core/let
   [bean6003 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/when-let
    [v6005 (:user-id m6004)]
    (. bean6003 setUserId (clojure.core/str v6005)))
   (clojure.core/when-let
    [v6005 (:group m6004)]
    (. bean6003 setGroup (ec2/permission-group v6005)))
   bean6003))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m6007]
  (clojure.core/let
   [bean6006
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/when-let
    [v6008 (:user-id m6007)]
    (. bean6006 setUserId (clojure.core/str v6008)))
   (clojure.core/when-let
    [v6008 (:group m6007)]
    (. bean6006 setGroup (ec2/permission-group v6008)))
   bean6006))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m6010]
  (clojure.core/let
   [bean6009 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/when-let
    [v6011 (:availability-zone m6010)]
    (. bean6009 setAvailabilityZone (clojure.core/str v6011)))
   (clojure.core/when-let
    [v6011 (:tenancy m6010)]
    (. bean6009 setTenancy (ec2/tenancy v6011)))
   (clojure.core/when-let
    [v6011 (:group-name m6010)]
    (. bean6009 setGroupName (clojure.core/str v6011)))
   bean6009))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m6013]
  (clojure.core/let
   [bean6012 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/when-let
    [v6014 (:format m6013)]
    (. bean6012 setFormat (ec2/disk-image-format v6014)))
   (clojure.core/when-let
    [v6014 (:bytes m6013)]
    (. bean6012 setBytes (clojure.core/long v6014)))
   (clojure.core/when-let
    [v6014 (:import-manifest-url m6013)]
    (. bean6012 setImportManifestUrl (clojure.core/str v6014)))
   bean6012))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m6016]
  (clojure.core/let
   [bean6015 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/when-let
    [v6017 (:size m6016)]
    (. bean6015 setSize (clojure.core/long v6017)))
   bean6015))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m6019]
  (clojure.core/let
   [bean6018
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/when-let
    [v6020 (:delete-on-termination m6019)]
    (. bean6018 setDeleteOnTermination (clojure.core/boolean v6020)))
   (clojure.core/when-let
    [v6020 (:volume-id m6019)]
    (. bean6018 setVolumeId (clojure.core/str v6020)))
   bean6018))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m6022]
  (clojure.core/let
   [bean6021 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/when-let
    [v6023 (:prefix m6022)]
    (. bean6021 setPrefix (clojure.core/str v6023)))
   (clojure.core/when-let
    [v6023 (:bucket m6022)]
    (. bean6021 setBucket (clojure.core/str v6023)))
   (clojure.core/when-let
    [v6023 (:awsaccess-key-id m6022)]
    (. bean6021 setAWSAccessKeyId (clojure.core/str v6023)))
   (clojure.core/when-let
    [v6023 (:upload-policy m6022)]
    (. bean6021 setUploadPolicy (clojure.core/str v6023)))
   (clojure.core/when-let
    [v6023 (:upload-policy-signature m6022)]
    (. bean6021 setUploadPolicySignature (clojure.core/str v6023)))
   bean6021))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m6025]
  (clojure.core/let
   [bean6024
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/when-let
    [v6026 (:name m6025)]
    (. bean6024 setName (clojure.core/str v6026)))
   (clojure.core/when-let
    [v6026 (:arn m6025)]
    (. bean6024 setArn (clojure.core/str v6026)))
   bean6024))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m6028]
  (clojure.core/let
   [bean6027 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/when-let
    [v6029 (:availability-zone m6028)]
    (. bean6027 setAvailabilityZone (clojure.core/str v6029)))
   (clojure.core/when-let
    [v6029 (:group-name m6028)]
    (. bean6027 setGroupName (clojure.core/str v6029)))
   bean6027))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m6031]
  (clojure.core/let
   [bean6030
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v6032 (:virtual-name m6031)]
    (. bean6030 setVirtualName (clojure.core/str v6032)))
   (clojure.core/when-let
    [v6032 (:device-name m6031)]
    (. bean6030 setDeviceName (clojure.core/str v6032)))
   (clojure.core/when-let
    [v6032 (:ebs m6031)]
    (. bean6030 setEbs (ec2/ebs-block-device v6032)))
   (clojure.core/when-let
    [v6032 (:no-device m6031)]
    (. bean6030 setNoDevice (clojure.core/str v6032)))
   bean6030))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m6034]
  (clojure.core/let
   [bean6033
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/when-let
    [v6035 (:network-interface-id m6034)]
    (. bean6033 setNetworkInterfaceId (clojure.core/str v6035)))
   (clojure.core/when-let
    [v6035 (:associate-public-ip-address m6034)]
    (.
     bean6033
     setAssociatePublicIpAddress
     (clojure.core/boolean v6035)))
   (clojure.core/when-let
    [v6035 (:private-ip-address m6034)]
    (. bean6033 setPrivateIpAddress (clojure.core/str v6035)))
   (clojure.core/when-let
    [v6035 (:secondary-private-ip-address-count m6034)]
    (.
     bean6033
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6035)))
   (clojure.core/when-let
    [v6035 (:groups m6034)]
    (.
     bean6033
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6591] (clojure.core/str arg6591))
 v6035)))
   (clojure.core/when-let
    [v6035 (:delete-on-termination m6034)]
    (. bean6033 setDeleteOnTermination (clojure.core/boolean v6035)))
   (clojure.core/when-let
    [v6035 (:private-ip-addresses m6034)]
    (.
     bean6033
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6592]
  (ec2/private-ip-address-specification arg6592))
 v6035)))
   (clojure.core/when-let
    [v6035 (:description m6034)]
    (. bean6033 setDescription (clojure.core/str v6035)))
   (clojure.core/when-let
    [v6035 (:device-index m6034)]
    (. bean6033 setDeviceIndex (clojure.core/int v6035)))
   (clojure.core/when-let
    [v6035 (:subnet-id m6034)]
    (. bean6033 setSubnetId (clojure.core/str v6035)))
   bean6033))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m6037]
  (clojure.core/let
   [bean6036 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/when-let
    [v6038 (:group-name m6037)]
    (. bean6036 setGroupName (clojure.core/str v6038)))
   (clojure.core/when-let
    [v6038 (:group-id m6037)]
    (. bean6036 setGroupId (clojure.core/str v6038)))
   bean6036))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m6040]
  (clojure.core/let
   [bean6039 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/when-let
    [v6041 (:name m6040)]
    (. bean6039 setName (clojure.core/str v6041)))
   (clojure.core/when-let
    [v6041 (:values m6040)]
    (.
     bean6039
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6593] (clojure.core/str arg6593))
 v6041)))
   bean6039))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m6043]
  (clojure.core/let
   [bean6042 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/when-let
    [v6044 (:code m6043)]
    (. bean6042 setCode (clojure.core/int v6044)))
   (clojure.core/when-let
    [v6044 (:type m6043)]
    (. bean6042 setType (clojure.core/int v6044)))
   bean6042))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m6046]
  (clojure.core/let
   [bean6045 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/when-let
    [v6047 (:from m6046)]
    (. bean6045 setFrom (clojure.core/int v6047)))
   (clojure.core/when-let
    [v6047 (:to m6046)]
    (. bean6045 setTo (clojure.core/int v6047)))
   bean6045))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m6049]
  (clojure.core/let
   [bean6048 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/when-let
    [v6050 (:user-id-group-pairs m6049)]
    (.
     bean6048
     setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6594] (ec2/user-id-group-pair arg6594))
 v6050)))
   (clojure.core/when-let
    [v6050 (:ip-ranges m6049)]
    (.
     bean6048
     setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6595] (clojure.core/str arg6595))
 v6050)))
   (clojure.core/when-let
    [v6050 (:ip-protocol m6049)]
    (. bean6048 setIpProtocol (clojure.core/str v6050)))
   (clojure.core/when-let
    [v6050 (:from-port m6049)]
    (. bean6048 setFromPort (clojure.core/int v6050)))
   (clojure.core/when-let
    [v6050 (:to-port m6049)]
    (. bean6048 setToPort (clojure.core/int v6050)))
   bean6048))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m6052]
  (clojure.core/let
   [bean6051
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/when-let
    [v6053 (:currency-code m6052)]
    (. bean6051 setCurrencyCode (ec2/currency-code-values v6053)))
   (clojure.core/when-let
    [v6053 (:term m6052)]
    (. bean6051 setTerm (clojure.core/long v6053)))
   (clojure.core/when-let
    [v6053 (:price m6052)]
    (. bean6051 setPrice (clojure.core/double v6053)))
   bean6051))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeName}
reset-image-attribute-name
  [m6055]
  (.
   com.amazonaws.services.ec2.model.ResetImageAttributeName
   fromValue
   (clojure.core/name m6055)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m6058]
  (clojure.core/let
   [bean6057
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/when-let
    [v6059 (:add m6058)]
    (.
     bean6057
     setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6596] (ec2/launch-permission arg6596))
 v6059)))
   (clojure.core/when-let
    [v6059 (:remove m6058)]
    (.
     bean6057
     setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6597] (ec2/launch-permission arg6597))
 v6059)))
   bean6057))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageAttributeName}
image-attribute-name
  [m6061]
  (.
   com.amazonaws.services.ec2.model.ImageAttributeName
   fromValue
   (clojure.core/name m6061)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportStatusType}
report-status-type
  [m6064]
  (.
   com.amazonaws.services.ec2.model.ReportStatusType
   fromValue
   (clojure.core/name m6064)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m6067]
  (clojure.core/let
   [bean6066 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/when-let
    [v6068 (:key m6067)]
    (. bean6066 setKey (clojure.core/str v6068)))
   (clojure.core/when-let
    [v6068 (:value m6067)]
    (. bean6066 setValue (clojure.core/str v6068)))
   bean6066))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m6070]
  (clojure.core/let
   [bean6069
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/when-let
    [v6071 (:add m6070)]
    (.
     bean6069
     setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6598] (ec2/create-volume-permission arg6598))
 v6071)))
   (clojure.core/when-let
    [v6071 (:remove m6070)]
    (.
     bean6069
     setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6599] (ec2/create-volume-permission arg6599))
 v6071)))
   bean6069))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m6073]
  (clojure.core/let
   [bean6072
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/when-let
    [v6074 (:availability-zone m6073)]
    (. bean6072 setAvailabilityZone (clojure.core/str v6074)))
   (clojure.core/when-let
    [v6074 (:instance-type m6073)]
    (. bean6072 setInstanceType (clojure.core/str v6074)))
   (clojure.core/when-let
    [v6074 (:platform m6073)]
    (. bean6072 setPlatform (clojure.core/str v6074)))
   (clojure.core/when-let
    [v6074 (:instance-count m6073)]
    (. bean6072 setInstanceCount (clojure.core/int v6074)))
   bean6072))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m6076]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m6076)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m6079]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m6079)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m6082]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m6082)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m6085]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m6085)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m6088]
  (clojure.core/let
   [bean6087
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/when-let
    [v6089 (:placement m6088)]
    (. bean6087 setPlacement (ec2/placement v6089)))
   (clojure.core/when-let
    [v6089 (:monitoring m6088)]
    (. bean6087 setMonitoring (clojure.core/boolean v6089)))
   (clojure.core/when-let
    [v6089 (:group-names m6088)]
    (.
     bean6087
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6600] (clojure.core/str arg6600))
 v6089)))
   (clojure.core/when-let
    [v6089 (:private-ip-address m6088)]
    (. bean6087 setPrivateIpAddress (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:instance-type m6088)]
    (. bean6087 setInstanceType (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:architecture m6088)]
    (. bean6087 setArchitecture (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:user-data m6088)]
    (. bean6087 setUserData (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:additional-info m6088)]
    (. bean6087 setAdditionalInfo (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:subnet-id m6088)]
    (. bean6087 setSubnetId (clojure.core/str v6089)))
   (clojure.core/when-let
    [v6089 (:instance-initiated-shutdown-behavior m6088)]
    (.
     bean6087
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v6089)))
   bean6087))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m6091]
  (clojure.core/let
   [bean6090 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/when-let
    [v6092 (:description m6091)]
    (. bean6090 setDescription (clojure.core/str v6092)))
   (clojure.core/when-let
    [v6092 (:image m6091)]
    (. bean6090 setImage (ec2/disk-image-detail v6092)))
   (clojure.core/when-let
    [v6092 (:volume m6091)]
    (. bean6090 setVolume (ec2/volume-detail v6092)))
   bean6090))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DomainType}
domain-type
  [m6094]
  (.
   com.amazonaws.services.ec2.model.DomainType
   fromValue
   (clojure.core/name m6094)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m6097]
  (clojure.core/let
   [bean6096
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/when-let
    [v6098 (:delete-on-termination m6097)]
    (. bean6096 setDeleteOnTermination (clojure.core/boolean v6098)))
   (clojure.core/when-let
    [v6098 (:attachment-id m6097)]
    (. bean6096 setAttachmentId (clojure.core/str v6098)))
   bean6096))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m6100]
  (clojure.core/let
   [bean6099
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/when-let
    [v6101 (:virtual-name m6100)]
    (. bean6099 setVirtualName (clojure.core/str v6101)))
   (clojure.core/when-let
    [v6101 (:device-name m6100)]
    (. bean6099 setDeviceName (clojure.core/str v6101)))
   (clojure.core/when-let
    [v6101 (:ebs m6100)]
    (.
     bean6099
     setEbs
     (ec2/ebs-instance-block-device-specification v6101)))
   (clojure.core/when-let
    [v6101 (:no-device m6100)]
    (. bean6099 setNoDevice (clojure.core/str v6101)))
   bean6099))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m6103]
  (clojure.core/let
   [bean6102 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/when-let
    [v6104 (:s3 m6103)]
    (. bean6102 setS3 (ec2/s3storage v6104)))
   bean6102))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m6106]
  (clojure.core/let
   [bean6105
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/when-let
    [v6107 (:currency-code m6106)]
    (. bean6105 setCurrencyCode (ec2/currency-code-values v6107)))
   (clojure.core/when-let
    [v6107 (:amount m6106)]
    (. bean6105 setAmount (clojure.core/double v6107)))
   bean6105))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GatewayType}
gateway-type
  [m6109]
  (.
   com.amazonaws.services.ec2.model.GatewayType
   fromValue
   (clojure.core/name m6109)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportEnvironment}
export-environment
  [m6112]
  (.
   com.amazonaws.services.ec2.model.ExportEnvironment
   fromValue
   (clojure.core/name m6112)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m6115]
  (clojure.core/let
   [bean6114
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/when-let
    [v6116 (:disk-image-format m6115)]
    (. bean6114 setDiskImageFormat (clojure.core/str v6116)))
   (clojure.core/when-let
    [v6116 (:container-format m6115)]
    (. bean6114 setContainerFormat (clojure.core/str v6116)))
   (clojure.core/when-let
    [v6116 (:s3bucket m6115)]
    (. bean6114 setS3Bucket (clojure.core/str v6116)))
   (clojure.core/when-let
    [v6116 (:s3prefix m6115)]
    (. bean6114 setS3Prefix (clojure.core/str v6116)))
   bean6114))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m6118]
  (clojure.core/let
   [bean6117
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/when-let
    [v6119 (:static-routes-only m6118)]
    (. bean6117 setStaticRoutesOnly (clojure.core/boolean v6119)))
   bean6117))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceAttributeName}
instance-attribute-name
  [m6121]
  (.
   com.amazonaws.services.ec2.model.InstanceAttributeName
   fromValue
   (clojure.core/name m6121)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m6124]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m6124)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m6127]
  (clojure.core/let
   [bean6126
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/when-let
    [v6128 (:iam-instance-profile m6127)]
    (.
     bean6126
     setIamInstanceProfile
     (ec2/iam-instance-profile-specification v6128)))
   (clojure.core/when-let
    [v6128 (:placement m6127)]
    (. bean6126 setPlacement (ec2/spot-placement v6128)))
   (clojure.core/when-let
    [v6128 (:block-device-mappings m6127)]
    (.
     bean6126
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6601] (ec2/block-device-mapping arg6601))
 v6128)))
   (clojure.core/when-let
    [v6128 (:network-interfaces m6127)]
    (.
     bean6126
     setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6602]
  (ec2/instance-network-interface-specification arg6602))
 v6128)))
   (clojure.core/when-let
    [v6128 (:key-name m6127)]
    (. bean6126 setKeyName (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:addressing-type m6127)]
    (. bean6126 setAddressingType (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:instance-type m6127)]
    (. bean6126 setInstanceType (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:all-security-groups m6127)]
    (.
     bean6126
     setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6603] (ec2/group-identifier arg6603))
 v6128)))
   (clojure.core/when-let
    [v6128 (:ebs-optimized m6127)]
    (. bean6126 setEbsOptimized (clojure.core/boolean v6128)))
   (clojure.core/when-let
    [v6128 (:image-id m6127)]
    (. bean6126 setImageId (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:ramdisk-id m6127)]
    (. bean6126 setRamdiskId (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:security-groups m6127)]
    (.
     bean6126
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6604] (clojure.core/str arg6604))
 v6128)))
   (clojure.core/when-let
    [v6128 (:user-data m6127)]
    (. bean6126 setUserData (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:monitoring-enabled m6127)]
    (. bean6126 setMonitoringEnabled (clojure.core/boolean v6128)))
   (clojure.core/when-let
    [v6128 (:kernel-id m6127)]
    (. bean6126 setKernelId (clojure.core/str v6128)))
   (clojure.core/when-let
    [v6128 (:subnet-id m6127)]
    (. bean6126 setSubnetId (clojure.core/str v6128)))
   bean6126))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m6130]
  (clojure.core/let
   [bean6129 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/when-let
    [v6131 (:key m6130)]
    (. bean6129 setKey (clojure.core/str v6131)))
   (clojure.core/when-let
    [v6131 (:values m6130)]
    (.
     bean6129
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6605] (clojure.core/str arg6605))
 v6131)))
   bean6129))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m6133]
  (clojure.core/let
   [bean6132
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/when-let
    [v6134 (:filters m6133)]
    (.
     bean6132
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6606] (ec2/filter arg6606))
 v6134)))
   (clojure.core/when-let
    [v6134 (:group-names m6133)]
    (.
     bean6132
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6607] (clojure.core/str arg6607))
 v6134)))
   (clojure.core/when-let
    [v6134 (:group-ids m6133)]
    (.
     bean6132
     setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6608] (clojure.core/str arg6608))
 v6134)))
   bean6132))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m6136]
  (clojure.core/let
   [bean6135 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/when-let
    [v6137 (:cidr-block m6136)]
    (. bean6135 setCidrBlock (clojure.core/str v6137)))
   (clojure.core/when-let
    [v6137 (:instance-tenancy m6136)]
    (. bean6135 setInstanceTenancy (clojure.core/str v6137)))
   bean6135))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m6139]
  (clojure.core/let
   [bean6138
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/when-let
    [v6140 (:image-id m6139)]
    (. bean6138 setImageId (clojure.core/str v6140)))
   bean6138))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m6142]
  (clojure.core/let
   [bean6141
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6143 (:protocol m6142)]
    (. bean6141 setProtocol (clojure.core/str v6143)))
   (clojure.core/when-let
    [v6143 (:network-acl-id m6142)]
    (. bean6141 setNetworkAclId (clojure.core/str v6143)))
   (clojure.core/when-let
    [v6143 (:rule-number m6142)]
    (. bean6141 setRuleNumber (clojure.core/int v6143)))
   (clojure.core/when-let
    [v6143 (:rule-action m6142)]
    (. bean6141 setRuleAction (clojure.core/str v6143)))
   (clojure.core/when-let
    [v6143 (:egress m6142)]
    (. bean6141 setEgress (clojure.core/boolean v6143)))
   (clojure.core/when-let
    [v6143 (:cidr-block m6142)]
    (. bean6141 setCidrBlock (clojure.core/str v6143)))
   (clojure.core/when-let
    [v6143 (:icmp-type-code m6142)]
    (. bean6141 setIcmpTypeCode (ec2/icmp-type-code v6143)))
   (clojure.core/when-let
    [v6143 (:port-range m6142)]
    (. bean6141 setPortRange (ec2/port-range v6143)))
   bean6141))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m6145]
  (clojure.core/let
   [bean6144
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/when-let
    [v6146 (:export-task-id m6145)]
    (. bean6144 setExportTaskId (clojure.core/str v6146)))
   bean6144))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m6148]
  (clojure.core/let
   [bean6147
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v6149 (:ip-protocol m6148)]
    (. bean6147 setIpProtocol (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:group-name m6148)]
    (. bean6147 setGroupName (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:source-security-group-owner-id m6148)]
    (.
     bean6147
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:source-security-group-name m6148)]
    (. bean6147 setSourceSecurityGroupName (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:from-port m6148)]
    (. bean6147 setFromPort (clojure.core/int v6149)))
   (clojure.core/when-let
    [v6149 (:group-id m6148)]
    (. bean6147 setGroupId (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:ip-permissions m6148)]
    (.
     bean6147
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6609] (ec2/ip-permission arg6609))
 v6149)))
   (clojure.core/when-let
    [v6149 (:cidr-ip m6148)]
    (. bean6147 setCidrIp (clojure.core/str v6149)))
   (clojure.core/when-let
    [v6149 (:to-port m6148)]
    (. bean6147 setToPort (clojure.core/int v6149)))
   bean6147))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m6151]
  (clojure.core/let
   [bean6150
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/when-let
    [v6152 (:filters m6151)]
    (.
     bean6150
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6610] (ec2/filter arg6610))
 v6152)))
   (clojure.core/when-let
    [v6152 (:route-table-ids m6151)]
    (.
     bean6150
     setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6611] (clojure.core/str arg6611))
 v6152)))
   bean6150))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m6154]
  (clojure.core/let
   [bean6153
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v6155 (:instance-count m6154)]
    (. bean6153 setInstanceCount (clojure.core/int v6155)))
   (clojure.core/when-let
    [v6155 (:client-token m6154)]
    (. bean6153 setClientToken (clojure.core/str v6155)))
   (clojure.core/when-let
    [v6155 (:reserved-instances-id m6154)]
    (. bean6153 setReservedInstancesId (clojure.core/str v6155)))
   (clojure.core/when-let
    [v6155 (:price-schedules m6154)]
    (.
     bean6153
     setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6612]
  (ec2/price-schedule-specification arg6612))
 v6155)))
   bean6153))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m6157]
  (clojure.core/let
   [bean6156
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/when-let
    [v6158 (:image-id m6157)]
    (. bean6156 setImageId (clojure.core/str v6158)))
   (clojure.core/when-let
    [v6158 (:attribute m6157)]
    (. bean6156 setAttribute (ec2/reset-image-attribute-name v6158)))
   bean6156))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m6160]
  (clojure.core/let
   [bean6159
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/when-let
    [v6161 (:filters m6160)]
    (.
     bean6159
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6613] (ec2/filter arg6613))
 v6161)))
   (clojure.core/when-let
    [v6161 (:zone-names m6160)]
    (.
     bean6159
     setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6614] (clojure.core/str arg6614))
 v6161)))
   bean6159))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m6163]
  (clojure.core/let
   [bean6162
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/when-let
    [v6164 (:filters m6163)]
    (.
     bean6162
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6615] (ec2/filter arg6615))
 v6164)))
   (clojure.core/when-let
    [v6164 (:network-acl-ids m6163)]
    (.
     bean6162
     setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6616] (clojure.core/str arg6616))
 v6164)))
   bean6162))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m6166]
  (clojure.core/let
   [bean6165
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/when-let
    [v6167 (:filters m6166)]
    (.
     bean6165
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6617] (ec2/filter arg6617))
 v6167)))
   (clojure.core/when-let
    [v6167 (:vpn-gateway-ids m6166)]
    (.
     bean6165
     setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6618] (clojure.core/str arg6618))
 v6167)))
   bean6165))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m6169]
  (clojure.core/let
   [bean6168
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v6170 (:filters m6169)]
    (.
     bean6168
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6619] (ec2/filter arg6619))
 v6170)))
   (clojure.core/when-let
    [v6170 (:snapshot-ids m6169)]
    (.
     bean6168
     setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6620] (clojure.core/str arg6620))
 v6170)))
   (clojure.core/when-let
    [v6170 (:owner-ids m6169)]
    (.
     bean6168
     setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6621] (clojure.core/str arg6621))
 v6170)))
   (clojure.core/when-let
    [v6170 (:restorable-by-user-ids m6169)]
    (.
     bean6168
     setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6622] (clojure.core/str arg6622))
 v6170)))
   bean6168))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m6172]
  (clojure.core/let
   [bean6171
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/when-let
    [v6173 (:user-groups m6172)]
    (.
     bean6171
     setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6623] (clojure.core/str arg6623))
 v6173)))
   (clojure.core/when-let
    [v6173 (:launch-permission m6172)]
    (.
     bean6171
     setLaunchPermission
     (ec2/launch-permission-modifications v6173)))
   (clojure.core/when-let
    [v6173 (:user-ids m6172)]
    (.
     bean6171
     setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6624] (clojure.core/str arg6624))
 v6173)))
   (clojure.core/when-let
    [v6173 (:value m6172)]
    (. bean6171 setValue (clojure.core/str v6173)))
   (clojure.core/when-let
    [v6173 (:image-id m6172)]
    (. bean6171 setImageId (clojure.core/str v6173)))
   (clojure.core/when-let
    [v6173 (:product-codes m6172)]
    (.
     bean6171
     setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6625] (clojure.core/str arg6625))
 v6173)))
   (clojure.core/when-let
    [v6173 (:attribute m6172)]
    (. bean6171 setAttribute (clojure.core/str v6173)))
   (clojure.core/when-let
    [v6173 (:description m6172)]
    (. bean6171 setDescription (clojure.core/str v6173)))
   (clojure.core/when-let
    [v6173 (:operation-type m6172)]
    (. bean6171 setOperationType (clojure.core/str v6173)))
   bean6171))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m6175]
  (clojure.core/let
   [bean6174
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/when-let
    [v6176 (:filters m6175)]
    (.
     bean6174
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6626] (ec2/filter arg6626))
 v6176)))
   (clojure.core/when-let
    [v6176 (:volume-ids m6175)]
    (.
     bean6174
     setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6627] (clojure.core/str arg6627))
 v6176)))
   bean6174))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m6178]
  (clojure.core/let
   [bean6177
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/when-let
    [v6179 (:vpc-id m6178)]
    (. bean6177 setVpcId (clojure.core/str v6179)))
   (clojure.core/when-let
    [v6179 (:internet-gateway-id m6178)]
    (. bean6177 setInternetGatewayId (clojure.core/str v6179)))
   bean6177))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m6181]
  (clojure.core/let
   [bean6180
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/when-let
    [v6182 (:group-name m6181)]
    (. bean6180 setGroupName (clojure.core/str v6182)))
   (clojure.core/when-let
    [v6182 (:group-id m6181)]
    (. bean6180 setGroupId (clojure.core/str v6182)))
   bean6180))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m6184]
  (clojure.core/let
   [bean6183
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/when-let
    [v6185 (:instance-id m6184)]
    (. bean6183 setInstanceId (clojure.core/str v6185)))
   (clojure.core/when-let
    [v6185 (:volume-id m6184)]
    (. bean6183 setVolumeId (clojure.core/str v6185)))
   (clojure.core/when-let
    [v6185 (:device m6184)]
    (. bean6183 setDevice (clojure.core/str v6185)))
   (clojure.core/when-let
    [v6185 (:force m6184)]
    (. bean6183 setForce (clojure.core/boolean v6185)))
   bean6183))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m6187]
  (clojure.core/let
   [bean6186
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/when-let
    [v6188 (:public-ip m6187)]
    (. bean6186 setPublicIp (clojure.core/str v6188)))
   (clojure.core/when-let
    [v6188 (:allocation-id m6187)]
    (. bean6186 setAllocationId (clojure.core/str v6188)))
   bean6186))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m6190]
  (clojure.core/let
   [bean6189
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/when-let
    [v6191 (:availability-zone m6190)]
    (. bean6189 setAvailabilityZone (clojure.core/str v6191)))
   (clojure.core/when-let
    [v6191 (:description m6190)]
    (. bean6189 setDescription (clojure.core/str v6191)))
   (clojure.core/when-let
    [v6191 (:image m6190)]
    (. bean6189 setImage (ec2/disk-image-detail v6191)))
   (clojure.core/when-let
    [v6191 (:volume m6190)]
    (. bean6189 setVolume (ec2/volume-detail v6191)))
   bean6189))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m6193]
  (clojure.core/let
   [bean6192
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/when-let
    [v6194 (:route-table-id m6193)]
    (. bean6192 setRouteTableId (clojure.core/str v6194)))
   bean6192))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m6196]
  (clojure.core/let
   [bean6195
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6197 (:snapshot-id m6196)]
    (. bean6195 setSnapshotId (clojure.core/str v6197)))
   (clojure.core/when-let
    [v6197 (:attribute m6196)]
    (. bean6195 setAttribute (clojure.core/str v6197)))
   bean6195))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m6199]
  (clojure.core/let
   [bean6198
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/when-let
    [v6200 (:instance-ids m6199)]
    (.
     bean6198
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6628] (clojure.core/str arg6628))
 v6200)))
   (clojure.core/when-let
    [v6200 (:filters m6199)]
    (.
     bean6198
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6629] (ec2/filter arg6629))
 v6200)))
   (clojure.core/when-let
    [v6200 (:next-token m6199)]
    (. bean6198 setNextToken (clojure.core/str v6200)))
   (clojure.core/when-let
    [v6200 (:max-results m6199)]
    (. bean6198 setMaxResults (clojure.core/int v6200)))
   (clojure.core/when-let
    [v6200 (:include-all-instances m6199)]
    (. bean6198 setIncludeAllInstances (clojure.core/boolean v6200)))
   bean6198))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m6202]
  (clojure.core/let
   [bean6201
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/when-let
    [v6203 (:image-id m6202)]
    (. bean6201 setImageId (clojure.core/str v6203)))
   (clojure.core/when-let
    [v6203 (:attribute m6202)]
    (. bean6201 setAttribute (ec2/image-attribute-name v6203)))
   bean6201))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m6205]
  (clojure.core/let
   [bean6204
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/when-let
    [v6206 (:start-time m6205)]
    (.
     bean6204
     setStartTime
     (com.palletops.awaze.common/to-date v6206)))
   (clojure.core/when-let
    [v6206 (:end-time m6205)]
    (. bean6204 setEndTime (com.palletops.awaze.common/to-date v6206)))
   (clojure.core/when-let
    [v6206 (:status m6205)]
    (. bean6204 setStatus (ec2/report-status-type v6206)))
   (clojure.core/when-let
    [v6206 (:description m6205)]
    (. bean6204 setDescription (clojure.core/str v6206)))
   (clojure.core/when-let
    [v6206 (:instances m6205)]
    (.
     bean6204
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6630] (clojure.core/str arg6630))
 v6206)))
   (clojure.core/when-let
    [v6206 (:reason-codes m6205)]
    (.
     bean6204
     setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6631] (clojure.core/str arg6631))
 v6206)))
   bean6204))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m6208]
  (clojure.core/let
   [bean6207 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v6209 (:tags m6208)]
    (.
     bean6207
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6632] (ec2/tag arg6632)) v6209)))
   (clojure.core/when-let
    [v6209 (:resources m6208)]
    (.
     bean6207
     setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6633] (clojure.core/str arg6633))
 v6209)))
   bean6207))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m6211]
  (clojure.core/let
   [bean6210
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6212 (:snapshot-id m6211)]
    (. bean6210 setSnapshotId (clojure.core/str v6212)))
   (clojure.core/when-let
    [v6212 (:attribute m6211)]
    (. bean6210 setAttribute (clojure.core/str v6212)))
   bean6210))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m6214]
  (clojure.core/let
   [bean6213
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6215 (:vpc-id m6214)]
    (. bean6213 setVpcId (clojure.core/str v6215)))
   (clojure.core/when-let
    [v6215 (:dhcp-options-id m6214)]
    (. bean6213 setDhcpOptionsId (clojure.core/str v6215)))
   bean6213))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m6217]
  (clojure.core/let
   [bean6216
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6218 (:snapshot-id m6217)]
    (. bean6216 setSnapshotId (clojure.core/str v6218)))
   (clojure.core/when-let
    [v6218 (:attribute m6217)]
    (. bean6216 setAttribute (clojure.core/str v6218)))
   (clojure.core/when-let
    [v6218 (:group-names m6217)]
    (.
     bean6216
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6634] (clojure.core/str arg6634))
 v6218)))
   (clojure.core/when-let
    [v6218 (:operation-type m6217)]
    (. bean6216 setOperationType (clojure.core/str v6218)))
   (clojure.core/when-let
    [v6218 (:user-ids m6217)]
    (.
     bean6216
     setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6635] (clojure.core/str arg6635))
 v6218)))
   (clojure.core/when-let
    [v6218 (:create-volume-permission m6217)]
    (.
     bean6216
     setCreateVolumePermission
     (ec2/create-volume-permission-modifications v6218)))
   bean6216))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m6220]
  (clojure.core/let
   [bean6219
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/when-let
    [v6221 (:volume-id m6220)]
    (. bean6219 setVolumeId (clojure.core/str v6221)))
   (clojure.core/when-let
    [v6221 (:auto-enable-io m6220)]
    (. bean6219 setAutoEnableIO (clojure.core/boolean v6221)))
   bean6219))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m6223]
  (clojure.core/let
   [bean6222
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/when-let
    [v6224 (:group-name m6223)]
    (. bean6222 setGroupName (clojure.core/str v6224)))
   (clojure.core/when-let
    [v6224 (:strategy m6223)]
    (. bean6222 setStrategy (clojure.core/str v6224)))
   bean6222))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m6226]
  (clojure.core/let
   [bean6225
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/when-let
    [v6227 (:filters m6226)]
    (.
     bean6225
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6636] (ec2/filter arg6636))
 v6227)))
   (clojure.core/when-let
    [v6227 (:vpn-connection-ids m6226)]
    (.
     bean6225
     setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6637] (clojure.core/str arg6637))
 v6227)))
   bean6225))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m6229]
  (clojure.core/let
   [bean6228
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/when-let
    [v6230 (:availability-zone m6229)]
    (. bean6228 setAvailabilityZone (clojure.core/str v6230)))
   (clojure.core/when-let
    [v6230 (:start-time m6229)]
    (.
     bean6228
     setStartTime
     (com.palletops.awaze.common/to-date v6230)))
   (clojure.core/when-let
    [v6230 (:end-time m6229)]
    (. bean6228 setEndTime (com.palletops.awaze.common/to-date v6230)))
   (clojure.core/when-let
    [v6230 (:filters m6229)]
    (.
     bean6228
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6638] (ec2/filter arg6638))
 v6230)))
   (clojure.core/when-let
    [v6230 (:next-token m6229)]
    (. bean6228 setNextToken (clojure.core/str v6230)))
   (clojure.core/when-let
    [v6230 (:max-results m6229)]
    (. bean6228 setMaxResults (clojure.core/int v6230)))
   (clojure.core/when-let
    [v6230 (:instance-types m6229)]
    (.
     bean6228
     setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6639] (clojure.core/str arg6639))
 v6230)))
   (clojure.core/when-let
    [v6230 (:product-descriptions m6229)]
    (.
     bean6228
     setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6640] (clojure.core/str arg6640))
 v6230)))
   bean6228))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m6232]
  (clojure.core/let
   [bean6231
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6233 (:vpc-peering-connection-id m6232)]
    (. bean6231 setVpcPeeringConnectionId (clojure.core/str v6233)))
   bean6231))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m6235]
  (clojure.core/let
   [bean6234 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/when-let
    [v6236 (:vpc-id m6235)]
    (. bean6234 setVpcId (clojure.core/str v6236)))
   bean6234))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m6238]
  (clojure.core/let
   [bean6237
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/when-let
    [v6239 (:vpc-id m6238)]
    (. bean6237 setVpcId (clojure.core/str v6239)))
   bean6237))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m6241]
  (clojure.core/let
   [bean6240
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/when-let
    [v6242 (:instance-ids m6241)]
    (.
     bean6240
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6641] (clojure.core/str arg6641))
 v6242)))
   bean6240))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m6244]
  (clojure.core/let
   [bean6243
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/when-let
    [v6245 (:filters m6244)]
    (.
     bean6243
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6642] (ec2/filter arg6642))
 v6245)))
   (clojure.core/when-let
    [v6245 (:bundle-ids m6244)]
    (.
     bean6243
     setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6643] (clojure.core/str arg6643))
 v6245)))
   bean6243))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m6247]
  (clojure.core/let
   [bean6246
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/when-let
    [v6248 (:instance-id m6247)]
    (. bean6246 setInstanceId (clojure.core/str v6248)))
   (clojure.core/when-let
    [v6248 (:network-interface-id m6247)]
    (. bean6246 setNetworkInterfaceId (clojure.core/str v6248)))
   (clojure.core/when-let
    [v6248 (:private-ip-address m6247)]
    (. bean6246 setPrivateIpAddress (clojure.core/str v6248)))
   (clojure.core/when-let
    [v6248 (:public-ip m6247)]
    (. bean6246 setPublicIp (clojure.core/str v6248)))
   (clojure.core/when-let
    [v6248 (:allocation-id m6247)]
    (. bean6246 setAllocationId (clojure.core/str v6248)))
   (clojure.core/when-let
    [v6248 (:allow-reassociation m6247)]
    (. bean6246 setAllowReassociation (clojure.core/boolean v6248)))
   bean6246))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m6250]
  (clojure.core/let
   [bean6249
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/when-let
    [v6251 (:availability-zone m6250)]
    (. bean6249 setAvailabilityZone (clojure.core/str v6251)))
   (clojure.core/when-let
    [v6251 (:encrypted m6250)]
    (. bean6249 setEncrypted (clojure.core/boolean v6251)))
   (clojure.core/when-let
    [v6251 (:snapshot-id m6250)]
    (. bean6249 setSnapshotId (clojure.core/str v6251)))
   (clojure.core/when-let
    [v6251 (:volume-type m6250)]
    (. bean6249 setVolumeType (clojure.core/str v6251)))
   (clojure.core/when-let
    [v6251 (:iops m6250)]
    (. bean6249 setIops (clojure.core/int v6251)))
   (clojure.core/when-let
    [v6251 (:size m6250)]
    (. bean6249 setSize (clojure.core/int v6251)))
   bean6249))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m6253]
  (clojure.core/let
   [bean6252
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/when-let
    [v6254 (:client-token m6253)]
    (. bean6252 setClientToken (clojure.core/str v6254)))
   (clojure.core/when-let
    [v6254 (:reserved-instances-ids m6253)]
    (.
     bean6252
     setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6644] (clojure.core/str arg6644))
 v6254)))
   (clojure.core/when-let
    [v6254 (:target-configurations m6253)]
    (.
     bean6252
     setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6645]
  (ec2/reserved-instances-configuration arg6645))
 v6254)))
   bean6252))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m6256]
  (clojure.core/let
   [bean6255
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/when-let
    [v6257 (:vpc-id m6256)]
    (. bean6255 setVpcId (clojure.core/str v6257)))
   (clojure.core/when-let
    [v6257 (:attribute m6256)]
    (. bean6255 setAttribute (clojure.core/str v6257)))
   bean6255))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m6259]
  (clojure.core/let
   [bean6258
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v6260 (:group-id m6259)]
    (. bean6258 setGroupId (clojure.core/str v6260)))
   (clojure.core/when-let
    [v6260 (:source-security-group-name m6259)]
    (. bean6258 setSourceSecurityGroupName (clojure.core/str v6260)))
   (clojure.core/when-let
    [v6260 (:source-security-group-owner-id m6259)]
    (.
     bean6258
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6260)))
   (clojure.core/when-let
    [v6260 (:ip-protocol m6259)]
    (. bean6258 setIpProtocol (clojure.core/str v6260)))
   (clojure.core/when-let
    [v6260 (:from-port m6259)]
    (. bean6258 setFromPort (clojure.core/int v6260)))
   (clojure.core/when-let
    [v6260 (:to-port m6259)]
    (. bean6258 setToPort (clojure.core/int v6260)))
   (clojure.core/when-let
    [v6260 (:cidr-ip m6259)]
    (. bean6258 setCidrIp (clojure.core/str v6260)))
   (clojure.core/when-let
    [v6260 (:ip-permissions m6259)]
    (.
     bean6258
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6646] (ec2/ip-permission arg6646))
 v6260)))
   bean6258))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m6262]
  (clojure.core/let
   [bean6261
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/when-let
    [v6263 (:customer-gateway-id m6262)]
    (. bean6261 setCustomerGatewayId (clojure.core/str v6263)))
   bean6261))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m6265]
  (clojure.core/let
   [bean6264
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6266 (:protocol m6265)]
    (. bean6264 setProtocol (clojure.core/str v6266)))
   (clojure.core/when-let
    [v6266 (:network-acl-id m6265)]
    (. bean6264 setNetworkAclId (clojure.core/str v6266)))
   (clojure.core/when-let
    [v6266 (:rule-number m6265)]
    (. bean6264 setRuleNumber (clojure.core/int v6266)))
   (clojure.core/when-let
    [v6266 (:rule-action m6265)]
    (. bean6264 setRuleAction (clojure.core/str v6266)))
   (clojure.core/when-let
    [v6266 (:egress m6265)]
    (. bean6264 setEgress (clojure.core/boolean v6266)))
   (clojure.core/when-let
    [v6266 (:cidr-block m6265)]
    (. bean6264 setCidrBlock (clojure.core/str v6266)))
   (clojure.core/when-let
    [v6266 (:icmp-type-code m6265)]
    (. bean6264 setIcmpTypeCode (ec2/icmp-type-code v6266)))
   (clojure.core/when-let
    [v6266 (:port-range m6265)]
    (. bean6264 setPortRange (ec2/port-range v6266)))
   bean6264))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m6268]
  (clojure.core/let
   [bean6267
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6269 (:vpc-id m6268)]
    (. bean6267 setVpcId (clojure.core/str v6269)))
   (clojure.core/when-let
    [v6269 (:peer-vpc-id m6268)]
    (. bean6267 setPeerVpcId (clojure.core/str v6269)))
   (clojure.core/when-let
    [v6269 (:peer-owner-id m6268)]
    (. bean6267 setPeerOwnerId (clojure.core/str v6269)))
   bean6267))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m6271]
  (clojure.core/let
   [bean6270
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/when-let
    [v6272 (:subnet-ids m6271)]
    (.
     bean6270
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6647] (clojure.core/str arg6647))
 v6272)))
   (clojure.core/when-let
    [v6272 (:filters m6271)]
    (.
     bean6270
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6648] (ec2/filter arg6648))
 v6272)))
   bean6270))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m6274]
  (clojure.core/let
   [bean6273
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/when-let
    [v6275 (:instance-id m6274)]
    (. bean6273 setInstanceId (clojure.core/str v6275)))
   bean6273))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m6277]
  (clojure.core/let
   [bean6276
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/when-let
    [v6278 (:conversion-task-id m6277)]
    (. bean6276 setConversionTaskId (clojure.core/str v6278)))
   (clojure.core/when-let
    [v6278 (:reason-message m6277)]
    (. bean6276 setReasonMessage (clojure.core/str v6278)))
   bean6276))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m6280]
  (clojure.core/let
   [bean6279
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/when-let
    [v6281 (:vpc-id m6280)]
    (. bean6279 setVpcId (clojure.core/str v6281)))
   (clojure.core/when-let
    [v6281 (:vpn-gateway-id m6280)]
    (. bean6279 setVpnGatewayId (clojure.core/str v6281)))
   bean6279))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m6283]
  (clojure.core/let
   [bean6282
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/when-let
    [v6284 (:filters m6283)]
    (.
     bean6282
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6649] (ec2/filter arg6649))
 v6284)))
   (clojure.core/when-let
    [v6284 (:vpc-peering-connection-ids m6283)]
    (.
     bean6282
     setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6650] (clojure.core/str arg6650))
 v6284)))
   bean6282))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m6286]
  (clojure.core/let
   [bean6285
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v6287 (:destination-cidr-block m6286)]
    (. bean6285 setDestinationCidrBlock (clojure.core/str v6287)))
   (clojure.core/when-let
    [v6287 (:vpn-connection-id m6286)]
    (. bean6285 setVpnConnectionId (clojure.core/str v6287)))
   bean6285))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m6289]
  (clojure.core/let
   [bean6288
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/when-let
    [v6290 (:iam-instance-profile m6289)]
    (.
     bean6288
     setIamInstanceProfile
     (ec2/iam-instance-profile-specification v6290)))
   (clojure.core/when-let
    [v6290 (:placement m6289)]
    (. bean6288 setPlacement (ec2/placement v6290)))
   (clojure.core/when-let
    [v6290 (:block-device-mappings m6289)]
    (.
     bean6288
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6651] (ec2/block-device-mapping arg6651))
 v6290)))
   (clojure.core/when-let
    [v6290 (:network-interfaces m6289)]
    (.
     bean6288
     setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6652]
  (ec2/instance-network-interface-specification arg6652))
 v6290)))
   (clojure.core/when-let
    [v6290 (:key-name m6289)]
    (. bean6288 setKeyName (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:monitoring m6289)]
    (. bean6288 setMonitoring (clojure.core/boolean v6290)))
   (clojure.core/when-let
    [v6290 (:private-ip-address m6289)]
    (. bean6288 setPrivateIpAddress (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:client-token m6289)]
    (. bean6288 setClientToken (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:max-count m6289)]
    (. bean6288 setMaxCount (clojure.core/int v6290)))
   (clojure.core/when-let
    [v6290 (:disable-api-termination m6289)]
    (. bean6288 setDisableApiTermination (clojure.core/boolean v6290)))
   (clojure.core/when-let
    [v6290 (:instance-type m6289)]
    (. bean6288 setInstanceType (ec2/instance-type v6290)))
   (clojure.core/when-let
    [v6290 (:ebs-optimized m6289)]
    (. bean6288 setEbsOptimized (clojure.core/boolean v6290)))
   (clojure.core/when-let
    [v6290 (:image-id m6289)]
    (. bean6288 setImageId (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:ramdisk-id m6289)]
    (. bean6288 setRamdiskId (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:security-groups m6289)]
    (.
     bean6288
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6653] (clojure.core/str arg6653))
 v6290)))
   (clojure.core/when-let
    [v6290 (:user-data m6289)]
    (. bean6288 setUserData (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:additional-info m6289)]
    (. bean6288 setAdditionalInfo (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:kernel-id m6289)]
    (. bean6288 setKernelId (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:subnet-id m6289)]
    (. bean6288 setSubnetId (clojure.core/str v6290)))
   (clojure.core/when-let
    [v6290 (:security-group-ids m6289)]
    (.
     bean6288
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6654] (clojure.core/str arg6654))
 v6290)))
   (clojure.core/when-let
    [v6290 (:instance-initiated-shutdown-behavior m6289)]
    (.
     bean6288
     setInstanceInitiatedShutdownBehavior
     (ec2/shutdown-behavior v6290)))
   (clojure.core/when-let
    [v6290 (:min-count m6289)]
    (. bean6288 setMinCount (clojure.core/int v6290)))
   bean6288))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m6292]
  (clojure.core/let
   [bean6291
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/when-let
    [v6293 (:sriov-net-support m6292)]
    (. bean6291 setSriovNetSupport (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:root-device-name m6292)]
    (. bean6291 setRootDeviceName (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:block-device-mappings m6292)]
    (.
     bean6291
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6655] (ec2/block-device-mapping arg6655))
 v6293)))
   (clojure.core/when-let
    [v6293 (:name m6292)]
    (. bean6291 setName (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:image-location m6292)]
    (. bean6291 setImageLocation (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:ramdisk-id m6292)]
    (. bean6291 setRamdiskId (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:virtualization-type m6292)]
    (. bean6291 setVirtualizationType (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:architecture m6292)]
    (. bean6291 setArchitecture (ec2/architecture-values v6293)))
   (clojure.core/when-let
    [v6293 (:kernel-id m6292)]
    (. bean6291 setKernelId (clojure.core/str v6293)))
   (clojure.core/when-let
    [v6293 (:description m6292)]
    (. bean6291 setDescription (clojure.core/str v6293)))
   bean6291))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m6295]
  (clojure.core/let
   [bean6294
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v6296 (:filters m6295)]
    (.
     bean6294
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6656] (ec2/filter arg6656))
 v6296)))
   (clojure.core/when-let
    [v6296 (:next-token m6295)]
    (. bean6294 setNextToken (clojure.core/str v6296)))
   (clojure.core/when-let
    [v6296 (:max-results m6295)]
    (. bean6294 setMaxResults (clojure.core/int v6296)))
   bean6294))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m6298]
  (clojure.core/let
   [bean6297
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/when-let
    [v6299 (:offering-type m6298)]
    (. bean6297 setOfferingType (ec2/offering-type-values v6299)))
   (clojure.core/when-let
    [v6299 (:filters m6298)]
    (.
     bean6297
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6657] (ec2/filter arg6657))
 v6299)))
   (clojure.core/when-let
    [v6299 (:reserved-instances-ids m6298)]
    (.
     bean6297
     setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6658] (clojure.core/str arg6658))
 v6299)))
   bean6297))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m6301]
  (clojure.core/let
   [bean6300
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/when-let
    [v6302 (:vpc-id m6301)]
    (. bean6300 setVpcId (clojure.core/str v6302)))
   (clojure.core/when-let
    [v6302 (:vpn-gateway-id m6301)]
    (. bean6300 setVpnGatewayId (clojure.core/str v6302)))
   bean6300))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m6304]
  (clojure.core/let
   [bean6303
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/when-let
    [v6305 (:filters m6304)]
    (.
     bean6303
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6659] (ec2/filter arg6659))
 v6305)))
   (clojure.core/when-let
    [v6305 (:customer-gateway-ids m6304)]
    (.
     bean6303
     setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6660] (clojure.core/str arg6660))
 v6305)))
   bean6303))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m6307]
  (clojure.core/let
   [bean6306
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6308 (:description m6307)]
    (. bean6306 setDescription (clojure.core/str v6308)))
   (clojure.core/when-let
    [v6308 (:network-interface-id m6307)]
    (. bean6306 setNetworkInterfaceId (clojure.core/str v6308)))
   (clojure.core/when-let
    [v6308 (:groups m6307)]
    (. bean6306 setGroups (clojure.core/str v6308)))
   (clojure.core/when-let
    [v6308 (:attachment m6307)]
    (. bean6306 setAttachment (clojure.core/str v6308)))
   (clojure.core/when-let
    [v6308 (:source-dest-check m6307)]
    (. bean6306 setSourceDestCheck (clojure.core/str v6308)))
   bean6306))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m6310]
  (clojure.core/let
   [bean6309
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/when-let
    [v6311 (:key-name m6310)]
    (. bean6309 setKeyName (clojure.core/str v6311)))
   (clojure.core/when-let
    [v6311 (:public-key-material m6310)]
    (. bean6309 setPublicKeyMaterial (clojure.core/str v6311)))
   bean6309))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m6313]
  (clojure.core/let
   [bean6312
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/when-let
    [v6314 (:description m6313)]
    (. bean6312 setDescription (clojure.core/str v6314)))
   (clojure.core/when-let
    [v6314 (:platform m6313)]
    (. bean6312 setPlatform (clojure.core/str v6314)))
   (clojure.core/when-let
    [v6314 (:launch-specification m6313)]
    (.
     bean6312
     setLaunchSpecification
     (ec2/import-instance-launch-specification v6314)))
   (clojure.core/when-let
    [v6314 (:disk-images m6313)]
    (.
     bean6312
     setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6661] (ec2/disk-image arg6661))
 v6314)))
   bean6312))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m6316]
  (clojure.core/let
   [bean6315
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/when-let
    [v6317 (:domain m6316)]
    (. bean6315 setDomain (ec2/domain-type v6317)))
   bean6315))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m6319]
  (clojure.core/let
   [bean6318
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v6320 (:filters m6319)]
    (.
     bean6318
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6662] (ec2/filter arg6662))
 v6320)))
   (clojure.core/when-let
    [v6320 (:spot-instance-request-ids m6319)]
    (.
     bean6318
     setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6663] (clojure.core/str arg6663))
 v6320)))
   bean6318))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m6322]
  (clojure.core/let
   [bean6321
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean6321))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m6325]
  (clojure.core/let
   [bean6324
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/when-let
    [v6326 (:filters m6325)]
    (.
     bean6324
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6664] (ec2/filter arg6664))
 v6326)))
   (clojure.core/when-let
    [v6326 (:conversion-task-ids m6325)]
    (.
     bean6324
     setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6665] (clojure.core/str arg6665))
 v6326)))
   bean6324))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m6328]
  (clojure.core/let
   [bean6327
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/when-let
    [v6329 (:route-table-id m6328)]
    (. bean6327 setRouteTableId (clojure.core/str v6329)))
   (clojure.core/when-let
    [v6329 (:association-id m6328)]
    (. bean6327 setAssociationId (clojure.core/str v6329)))
   bean6327))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m6331]
  (clojure.core/let
   [bean6330
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/when-let
    [v6332 (:subnet-id m6331)]
    (. bean6330 setSubnetId (clojure.core/str v6332)))
   bean6330))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m6334]
  (clojure.core/let
   [bean6333
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/when-let
    [v6335 (:vpc-id m6334)]
    (. bean6333 setVpcId (clojure.core/str v6335)))
   (clojure.core/when-let
    [v6335 (:enable-dns-support m6334)]
    (. bean6333 setEnableDnsSupport (clojure.core/boolean v6335)))
   (clojure.core/when-let
    [v6335 (:enable-dns-hostnames m6334)]
    (. bean6333 setEnableDnsHostnames (clojure.core/boolean v6335)))
   bean6333))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m6337]
  (clojure.core/let
   [bean6336
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/when-let
    [v6338 (:vpc-id m6337)]
    (. bean6336 setVpcId (clojure.core/str v6338)))
   (clojure.core/when-let
    [v6338 (:internet-gateway-id m6337)]
    (. bean6336 setInternetGatewayId (clojure.core/str v6338)))
   bean6336))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m6340]
  (clojure.core/let
   [bean6339
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/when-let
    [v6341 (:filters m6340)]
    (.
     bean6339
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6666] (ec2/filter arg6666))
 v6341)))
   (clojure.core/when-let
    [v6341 (:next-token m6340)]
    (. bean6339 setNextToken (clojure.core/str v6341)))
   (clojure.core/when-let
    [v6341 (:reserved-instances-modification-ids m6340)]
    (.
     bean6339
     setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6667] (clojure.core/str arg6667))
 v6341)))
   bean6339))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m6343]
  (clojure.core/let
   [bean6342
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/when-let
    [v6344 (:instance-id m6343)]
    (. bean6342 setInstanceId (clojure.core/str v6344)))
   bean6342))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m6346]
  (clojure.core/let
   [bean6345
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v6347 (:network-interface-id m6346)]
    (. bean6345 setNetworkInterfaceId (clojure.core/str v6347)))
   (clojure.core/when-let
    [v6347 (:private-ip-addresses m6346)]
    (.
     bean6345
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6668] (clojure.core/str arg6668))
 v6347)))
   bean6345))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m6349]
  (clojure.core/let
   [bean6348
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6350 (:description m6349)]
    (. bean6348 setDescription (clojure.core/str v6350)))
   (clojure.core/when-let
    [v6350 (:network-interface-id m6349)]
    (. bean6348 setNetworkInterfaceId (clojure.core/str v6350)))
   (clojure.core/when-let
    [v6350 (:groups m6349)]
    (.
     bean6348
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6669] (clojure.core/str arg6669))
 v6350)))
   (clojure.core/when-let
    [v6350 (:attachment m6349)]
    (.
     bean6348
     setAttachment
     (ec2/network-interface-attachment-changes v6350)))
   (clojure.core/when-let
    [v6350 (:source-dest-check m6349)]
    (. bean6348 setSourceDestCheck (clojure.core/boolean v6350)))
   bean6348))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m6352]
  (clojure.core/let
   [bean6351
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6353 (:network-interface-id m6352)]
    (. bean6351 setNetworkInterfaceId (clojure.core/str v6353)))
   (clojure.core/when-let
    [v6353 (:source-dest-check m6352)]
    (. bean6351 setSourceDestCheck (clojure.core/str v6353)))
   bean6351))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m6355]
  (clojure.core/let
   [bean6354
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/when-let
    [v6356 (:filters m6355)]
    (.
     bean6354
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6670] (ec2/filter arg6670))
 v6356)))
   (clojure.core/when-let
    [v6356 (:vpc-ids m6355)]
    (.
     bean6354
     setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6671] (clojure.core/str arg6671))
 v6356)))
   bean6354))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m6358]
  (clojure.core/let
   [bean6357
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/when-let
    [v6359 (:instance-ids m6358)]
    (.
     bean6357
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6672] (clojure.core/str arg6672))
 v6359)))
   bean6357))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m6361]
  (clojure.core/let
   [bean6360
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/when-let
    [v6362 (:attribute m6361)]
    (. bean6360 setAttribute (clojure.core/str v6362)))
   (clojure.core/when-let
    [v6362 (:volume-id m6361)]
    (. bean6360 setVolumeId (clojure.core/str v6362)))
   bean6360))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m6364]
  (clojure.core/let
   [bean6363
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6365 (:sriov-net-support m6364)]
    (. bean6363 setSriovNetSupport (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:block-device-mappings m6364)]
    (.
     bean6363
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6673]
  (ec2/instance-block-device-mapping-specification arg6673))
 v6365)))
   (clojure.core/when-let
    [v6365 (:source-dest-check m6364)]
    (. bean6363 setSourceDestCheck (clojure.core/boolean v6365)))
   (clojure.core/when-let
    [v6365 (:value m6364)]
    (. bean6363 setValue (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:disable-api-termination m6364)]
    (. bean6363 setDisableApiTermination (clojure.core/boolean v6365)))
   (clojure.core/when-let
    [v6365 (:instance-type m6364)]
    (. bean6363 setInstanceType (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:instance-id m6364)]
    (. bean6363 setInstanceId (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:ebs-optimized m6364)]
    (. bean6363 setEbsOptimized (clojure.core/boolean v6365)))
   (clojure.core/when-let
    [v6365 (:groups m6364)]
    (.
     bean6363
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6674] (clojure.core/str arg6674))
 v6365)))
   (clojure.core/when-let
    [v6365 (:user-data m6364)]
    (. bean6363 setUserData (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:ramdisk m6364)]
    (. bean6363 setRamdisk (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:attribute m6364)]
    (. bean6363 setAttribute (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:instance-initiated-shutdown-behavior m6364)]
    (.
     bean6363
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v6365)))
   (clojure.core/when-let
    [v6365 (:kernel m6364)]
    (. bean6363 setKernel (clojure.core/str v6365)))
   bean6363))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m6367]
  (clojure.core/let
   [bean6366
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/when-let
    [v6368 (:key-name m6367)]
    (. bean6366 setKeyName (clojure.core/str v6368)))
   bean6366))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m6370]
  (clojure.core/let
   [bean6369
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v6371 (:gateway-id m6370)]
    (. bean6369 setGatewayId (clojure.core/str v6371)))
   (clojure.core/when-let
    [v6371 (:route-table-id m6370)]
    (. bean6369 setRouteTableId (clojure.core/str v6371)))
   bean6369))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m6373]
  (clojure.core/let
   [bean6372
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/when-let
    [v6374 (:instance-id m6373)]
    (. bean6372 setInstanceId (clojure.core/str v6374)))
   (clojure.core/when-let
    [v6374 (:storage m6373)]
    (. bean6372 setStorage (ec2/storage v6374)))
   bean6372))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m6376]
  (clojure.core/let
   [bean6375
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean6375))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m6379]
  (clojure.core/let
   [bean6378
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/when-let
    [v6380 (:filters m6379)]
    (.
     bean6378
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6675] (ec2/filter arg6675))
 v6380)))
   (clojure.core/when-let
    [v6380 (:next-token m6379)]
    (. bean6378 setNextToken (clojure.core/str v6380)))
   (clojure.core/when-let
    [v6380 (:max-results m6379)]
    (. bean6378 setMaxResults (clojure.core/int v6380)))
   (clojure.core/when-let
    [v6380 (:volume-ids m6379)]
    (.
     bean6378
     setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6676] (clojure.core/str arg6676))
 v6380)))
   bean6378))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m6382]
  (clojure.core/let
   [bean6381 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/when-let
    [v6383 (:source-region m6382)]
    (. bean6381 setSourceRegion (clojure.core/str v6383)))
   (clojure.core/when-let
    [v6383 (:name m6382)]
    (. bean6381 setName (clojure.core/str v6383)))
   (clojure.core/when-let
    [v6383 (:description m6382)]
    (. bean6381 setDescription (clojure.core/str v6383)))
   (clojure.core/when-let
    [v6383 (:client-token m6382)]
    (. bean6381 setClientToken (clojure.core/str v6383)))
   (clojure.core/when-let
    [v6383 (:source-image-id m6382)]
    (. bean6381 setSourceImageId (clojure.core/str v6383)))
   bean6381))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m6385]
  (clojure.core/let
   [bean6384
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/when-let
    [v6386 (:filters m6385)]
    (.
     bean6384
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6677] (ec2/filter arg6677))
 v6386)))
   (clojure.core/when-let
    [v6386 (:key-names m6385)]
    (.
     bean6384
     setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6678] (clojure.core/str arg6678))
 v6386)))
   bean6384))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m6388]
  (clojure.core/let
   [bean6387
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6389 (:vpc-peering-connection-id m6388)]
    (. bean6387 setVpcPeeringConnectionId (clojure.core/str v6389)))
   bean6387))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m6391]
  (clojure.core/let
   [bean6390
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6392 (:network-acl-id m6391)]
    (. bean6390 setNetworkAclId (clojure.core/str v6392)))
   (clojure.core/when-let
    [v6392 (:rule-number m6391)]
    (. bean6390 setRuleNumber (clojure.core/int v6392)))
   (clojure.core/when-let
    [v6392 (:egress m6391)]
    (. bean6390 setEgress (clojure.core/boolean v6392)))
   bean6390))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m6394]
  (clojure.core/let
   [bean6393
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/when-let
    [v6395 (:instance-count m6394)]
    (. bean6393 setInstanceCount (clojure.core/int v6395)))
   (clojure.core/when-let
    [v6395 (:limit-price m6394)]
    (.
     bean6393
     setLimitPrice
     (ec2/reserved-instance-limit-price v6395)))
   (clojure.core/when-let
    [v6395 (:reserved-instances-offering-id m6394)]
    (.
     bean6393
     setReservedInstancesOfferingId
     (clojure.core/str v6395)))
   bean6393))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m6397]
  (clojure.core/let
   [bean6396
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v6398 (:reserved-instances-listing-id m6397)]
    (.
     bean6396
     setReservedInstancesListingId
     (clojure.core/str v6398)))
   bean6396))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m6400]
  (clojure.core/let
   [bean6399
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v6401 (:group-id m6400)]
    (. bean6399 setGroupId (clojure.core/str v6401)))
   (clojure.core/when-let
    [v6401 (:source-security-group-name m6400)]
    (. bean6399 setSourceSecurityGroupName (clojure.core/str v6401)))
   (clojure.core/when-let
    [v6401 (:source-security-group-owner-id m6400)]
    (.
     bean6399
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6401)))
   (clojure.core/when-let
    [v6401 (:ip-protocol m6400)]
    (. bean6399 setIpProtocol (clojure.core/str v6401)))
   (clojure.core/when-let
    [v6401 (:from-port m6400)]
    (. bean6399 setFromPort (clojure.core/int v6401)))
   (clojure.core/when-let
    [v6401 (:to-port m6400)]
    (. bean6399 setToPort (clojure.core/int v6401)))
   (clojure.core/when-let
    [v6401 (:cidr-ip m6400)]
    (. bean6399 setCidrIp (clojure.core/str v6401)))
   (clojure.core/when-let
    [v6401 (:ip-permissions m6400)]
    (.
     bean6399
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6679] (ec2/ip-permission arg6679))
 v6401)))
   bean6399))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m6403]
  (clojure.core/let
   [bean6402
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/when-let
    [v6404 (:prefix m6403)]
    (. bean6402 setPrefix (clojure.core/str v6404)))
   (clojure.core/when-let
    [v6404 (:bucket m6403)]
    (. bean6402 setBucket (clojure.core/str v6404)))
   bean6402))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m6406]
  (clojure.core/let
   [bean6405
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/when-let
    [v6407 (:volume-id m6406)]
    (. bean6405 setVolumeId (clojure.core/str v6407)))
   bean6405))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m6409]
  (clojure.core/let
   [bean6408
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/when-let
    [v6410 (:network-acl-id m6409)]
    (. bean6408 setNetworkAclId (clojure.core/str v6410)))
   (clojure.core/when-let
    [v6410 (:association-id m6409)]
    (. bean6408 setAssociationId (clojure.core/str v6410)))
   bean6408))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m6412]
  (clojure.core/let
   [bean6411
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6413 (:vpc-peering-connection-id m6412)]
    (. bean6411 setVpcPeeringConnectionId (clojure.core/str v6413)))
   bean6411))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m6415]
  (clojure.core/let
   [bean6414
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v6416 (:destination-region m6415)]
    (. bean6414 setDestinationRegion (clojure.core/str v6416)))
   (clojure.core/when-let
    [v6416 (:source-region m6415)]
    (. bean6414 setSourceRegion (clojure.core/str v6416)))
   (clojure.core/when-let
    [v6416 (:description m6415)]
    (. bean6414 setDescription (clojure.core/str v6416)))
   (clojure.core/when-let
    [v6416 (:source-snapshot-id m6415)]
    (. bean6414 setSourceSnapshotId (clojure.core/str v6416)))
   (clojure.core/when-let
    [v6416 (:presigned-url m6415)]
    (. bean6414 setPresignedUrl (clojure.core/str v6416)))
   bean6414))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m6418]
  (clojure.core/let
   [bean6417
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/when-let
    [v6419 (:type m6418)]
    (. bean6417 setType (ec2/gateway-type v6419)))
   (clojure.core/when-let
    [v6419 (:public-ip m6418)]
    (. bean6417 setPublicIp (clojure.core/str v6419)))
   (clojure.core/when-let
    [v6419 (:bgp-asn m6418)]
    (. bean6417 setBgpAsn (clojure.core/int v6419)))
   bean6417))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m6421]
  (clojure.core/let
   [bean6420
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v6422 (:offering-type m6421)]
    (. bean6420 setOfferingType (clojure.core/str v6422)))
   (clojure.core/when-let
    [v6422 (:min-duration m6421)]
    (. bean6420 setMinDuration (clojure.core/long v6422)))
   (clojure.core/when-let
    [v6422 (:next-token m6421)]
    (. bean6420 setNextToken (clojure.core/str v6422)))
   (clojure.core/when-let
    [v6422 (:include-marketplace m6421)]
    (. bean6420 setIncludeMarketplace (clojure.core/boolean v6422)))
   (clojure.core/when-let
    [v6422 (:availability-zone m6421)]
    (. bean6420 setAvailabilityZone (clojure.core/str v6422)))
   (clojure.core/when-let
    [v6422 (:instance-tenancy m6421)]
    (. bean6420 setInstanceTenancy (ec2/tenancy v6422)))
   (clojure.core/when-let
    [v6422 (:product-description m6421)]
    (. bean6420 setProductDescription (clojure.core/str v6422)))
   (clojure.core/when-let
    [v6422 (:instance-type m6421)]
    (. bean6420 setInstanceType (clojure.core/str v6422)))
   (clojure.core/when-let
    [v6422 (:max-results m6421)]
    (. bean6420 setMaxResults (clojure.core/int v6422)))
   (clojure.core/when-let
    [v6422 (:max-duration m6421)]
    (. bean6420 setMaxDuration (clojure.core/long v6422)))
   (clojure.core/when-let
    [v6422 (:max-instance-count m6421)]
    (. bean6420 setMaxInstanceCount (clojure.core/int v6422)))
   (clojure.core/when-let
    [v6422 (:filters m6421)]
    (.
     bean6420
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6680] (ec2/filter arg6680))
 v6422)))
   (clojure.core/when-let
    [v6422 (:reserved-instances-offering-ids m6421)]
    (.
     bean6420
     setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6681] (clojure.core/str arg6681))
 v6422)))
   bean6420))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m6424]
  (clojure.core/let
   [bean6423
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/when-let
    [v6425 (:bundle-id m6424)]
    (. bean6423 setBundleId (clojure.core/str v6425)))
   bean6423))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m6427]
  (clojure.core/let
   [bean6426
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/when-let
    [v6428 (:filters m6427)]
    (.
     bean6426
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6682] (ec2/filter arg6682))
 v6428)))
   (clojure.core/when-let
    [v6428 (:image-ids m6427)]
    (.
     bean6426
     setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6683] (clojure.core/str arg6683))
 v6428)))
   (clojure.core/when-let
    [v6428 (:owners m6427)]
    (.
     bean6426
     setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6684] (clojure.core/str arg6684))
 v6428)))
   (clojure.core/when-let
    [v6428 (:executable-users m6427)]
    (.
     bean6426
     setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6685] (clojure.core/str arg6685))
 v6428)))
   bean6426))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m6430]
  (clojure.core/let
   [bean6429
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6431 (:filters m6430)]
    (.
     bean6429
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6686] (ec2/filter arg6686))
 v6431)))
   (clojure.core/when-let
    [v6431 (:dhcp-options-ids m6430)]
    (.
     bean6429
     setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6687] (clojure.core/str arg6687))
 v6431)))
   bean6429))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m6433]
  (clojure.core/let
   [bean6432
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/when-let
    [v6434 (:vpn-connection-id m6433)]
    (. bean6432 setVpnConnectionId (clojure.core/str v6434)))
   bean6432))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m6436]
  (clojure.core/let
   [bean6435
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v6437 (:destination-cidr-block m6436)]
    (. bean6435 setDestinationCidrBlock (clojure.core/str v6437)))
   (clojure.core/when-let
    [v6437 (:vpn-connection-id m6436)]
    (. bean6435 setVpnConnectionId (clojure.core/str v6437)))
   bean6435))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m6439]
  (clojure.core/let
   [bean6438
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/when-let
    [v6440 (:key-name m6439)]
    (. bean6438 setKeyName (clojure.core/str v6440)))
   bean6438))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m6442]
  (clojure.core/let
   [bean6441
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/when-let
    [v6443 (:attribute-names m6442)]
    (.
     bean6441
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6688] (clojure.core/str arg6688))
 v6443)))
   bean6441))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m6445]
  (clojure.core/let
   [bean6444
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean6444))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m6448]
  (clojure.core/let
   [bean6447
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/when-let
    [v6449 (:filters m6448)]
    (.
     bean6447
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6689] (ec2/filter arg6689))
 v6449)))
   (clojure.core/when-let
    [v6449 (:internet-gateway-ids m6448)]
    (.
     bean6447
     setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6690] (clojure.core/str arg6690))
 v6449)))
   bean6447))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m6451]
  (clojure.core/let
   [bean6450
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/when-let
    [v6452 (:instance-ids m6451)]
    (.
     bean6450
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6691] (clojure.core/str arg6691))
 v6452)))
   (clojure.core/when-let
    [v6452 (:additional-info m6451)]
    (. bean6450 setAdditionalInfo (clojure.core/str v6452)))
   bean6450))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m6454]
  (clojure.core/let
   [bean6453
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6455 (:instance-id m6454)]
    (. bean6453 setInstanceId (clojure.core/str v6455)))
   (clojure.core/when-let
    [v6455 (:network-interface-id m6454)]
    (. bean6453 setNetworkInterfaceId (clojure.core/str v6455)))
   (clojure.core/when-let
    [v6455 (:device-index m6454)]
    (. bean6453 setDeviceIndex (clojure.core/int v6455)))
   bean6453))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m6457]
  (clojure.core/let
   [bean6456
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/when-let
    [v6458 (:instance-id m6457)]
    (. bean6456 setInstanceId (clojure.core/str v6458)))
   (clojure.core/when-let
    [v6458 (:network-interface-id m6457)]
    (. bean6456 setNetworkInterfaceId (clojure.core/str v6458)))
   (clojure.core/when-let
    [v6458 (:gateway-id m6457)]
    (. bean6456 setGatewayId (clojure.core/str v6458)))
   (clojure.core/when-let
    [v6458 (:route-table-id m6457)]
    (. bean6456 setRouteTableId (clojure.core/str v6458)))
   (clojure.core/when-let
    [v6458 (:destination-cidr-block m6457)]
    (. bean6456 setDestinationCidrBlock (clojure.core/str v6458)))
   (clojure.core/when-let
    [v6458 (:vpc-peering-connection-id m6457)]
    (. bean6456 setVpcPeeringConnectionId (clojure.core/str v6458)))
   bean6456))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m6460]
  (clojure.core/let
   [bean6459
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/when-let
    [v6461 (:instance-ids m6460)]
    (.
     bean6459
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6692] (clojure.core/str arg6692))
 v6461)))
   bean6459))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m6463]
  (clojure.core/let
   [bean6462
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6464 (:network-interface-id m6463)]
    (. bean6462 setNetworkInterfaceId (clojure.core/str v6464)))
   bean6462))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m6466]
  (clojure.core/let
   [bean6465
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/when-let
    [v6467 (:instance-ids m6466)]
    (.
     bean6465
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6693] (clojure.core/str arg6693))
 v6467)))
   bean6465))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m6469]
  (clojure.core/let
   [bean6468
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/when-let
    [v6470 (:filters m6469)]
    (.
     bean6468
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6694] (ec2/filter arg6694))
 v6470)))
   (clojure.core/when-let
    [v6470 (:reserved-instances-id m6469)]
    (. bean6468 setReservedInstancesId (clojure.core/str v6470)))
   (clojure.core/when-let
    [v6470 (:reserved-instances-listing-id m6469)]
    (.
     bean6468
     setReservedInstancesListingId
     (clojure.core/str v6470)))
   bean6468))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m6472]
  (clojure.core/let
   [bean6471 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/when-let
    [v6473 (:tags m6472)]
    (.
     bean6471
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6695] (ec2/tag arg6695)) v6473)))
   (clojure.core/when-let
    [v6473 (:resources m6472)]
    (.
     bean6471
     setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6696] (clojure.core/str arg6696))
 v6473)))
   bean6471))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m6475]
  (clojure.core/let
   [bean6474
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/when-let
    [v6476 (:instance-id m6475)]
    (. bean6474 setInstanceId (clojure.core/str v6476)))
   (clojure.core/when-let
    [v6476 (:product-code m6475)]
    (. bean6474 setProductCode (clojure.core/str v6476)))
   bean6474))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m6478]
  (clojure.core/let
   [bean6477
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/when-let
    [v6479 (:association-id m6478)]
    (. bean6477 setAssociationId (clojure.core/str v6479)))
   bean6477))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m6481]
  (clojure.core/let
   [bean6480
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/when-let
    [v6482 (:public-ip m6481)]
    (. bean6480 setPublicIp (clojure.core/str v6482)))
   (clojure.core/when-let
    [v6482 (:association-id m6481)]
    (. bean6480 setAssociationId (clojure.core/str v6482)))
   bean6480))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m6484]
  (clojure.core/let
   [bean6483
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6485 (:force m6484)]
    (. bean6483 setForce (clojure.core/boolean v6485)))
   (clojure.core/when-let
    [v6485 (:attachment-id m6484)]
    (. bean6483 setAttachmentId (clojure.core/str v6485)))
   bean6483))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m6487]
  (clojure.core/let
   [bean6486
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/when-let
    [v6488 (:export-task-ids m6487)]
    (.
     bean6486
     setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6697] (clojure.core/str arg6697))
 v6488)))
   bean6486))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m6490]
  (clojure.core/let
   [bean6489
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/when-let
    [v6491 (:filters m6490)]
    (.
     bean6489
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6698] (ec2/filter arg6698))
 v6491)))
   (clojure.core/when-let
    [v6491 (:public-ips m6490)]
    (.
     bean6489
     setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6699] (clojure.core/str arg6699))
 v6491)))
   (clojure.core/when-let
    [v6491 (:allocation-ids m6490)]
    (.
     bean6489
     setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6700] (clojure.core/str arg6700))
 v6491)))
   bean6489))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m6493]
  (clojure.core/let
   [bean6492
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/when-let
    [v6494 (:instance-id m6493)]
    (. bean6492 setInstanceId (clojure.core/str v6494)))
   (clojure.core/when-let
    [v6494 (:description m6493)]
    (. bean6492 setDescription (clojure.core/str v6494)))
   (clojure.core/when-let
    [v6494 (:target-environment m6493)]
    (. bean6492 setTargetEnvironment (ec2/export-environment v6494)))
   (clojure.core/when-let
    [v6494 (:export-to-s3task m6493)]
    (.
     bean6492
     setExportToS3Task
     (ec2/export-to-s3task-specification v6494)))
   bean6492))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m6496]
  (clojure.core/let
   [bean6495
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/when-let
    [v6497 (:instance-id m6496)]
    (. bean6495 setInstanceId (clojure.core/str v6497)))
   (clojure.core/when-let
    [v6497 (:block-device-mappings m6496)]
    (.
     bean6495
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6701] (ec2/block-device-mapping arg6701))
 v6497)))
   (clojure.core/when-let
    [v6497 (:name m6496)]
    (. bean6495 setName (clojure.core/str v6497)))
   (clojure.core/when-let
    [v6497 (:description m6496)]
    (. bean6495 setDescription (clojure.core/str v6497)))
   (clojure.core/when-let
    [v6497 (:no-reboot m6496)]
    (. bean6495 setNoReboot (clojure.core/boolean v6497)))
   bean6495))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m6499]
  (clojure.core/let
   [bean6498
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/when-let
    [v6500 (:vpc-id m6499)]
    (. bean6498 setVpcId (clojure.core/str v6500)))
   (clojure.core/when-let
    [v6500 (:description m6499)]
    (. bean6498 setDescription (clojure.core/str v6500)))
   (clojure.core/when-let
    [v6500 (:group-name m6499)]
    (. bean6498 setGroupName (clojure.core/str v6500)))
   bean6498))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m6502]
  (clojure.core/let
   [bean6501
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/when-let
    [v6503 (:availability-zone m6502)]
    (. bean6501 setAvailabilityZone (clojure.core/str v6503)))
   (clojure.core/when-let
    [v6503 (:vpc-id m6502)]
    (. bean6501 setVpcId (clojure.core/str v6503)))
   (clojure.core/when-let
    [v6503 (:cidr-block m6502)]
    (. bean6501 setCidrBlock (clojure.core/str v6503)))
   bean6501))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m6505]
  (clojure.core/let
   [bean6504
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/when-let
    [v6506 (:network-acl-id m6505)]
    (. bean6504 setNetworkAclId (clojure.core/str v6506)))
   bean6504))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m6508]
  (clojure.core/let
   [bean6507
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6509 (:description m6508)]
    (. bean6507 setDescription (clojure.core/str v6509)))
   (clojure.core/when-let
    [v6509 (:subnet-id m6508)]
    (. bean6507 setSubnetId (clojure.core/str v6509)))
   (clojure.core/when-let
    [v6509 (:private-ip-address m6508)]
    (. bean6507 setPrivateIpAddress (clojure.core/str v6509)))
   (clojure.core/when-let
    [v6509 (:groups m6508)]
    (.
     bean6507
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6702] (clojure.core/str arg6702))
 v6509)))
   (clojure.core/when-let
    [v6509 (:private-ip-addresses m6508)]
    (.
     bean6507
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6703]
  (ec2/private-ip-address-specification arg6703))
 v6509)))
   (clojure.core/when-let
    [v6509 (:secondary-private-ip-address-count m6508)]
    (.
     bean6507
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6509)))
   bean6507))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m6511]
  (clojure.core/let
   [bean6510
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/when-let
    [v6512 (:vpn-gateway-id m6511)]
    (. bean6510 setVpnGatewayId (clojure.core/str v6512)))
   bean6510))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m6514]
  (clojure.core/let
   [bean6513
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/when-let
    [v6515 (:instance-id m6514)]
    (. bean6513 setInstanceId (clojure.core/str v6515)))
   (clojure.core/when-let
    [v6515 (:volume-id m6514)]
    (. bean6513 setVolumeId (clojure.core/str v6515)))
   (clojure.core/when-let
    [v6515 (:device m6514)]
    (. bean6513 setDevice (clojure.core/str v6515)))
   bean6513))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m6517]
  (clojure.core/let
   [bean6516
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/when-let
    [v6518 (:options m6517)]
    (.
     bean6516
     setOptions
     (ec2/vpn-connection-options-specification v6518)))
   (clojure.core/when-let
    [v6518 (:type m6517)]
    (. bean6516 setType (clojure.core/str v6518)))
   (clojure.core/when-let
    [v6518 (:vpn-gateway-id m6517)]
    (. bean6516 setVpnGatewayId (clojure.core/str v6518)))
   (clojure.core/when-let
    [v6518 (:customer-gateway-id m6517)]
    (. bean6516 setCustomerGatewayId (clojure.core/str v6518)))
   bean6516))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m6520]
  (clojure.core/let
   [bean6519
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/when-let
    [v6521 (:group-name m6520)]
    (. bean6519 setGroupName (clojure.core/str v6521)))
   bean6519))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m6523]
  (clojure.core/let
   [bean6522
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6524 (:instance-id m6523)]
    (. bean6522 setInstanceId (clojure.core/str v6524)))
   (clojure.core/when-let
    [v6524 (:attribute m6523)]
    (. bean6522 setAttribute (ec2/instance-attribute-name v6524)))
   bean6522))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m6526]
  (clojure.core/let
   [bean6525
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v6527 (:description m6526)]
    (. bean6525 setDescription (clojure.core/str v6527)))
   (clojure.core/when-let
    [v6527 (:volume-id m6526)]
    (. bean6525 setVolumeId (clojure.core/str v6527)))
   bean6525))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m6529]
  (clojure.core/let
   [bean6528
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/when-let
    [v6530 (:spot-price m6529)]
    (. bean6528 setSpotPrice (clojure.core/str v6530)))
   (clojure.core/when-let
    [v6530 (:instance-count m6529)]
    (. bean6528 setInstanceCount (clojure.core/int v6530)))
   (clojure.core/when-let
    [v6530 (:type m6529)]
    (. bean6528 setType (ec2/spot-instance-type v6530)))
   (clojure.core/when-let
    [v6530 (:launch-specification m6529)]
    (.
     bean6528
     setLaunchSpecification
     (ec2/launch-specification v6530)))
   (clojure.core/when-let
    [v6530 (:valid-from m6529)]
    (.
     bean6528
     setValidFrom
     (com.palletops.awaze.common/to-date v6530)))
   (clojure.core/when-let
    [v6530 (:valid-until m6529)]
    (.
     bean6528
     setValidUntil
     (com.palletops.awaze.common/to-date v6530)))
   (clojure.core/when-let
    [v6530 (:launch-group m6529)]
    (. bean6528 setLaunchGroup (clojure.core/str v6530)))
   (clojure.core/when-let
    [v6530 (:availability-zone-group m6529)]
    (. bean6528 setAvailabilityZoneGroup (clojure.core/str v6530)))
   bean6528))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m6532]
  (clojure.core/let
   [bean6531
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/when-let
    [v6533 (:filters m6532)]
    (.
     bean6531
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6704] (ec2/filter arg6704))
 v6533)))
   (clojure.core/when-let
    [v6533 (:network-interface-ids m6532)]
    (.
     bean6531
     setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6705] (clojure.core/str arg6705))
 v6533)))
   bean6531))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m6535]
  (clojure.core/let
   [bean6534
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v6536 (:volume-id m6535)]
    (. bean6534 setVolumeId (clojure.core/str v6536)))
   bean6534))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m6538]
  (clojure.core/let
   [bean6537
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v6539 (:snapshot-id m6538)]
    (. bean6537 setSnapshotId (clojure.core/str v6539)))
   bean6537))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m6541]
  (clojure.core/let
   [bean6540
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/when-let
    [v6542 (:instance-ids m6541)]
    (.
     bean6540
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6706] (clojure.core/str arg6706))
 v6542)))
   (clojure.core/when-let
    [v6542 (:filters m6541)]
    (.
     bean6540
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6707] (ec2/filter arg6707))
 v6542)))
   (clojure.core/when-let
    [v6542 (:next-token m6541)]
    (. bean6540 setNextToken (clojure.core/str v6542)))
   (clojure.core/when-let
    [v6542 (:max-results m6541)]
    (. bean6540 setMaxResults (clojure.core/int v6542)))
   bean6540))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m6544]
  (clojure.core/let
   [bean6543
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/when-let
    [v6545 (:route-table-id m6544)]
    (. bean6543 setRouteTableId (clojure.core/str v6545)))
   (clojure.core/when-let
    [v6545 (:subnet-id m6544)]
    (. bean6543 setSubnetId (clojure.core/str v6545)))
   bean6543))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m6547]
  (clojure.core/let
   [bean6546
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v6548 (:gateway-id m6547)]
    (. bean6546 setGatewayId (clojure.core/str v6548)))
   (clojure.core/when-let
    [v6548 (:route-table-id m6547)]
    (. bean6546 setRouteTableId (clojure.core/str v6548)))
   bean6546))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m6550]
  (clojure.core/let
   [bean6549
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6551 (:instance-id m6550)]
    (. bean6549 setInstanceId (clojure.core/str v6551)))
   (clojure.core/when-let
    [v6551 (:attribute m6550)]
    (. bean6549 setAttribute (ec2/instance-attribute-name v6551)))
   bean6549))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m6553]
  (clojure.core/let
   [bean6552
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/when-let
    [v6554 (:availability-zone m6553)]
    (. bean6552 setAvailabilityZone (clojure.core/str v6554)))
   (clojure.core/when-let
    [v6554 (:type m6553)]
    (. bean6552 setType (ec2/gateway-type v6554)))
   bean6552))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m6556]
  (clojure.core/let
   [bean6555
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/when-let
    [v6557 (:vpc-id m6556)]
    (. bean6555 setVpcId (clojure.core/str v6557)))
   bean6555))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m6559]
  (clojure.core/let
   [bean6558
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/when-let
    [v6560 (:instance-id m6559)]
    (. bean6558 setInstanceId (clojure.core/str v6560)))
   (clojure.core/when-let
    [v6560 (:network-interface-id m6559)]
    (. bean6558 setNetworkInterfaceId (clojure.core/str v6560)))
   (clojure.core/when-let
    [v6560 (:gateway-id m6559)]
    (. bean6558 setGatewayId (clojure.core/str v6560)))
   (clojure.core/when-let
    [v6560 (:route-table-id m6559)]
    (. bean6558 setRouteTableId (clojure.core/str v6560)))
   (clojure.core/when-let
    [v6560 (:destination-cidr-block m6559)]
    (. bean6558 setDestinationCidrBlock (clojure.core/str v6560)))
   (clojure.core/when-let
    [v6560 (:vpc-peering-connection-id m6559)]
    (. bean6558 setVpcPeeringConnectionId (clojure.core/str v6560)))
   bean6558))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m6562]
  (clojure.core/let
   [bean6561
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/when-let
    [v6563 (:filters m6562)]
    (.
     bean6561
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6708] (ec2/filter arg6708))
 v6563)))
   (clojure.core/when-let
    [v6563 (:region-names m6562)]
    (.
     bean6561
     setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6709] (clojure.core/str arg6709))
 v6563)))
   bean6561))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m6565]
  (clojure.core/let
   [bean6564
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/when-let
    [v6566 (:internet-gateway-id m6565)]
    (. bean6564 setInternetGatewayId (clojure.core/str v6566)))
   bean6564))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m6568]
  (clojure.core/let
   [bean6567
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/when-let
    [v6569 (:route-table-id m6568)]
    (. bean6567 setRouteTableId (clojure.core/str v6569)))
   (clojure.core/when-let
    [v6569 (:destination-cidr-block m6568)]
    (. bean6567 setDestinationCidrBlock (clojure.core/str v6569)))
   bean6567))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m6571]
  (clojure.core/let
   [bean6570
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v6572 (:network-interface-id m6571)]
    (. bean6570 setNetworkInterfaceId (clojure.core/str v6572)))
   (clojure.core/when-let
    [v6572 (:private-ip-addresses m6571)]
    (.
     bean6570
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6710] (clojure.core/str arg6710))
 v6572)))
   (clojure.core/when-let
    [v6572 (:secondary-private-ip-address-count m6571)]
    (.
     bean6570
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6572)))
   (clojure.core/when-let
    [v6572 (:allow-reassignment m6571)]
    (. bean6570 setAllowReassignment (clojure.core/boolean v6572)))
   bean6570))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m6574]
  (clojure.core/let
   [bean6573
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6575 (:dhcp-options-id m6574)]
    (. bean6573 setDhcpOptionsId (clojure.core/str v6575)))
   bean6573))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m6577]
  (clojure.core/let
   [bean6576
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v6578 (:spot-instance-request-ids m6577)]
    (.
     bean6576
     setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6711] (clojure.core/str arg6711))
 v6578)))
   bean6576))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m6580]
  (clojure.core/let
   [bean6579
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6581 (:dhcp-configurations m6580)]
    (.
     bean6579
     setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6712] (ec2/dhcp-configuration arg6712))
 v6581)))
   bean6579))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m6583]
  (clojure.core/let
   [bean6582
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/when-let
    [v6584 (:instance-ids m6583)]
    (.
     bean6582
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6713] (clojure.core/str arg6713))
 v6584)))
   (clojure.core/when-let
    [v6584 (:force m6583)]
    (. bean6582 setForce (clojure.core/boolean v6584)))
   bean6582))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m6586]
  (clojure.core/let
   [bean6585
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v6587 (:ip-protocol m6586)]
    (. bean6585 setIpProtocol (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:group-name m6586)]
    (. bean6585 setGroupName (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:source-security-group-owner-id m6586)]
    (.
     bean6585
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:source-security-group-name m6586)]
    (. bean6585 setSourceSecurityGroupName (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:from-port m6586)]
    (. bean6585 setFromPort (clojure.core/int v6587)))
   (clojure.core/when-let
    [v6587 (:group-id m6586)]
    (. bean6585 setGroupId (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:ip-permissions m6586)]
    (.
     bean6585
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6714] (ec2/ip-permission arg6714))
 v6587)))
   (clojure.core/when-let
    [v6587 (:cidr-ip m6586)]
    (. bean6585 setCidrIp (clojure.core/str v6587)))
   (clojure.core/when-let
    [v6587 (:to-port m6586)]
    (. bean6585 setToPort (clojure.core/int v6587)))
   bean6585))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m6589]
  (clojure.core/let
   [bean6588
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/when-let
    [v6590 (:filters m6589)]
    (.
     bean6588
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6715] (ec2/filter arg6715))
 v6590)))
   (clojure.core/when-let
    [v6590 (:group-names m6589)]
    (.
     bean6588
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6716] (clojure.core/str arg6716))
 v6590)))
   bean6588))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m6717]
   (clojure.core/let
    [credentials6718 (:credentials m6717) args6719 (:args m6717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6720
      (com.palletops.awaze.common/aws-client :ec2 credentials6718)]
     (clojure.core/case
      (clojure.core/count args6719)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6720
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6720
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args6719 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials6722 & args6723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6724
     (com.palletops.awaze.common/aws-client :ec2 credentials6722)]
    (clojure.core/case
     (clojure.core/count args6723)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6724
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6724
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args6723 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m6725]
   (clojure.core/let
    [credentials6726 (:credentials m6725) args6727 (:args m6725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6728
      (com.palletops.awaze.common/aws-client :ec2 credentials6726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6728
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args6727 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Call createVpc"}
   [credentials6730 & args6731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6732
     (com.palletops.awaze.common/aws-client :ec2 credentials6730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6732
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args6731 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m6733]
   (clojure.core/let
    [credentials6734 (:credentials m6733) args6735 (:args m6733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6736
      (com.palletops.awaze.common/aws-client :ec2 credentials6734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6736
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args6735 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deregister-image,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Call deregisterImage"}
   [credentials6738 & args6739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6740
     (com.palletops.awaze.common/aws-client :ec2 credentials6738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6740
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args6739 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m6741]
   (clojure.core/let
    [credentials6742 (:credentials m6741) args6743 (:args m6741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6744
      (com.palletops.awaze.common/aws-client :ec2 credentials6742)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6744
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args6743 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl-entry,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials6746 & args6747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6748
     (com.palletops.awaze.common/aws-client :ec2 credentials6746)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6748
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args6747 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m6749]
   (clojure.core/let
    [credentials6750 (:credentials m6749) args6751 (:args m6749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6752
      (com.palletops.awaze.common/aws-client :ec2 credentials6750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6752
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args6751 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-export-task,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Call cancelExportTask"}
   [credentials6754 & args6755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6756
     (com.palletops.awaze.common/aws-client :ec2 credentials6754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6756
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args6755 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m6757]
   (clojure.core/let
    [credentials6758 (:credentials m6757) args6759 (:args m6757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6760
      (com.palletops.awaze.common/aws-client :ec2 credentials6758)]
     (clojure.core/case
      (clojure.core/count args6759)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6760
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args6759 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6760
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials6762 & args6763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6764
     (com.palletops.awaze.common/aws-client :ec2 credentials6762)]
    (clojure.core/case
     (clojure.core/count args6763)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6764
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args6763 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6764
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m6765]
   (clojure.core/let
    [credentials6766 (:credentials m6765) args6767 (:args m6765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6768
      (com.palletops.awaze.common/aws-client :ec2 credentials6766)]
     (clojure.core/case
      (clojure.core/count args6767)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6768
        describeRouteTables))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6768
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args6767 0))))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials6770 & args6771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6772
     (com.palletops.awaze.common/aws-client :ec2 credentials6770)]
    (clojure.core/case
     (clojure.core/count args6771)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6772
       describeRouteTables))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6772
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args6771 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m6773]
   (clojure.core/let
    [credentials6774 (:credentials m6773) args6775 (:args m6773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6776
      (com.palletops.awaze.common/aws-client :ec2 credentials6774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6776
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args6775 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-reserved-instances-listing,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials6778 & args6779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6780
     (com.palletops.awaze.common/aws-client :ec2 credentials6778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6780
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args6779 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m6781]
   (clojure.core/let
    [credentials6782 (:credentials m6781) args6783 (:args m6781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6784
      (com.palletops.awaze.common/aws-client :ec2 credentials6782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6784
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args6783 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-image-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call resetImageAttribute"}
   [credentials6786 & args6787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6788
     (com.palletops.awaze.common/aws-client :ec2 credentials6786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6788
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args6787 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m6789]
   (clojure.core/let
    [credentials6790 (:credentials m6789) args6791 (:args m6789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6792
      (com.palletops.awaze.common/aws-client :ec2 credentials6790)]
     (clojure.core/case
      (clojure.core/count args6791)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6792
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args6791 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6792
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials6794 & args6795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6796
     (com.palletops.awaze.common/aws-client :ec2 credentials6794)]
    (clojure.core/case
     (clojure.core/count args6795)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6796
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args6795 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6796
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m6797]
   (clojure.core/let
    [credentials6798 (:credentials m6797) args6799 (:args m6797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6800
      (com.palletops.awaze.common/aws-client :ec2 credentials6798)]
     (clojure.core/case
      (clojure.core/count args6799)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6800
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6800
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args6799 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials6802 & args6803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6804
     (com.palletops.awaze.common/aws-client :ec2 credentials6802)]
    (clojure.core/case
     (clojure.core/count args6803)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6804
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6804
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args6803 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m6805]
   (clojure.core/let
    [credentials6806 (:credentials m6805) args6807 (:args m6805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6808
      (com.palletops.awaze.common/aws-client :ec2 credentials6806)]
     (clojure.core/case
      (clojure.core/count args6807)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6808
        describeVpnGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6808
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args6807 0))))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials6810 & args6811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6812
     (com.palletops.awaze.common/aws-client :ec2 credentials6810)]
    (clojure.core/case
     (clojure.core/count args6811)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6812
       describeVpnGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6812
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args6811 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m6813]
   (clojure.core/let
    [credentials6814 (:credentials m6813) args6815 (:args m6813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6816
      (com.palletops.awaze.common/aws-client :ec2 credentials6814)]
     (clojure.core/case
      (clojure.core/count args6815)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6816
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args6815 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6816
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials6818 & args6819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6820
     (com.palletops.awaze.common/aws-client :ec2 credentials6818)]
    (clojure.core/case
     (clojure.core/count args6819)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6820
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args6819 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6820
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m6821]
   (clojure.core/let
    [credentials6822 (:credentials m6821) args6823 (:args m6821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6824
      (com.palletops.awaze.common/aws-client :ec2 credentials6822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6824
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args6823 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-image-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials6826 & args6827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6828
     (com.palletops.awaze.common/aws-client :ec2 credentials6826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6828
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args6827 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m6829]
   (clojure.core/let
    [credentials6830 (:credentials m6829) args6831 (:args m6829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6832
      (com.palletops.awaze.common/aws-client :ec2 credentials6830)]
     (clojure.core/case
      (clojure.core/count args6831)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6832
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6832
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args6831 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials6834 & args6835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6836
     (com.palletops.awaze.common/aws-client :ec2 credentials6834)]
    (clojure.core/case
     (clojure.core/count args6835)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6836
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6836
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args6835 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m6837]
   (clojure.core/let
    [credentials6838 (:credentials m6837) args6839 (:args m6837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6840
      (com.palletops.awaze.common/aws-client :ec2 credentials6838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6840
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args6839 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-internet-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call attachInternetGateway"}
   [credentials6842 & args6843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6844
     (com.palletops.awaze.common/aws-client :ec2 credentials6842)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6844
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args6843 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m6845]
   (clojure.core/let
    [credentials6846 (:credentials m6845) args6847 (:args m6845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6848
      (com.palletops.awaze.common/aws-client :ec2 credentials6846)]
     (clojure.core/case
      (clojure.core/count args6847)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6848
        deleteSecurityGroup))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6848
        deleteSecurityGroup
        (ec2/delete-security-group-request
         (clojure.core/nth args6847 0))))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteSecurityGroup, deleteSecurityGroup"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Call deleteSecurityGroup, deleteSecurityGroup"}
   [credentials6850 & args6851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6852
     (com.palletops.awaze.common/aws-client :ec2 credentials6850)]
    (clojure.core/case
     (clojure.core/count args6851)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6852
       deleteSecurityGroup))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6852
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args6851 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m6853]
   (clojure.core/let
    [credentials6854 (:credentials m6853) args6855 (:args m6853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6856
      (com.palletops.awaze.common/aws-client :ec2 credentials6854)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6856
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args6855 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Call detachVolume"}
   [credentials6858 & args6859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6860
     (com.palletops.awaze.common/aws-client :ec2 credentials6858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6860
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args6859 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m6861]
   (clojure.core/let
    [credentials6862 (:credentials m6861) args6863 (:args m6861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6864
      (com.palletops.awaze.common/aws-client :ec2 credentials6862)]
     (clojure.core/case
      (clojure.core/count args6863)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6864
        releaseAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6864
        releaseAddress
        (ec2/release-address-request (clojure.core/nth args6863 0))))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Generate map for releaseAddress, releaseAddress"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Call releaseAddress, releaseAddress"}
   [credentials6866 & args6867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6868
     (com.palletops.awaze.common/aws-client :ec2 credentials6866)]
    (clojure.core/case
     (clojure.core/count args6867)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6868
       releaseAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6868
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args6867 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m6869]
   (clojure.core/let
    [credentials6870 (:credentials m6869) args6871 (:args m6869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6872
      (com.palletops.awaze.common/aws-client :ec2 credentials6870)]
     (clojure.core/case
      (clojure.core/count args6871)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6872
        importVolume
        (ec2/import-volume-request (clojure.core/nth args6871 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6872
        importVolume))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for importVolume, importVolume"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call importVolume, importVolume"}
   [credentials6874 & args6875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6876
     (com.palletops.awaze.common/aws-client :ec2 credentials6874)]
    (clojure.core/case
     (clojure.core/count args6875)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6876
       importVolume
       (ec2/import-volume-request (clojure.core/nth args6875 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6876
       importVolume))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m6877]
   (clojure.core/let
    [credentials6878 (:credentials m6877) args6879 (:args m6877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6880
      (com.palletops.awaze.common/aws-client :ec2 credentials6878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6880
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args6879 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route-table,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Call deleteRouteTable"}
   [credentials6882 & args6883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6884
     (com.palletops.awaze.common/aws-client :ec2 credentials6882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6884
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args6883 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m6885]
   (clojure.core/let
    [credentials6886 (:credentials m6885) args6887 (:args m6885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6888
      (com.palletops.awaze.common/aws-client :ec2 credentials6886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6888
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args6887 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshot-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials6890 & args6891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6892
     (com.palletops.awaze.common/aws-client :ec2 credentials6890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6892
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args6891 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m6893]
   (clojure.core/let
    [credentials6894 (:credentials m6893) args6895 (:args m6893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6896
      (com.palletops.awaze.common/aws-client :ec2 credentials6894)]
     (clojure.core/case
      (clojure.core/count args6895)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6896
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6896
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args6895 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials6898 & args6899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6900
     (com.palletops.awaze.common/aws-client :ec2 credentials6898)]
    (clojure.core/case
     (clojure.core/count args6899)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6900
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6900
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args6899 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m6901]
   (clojure.core/let
    [credentials6902 (:credentials m6901) args6903 (:args m6901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6904
      (com.palletops.awaze.common/aws-client :ec2 credentials6902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6904
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args6903 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-image-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call describeImageAttribute"}
   [credentials6906 & args6907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6908
     (com.palletops.awaze.common/aws-client :ec2 credentials6906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6908
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args6907 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m6909]
   (clojure.core/let
    [credentials6910 (:credentials m6909) args6911 (:args m6909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6912
      (com.palletops.awaze.common/aws-client :ec2 credentials6910)]
     (clojure.core/case
      (clojure.core/count args6911)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6912
        reportInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6912
        reportInstanceStatus
        (ec2/report-instance-status-request
         (clojure.core/nth args6911 0))))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Generate map for reportInstanceStatus, reportInstanceStatus"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Call reportInstanceStatus, reportInstanceStatus"}
   [credentials6914 & args6915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6916
     (com.palletops.awaze.common/aws-client :ec2 credentials6914)]
    (clojure.core/case
     (clojure.core/count args6915)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6916
       reportInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6916
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args6915 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m6917]
   (clojure.core/let
    [credentials6918 (:credentials m6917) args6919 (:args m6917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6920
      (com.palletops.awaze.common/aws-client :ec2 credentials6918)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6920
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args6919 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials6922 & args6923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6924
     (com.palletops.awaze.common/aws-client :ec2 credentials6922)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6924
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args6923 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m6925]
   (clojure.core/let
    [credentials6926 (:credentials m6925) args6927 (:args m6925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6928
      (com.palletops.awaze.common/aws-client :ec2 credentials6926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6928
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args6927 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-snapshot-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials6930 & args6931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6932
     (com.palletops.awaze.common/aws-client :ec2 credentials6930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6932
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args6931 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m6933]
   (clojure.core/let
    [credentials6934 (:credentials m6933) args6935 (:args m6933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6936
      (com.palletops.awaze.common/aws-client :ec2 credentials6934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6936
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args6935 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-dhcp-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials6938 & args6939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6940
     (com.palletops.awaze.common/aws-client :ec2 credentials6938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6940
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args6939 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m6941]
   (clojure.core/let
    [credentials6942 (:credentials m6941) args6943 (:args m6941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6944
      (com.palletops.awaze.common/aws-client :ec2 credentials6942)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6944
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args6943 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-snapshot-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials6946 & args6947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6948
     (com.palletops.awaze.common/aws-client :ec2 credentials6946)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6948
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args6947 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m6949]
   (clojure.core/let
    [credentials6950 (:credentials m6949) args6951 (:args m6949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6952
      (com.palletops.awaze.common/aws-client :ec2 credentials6950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6952
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args6951 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-volume-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials6954 & args6955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6956
     (com.palletops.awaze.common/aws-client :ec2 credentials6954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6956
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args6955 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m6957]
   (clojure.core/let
    [credentials6958 (:credentials m6957) args6959 (:args m6957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6960
      (com.palletops.awaze.common/aws-client :ec2 credentials6958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6960
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args6959 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-placement-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Call createPlacementGroup"}
   [credentials6962 & args6963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6964
     (com.palletops.awaze.common/aws-client :ec2 credentials6962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6964
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args6963 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m6965]
   (clojure.core/let
    [credentials6966 (:credentials m6965) args6967 (:args m6965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6968
      (com.palletops.awaze.common/aws-client :ec2 credentials6966)]
     (clojure.core/case
      (clojure.core/count args6967)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6968
        describeVpnConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6968
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args6967 0))))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials6970 & args6971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6972
     (com.palletops.awaze.common/aws-client :ec2 credentials6970)]
    (clojure.core/case
     (clojure.core/count args6971)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6972
       describeVpnConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6972
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args6971 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m6973]
   (clojure.core/let
    [credentials6974 (:credentials m6973) args6975 (:args m6973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6976
      (com.palletops.awaze.common/aws-client :ec2 credentials6974)]
     (clojure.core/case
      (clojure.core/count args6975)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6976
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args6975 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6976
        describeSpotPriceHistory))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials6978 & args6979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6980
     (com.palletops.awaze.common/aws-client :ec2 credentials6978)]
    (clojure.core/case
     (clojure.core/count args6979)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6980
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args6979 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6980
       describeSpotPriceHistory))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m6981]
   (clojure.core/let
    [credentials6982 (:credentials m6981) args6983 (:args m6981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6984
      (com.palletops.awaze.common/aws-client :ec2 credentials6982)]
     (clojure.core/case
      (clojure.core/count args6983)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6984
        rejectVpcPeeringConnection
        (ec2/reject-vpc-peering-connection-request
         (clojure.core/nth args6983 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6984
        rejectVpcPeeringConnection))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   [credentials6986 & args6987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6988
     (com.palletops.awaze.common/aws-client :ec2 credentials6986)]
    (clojure.core/case
     (clojure.core/count args6987)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6988
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args6987 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6988
       rejectVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m6989]
   (clojure.core/let
    [credentials6990 (:credentials m6989) args6991 (:args m6989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6992
      (com.palletops.awaze.common/aws-client :ec2 credentials6990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6992
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args6991 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call deleteVpc"}
   [credentials6994 & args6995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6996
     (com.palletops.awaze.common/aws-client :ec2 credentials6994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6996
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args6995 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m6997]
   (clojure.core/let
    [credentials6998 (:credentials m6997) args6999 (:args m6997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7000
      (com.palletops.awaze.common/aws-client :ec2 credentials6998)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7000
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args6999 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route-table,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createRouteTable"}
   [credentials7002 & args7003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7004
     (com.palletops.awaze.common/aws-client :ec2 credentials7002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7004
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args7003 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m7005]
   (clojure.core/let
    [credentials7006 (:credentials m7005) args7007 (:args m7005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7008
      (com.palletops.awaze.common/aws-client :ec2 credentials7006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7008
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args7007 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :terminate-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call terminateInstances"}
   [credentials7010 & args7011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7012
     (com.palletops.awaze.common/aws-client :ec2 credentials7010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7012
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args7011 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m7013]
   (clojure.core/let
    [credentials7014 (:credentials m7013) args7015 (:args m7013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7016
      (com.palletops.awaze.common/aws-client :ec2 credentials7014)]
     (clojure.core/case
      (clojure.core/count args7015)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7016
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args7015 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7016
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials7018 & args7019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7020
     (com.palletops.awaze.common/aws-client :ec2 credentials7018)]
    (clojure.core/case
     (clojure.core/count args7019)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7020
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args7019 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7020
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m7021]
   (clojure.core/let
    [credentials7022 (:credentials m7021) args7023 (:args m7021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7024
      (com.palletops.awaze.common/aws-client :ec2 credentials7022)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7024
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args7023 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Call associateAddress"}
   [credentials7026 & args7027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7028
     (com.palletops.awaze.common/aws-client :ec2 credentials7026)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7028
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args7027 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m7029]
   (clojure.core/let
    [credentials7030 (:credentials m7029) args7031 (:args m7029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7032
      (com.palletops.awaze.common/aws-client :ec2 credentials7030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7032
       createVolume
       (ec2/create-volume-request (clojure.core/nth args7031 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Call createVolume"}
   [credentials7034 & args7035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7036
     (com.palletops.awaze.common/aws-client :ec2 credentials7034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7036
      createVolume
      (ec2/create-volume-request (clojure.core/nth args7035 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m7037]
   (clojure.core/let
    [credentials7038 (:credentials m7037) args7039 (:args m7037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7040
      (com.palletops.awaze.common/aws-client :ec2 credentials7038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7040
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args7039 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-reserved-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials7042 & args7043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7044
     (com.palletops.awaze.common/aws-client :ec2 credentials7042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7044
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args7043 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m7045]
   (clojure.core/let
    [credentials7046 (:credentials m7045) args7047 (:args m7045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7048
      (com.palletops.awaze.common/aws-client :ec2 credentials7046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7048
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args7047 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials7050 & args7051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7052
     (com.palletops.awaze.common/aws-client :ec2 credentials7050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7052
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args7051 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m7053]
   (clojure.core/let
    [credentials7054 (:credentials m7053) args7055 (:args m7053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7056
      (com.palletops.awaze.common/aws-client :ec2 credentials7054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7056
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args7055 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-egress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials7058 & args7059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7060
     (com.palletops.awaze.common/aws-client :ec2 credentials7058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7060
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args7059 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m7061]
   (clojure.core/let
    [credentials7062 (:credentials m7061) args7063 (:args m7061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7064
      (com.palletops.awaze.common/aws-client :ec2 credentials7062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7064
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args7063 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-customer-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials7066 & args7067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7068
     (com.palletops.awaze.common/aws-client :ec2 credentials7066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7068
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args7067 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m7069]
   (clojure.core/let
    [credentials7070 (:credentials m7069) args7071 (:args m7069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7072
      (com.palletops.awaze.common/aws-client :ec2 credentials7070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7072
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args7071 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-entry,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials7074 & args7075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7076
     (com.palletops.awaze.common/aws-client :ec2 credentials7074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7076
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args7075 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m7077]
   (clojure.core/let
    [credentials7078 (:credentials m7077) args7079 (:args m7077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7080
      (com.palletops.awaze.common/aws-client :ec2 credentials7078)]
     (clojure.core/case
      (clojure.core/count args7079)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7080
        createVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7080
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args7079 0))))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials7082 & args7083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7084
     (com.palletops.awaze.common/aws-client :ec2 credentials7082)]
    (clojure.core/case
     (clojure.core/count args7083)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7084
       createVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7084
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args7083 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m7085]
   (clojure.core/let
    [credentials7086 (:credentials m7085) args7087 (:args m7085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7088
      (com.palletops.awaze.common/aws-client :ec2 credentials7086)]
     (clojure.core/case
      (clojure.core/count args7087)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7088
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args7087 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7088
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials7090 & args7091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7092
     (com.palletops.awaze.common/aws-client :ec2 credentials7090)]
    (clojure.core/case
     (clojure.core/count args7091)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7092
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args7091 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7092
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m7093]
   (clojure.core/let
    [credentials7094 (:credentials m7093) args7095 (:args m7093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7096
      (com.palletops.awaze.common/aws-client :ec2 credentials7094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7096
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args7095 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-console-output,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getConsoleOutput"}
   [credentials7098 & args7099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7100
     (com.palletops.awaze.common/aws-client :ec2 credentials7098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7100
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args7099 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m7101]
   (clojure.core/let
    [credentials7102 (:credentials m7101) args7103 (:args m7101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7104
      (com.palletops.awaze.common/aws-client :ec2 credentials7102)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7104
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args7103 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-conversion-task,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Call cancelConversionTask"}
   [credentials7106 & args7107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7108
     (com.palletops.awaze.common/aws-client :ec2 credentials7106)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7108
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args7107 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m7109]
   (clojure.core/let
    [credentials7110 (:credentials m7109) args7111 (:args m7109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7112
      (com.palletops.awaze.common/aws-client :ec2 credentials7110)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7112
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args7111 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-vpn-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call attachVpnGateway"}
   [credentials7114 & args7115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7116
     (com.palletops.awaze.common/aws-client :ec2 credentials7114)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7116
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args7115 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m7117]
   (clojure.core/let
    [credentials7118 (:credentials m7117) args7119 (:args m7117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7120
      (com.palletops.awaze.common/aws-client :ec2 credentials7118)]
     (clojure.core/case
      (clojure.core/count args7119)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7120
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args7119 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7120
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials7122 & args7123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7124
     (com.palletops.awaze.common/aws-client :ec2 credentials7122)]
    (clojure.core/case
     (clojure.core/count args7123)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7124
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args7123 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7124
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m7125]
   (clojure.core/let
    [credentials7126 (:credentials m7125) args7127 (:args m7125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7128
      (com.palletops.awaze.common/aws-client :ec2 credentials7126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7128
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args7127 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection-route,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials7130 & args7131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7132
     (com.palletops.awaze.common/aws-client :ec2 credentials7130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7132
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args7131 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m7133]
   (clojure.core/let
    [credentials7134 (:credentials m7133) args7135 (:args m7133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7136
      (com.palletops.awaze.common/aws-client :ec2 credentials7134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7136
       runInstances
       (ec2/run-instances-request (clojure.core/nth args7135 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :run-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Call runInstances"}
   [credentials7138 & args7139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7140
     (com.palletops.awaze.common/aws-client :ec2 credentials7138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7140
      runInstances
      (ec2/run-instances-request (clojure.core/nth args7139 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m7141]
   (clojure.core/let
    [credentials7142 (:credentials m7141) args7143 (:args m7141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7144
      (com.palletops.awaze.common/aws-client :ec2 credentials7142)]
     (clojure.core/case
      (clojure.core/count args7143)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7144
        registerImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7144
        registerImage
        (ec2/register-image-request (clojure.core/nth args7143 0))))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]]),
    :doc "Generate map for registerImage, registerImage"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]]),
    :doc "Call registerImage, registerImage"}
   [credentials7146 & args7147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7148
     (com.palletops.awaze.common/aws-client :ec2 credentials7146)]
    (clojure.core/case
     (clojure.core/count args7147)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7148
       registerImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7148
       registerImage
       (ec2/register-image-request (clojure.core/nth args7147 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m7149]
   (clojure.core/let
    [credentials7150 (:credentials m7149) args7151 (:args m7149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7152
      (com.palletops.awaze.common/aws-client :ec2 credentials7150)]
     (clojure.core/case
      (clojure.core/count args7151)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7152
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args7151 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7152
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials7154 & args7155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7156
     (com.palletops.awaze.common/aws-client :ec2 credentials7154)]
    (clojure.core/case
     (clojure.core/count args7155)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7156
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args7155 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7156
       describeTags))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m7157]
   (clojure.core/let
    [credentials7158 (:credentials m7157) args7159 (:args m7157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7160
      (com.palletops.awaze.common/aws-client :ec2 credentials7158)]
     (clojure.core/case
      (clojure.core/count args7159)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7160
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7160
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args7159 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials7162 & args7163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7164
     (com.palletops.awaze.common/aws-client :ec2 credentials7162)]
    (clojure.core/case
     (clojure.core/count args7163)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7164
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7164
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args7163 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m7165]
   (clojure.core/let
    [credentials7166 (:credentials m7165) args7167 (:args m7165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7168
      (com.palletops.awaze.common/aws-client :ec2 credentials7166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7168
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args7167 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-vpn-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call detachVpnGateway"}
   [credentials7170 & args7171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7172
     (com.palletops.awaze.common/aws-client :ec2 credentials7170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7172
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args7171 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m7173]
   (clojure.core/let
    [credentials7174 (:credentials m7173) args7175 (:args m7173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7176
      (com.palletops.awaze.common/aws-client :ec2 credentials7174)]
     (clojure.core/case
      (clojure.core/count args7175)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7176
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args7175 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7176
        describeCustomerGateways))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]
                [credentials]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]
                [credentials]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials7178 & args7179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7180
     (com.palletops.awaze.common/aws-client :ec2 credentials7178)]
    (clojure.core/case
     (clojure.core/count args7179)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7180
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args7179 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7180
       describeCustomerGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m7181]
   (clojure.core/let
    [credentials7182 (:credentials m7181) args7183 (:args m7181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7184
      (com.palletops.awaze.common/aws-client :ec2 credentials7182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7184
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args7183 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interface-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials7186 & args7187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7188
     (com.palletops.awaze.common/aws-client :ec2 credentials7186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7188
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args7187 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m7189]
   (clojure.core/let
    [credentials7190 (:credentials m7189) args7191 (:args m7189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7192
      (com.palletops.awaze.common/aws-client :ec2 credentials7190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7192
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args7191 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-key-pair,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Call importKeyPair"}
   [credentials7194 & args7195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7196
     (com.palletops.awaze.common/aws-client :ec2 credentials7194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7196
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args7195 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m7197]
   (clojure.core/let
    [credentials7198 (:credentials m7197) args7199 (:args m7197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7200
      (com.palletops.awaze.common/aws-client :ec2 credentials7198)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7200
       importInstance
       (ec2/import-instance-request (clojure.core/nth args7199 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-instance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Call importInstance"}
   [credentials7202 & args7203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7204
     (com.palletops.awaze.common/aws-client :ec2 credentials7202)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7204
      importInstance
      (ec2/import-instance-request (clojure.core/nth args7203 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m7205]
   (clojure.core/let
    [credentials7206 (:credentials m7205) args7207 (:args m7205)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7208
      (com.palletops.awaze.common/aws-client :ec2 credentials7206)]
     (clojure.core/case
      (clojure.core/count args7207)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7208
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7208
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args7207 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials7210 & args7211]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7212
     (com.palletops.awaze.common/aws-client :ec2 credentials7210)]
    (clojure.core/case
     (clojure.core/count args7211)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7212
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7212
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args7211 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m7213]
   (clojure.core/let
    [credentials7214 (:credentials m7213) args7215 (:args m7213)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7216
      (com.palletops.awaze.common/aws-client :ec2 credentials7214)]
     (clojure.core/case
      (clojure.core/count args7215)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7216
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7216
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args7215 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials7218 & args7219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7220
     (com.palletops.awaze.common/aws-client :ec2 credentials7218)]
    (clojure.core/case
     (clojure.core/count args7219)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7220
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7220
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args7219 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m7221]
   (clojure.core/let
    [credentials7222 (:credentials m7221) args7223 (:args m7221)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7224
      (com.palletops.awaze.common/aws-client :ec2 credentials7222)]
     (clojure.core/case
      (clojure.core/count args7223)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7224
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args7223 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7224
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials7226 & args7227]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7228
     (com.palletops.awaze.common/aws-client :ec2 credentials7226)]
    (clojure.core/case
     (clojure.core/count args7227)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7228
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args7227 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7228
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m7229]
   (clojure.core/let
    [credentials7230 (:credentials m7229) args7231 (:args m7229)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7232
      (com.palletops.awaze.common/aws-client :ec2 credentials7230)]
     (clojure.core/case
      (clojure.core/count args7231)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7232
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args7231 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7232
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials7234 & args7235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7236
     (com.palletops.awaze.common/aws-client :ec2 credentials7234)]
    (clojure.core/case
     (clojure.core/count args7235)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7236
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args7235 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7236
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m7237]
   (clojure.core/let
    [credentials7238 (:credentials m7237) args7239 (:args m7237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7240
      (com.palletops.awaze.common/aws-client :ec2 credentials7238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7240
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args7239 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route-table-association,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials7242 & args7243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7244
     (com.palletops.awaze.common/aws-client :ec2 credentials7242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7244
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args7243 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m7245]
   (clojure.core/let
    [credentials7246 (:credentials m7245) args7247 (:args m7245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7248
      (com.palletops.awaze.common/aws-client :ec2 credentials7246)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7248
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args7247 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-subnet,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Call deleteSubnet"}
   [credentials7250 & args7251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7252
     (com.palletops.awaze.common/aws-client :ec2 credentials7250)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7252
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args7251 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m7253]
   (clojure.core/let
    [credentials7254 (:credentials m7253) args7255 (:args m7253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7256
      (com.palletops.awaze.common/aws-client :ec2 credentials7254)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7256
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args7255 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-vpc-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials7258 & args7259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7260
     (com.palletops.awaze.common/aws-client :ec2 credentials7258)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7260
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args7259 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m7261]
   (clojure.core/let
    [credentials7262 (:credentials m7261) args7263 (:args m7261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7264
      (com.palletops.awaze.common/aws-client :ec2 credentials7262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7264
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args7263 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-internet-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call detachInternetGateway"}
   [credentials7266 & args7267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7268
     (com.palletops.awaze.common/aws-client :ec2 credentials7266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7268
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args7267 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m7269]
   (clojure.core/let
    [credentials7270 (:credentials m7269) args7271 (:args m7269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7272
      (com.palletops.awaze.common/aws-client :ec2 credentials7270)]
     (clojure.core/case
      (clojure.core/count args7271)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7272
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args7271 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7272
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials7274 & args7275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7276
     (com.palletops.awaze.common/aws-client :ec2 credentials7274)]
    (clojure.core/case
     (clojure.core/count args7275)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7276
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args7275 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7276
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m7277]
   (clojure.core/let
    [credentials7278 (:credentials m7277) args7279 (:args m7277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7280
      (com.palletops.awaze.common/aws-client :ec2 credentials7278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7280
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args7279 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-password-data,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getPasswordData"}
   [credentials7282 & args7283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7284
     (com.palletops.awaze.common/aws-client :ec2 credentials7282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7284
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args7283 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m7285]
   (clojure.core/let
    [credentials7286 (:credentials m7285) args7287 (:args m7285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7288
      (com.palletops.awaze.common/aws-client :ec2 credentials7286)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7288
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args7287 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials7290 & args7291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7292
     (com.palletops.awaze.common/aws-client :ec2 credentials7290)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7292
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args7291 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m7293]
   (clojure.core/let
    [credentials7294 (:credentials m7293) args7295 (:args m7293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7296
      (com.palletops.awaze.common/aws-client :ec2 credentials7294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7296
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args7295 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-network-interface-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials7298 & args7299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7300
     (com.palletops.awaze.common/aws-client :ec2 credentials7298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7300
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args7299 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m7301]
   (clojure.core/let
    [credentials7302 (:credentials m7301) args7303 (:args m7301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7304
      (com.palletops.awaze.common/aws-client :ec2 credentials7302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7304
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args7303 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-network-interface-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials7306 & args7307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7308
     (com.palletops.awaze.common/aws-client :ec2 credentials7306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7308
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args7307 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m7309]
   (clojure.core/let
    [credentials7310 (:credentials m7309) args7311 (:args m7309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7312
      (com.palletops.awaze.common/aws-client :ec2 credentials7310)]
     (clojure.core/case
      (clojure.core/count args7311)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7312
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args7311 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7312
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials7314 & args7315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7316
     (com.palletops.awaze.common/aws-client :ec2 credentials7314)]
    (clojure.core/case
     (clojure.core/count args7315)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7316
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args7315 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7316
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m7317]
   (clojure.core/let
    [credentials7318 (:credentials m7317) args7319 (:args m7317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7320
      (com.palletops.awaze.common/aws-client :ec2 credentials7318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7320
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args7319 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reboot-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call rebootInstances"}
   [credentials7322 & args7323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7324
     (com.palletops.awaze.common/aws-client :ec2 credentials7322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7324
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args7323 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m7325]
   (clojure.core/let
    [credentials7326 (:credentials m7325) args7327 (:args m7325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7328
      (com.palletops.awaze.common/aws-client :ec2 credentials7326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7328
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args7327 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials7330 & args7331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7332
     (com.palletops.awaze.common/aws-client :ec2 credentials7330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7332
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args7331 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m7333]
   (clojure.core/let
    [credentials7334 (:credentials m7333) args7335 (:args m7333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7336
      (com.palletops.awaze.common/aws-client :ec2 credentials7334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7336
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args7335 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-instance-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials7338 & args7339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7340
     (com.palletops.awaze.common/aws-client :ec2 credentials7338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7340
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args7339 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m7341]
   (clojure.core/let
    [credentials7342 (:credentials m7341) args7343 (:args m7341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7344
      (com.palletops.awaze.common/aws-client :ec2 credentials7342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7344
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args7343 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-key-pair,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call deleteKeyPair"}
   [credentials7346 & args7347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7348
     (com.palletops.awaze.common/aws-client :ec2 credentials7346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7348
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args7347 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m7349]
   (clojure.core/let
    [credentials7350 (:credentials m7349) args7351 (:args m7349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7352
      (com.palletops.awaze.common/aws-client :ec2 credentials7350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7352
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args7351 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials7354 & args7355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7356
     (com.palletops.awaze.common/aws-client :ec2 credentials7354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7356
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args7355 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m7357]
   (clojure.core/let
    [credentials7358 (:credentials m7357) args7359 (:args m7357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7360
      (com.palletops.awaze.common/aws-client :ec2 credentials7358)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7360
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args7359 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :bundle-instance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call bundleInstance"}
   [credentials7362 & args7363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7364
     (com.palletops.awaze.common/aws-client :ec2 credentials7362)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7364
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args7363 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m7365]
   (clojure.core/let
    [credentials7366 (:credentials m7365) args7367 (:args m7365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7368
      (com.palletops.awaze.common/aws-client :ec2 credentials7366)]
     (clojure.core/case
      (clojure.core/count args7367)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7368
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7368
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args7367 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials7370 & args7371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7372
     (com.palletops.awaze.common/aws-client :ec2 credentials7370)]
    (clojure.core/case
     (clojure.core/count args7371)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7372
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7372
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args7371 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m7373]
   (clojure.core/let
    [credentials7374 (:credentials m7373) args7375 (:args m7373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7376
      (com.palletops.awaze.common/aws-client :ec2 credentials7374)]
     (clojure.core/case
      (clojure.core/count args7375)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7376
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7376
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args7375 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials7378 & args7379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7380
     (com.palletops.awaze.common/aws-client :ec2 credentials7378)]
    (clojure.core/case
     (clojure.core/count args7379)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7380
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7380
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args7379 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m7381]
   (clojure.core/let
    [credentials7382 (:credentials m7381) args7383 (:args m7381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7384
      (com.palletops.awaze.common/aws-client :ec2 credentials7382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7384
       copyImage
       (ec2/copy-image-request (clojure.core/nth args7383 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-image,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Call copyImage"}
   [credentials7386 & args7387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7388
     (com.palletops.awaze.common/aws-client :ec2 credentials7386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7388
      copyImage
      (ec2/copy-image-request (clojure.core/nth args7387 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m7389]
   (clojure.core/let
    [credentials7390 (:credentials m7389) args7391 (:args m7389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7392
      (com.palletops.awaze.common/aws-client :ec2 credentials7390)]
     (clojure.core/case
      (clojure.core/count args7391)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7392
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args7391 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7392
        describeKeyPairs))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials
                 {:keys [key-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials
                 {:keys [key-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials7394 & args7395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7396
     (com.palletops.awaze.common/aws-client :ec2 credentials7394)]
    (clojure.core/case
     (clojure.core/count args7395)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7396
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args7395 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7396
       describeKeyPairs))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m7397]
   (clojure.core/let
    [credentials7398 (:credentials m7397) args7399 (:args m7397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7400
      (com.palletops.awaze.common/aws-client :ec2 credentials7398)]
     (clojure.core/case
      (clojure.core/count args7399)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7400
        acceptVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7400
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args7399 0))))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials7402 & args7403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7404
     (com.palletops.awaze.common/aws-client :ec2 credentials7402)]
    (clojure.core/case
     (clojure.core/count args7403)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7404
       acceptVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7404
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args7403 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m7405]
   (clojure.core/let
    [credentials7406 (:credentials m7405) args7407 (:args m7405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7408
      (com.palletops.awaze.common/aws-client :ec2 credentials7406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7408
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args7407 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl-entry,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials7410 & args7411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7412
     (com.palletops.awaze.common/aws-client :ec2 credentials7410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7412
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args7411 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m7413]
   (clojure.core/let
    [credentials7414 (:credentials m7413) args7415 (:args m7413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7416
      (com.palletops.awaze.common/aws-client :ec2 credentials7414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7416
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args7415 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials7418 & args7419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7420
     (com.palletops.awaze.common/aws-client :ec2 credentials7418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7420
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args7419 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m7421]
   (clojure.core/let
    [credentials7422 (:credentials m7421) args7423 (:args m7421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7424
      (com.palletops.awaze.common/aws-client :ec2 credentials7422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7424
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args7423 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials7426 & args7427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7428
     (com.palletops.awaze.common/aws-client :ec2 credentials7426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7428
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args7427 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m7429]
   (clojure.core/let
    [credentials7430 (:credentials m7429) args7431 (:args m7429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7432
      (com.palletops.awaze.common/aws-client :ec2 credentials7430)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7432
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args7431 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-egress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials7434 & args7435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7436
     (com.palletops.awaze.common/aws-client :ec2 credentials7434)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7436
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args7435 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m7437]
   (clojure.core/let
    [credentials7438 (:credentials m7437) args7439 (:args m7437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7440
      (com.palletops.awaze.common/aws-client :ec2 credentials7438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7440
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args7439 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials7442 & args7443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7444
     (com.palletops.awaze.common/aws-client :ec2 credentials7442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7444
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args7443 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m7445]
   (clojure.core/let
    [credentials7446 (:credentials m7445) args7447 (:args m7445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7448
      (com.palletops.awaze.common/aws-client :ec2 credentials7446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7448
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args7447 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-volume-io,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call enableVolumeIO"}
   [credentials7450 & args7451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7452
     (com.palletops.awaze.common/aws-client :ec2 credentials7450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7452
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args7451 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m7453]
   (clojure.core/let
    [credentials7454 (:credentials m7453) args7455 (:args m7453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7456
      (com.palletops.awaze.common/aws-client :ec2 credentials7454)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7456
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args7455 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-association,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials7458 & args7459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7460
     (com.palletops.awaze.common/aws-client :ec2 credentials7458)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7460
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args7459 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m7461]
   (clojure.core/let
    [credentials7462 (:credentials m7461) args7463 (:args m7461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7464
      (com.palletops.awaze.common/aws-client :ec2 credentials7462)]
     (clojure.core/case
      (clojure.core/count args7463)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7464
        deleteVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7464
        deleteVpcPeeringConnection
        (ec2/delete-vpc-peering-connection-request
         (clojure.core/nth args7463 0))))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Call deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   [credentials7466 & args7467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7468
     (com.palletops.awaze.common/aws-client :ec2 credentials7466)]
    (clojure.core/case
     (clojure.core/count args7467)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7468
       deleteVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7468
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args7467 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m7469]
   (clojure.core/let
    [credentials7470 (:credentials m7469) args7471 (:args m7469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7472
      (com.palletops.awaze.common/aws-client :ec2 credentials7470)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7472
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args7471 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Call copySnapshot"}
   [credentials7474 & args7475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7476
     (com.palletops.awaze.common/aws-client :ec2 credentials7474)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7476
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args7475 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m7477]
   (clojure.core/let
    [credentials7478 (:credentials m7477) args7479 (:args m7477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7480
      (com.palletops.awaze.common/aws-client :ec2 credentials7478)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7480
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args7479 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-customer-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Call createCustomerGateway"}
   [credentials7482 & args7483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7484
     (com.palletops.awaze.common/aws-client :ec2 credentials7482)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7484
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args7483 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m7485]
   (clojure.core/let
    [credentials7486 (:credentials m7485) args7487 (:args m7485)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7488
      (com.palletops.awaze.common/aws-client :ec2 credentials7486)]
     (clojure.core/case
      (clojure.core/count args7487)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7488
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7488
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args7487 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials7490 & args7491]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7492
     (com.palletops.awaze.common/aws-client :ec2 credentials7490)]
    (clojure.core/case
     (clojure.core/count args7491)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7492
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7492
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args7491 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m7493]
   (clojure.core/let
    [credentials7494 (:credentials m7493) args7495 (:args m7493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7496
      (com.palletops.awaze.common/aws-client :ec2 credentials7494)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7496
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args7495 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-bundle-task,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Call cancelBundleTask"}
   [credentials7498 & args7499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7500
     (com.palletops.awaze.common/aws-client :ec2 credentials7498)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7500
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args7499 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m7501]
   (clojure.core/let
    [credentials7502 (:credentials m7501) args7503 (:args m7501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7504
      (com.palletops.awaze.common/aws-client :ec2 credentials7502)]
     (clojure.core/case
      (clojure.core/count args7503)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7504
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7504
        describeImages
        (ec2/describe-images-request (clojure.core/nth args7503 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials7506 & args7507]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7508
     (com.palletops.awaze.common/aws-client :ec2 credentials7506)]
    (clojure.core/case
     (clojure.core/count args7507)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7508
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7508
       describeImages
       (ec2/describe-images-request (clojure.core/nth args7507 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m7509]
   (clojure.core/let
    [credentials7510 (:credentials m7509) args7511 (:args m7509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7512
      (com.palletops.awaze.common/aws-client :ec2 credentials7510)]
     (clojure.core/case
      (clojure.core/count args7511)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7512
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7512
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args7511 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials7514 & args7515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7516
     (com.palletops.awaze.common/aws-client :ec2 credentials7514)]
    (clojure.core/case
     (clojure.core/count args7515)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7516
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7516
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args7515 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m7517]
   (clojure.core/let
    [credentials7518 (:credentials m7517) args7519 (:args m7517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7520
      (com.palletops.awaze.common/aws-client :ec2 credentials7518)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7520
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args7519 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials7522 & args7523]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7524
     (com.palletops.awaze.common/aws-client :ec2 credentials7522)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7524
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args7523 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m7525]
   (clojure.core/let
    [credentials7526 (:credentials m7525) args7527 (:args m7525)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7528
      (com.palletops.awaze.common/aws-client :ec2 credentials7526)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7528
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args7527 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection-route,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials7530 & args7531]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7532
     (com.palletops.awaze.common/aws-client :ec2 credentials7530)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7532
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args7531 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m7533]
   (clojure.core/let
    [credentials7534 (:credentials m7533) args7535 (:args m7533)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7536
      (com.palletops.awaze.common/aws-client :ec2 credentials7534)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7536
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args7535 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-key-pair,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call createKeyPair"}
   [credentials7538 & args7539]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7540
     (com.palletops.awaze.common/aws-client :ec2 credentials7538)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7540
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args7539 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m7541]
   (clojure.core/let
    [credentials7542 (:credentials m7541) args7543 (:args m7541)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7544
      (com.palletops.awaze.common/aws-client :ec2 credentials7542)]
     (clojure.core/case
      (clojure.core/count args7543)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7544
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args7543 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7544
        describeAccountAttributes))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener attribute-names]}]
                [credentials]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener attribute-names]}]
                [credentials]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials7546 & args7547]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7548
     (com.palletops.awaze.common/aws-client :ec2 credentials7546)]
    (clojure.core/case
     (clojure.core/count args7547)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7548
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args7547 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7548
       describeAccountAttributes))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m7549]
   (clojure.core/let
    [credentials7550 (:credentials m7549) args7551 (:args m7549)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7552
      (com.palletops.awaze.common/aws-client :ec2 credentials7550)]
     (clojure.core/case
      (clojure.core/count args7551)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7552
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7552
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args7551 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials7554 & args7555]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7556
     (com.palletops.awaze.common/aws-client :ec2 credentials7554)]
    (clojure.core/case
     (clojure.core/count args7555)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7556
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7556
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args7555 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m7557]
   (clojure.core/let
    [credentials7558 (:credentials m7557) args7559 (:args m7557)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7560
      (com.palletops.awaze.common/aws-client :ec2 credentials7558)]
     (clojure.core/case
      (clojure.core/count args7559)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7560
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7560
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args7559 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials7562 & args7563]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7564
     (com.palletops.awaze.common/aws-client :ec2 credentials7562)]
    (clojure.core/case
     (clojure.core/count args7563)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7564
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7564
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args7563 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m7565]
   (clojure.core/let
    [credentials7566 (:credentials m7565) args7567 (:args m7565)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7568
      (com.palletops.awaze.common/aws-client :ec2 credentials7566)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7568
       startInstances
       (ec2/start-instances-request (clojure.core/nth args7567 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :start-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Call startInstances"}
   [credentials7570 & args7571]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7572
     (com.palletops.awaze.common/aws-client :ec2 credentials7570)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7572
      startInstances
      (ec2/start-instances-request (clojure.core/nth args7571 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m7573]
   (clojure.core/let
    [credentials7574 (:credentials m7573) args7575 (:args m7573)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7576
      (com.palletops.awaze.common/aws-client :ec2 credentials7574)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7576
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args7575 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-network-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials7578 & args7579]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7580
     (com.palletops.awaze.common/aws-client :ec2 credentials7578)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7580
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args7579 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m7581]
   (clojure.core/let
    [credentials7582 (:credentials m7581) args7583 (:args m7581)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7584
      (com.palletops.awaze.common/aws-client :ec2 credentials7582)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7584
       createRoute
       (ec2/create-route-request (clojure.core/nth args7583 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call createRoute"}
   [credentials7586 & args7587]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7588
     (com.palletops.awaze.common/aws-client :ec2 credentials7586)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7588
      createRoute
      (ec2/create-route-request (clojure.core/nth args7587 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m7589]
   (clojure.core/let
    [credentials7590 (:credentials m7589) args7591 (:args m7589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7592
      (com.palletops.awaze.common/aws-client :ec2 credentials7590)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7592
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args7591 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unmonitor-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call unmonitorInstances"}
   [credentials7594 & args7595]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7596
     (com.palletops.awaze.common/aws-client :ec2 credentials7594)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7596
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args7595 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m7597]
   (clojure.core/let
    [credentials7598 (:credentials m7597) args7599 (:args m7597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7600
      (com.palletops.awaze.common/aws-client :ec2 credentials7598)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7600
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args7599 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials7602 & args7603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7604
     (com.palletops.awaze.common/aws-client :ec2 credentials7602)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7604
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args7603 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m7605]
   (clojure.core/let
    [credentials7606 (:credentials m7605) args7607 (:args m7605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7608
      (com.palletops.awaze.common/aws-client :ec2 credentials7606)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7608
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args7607 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :monitor-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call monitorInstances"}
   [credentials7610 & args7611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7612
     (com.palletops.awaze.common/aws-client :ec2 credentials7610)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7612
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args7611 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m7613]
   (clojure.core/let
    [credentials7614 (:credentials m7613) args7615 (:args m7613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7616
      (com.palletops.awaze.common/aws-client :ec2 credentials7614)]
     (clojure.core/case
      (clojure.core/count args7615)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7616
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7616
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args7615 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials7618 & args7619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7620
     (com.palletops.awaze.common/aws-client :ec2 credentials7618)]
    (clojure.core/case
     (clojure.core/count args7619)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7620
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7620
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args7619 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m7621]
   (clojure.core/let
    [credentials7622 (:credentials m7621) args7623 (:args m7621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7624
      (com.palletops.awaze.common/aws-client :ec2 credentials7622)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7624
       createTags
       (ec2/create-tags-request (clojure.core/nth args7623 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call createTags"}
   [credentials7626 & args7627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7628
     (com.palletops.awaze.common/aws-client :ec2 credentials7626)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7628
      createTags
      (ec2/create-tags-request (clojure.core/nth args7627 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m7629]
   (clojure.core/let
    [credentials7630 (:credentials m7629) args7631 (:args m7629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7632
      (com.palletops.awaze.common/aws-client :ec2 credentials7630)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7632
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args7631 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :confirm-product-instance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call confirmProductInstance"}
   [credentials7634 & args7635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7636
     (com.palletops.awaze.common/aws-client :ec2 credentials7634)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7636
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args7635 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m7637]
   (clojure.core/let
    [credentials7638 (:credentials m7637) args7639 (:args m7637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7640
      (com.palletops.awaze.common/aws-client :ec2 credentials7638)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7640
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args7639 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-route-table,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials7642 & args7643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7644
     (com.palletops.awaze.common/aws-client :ec2 credentials7642)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7644
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args7643 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m7645]
   (clojure.core/let
    [credentials7646 (:credentials m7645) args7647 (:args m7645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7648
      (com.palletops.awaze.common/aws-client :ec2 credentials7646)]
     (clojure.core/case
      (clojure.core/count args7647)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7648
        disassociateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7648
        disassociateAddress
        (ec2/disassociate-address-request
         (clojure.core/nth args7647 0))))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for disassociateAddress, disassociateAddress"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Call disassociateAddress, disassociateAddress"}
   [credentials7650 & args7651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7652
     (com.palletops.awaze.common/aws-client :ec2 credentials7650)]
    (clojure.core/case
     (clojure.core/count args7651)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7652
       disassociateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7652
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args7651 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m7653]
   (clojure.core/let
    [credentials7654 (:credentials m7653) args7655 (:args m7653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7656
      (com.palletops.awaze.common/aws-client :ec2 credentials7654)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7656
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args7655 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-network-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials7658 & args7659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7660
     (com.palletops.awaze.common/aws-client :ec2 credentials7658)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7660
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args7659 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m7661]
   (clojure.core/let
    [credentials7662 (:credentials m7661) args7663 (:args m7661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7664
      (com.palletops.awaze.common/aws-client :ec2 credentials7662)]
     (clojure.core/case
      (clojure.core/count args7663)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7664
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7664
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args7663 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials7666 & args7667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7668
     (com.palletops.awaze.common/aws-client :ec2 credentials7666)]
    (clojure.core/case
     (clojure.core/count args7667)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7668
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7668
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args7667 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m7669]
   (clojure.core/let
    [credentials7670 (:credentials m7669) args7671 (:args m7669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7672
      (com.palletops.awaze.common/aws-client :ec2 credentials7670)]
     (clojure.core/case
      (clojure.core/count args7671)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7672
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args7671 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7672
        describeAddresses))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials7674 & args7675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7676
     (com.palletops.awaze.common/aws-client :ec2 credentials7674)]
    (clojure.core/case
     (clojure.core/count args7675)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7676
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args7675 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7676
       describeAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m7677]
   (clojure.core/let
    [credentials7678 (:credentials m7677) args7679 (:args m7677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7680
      (com.palletops.awaze.common/aws-client :ec2 credentials7678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7680
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args7679 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-instance-export-task,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials7682 & args7683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7684
     (com.palletops.awaze.common/aws-client :ec2 credentials7682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7684
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args7683 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m7685]
   (clojure.core/let
    [credentials7686 (:credentials m7685) args7687 (:args m7685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7688
      (com.palletops.awaze.common/aws-client :ec2 credentials7686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7688
       createImage
       (ec2/create-image-request (clojure.core/nth args7687 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-image,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Call createImage"}
   [credentials7690 & args7691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7692
     (com.palletops.awaze.common/aws-client :ec2 credentials7690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7692
      createImage
      (ec2/create-image-request (clojure.core/nth args7691 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m7693]
   (clojure.core/let
    [credentials7694 (:credentials m7693) args7695 (:args m7693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7696
      (com.palletops.awaze.common/aws-client :ec2 credentials7694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7696
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args7695 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Call createSecurityGroup"}
   [credentials7698 & args7699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7700
     (com.palletops.awaze.common/aws-client :ec2 credentials7698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7700
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args7699 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m7701]
   (clojure.core/let
    [credentials7702 (:credentials m7701) args7703 (:args m7701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7704
      (com.palletops.awaze.common/aws-client :ec2 credentials7702)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7704
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args7703 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-subnet,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Call createSubnet"}
   [credentials7706 & args7707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7708
     (com.palletops.awaze.common/aws-client :ec2 credentials7706)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7708
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args7707 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m7709]
   (clojure.core/let
    [credentials7710 (:credentials m7709) args7711 (:args m7709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7712
      (com.palletops.awaze.common/aws-client :ec2 credentials7710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7712
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args7711 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials7714 & args7715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7716
     (com.palletops.awaze.common/aws-client :ec2 credentials7714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7716
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args7715 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m7717]
   (clojure.core/let
    [credentials7718 (:credentials m7717) args7719 (:args m7717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7720
      (com.palletops.awaze.common/aws-client :ec2 credentials7718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7720
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args7719 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Call createNetworkInterface"}
   [credentials7722 & args7723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7724
     (com.palletops.awaze.common/aws-client :ec2 credentials7722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7724
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args7723 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m7725]
   (clojure.core/let
    [credentials7726 (:credentials m7725) args7727 (:args m7725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7728
      (com.palletops.awaze.common/aws-client :ec2 credentials7726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7728
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args7727 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials7730 & args7731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7732
     (com.palletops.awaze.common/aws-client :ec2 credentials7730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7732
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args7731 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m7733]
   (clojure.core/let
    [credentials7734 (:credentials m7733) args7735 (:args m7733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7736
      (com.palletops.awaze.common/aws-client :ec2 credentials7734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7736
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args7735 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Call attachVolume"}
   [credentials7738 & args7739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7740
     (com.palletops.awaze.common/aws-client :ec2 credentials7738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7740
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args7739 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m7741]
   (clojure.core/let
    [credentials7742 (:credentials m7741) args7743 (:args m7741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7744
      (com.palletops.awaze.common/aws-client :ec2 credentials7742)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7744
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args7743 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call createVpnConnection"}
   [credentials7746 & args7747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7748
     (com.palletops.awaze.common/aws-client :ec2 credentials7746)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7748
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args7747 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m7749]
   (clojure.core/let
    [credentials7750 (:credentials m7749) args7751 (:args m7749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7752
      (com.palletops.awaze.common/aws-client :ec2 credentials7750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7752
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args7751 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-placement-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials7754 & args7755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7756
     (com.palletops.awaze.common/aws-client :ec2 credentials7754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7756
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args7755 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m7757]
   (clojure.core/let
    [credentials7758 (:credentials m7757) args7759 (:args m7757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7760
      (com.palletops.awaze.common/aws-client :ec2 credentials7758)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7760
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args7759 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-instance-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials7762 & args7763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7764
     (com.palletops.awaze.common/aws-client :ec2 credentials7762)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7764
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args7763 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m7765]
   (clojure.core/let
    [credentials7766 (:credentials m7765) args7767 (:args m7765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7768
      (com.palletops.awaze.common/aws-client :ec2 credentials7766)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7768
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args7767 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Call createSnapshot"}
   [credentials7770 & args7771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7772
     (com.palletops.awaze.common/aws-client :ec2 credentials7770)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7772
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args7771 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m7773]
   (clojure.core/let
    [credentials7774 (:credentials m7773) args7775 (:args m7773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7776
      (com.palletops.awaze.common/aws-client :ec2 credentials7774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7776
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args7775 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :request-spot-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Call requestSpotInstances"}
   [credentials7778 & args7779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7780
     (com.palletops.awaze.common/aws-client :ec2 credentials7778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7780
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args7779 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m7781]
   (clojure.core/let
    [credentials7782 (:credentials m7781) args7783 (:args m7781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7784
      (com.palletops.awaze.common/aws-client :ec2 credentials7782)]
     (clojure.core/case
      (clojure.core/count args7783)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7784
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args7783 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7784
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials7786 & args7787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7788
     (com.palletops.awaze.common/aws-client :ec2 credentials7786)]
    (clojure.core/case
     (clojure.core/count args7787)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7788
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args7787 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7788
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m7789]
   (clojure.core/let
    [credentials7790 (:credentials m7789) args7791 (:args m7789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7792
      (com.palletops.awaze.common/aws-client :ec2 credentials7790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7792
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args7791 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials7794 & args7795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7796
     (com.palletops.awaze.common/aws-client :ec2 credentials7794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7796
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args7795 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m7797]
   (clojure.core/let
    [credentials7798 (:credentials m7797) args7799 (:args m7797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7800
      (com.palletops.awaze.common/aws-client :ec2 credentials7798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7800
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args7799 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials7802 & args7803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7804
     (com.palletops.awaze.common/aws-client :ec2 credentials7802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7804
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args7803 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m7805]
   (clojure.core/let
    [credentials7806 (:credentials m7805) args7807 (:args m7805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7808
      (com.palletops.awaze.common/aws-client :ec2 credentials7806)]
     (clojure.core/case
      (clojure.core/count args7807)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7808
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args7807 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7808
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]
                [credentials]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]
                [credentials]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials7810 & args7811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7812
     (com.palletops.awaze.common/aws-client :ec2 credentials7810)]
    (clojure.core/case
     (clojure.core/count args7811)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7812
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args7811 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7812
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m7813]
   (clojure.core/let
    [credentials7814 (:credentials m7813) args7815 (:args m7813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7816
      (com.palletops.awaze.common/aws-client :ec2 credentials7814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7816
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args7815 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-route-table,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Call associateRouteTable"}
   [credentials7818 & args7819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7820
     (com.palletops.awaze.common/aws-client :ec2 credentials7818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7820
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args7819 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m7821]
   (clojure.core/let
    [credentials7822 (:credentials m7821) args7823 (:args m7821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7824
      (com.palletops.awaze.common/aws-client :ec2 credentials7822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7824
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args7823 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials7826 & args7827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7828
     (com.palletops.awaze.common/aws-client :ec2 credentials7826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7828
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args7827 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m7829]
   (clojure.core/let
    [credentials7830 (:credentials m7829) args7831 (:args m7829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7832
      (com.palletops.awaze.common/aws-client :ec2 credentials7830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7832
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args7831 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-attribute,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials7834 & args7835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7836
     (com.palletops.awaze.common/aws-client :ec2 credentials7834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7836
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args7835 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m7837]
   (clojure.core/let
    [credentials7838 (:credentials m7837) args7839 (:args m7837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7840
      (com.palletops.awaze.common/aws-client :ec2 credentials7838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7840
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args7839 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Call createVpnGateway"}
   [credentials7842 & args7843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7844
     (com.palletops.awaze.common/aws-client :ec2 credentials7842)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7844
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args7843 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m7845]
   (clojure.core/let
    [credentials7846 (:credentials m7845) args7847 (:args m7845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7848
      (com.palletops.awaze.common/aws-client :ec2 credentials7846)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7848
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args7847 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createNetworkAcl"}
   [credentials7850 & args7851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7852
     (com.palletops.awaze.common/aws-client :ec2 credentials7850)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7852
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args7851 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m7853]
   (clojure.core/let
    [credentials7854 (:credentials m7853) args7855 (:args m7853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7856
      (com.palletops.awaze.common/aws-client :ec2 credentials7854)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7856
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args7855 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call replaceRoute"}
   [credentials7858 & args7859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7860
     (com.palletops.awaze.common/aws-client :ec2 credentials7858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7860
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args7859 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m7861]
   (clojure.core/let
    [credentials7862 (:credentials m7861) args7863 (:args m7861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7864
      (com.palletops.awaze.common/aws-client :ec2 credentials7862)]
     (clojure.core/case
      (clojure.core/count args7863)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7864
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7864
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args7863 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials7866 & args7867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7868
     (com.palletops.awaze.common/aws-client :ec2 credentials7866)]
    (clojure.core/case
     (clojure.core/count args7867)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7868
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7868
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args7867 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m7869]
   (clojure.core/let
    [credentials7870 (:credentials m7869) args7871 (:args m7869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7872
      (com.palletops.awaze.common/aws-client :ec2 credentials7870)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7872
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args7871 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-internet-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials7874 & args7875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7876
     (com.palletops.awaze.common/aws-client :ec2 credentials7874)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7876
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args7875 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m7877]
   (clojure.core/let
    [credentials7878 (:credentials m7877) args7879 (:args m7877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7880
      (com.palletops.awaze.common/aws-client :ec2 credentials7878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7880
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args7879 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteRoute"}
   [credentials7882 & args7883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7884
     (com.palletops.awaze.common/aws-client :ec2 credentials7882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7884
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args7883 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m7885]
   (clojure.core/let
    [credentials7886 (:credentials m7885) args7887 (:args m7885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7888
      (com.palletops.awaze.common/aws-client :ec2 credentials7886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7888
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args7887 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :assign-private-ip-addresses,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials7890 & args7891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7892
     (com.palletops.awaze.common/aws-client :ec2 credentials7890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7892
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args7891 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m7893]
   (clojure.core/let
    [credentials7894 (:credentials m7893) args7895 (:args m7893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7896
      (com.palletops.awaze.common/aws-client :ec2 credentials7894)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7896
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args7895 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-dhcp-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials7898 & args7899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7900
     (com.palletops.awaze.common/aws-client :ec2 credentials7898)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7900
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args7899 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m7901]
   (clojure.core/let
    [credentials7902 (:credentials m7901) args7903 (:args m7901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7904
      (com.palletops.awaze.common/aws-client :ec2 credentials7902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7904
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args7903 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials7906 & args7907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7908
     (com.palletops.awaze.common/aws-client :ec2 credentials7906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7908
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args7907 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m7909]
   (clojure.core/let
    [credentials7910 (:credentials m7909) args7911 (:args m7909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7912
      (com.palletops.awaze.common/aws-client :ec2 credentials7910)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7912
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args7911 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-dhcp-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Call createDhcpOptions"}
   [credentials7914 & args7915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7916
     (com.palletops.awaze.common/aws-client :ec2 credentials7914)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7916
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args7915 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m7917]
   (clojure.core/let
    [credentials7918 (:credentials m7917) args7919 (:args m7917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7920
      (com.palletops.awaze.common/aws-client :ec2 credentials7918)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7920
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args7919 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :stop-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Call stopInstances"}
   [credentials7922 & args7923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7924
     (com.palletops.awaze.common/aws-client :ec2 credentials7922)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7924
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args7923 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m7925]
   (clojure.core/let
    [credentials7926 (:credentials m7925) args7927 (:args m7925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7928
      (com.palletops.awaze.common/aws-client :ec2 credentials7926)]
     (clojure.core/case
      (clojure.core/count args7927)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7928
        authorizeSecurityGroupIngress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7928
        authorizeSecurityGroupIngress
        (ec2/authorize-security-group-ingress-request
         (clojure.core/nth args7927 0))))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Call authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   [credentials7930 & args7931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7932
     (com.palletops.awaze.common/aws-client :ec2 credentials7930)]
    (clojure.core/case
     (clojure.core/count args7931)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7932
       authorizeSecurityGroupIngress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7932
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args7931 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m7933]
   (clojure.core/let
    [credentials7934 (:credentials m7933) args7935 (:args m7933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7936
      (com.palletops.awaze.common/aws-client :ec2 credentials7934)]
     (clojure.core/case
      (clojure.core/count args7935)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7936
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args7935 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7936
        describePlacementGroups))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials7938 & args7939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7940
     (com.palletops.awaze.common/aws-client :ec2 credentials7938)]
    (clojure.core/case
     (clojure.core/count args7939)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7940
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args7939 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7940
       describePlacementGroups)))))))
