(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m9366]
  (clojure.core/let
   [bean9365
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/when-let
    [v9367 (:name m9366)]
    (. bean9365 setName (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:version m9366)]
    (. bean9365 setVersion (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:type m9366)]
    (. bean9365 setType (clojure.core/str v9367)))
   bean9365))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m9369]
  (clojure.core/let
   [bean9368
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/when-let
    [v9370 (:namespace m9369)]
    (. bean9368 setNamespace (clojure.core/str v9370)))
   (clojure.core/when-let
    [v9370 (:value m9369)]
    (. bean9368 setValue (clojure.core/str v9370)))
   (clojure.core/when-let
    [v9370 (:option-name m9369)]
    (. bean9368 setOptionName (clojure.core/str v9370)))
   bean9368))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m9372]
  (clojure.core/let
   [bean9371
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/when-let
    [v9373 (:namespace m9372)]
    (. bean9371 setNamespace (clojure.core/str v9373)))
   (clojure.core/when-let
    [v9373 (:option-name m9372)]
    (. bean9371 setOptionName (clojure.core/str v9373)))
   bean9371))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m9375]
  (clojure.core/let
   [bean9374 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/when-let
    [v9376 (:key m9375)]
    (. bean9374 setKey (clojure.core/str v9376)))
   (clojure.core/when-let
    [v9376 (:value m9375)]
    (. bean9374 setValue (clojure.core/str v9376)))
   bean9374))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m9378]
  (clojure.core/let
   [bean9377
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/when-let
    [v9379 (:s3bucket m9378)]
    (. bean9377 setS3Bucket (clojure.core/str v9379)))
   (clojure.core/when-let
    [v9379 (:s3key m9378)]
    (. bean9377 setS3Key (clojure.core/str v9379)))
   bean9377))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m9381]
  (clojure.core/let
   [bean9380
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/when-let
    [v9382 (:application-name m9381)]
    (. bean9380 setApplicationName (clojure.core/str v9382)))
   (clojure.core/when-let
    [v9382 (:template-name m9381)]
    (. bean9380 setTemplateName (clojure.core/str v9382)))
   bean9380))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m9384]
  (clojure.core/let
   [bean9383
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/when-let
    [v9385 (:application-name m9384)]
    (. bean9383 setApplicationName (clojure.core/str v9385)))
   (clojure.core/when-let
    [v9385 (:description m9384)]
    (. bean9383 setDescription (clojure.core/str v9385)))
   bean9383))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m9387]
  (clojure.core/let
   [bean9386
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/when-let
    [v9388 (:application-name m9387)]
    (. bean9386 setApplicationName (clojure.core/str v9388)))
   (clojure.core/when-let
    [v9388 (:terminate-env-by-force m9387)]
    (. bean9386 setTerminateEnvByForce (clojure.core/boolean v9388)))
   bean9386))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m9390]
  (clojure.core/let
   [bean9389
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/when-let
    [v9391 (:tier m9390)]
    (. bean9389 setTier (elasticbeanstalk/environment-tier v9391)))
   (clojure.core/when-let
    [v9391 (:template-name m9390)]
    (. bean9389 setTemplateName (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:solution-stack-name m9390)]
    (. bean9389 setSolutionStackName (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:application-name m9390)]
    (. bean9389 setApplicationName (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:option-settings m9390)]
    (.
     bean9389
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9470]
  (elasticbeanstalk/configuration-option-setting arg9470))
 v9391)))
   (clojure.core/when-let
    [v9391 (:description m9390)]
    (. bean9389 setDescription (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:options-to-remove m9390)]
    (.
     bean9389
     setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9471]
  (elasticbeanstalk/option-specification arg9471))
 v9391)))
   (clojure.core/when-let
    [v9391 (:tags m9390)]
    (.
     bean9389
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9472] (elasticbeanstalk/tag arg9472))
 v9391)))
   (clojure.core/when-let
    [v9391 (:environment-name m9390)]
    (. bean9389 setEnvironmentName (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:version-label m9390)]
    (. bean9389 setVersionLabel (clojure.core/str v9391)))
   (clojure.core/when-let
    [v9391 (:cnameprefix m9390)]
    (. bean9389 setCNAMEPrefix (clojure.core/str v9391)))
   bean9389))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m9393]
  (clojure.core/let
   [bean9392
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v9394 (:application-name m9393)]
    (. bean9392 setApplicationName (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:environment-name m9393)]
    (. bean9392 setEnvironmentName (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:template-name m9393)]
    (. bean9392 setTemplateName (clojure.core/str v9394)))
   bean9392))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m9396]
  (clojure.core/let
   [bean9395
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean9395))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m9399]
  (clojure.core/let
   [bean9398
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/when-let
    [v9400 (:options m9399)]
    (.
     bean9398
     setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9473]
  (elasticbeanstalk/option-specification arg9473))
 v9400)))
   (clojure.core/when-let
    [v9400 (:application-name m9399)]
    (. bean9398 setApplicationName (clojure.core/str v9400)))
   (clojure.core/when-let
    [v9400 (:environment-name m9399)]
    (. bean9398 setEnvironmentName (clojure.core/str v9400)))
   (clojure.core/when-let
    [v9400 (:template-name m9399)]
    (. bean9398 setTemplateName (clojure.core/str v9400)))
   (clojure.core/when-let
    [v9400 (:solution-stack-name m9399)]
    (. bean9398 setSolutionStackName (clojure.core/str v9400)))
   bean9398))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m9402]
  (clojure.core/let
   [bean9401
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/when-let
    [v9403 (:environment-id m9402)]
    (. bean9401 setEnvironmentId (clojure.core/str v9403)))
   (clojure.core/when-let
    [v9403 (:environment-name m9402)]
    (. bean9401 setEnvironmentName (clojure.core/str v9403)))
   bean9401))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m9405]
  (clojure.core/let
   [bean9404
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/when-let
    [v9406 (:application-name m9405)]
    (. bean9404 setApplicationName (clojure.core/str v9406)))
   (clojure.core/when-let
    [v9406 (:version-label m9405)]
    (. bean9404 setVersionLabel (clojure.core/str v9406)))
   (clojure.core/when-let
    [v9406 (:source-bundle m9405)]
    (. bean9404 setSourceBundle (elasticbeanstalk/s3location v9406)))
   (clojure.core/when-let
    [v9406 (:auto-create-application m9405)]
    (. bean9404 setAutoCreateApplication (clojure.core/boolean v9406)))
   (clojure.core/when-let
    [v9406 (:description m9405)]
    (. bean9404 setDescription (clojure.core/str v9406)))
   bean9404))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m9408]
  (clojure.core/let
   [bean9407
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/when-let
    [v9409 (:environment-id m9408)]
    (. bean9407 setEnvironmentId (clojure.core/str v9409)))
   (clojure.core/when-let
    [v9409 (:environment-name m9408)]
    (. bean9407 setEnvironmentName (clojure.core/str v9409)))
   (clojure.core/when-let
    [v9409 (:tier m9408)]
    (. bean9407 setTier (elasticbeanstalk/environment-tier v9409)))
   (clojure.core/when-let
    [v9409 (:version-label m9408)]
    (. bean9407 setVersionLabel (clojure.core/str v9409)))
   (clojure.core/when-let
    [v9409 (:template-name m9408)]
    (. bean9407 setTemplateName (clojure.core/str v9409)))
   (clojure.core/when-let
    [v9409 (:description m9408)]
    (. bean9407 setDescription (clojure.core/str v9409)))
   (clojure.core/when-let
    [v9409 (:options-to-remove m9408)]
    (.
     bean9407
     setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9474]
  (elasticbeanstalk/option-specification arg9474))
 v9409)))
   (clojure.core/when-let
    [v9409 (:option-settings m9408)]
    (.
     bean9407
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9475]
  (elasticbeanstalk/configuration-option-setting arg9475))
 v9409)))
   bean9407))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m9411]
  (clojure.core/let
   [bean9410
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v9412 (:environment-id m9411)]
    (. bean9410 setEnvironmentId (clojure.core/str v9412)))
   (clojure.core/when-let
    [v9412 (:application-name m9411)]
    (. bean9410 setApplicationName (clojure.core/str v9412)))
   (clojure.core/when-let
    [v9412 (:template-name m9411)]
    (. bean9410 setTemplateName (clojure.core/str v9412)))
   (clojure.core/when-let
    [v9412 (:solution-stack-name m9411)]
    (. bean9410 setSolutionStackName (clojure.core/str v9412)))
   (clojure.core/when-let
    [v9412 (:source-configuration m9411)]
    (.
     bean9410
     setSourceConfiguration
     (elasticbeanstalk/source-configuration v9412)))
   (clojure.core/when-let
    [v9412 (:description m9411)]
    (. bean9410 setDescription (clojure.core/str v9412)))
   (clojure.core/when-let
    [v9412 (:option-settings m9411)]
    (.
     bean9410
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9476]
  (elasticbeanstalk/configuration-option-setting arg9476))
 v9412)))
   bean9410))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m9414]
  (clojure.core/let
   [bean9413
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v9415 (:application-name m9414)]
    (. bean9413 setApplicationName (clojure.core/str v9415)))
   (clojure.core/when-let
    [v9415 (:environment-name m9414)]
    (. bean9413 setEnvironmentName (clojure.core/str v9415)))
   (clojure.core/when-let
    [v9415 (:template-name m9414)]
    (. bean9413 setTemplateName (clojure.core/str v9415)))
   (clojure.core/when-let
    [v9415 (:option-settings m9414)]
    (.
     bean9413
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9477]
  (elasticbeanstalk/configuration-option-setting arg9477))
 v9415)))
   bean9413))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m9417]
  (clojure.core/let
   [bean9416
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v9418 (:max-records m9417)]
    (. bean9416 setMaxRecords (clojure.core/int v9418)))
   (clojure.core/when-let
    [v9418 (:next-token m9417)]
    (. bean9416 setNextToken (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:end-time m9417)]
    (. bean9416 setEndTime (com.palletops.awaze.common/to-date v9418)))
   (clojure.core/when-let
    [v9418 (:template-name m9417)]
    (. bean9416 setTemplateName (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:request-id m9417)]
    (. bean9416 setRequestId (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:environment-id m9417)]
    (. bean9416 setEnvironmentId (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:start-time m9417)]
    (.
     bean9416
     setStartTime
     (com.palletops.awaze.common/to-date v9418)))
   (clojure.core/when-let
    [v9418 (:application-name m9417)]
    (. bean9416 setApplicationName (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:environment-name m9417)]
    (. bean9416 setEnvironmentName (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:version-label m9417)]
    (. bean9416 setVersionLabel (clojure.core/str v9418)))
   (clojure.core/when-let
    [v9418 (:severity m9417)]
    (. bean9416 setSeverity (clojure.core/str v9418)))
   bean9416))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m9420]
  (clojure.core/let
   [bean9419
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/when-let
    [v9421 (:application-names m9420)]
    (.
     bean9419
     setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9478] (clojure.core/str arg9478))
 v9421)))
   bean9419))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m9423]
  (clojure.core/let
   [bean9422
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/when-let
    [v9424 (:cnameprefix m9423)]
    (. bean9422 setCNAMEPrefix (clojure.core/str v9424)))
   bean9422))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m9426]
  (clojure.core/let
   [bean9425
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/when-let
    [v9427 (:environment-id m9426)]
    (. bean9425 setEnvironmentId (clojure.core/str v9427)))
   (clojure.core/when-let
    [v9427 (:environment-name m9426)]
    (. bean9425 setEnvironmentName (clojure.core/str v9427)))
   bean9425))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m9429]
  (clojure.core/let
   [bean9428
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/when-let
    [v9430 (:application-name m9429)]
    (. bean9428 setApplicationName (clojure.core/str v9430)))
   (clojure.core/when-let
    [v9430 (:version-label m9429)]
    (. bean9428 setVersionLabel (clojure.core/str v9430)))
   (clojure.core/when-let
    [v9430 (:description m9429)]
    (. bean9428 setDescription (clojure.core/str v9430)))
   bean9428))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m9432]
  (clojure.core/let
   [bean9431
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/when-let
    [v9433 (:environment-id m9432)]
    (. bean9431 setEnvironmentId (clojure.core/str v9433)))
   (clojure.core/when-let
    [v9433 (:environment-name m9432)]
    (. bean9431 setEnvironmentName (clojure.core/str v9433)))
   bean9431))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m9435]
  (clojure.core/let
   [bean9434
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/when-let
    [v9436 (:application-name m9435)]
    (. bean9434 setApplicationName (clojure.core/str v9436)))
   (clojure.core/when-let
    [v9436 (:version-label m9435)]
    (. bean9434 setVersionLabel (clojure.core/str v9436)))
   (clojure.core/when-let
    [v9436 (:environment-ids m9435)]
    (.
     bean9434
     setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9479] (clojure.core/str arg9479))
 v9436)))
   (clojure.core/when-let
    [v9436 (:environment-names m9435)]
    (.
     bean9434
     setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9480] (clojure.core/str arg9480))
 v9436)))
   (clojure.core/when-let
    [v9436 (:include-deleted m9435)]
    (. bean9434 setIncludeDeleted (clojure.core/boolean v9436)))
   (clojure.core/when-let
    [v9436 (:included-deleted-back-to m9435)]
    (.
     bean9434
     setIncludedDeletedBackTo
     (com.palletops.awaze.common/to-date v9436)))
   bean9434))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m9438]
  (clojure.core/let
   [bean9437
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/when-let
    [v9439 (:application-name m9438)]
    (. bean9437 setApplicationName (clojure.core/str v9439)))
   (clojure.core/when-let
    [v9439 (:version-labels m9438)]
    (.
     bean9437
     setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9481] (clojure.core/str arg9481))
 v9439)))
   bean9437))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m9441]
  (clojure.core/let
   [bean9440
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/when-let
    [v9442 (:application-name m9441)]
    (. bean9440 setApplicationName (clojure.core/str v9442)))
   (clojure.core/when-let
    [v9442 (:version-label m9441)]
    (. bean9440 setVersionLabel (clojure.core/str v9442)))
   (clojure.core/when-let
    [v9442 (:delete-source-bundle m9441)]
    (. bean9440 setDeleteSourceBundle (clojure.core/boolean v9442)))
   bean9440))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m9444]
  (clojure.core/let
   [bean9443
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/when-let
    [v9445 (:source-environment-id m9444)]
    (. bean9443 setSourceEnvironmentId (clojure.core/str v9445)))
   (clojure.core/when-let
    [v9445 (:source-environment-name m9444)]
    (. bean9443 setSourceEnvironmentName (clojure.core/str v9445)))
   (clojure.core/when-let
    [v9445 (:destination-environment-id m9444)]
    (. bean9443 setDestinationEnvironmentId (clojure.core/str v9445)))
   (clojure.core/when-let
    [v9445 (:destination-environment-name m9444)]
    (.
     bean9443
     setDestinationEnvironmentName
     (clojure.core/str v9445)))
   bean9443))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m9447]
  (clojure.core/let
   [bean9446
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v9448 (:application-name m9447)]
    (. bean9446 setApplicationName (clojure.core/str v9448)))
   (clojure.core/when-let
    [v9448 (:template-name m9447)]
    (. bean9446 setTemplateName (clojure.core/str v9448)))
   bean9446))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m9450]
  (clojure.core/let
   [bean9449
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/when-let
    [v9451 (:application-name m9450)]
    (. bean9449 setApplicationName (clojure.core/str v9451)))
   (clojure.core/when-let
    [v9451 (:description m9450)]
    (. bean9449 setDescription (clojure.core/str v9451)))
   bean9449))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m9453]
  (clojure.core/let
   [bean9452
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean9452))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m9456]
  (clojure.core/let
   [bean9455
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v9457 (:application-name m9456)]
    (. bean9455 setApplicationName (clojure.core/str v9457)))
   (clojure.core/when-let
    [v9457 (:template-name m9456)]
    (. bean9455 setTemplateName (clojure.core/str v9457)))
   (clojure.core/when-let
    [v9457 (:description m9456)]
    (. bean9455 setDescription (clojure.core/str v9457)))
   (clojure.core/when-let
    [v9457 (:options-to-remove m9456)]
    (.
     bean9455
     setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9482]
  (elasticbeanstalk/option-specification arg9482))
 v9457)))
   (clojure.core/when-let
    [v9457 (:option-settings m9456)]
    (.
     bean9455
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9483]
  (elasticbeanstalk/configuration-option-setting arg9483))
 v9457)))
   bean9455))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m9459]
  (clojure.core/let
   [bean9458
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v9460 (:environment-id m9459)]
    (. bean9458 setEnvironmentId (clojure.core/str v9460)))
   (clojure.core/when-let
    [v9460 (:environment-name m9459)]
    (. bean9458 setEnvironmentName (clojure.core/str v9460)))
   (clojure.core/when-let
    [v9460 (:info-type m9459)]
    (. bean9458 setInfoType (clojure.core/str v9460)))
   bean9458))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m9462]
  (clojure.core/let
   [bean9461
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/when-let
    [v9463 (:application-name m9462)]
    (. bean9461 setApplicationName (clojure.core/str v9463)))
   (clojure.core/when-let
    [v9463 (:environment-name m9462)]
    (. bean9461 setEnvironmentName (clojure.core/str v9463)))
   bean9461))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m9465]
  (clojure.core/let
   [bean9464
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/when-let
    [v9466 (:environment-id m9465)]
    (. bean9464 setEnvironmentId (clojure.core/str v9466)))
   (clojure.core/when-let
    [v9466 (:environment-name m9465)]
    (. bean9464 setEnvironmentName (clojure.core/str v9466)))
   (clojure.core/when-let
    [v9466 (:terminate-resources m9465)]
    (. bean9464 setTerminateResources (clojure.core/boolean v9466)))
   bean9464))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m9468]
  (clojure.core/let
   [bean9467
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v9469 (:environment-id m9468)]
    (. bean9467 setEnvironmentId (clojure.core/str v9469)))
   (clojure.core/when-let
    [v9469 (:environment-name m9468)]
    (. bean9467 setEnvironmentName (clojure.core/str v9469)))
   (clojure.core/when-let
    [v9469 (:info-type m9468)]
    (. bean9467 setInfoType (clojure.core/str v9469)))
   bean9467))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m9484]
   (clojure.core/let
    [credentials9485 (:credentials m9484) args9486 (:args m9484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9487
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9485)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9487
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args9486 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call createApplication"}
   [credentials9489 & args9490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9491
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9489)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9491
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args9490 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m9492]
   (clojure.core/let
    [credentials9493 (:credentials m9492) args9494 (:args m9492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9495
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9495
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args9494 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [terminate-env-by-force
                         general-progress-listener
                         application-name]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [terminate-env-by-force
                         general-progress-listener
                         application-name]}]]),
    :doc "Call deleteApplication"}
   [credentials9497 & args9498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9499
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9499
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args9498 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m9500]
   (clojure.core/let
    [credentials9501 (:credentials m9500) args9502 (:args m9500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9503
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9503
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args9502 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         option-settings
                         tier
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name
                         tags]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-environment,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         option-settings
                         tier
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name
                         tags]}]]),
    :doc "Call createEnvironment"}
   [credentials9505 & args9506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9507
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9507
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args9506 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m9508]
   (clojure.core/let
    [credentials9509 (:credentials m9508) args9510 (:args m9508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9511
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9511
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args9510 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-settings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials9513 & args9514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9515
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9515
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args9514 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m9516]
   (clojure.core/let
    [credentials9517 (:credentials m9516) args9518 (:args m9516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9519
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9517)]
     (clojure.core/case
      (clojure.core/count args9518)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9519
        createStorageLocation))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9519
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args9518 0))))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials9521 & args9522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9523
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9521)]
    (clojure.core/case
     (clojure.core/count args9522)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9523
       createStorageLocation))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9523
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args9522 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m9524]
   (clojure.core/let
    [credentials9525 (:credentials m9524) args9526 (:args m9524)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9527
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9525)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9527
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args9526 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [options
                         solution-stack-name
                         environment-name
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [options
                         solution-stack-name
                         environment-name
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials9529 & args9530]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9531
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9529)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9531
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args9530 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m9532]
   (clojure.core/let
    [credentials9533 (:credentials m9532) args9534 (:args m9532)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9535
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9533)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9535
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args9534 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :rebuild-environment,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials9537 & args9538]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9539
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9537)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9539
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args9538 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m9540]
   (clojure.core/let
    [credentials9541 (:credentials m9540) args9542 (:args m9540)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9543
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9541)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9543
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args9542 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [source-bundle
                         description
                         version-label
                         general-progress-listener
                         auto-create-application
                         application-name]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application-version,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [source-bundle
                         description
                         version-label
                         general-progress-listener
                         auto-create-application
                         application-name]}]]),
    :doc "Call createApplicationVersion"}
   [credentials9545 & args9546]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9547
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9545)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9547
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args9546 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m9548]
   (clojure.core/let
    [credentials9549 (:credentials m9548) args9550 (:args m9548)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9551
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9549)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9551
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args9550 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         tier
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-environment,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         tier
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Call updateEnvironment"}
   [credentials9553 & args9554]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9555
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9553)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9555
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args9554 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m9556]
   (clojure.core/let
    [credentials9557 (:credentials m9556) args9558 (:args m9556)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9559
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9557)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9559
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args9558 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-configuration-template,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials9561 & args9562]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9563
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9561)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9563
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args9562 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m9564]
   (clojure.core/let
    [credentials9565 (:credentials m9564) args9566 (:args m9564)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9567
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9565)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9567
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args9566 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         option-settings
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :validate-configuration-settings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         option-settings
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials9569 & args9570]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9571
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9569)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9571
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args9570 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m9572]
   (clojure.core/let
    [credentials9573 (:credentials m9572) args9574 (:args m9572)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9575
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9573)]
     (clojure.core/case
      (clojure.core/count args9574)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9575
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9575
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args9574 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         environment-id
                         general-progress-listener
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         environment-id
                         general-progress-listener
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9577 & args9578]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9579
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9577)]
    (clojure.core/case
     (clojure.core/count args9578)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9579
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9579
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args9578 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m9580]
   (clojure.core/let
    [credentials9581 (:credentials m9580) args9582 (:args m9580)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9583
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9581)]
     (clojure.core/case
      (clojure.core/count args9582)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9583
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args9582 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9583
        describeApplications))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener application-names]}]
                [credentials]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener application-names]}]
                [credentials]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials9585 & args9586]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9587
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9585)]
    (clojure.core/case
     (clojure.core/count args9586)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9587
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args9586 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9587
       describeApplications))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m9588]
   (clojure.core/let
    [credentials9589 (:credentials m9588) args9590 (:args m9588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9591
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9589)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9591
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args9590 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cnameprefix]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :check-dnsavailability,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cnameprefix]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials9593 & args9594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9595
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9593)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9595
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args9594 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m9596]
   (clojure.core/let
    [credentials9597 (:credentials m9596) args9598 (:args m9596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9599
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9597)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9599
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args9598 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :restart-app-server,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call restartAppServer"}
   [credentials9601 & args9602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9603
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9601)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9603
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args9602 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m9604]
   (clojure.core/let
    [credentials9605 (:credentials m9604) args9606 (:args m9604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9607
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9605)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9607
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args9606 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application-version,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials9609 & args9610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9611
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9609)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9611
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args9610 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m9612]
   (clojure.core/let
    [credentials9613 (:credentials m9612) args9614 (:args m9612)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9615
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9613)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9615
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args9614 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environment-resources,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials9617 & args9618]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9619
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9617)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9619
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args9618 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m9620]
   (clojure.core/let
    [credentials9621 (:credentials m9620) args9622 (:args m9620)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9623
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9621)]
     (clojure.core/case
      (clojure.core/count args9622)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9623
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args9622 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9623
        describeEnvironments))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         included-deleted-back-to
                         environment-names
                         version-label
                         application-name
                         include-deleted
                         environment-ids]}]
                [credentials]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         included-deleted-back-to
                         environment-names
                         version-label
                         application-name
                         include-deleted
                         environment-ids]}]
                [credentials]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials9625 & args9626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9627
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9625)]
    (clojure.core/case
     (clojure.core/count args9626)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9627
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args9626 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9627
       describeEnvironments))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m9628]
   (clojure.core/let
    [credentials9629 (:credentials m9628) args9630 (:args m9628)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9631
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9629)]
     (clojure.core/case
      (clojure.core/count args9630)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9631
        describeApplicationVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9631
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args9630 0))))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-labels
                         general-progress-listener
                         application-name]}]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-labels
                         general-progress-listener
                         application-name]}]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials9633 & args9634]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9635
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9633)]
    (clojure.core/case
     (clojure.core/count args9634)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9635
       describeApplicationVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9635
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args9634 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m9636]
   (clojure.core/let
    [credentials9637 (:credentials m9636) args9638 (:args m9636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9639
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9637)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9639
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args9638 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         delete-source-bundle
                         application-name]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application-version,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         delete-source-bundle
                         application-name]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials9641 & args9642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9643
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9641)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9643
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args9642 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m9644]
   (clojure.core/let
    [credentials9645 (:credentials m9644) args9646 (:args m9644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9647
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9645)]
     (clojure.core/case
      (clojure.core/count args9646)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9647
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args9646 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9647
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-name
                         source-environment-id
                         general-progress-listener
                         destination-environment-name
                         destination-environment-id]}]
                [credentials]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-name
                         source-environment-id
                         general-progress-listener
                         destination-environment-name
                         destination-environment-id]}]
                [credentials]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials9649 & args9650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9651
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9649)]
    (clojure.core/case
     (clojure.core/count args9650)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9651
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args9650 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9651
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m9652]
   (clojure.core/let
    [credentials9653 (:credentials m9652) args9654 (:args m9652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9655
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9653)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9655
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args9654 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         application-name]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-configuration-template,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         application-name]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials9657 & args9658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9659
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9657)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9659
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args9658 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m9660]
   (clojure.core/let
    [credentials9661 (:credentials m9660) args9662 (:args m9660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9663
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9661)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9663
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args9662 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call updateApplication"}
   [credentials9665 & args9666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9667
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9665)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9667
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args9666 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m9668]
   (clojure.core/let
    [credentials9669 (:credentials m9668) args9670 (:args m9668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9671
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9669)]
     (clojure.core/case
      (clojure.core/count args9670)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9671
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args9670 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9671
        listAvailableSolutionStacks))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials9673 & args9674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9675
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9673)]
    (clojure.core/case
     (clojure.core/count args9674)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9675
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args9674 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9675
       listAvailableSolutionStacks))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m9676]
   (clojure.core/let
    [credentials9677 (:credentials m9676) args9678 (:args m9676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9679
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9677)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9679
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args9678 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         option-settings
                         options-to-remove
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-configuration-template,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         option-settings
                         options-to-remove
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials9681 & args9682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9683
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9681)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9683
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args9682 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m9684]
   (clojure.core/let
    [credentials9685 (:credentials m9684) args9686 (:args m9684)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9687
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9685)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9687
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args9686 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :request-environment-info,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials9689 & args9690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9691
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9689)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9691
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args9690 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m9692]
   (clojure.core/let
    [credentials9693 (:credentials m9692) args9694 (:args m9692)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9695
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9693)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9695
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args9694 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-environment-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials9697 & args9698]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9699
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9697)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9699
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args9698 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m9700]
   (clojure.core/let
    [credentials9701 (:credentials m9700) args9702 (:args m9700)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9703
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9701)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9703
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args9702 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :terminate-environment,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call terminateEnvironment"}
   [credentials9705 & args9706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9707
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9705)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9707
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args9706 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m9708]
   (clojure.core/let
    [credentials9709 (:credentials m9708) args9710 (:args m9708)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9711
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9709)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9711
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args9710 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :retrieve-environment-info,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials9713 & args9714]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9715
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9713)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9715
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args9714 0))))))))
