(ns
 com.palletops.awaze.rds
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.rds :as rds]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :rds
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.rds.AmazonRDSClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionSetting}
option-setting
  [m4828]
  (clojure.core/let
   [bean4827 (new com.amazonaws.services.rds.model.OptionSetting)]
   (clojure.core/when-let
    [v4829 (:data-type m4828)]
    (. bean4827 setDataType (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:apply-type m4828)]
    (. bean4827 setApplyType (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:allowed-values m4828)]
    (. bean4827 setAllowedValues (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:is-collection m4828)]
    (. bean4827 setIsCollection (clojure.core/boolean v4829)))
   (clojure.core/when-let
    [v4829 (:name m4828)]
    (. bean4827 setName (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:value m4828)]
    (. bean4827 setValue (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:is-modifiable m4828)]
    (. bean4827 setIsModifiable (clojure.core/boolean v4829)))
   (clojure.core/when-let
    [v4829 (:default-value m4828)]
    (. bean4827 setDefaultValue (clojure.core/str v4829)))
   (clojure.core/when-let
    [v4829 (:description m4828)]
    (. bean4827 setDescription (clojure.core/str v4829)))
   bean4827))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Tag}
tag
  [m4831]
  (clojure.core/let
   [bean4830 (new com.amazonaws.services.rds.model.Tag)]
   (clojure.core/when-let
    [v4832 (:key m4831)]
    (. bean4830 setKey (clojure.core/str v4832)))
   (clojure.core/when-let
    [v4832 (:value m4831)]
    (. bean4830 setValue (clojure.core/str v4832)))
   bean4830))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Filter}
filter
  [m4834]
  (clojure.core/let
   [bean4833 (new com.amazonaws.services.rds.model.Filter)]
   (clojure.core/when-let
    [v4835 (:filter-name m4834)]
    (. bean4833 setFilterName (clojure.core/str v4835)))
   (clojure.core/when-let
    [v4835 (:filter-value m4834)]
    (.
     bean4833
     setFilterValue
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4998] (clojure.core/str arg4998))
 v4835)))
   bean4833))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionConfiguration}
option-configuration
  [m4837]
  (clojure.core/let
   [bean4836
    (new com.amazonaws.services.rds.model.OptionConfiguration)]
   (clojure.core/when-let
    [v4838 (:port m4837)]
    (. bean4836 setPort (clojure.core/int v4838)))
   (clojure.core/when-let
    [v4838 (:option-name m4837)]
    (. bean4836 setOptionName (clojure.core/str v4838)))
   (clojure.core/when-let
    [v4838 (:dbsecurity-group-memberships m4837)]
    (.
     bean4836
     setDBSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4999] (clojure.core/str arg4999))
 v4838)))
   (clojure.core/when-let
    [v4838 (:vpc-security-group-memberships m4837)]
    (.
     bean4836
     setVpcSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5000] (clojure.core/str arg5000))
 v4838)))
   (clojure.core/when-let
    [v4838 (:option-settings m4837)]
    (.
     bean4836
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5001] (rds/option-setting arg5001))
 v4838)))
   bean4836))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Parameter}
parameter
  [m4840]
  (clojure.core/let
   [bean4839 (new com.amazonaws.services.rds.model.Parameter)]
   (clojure.core/when-let
    [v4841 (:data-type m4840)]
    (. bean4839 setDataType (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:apply-type m4840)]
    (. bean4839 setApplyType (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:allowed-values m4840)]
    (. bean4839 setAllowedValues (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:parameter-value m4840)]
    (. bean4839 setParameterValue (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:minimum-engine-version m4840)]
    (. bean4839 setMinimumEngineVersion (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:apply-method m4840)]
    (. bean4839 setApplyMethod (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:is-modifiable m4840)]
    (. bean4839 setIsModifiable (clojure.core/boolean v4841)))
   (clojure.core/when-let
    [v4841 (:parameter-name m4840)]
    (. bean4839 setParameterName (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:description m4840)]
    (. bean4839 setDescription (clojure.core/str v4841)))
   (clojure.core/when-let
    [v4841 (:source m4840)]
    (. bean4839 setSource (clojure.core/str v4841)))
   bean4839))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest}
revoke-dbsecurity-group-ingress-request
  [m4843]
  (clojure.core/let
   [bean4842
    (new
     com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4844 (:cidrip m4843)]
    (. bean4842 setCIDRIP (clojure.core/str v4844)))
   (clojure.core/when-let
    [v4844 (:ec2security-group-name m4843)]
    (. bean4842 setEC2SecurityGroupName (clojure.core/str v4844)))
   (clojure.core/when-let
    [v4844 (:ec2security-group-owner-id m4843)]
    (. bean4842 setEC2SecurityGroupOwnerId (clojure.core/str v4844)))
   (clojure.core/when-let
    [v4844 (:dbsecurity-group-name m4843)]
    (. bean4842 setDBSecurityGroupName (clojure.core/str v4844)))
   (clojure.core/when-let
    [v4844 (:ec2security-group-id m4843)]
    (. bean4842 setEC2SecurityGroupId (clojure.core/str v4844)))
   bean4842))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m4846]
  (clojure.core/let
   [bean4845
    (new com.amazonaws.services.rds.model.AddTagsToResourceRequest)]
   (clojure.core/when-let
    [v4847 (:tags m4846)]
    (.
     bean4845
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5002] (rds/tag arg5002)) v4847)))
   (clojure.core/when-let
    [v4847 (:resource-name m4846)]
    (. bean4845 setResourceName (clojure.core/str v4847)))
   bean4845))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest}
describe-dbsecurity-groups-request
  [m4849]
  (clojure.core/let
   [bean4848
    (new
     com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest)]
   (clojure.core/when-let
    [v4850 (:max-records m4849)]
    (. bean4848 setMaxRecords (clojure.core/int v4850)))
   (clojure.core/when-let
    [v4850 (:filters m4849)]
    (.
     bean4848
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5003] (rds/filter arg5003))
 v4850)))
   (clojure.core/when-let
    [v4850 (:marker m4849)]
    (. bean4848 setMarker (clojure.core/str v4850)))
   (clojure.core/when-let
    [v4850 (:dbsecurity-group-name m4849)]
    (. bean4848 setDBSecurityGroupName (clojure.core/str v4850)))
   bean4848))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest}
purchase-reserved-dbinstances-offering-request
  [m4852]
  (clojure.core/let
   [bean4851
    (new
     com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest)]
   (clojure.core/when-let
    [v4853 (:tags m4852)]
    (.
     bean4851
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5004] (rds/tag arg5004)) v4853)))
   (clojure.core/when-let
    [v4853 (:dbinstance-count m4852)]
    (. bean4851 setDBInstanceCount (clojure.core/int v4853)))
   (clojure.core/when-let
    [v4853 (:reserved-dbinstances-offering-id m4852)]
    (.
     bean4851
     setReservedDBInstancesOfferingId
     (clojure.core/str v4853)))
   (clojure.core/when-let
    [v4853 (:reserved-dbinstance-id m4852)]
    (. bean4851 setReservedDBInstanceId (clojure.core/str v4853)))
   bean4851))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParametersRequest}
describe-dbparameters-request
  [m4855]
  (clojure.core/let
   [bean4854
    (new com.amazonaws.services.rds.model.DescribeDBParametersRequest)]
   (clojure.core/when-let
    [v4856 (:max-records m4855)]
    (. bean4854 setMaxRecords (clojure.core/int v4856)))
   (clojure.core/when-let
    [v4856 (:source m4855)]
    (. bean4854 setSource (clojure.core/str v4856)))
   (clojure.core/when-let
    [v4856 (:marker m4855)]
    (. bean4854 setMarker (clojure.core/str v4856)))
   (clojure.core/when-let
    [v4856 (:dbparameter-group-name m4855)]
    (. bean4854 setDBParameterGroupName (clojure.core/str v4856)))
   bean4854))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupsRequest}
describe-option-groups-request
  [m4858]
  (clojure.core/let
   [bean4857
    (new com.amazonaws.services.rds.model.DescribeOptionGroupsRequest)]
   (clojure.core/when-let
    [v4859 (:max-records m4858)]
    (. bean4857 setMaxRecords (clojure.core/int v4859)))
   (clojure.core/when-let
    [v4859 (:filters m4858)]
    (.
     bean4857
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5005] (rds/filter arg5005))
 v4859)))
   (clojure.core/when-let
    [v4859 (:marker m4858)]
    (. bean4857 setMarker (clojure.core/str v4859)))
   (clojure.core/when-let
    [v4859 (:option-group-name m4858)]
    (. bean4857 setOptionGroupName (clojure.core/str v4859)))
   (clojure.core/when-let
    [v4859 (:engine-name m4858)]
    (. bean4857 setEngineName (clojure.core/str v4859)))
   (clojure.core/when-let
    [v4859 (:major-engine-version m4858)]
    (. bean4857 setMajorEngineVersion (clojure.core/str v4859)))
   bean4857))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest}
create-dbinstance-read-replica-request
  [m4861]
  (clojure.core/let
   [bean4860
    (new
     com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest)]
   (clojure.core/when-let
    [v4862 (:port m4861)]
    (. bean4860 setPort (clojure.core/int v4862)))
   (clojure.core/when-let
    [v4862 (:dbinstance-class m4861)]
    (. bean4860 setDBInstanceClass (clojure.core/str v4862)))
   (clojure.core/when-let
    [v4862 (:auto-minor-version-upgrade m4861)]
    (.
     bean4860
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4862)))
   (clojure.core/when-let
    [v4862 (:availability-zone m4861)]
    (. bean4860 setAvailabilityZone (clojure.core/str v4862)))
   (clojure.core/when-let
    [v4862 (:iops m4861)]
    (. bean4860 setIops (clojure.core/int v4862)))
   (clojure.core/when-let
    [v4862 (:dbsubnet-group-name m4861)]
    (. bean4860 setDBSubnetGroupName (clojure.core/str v4862)))
   (clojure.core/when-let
    [v4862 (:publicly-accessible m4861)]
    (. bean4860 setPubliclyAccessible (clojure.core/boolean v4862)))
   (clojure.core/when-let
    [v4862 (:option-group-name m4861)]
    (. bean4860 setOptionGroupName (clojure.core/str v4862)))
   (clojure.core/when-let
    [v4862 (:source-dbinstance-identifier m4861)]
    (.
     bean4860
     setSourceDBInstanceIdentifier
     (clojure.core/str v4862)))
   (clojure.core/when-let
    [v4862 (:tags m4861)]
    (.
     bean4860
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5006] (rds/tag arg5006)) v4862)))
   (clojure.core/when-let
    [v4862 (:dbinstance-identifier m4861)]
    (. bean4860 setDBInstanceIdentifier (clojure.core/str v4862)))
   bean4860))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest}
restore-dbinstance-from-dbsnapshot-request
  [m4864]
  (clojure.core/let
   [bean4863
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest)]
   (clojure.core/when-let
    [v4865 (:port m4864)]
    (. bean4863 setPort (clojure.core/int v4865)))
   (clojure.core/when-let
    [v4865 (:dbinstance-class m4864)]
    (. bean4863 setDBInstanceClass (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:engine m4864)]
    (. bean4863 setEngine (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:auto-minor-version-upgrade m4864)]
    (.
     bean4863
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4865)))
   (clojure.core/when-let
    [v4865 (:availability-zone m4864)]
    (. bean4863 setAvailabilityZone (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:license-model m4864)]
    (. bean4863 setLicenseModel (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:iops m4864)]
    (. bean4863 setIops (clojure.core/int v4865)))
   (clojure.core/when-let
    [v4865 (:dbname m4864)]
    (. bean4863 setDBName (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:dbsnapshot-identifier m4864)]
    (. bean4863 setDBSnapshotIdentifier (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:dbsubnet-group-name m4864)]
    (. bean4863 setDBSubnetGroupName (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:publicly-accessible m4864)]
    (. bean4863 setPubliclyAccessible (clojure.core/boolean v4865)))
   (clojure.core/when-let
    [v4865 (:multi-az m4864)]
    (. bean4863 setMultiAZ (clojure.core/boolean v4865)))
   (clojure.core/when-let
    [v4865 (:option-group-name m4864)]
    (. bean4863 setOptionGroupName (clojure.core/str v4865)))
   (clojure.core/when-let
    [v4865 (:tags m4864)]
    (.
     bean4863
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5007] (rds/tag arg5007)) v4865)))
   (clojure.core/when-let
    [v4865 (:dbinstance-identifier m4864)]
    (. bean4863 setDBInstanceIdentifier (clojure.core/str v4865)))
   bean4863))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest}
delete-dbparameter-group-request
  [m4867]
  (clojure.core/let
   [bean4866
    (new
     com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4868 (:dbparameter-group-name m4867)]
    (. bean4866 setDBParameterGroupName (clojure.core/str v4868)))
   bean4866))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest}
describe-reserved-dbinstances-request
  [m4870]
  (clojure.core/let
   [bean4869
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest)]
   (clojure.core/when-let
    [v4871 (:max-records m4870)]
    (. bean4869 setMaxRecords (clojure.core/int v4871)))
   (clojure.core/when-let
    [v4871 (:offering-type m4870)]
    (. bean4869 setOfferingType (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:dbinstance-class m4870)]
    (. bean4869 setDBInstanceClass (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:product-description m4870)]
    (. bean4869 setProductDescription (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:multi-az m4870)]
    (. bean4869 setMultiAZ (clojure.core/boolean v4871)))
   (clojure.core/when-let
    [v4871 (:duration m4870)]
    (. bean4869 setDuration (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:reserved-dbinstances-offering-id m4870)]
    (.
     bean4869
     setReservedDBInstancesOfferingId
     (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:reserved-dbinstance-id m4870)]
    (. bean4869 setReservedDBInstanceId (clojure.core/str v4871)))
   (clojure.core/when-let
    [v4871 (:filters m4870)]
    (.
     bean4869
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5008] (rds/filter arg5008))
 v4871)))
   (clojure.core/when-let
    [v4871 (:marker m4870)]
    (. bean4869 setMarker (clojure.core/str v4871)))
   bean4869))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest}
delete-dbsecurity-group-request
  [m4873]
  (clojure.core/let
   [bean4872
    (new
     com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v4874 (:dbsecurity-group-name m4873)]
    (. bean4872 setDBSecurityGroupName (clojure.core/str v4874)))
   bean4872))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m4876]
  (clojure.core/let
   [bean4875
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v4877 (:max-records m4876)]
    (. bean4875 setMaxRecords (clojure.core/int v4877)))
   (clojure.core/when-let
    [v4877 (:marker m4876)]
    (. bean4875 setMarker (clojure.core/str v4877)))
   (clojure.core/when-let
    [v4877 (:dbparameter-group-family m4876)]
    (. bean4875 setDBParameterGroupFamily (clojure.core/str v4877)))
   bean4875))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBParameterGroupRequest}
create-dbparameter-group-request
  [m4879]
  (clojure.core/let
   [bean4878
    (new
     com.amazonaws.services.rds.model.CreateDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4880 (:tags m4879)]
    (.
     bean4878
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5009] (rds/tag arg5009)) v4880)))
   (clojure.core/when-let
    [v4880 (:description m4879)]
    (. bean4878 setDescription (clojure.core/str v4880)))
   (clojure.core/when-let
    [v4880 (:dbparameter-group-name m4879)]
    (. bean4878 setDBParameterGroupName (clojure.core/str v4880)))
   (clojure.core/when-let
    [v4880 (:dbparameter-group-family m4879)]
    (. bean4878 setDBParameterGroupFamily (clojure.core/str v4880)))
   bean4878))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m4882]
  (clojure.core/let
   [bean4881
    (new
     com.amazonaws.services.rds.model.CreateEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4883 (:source-type m4882)]
    (. bean4881 setSourceType (clojure.core/str v4883)))
   (clojure.core/when-let
    [v4883 (:subscription-name m4882)]
    (. bean4881 setSubscriptionName (clojure.core/str v4883)))
   (clojure.core/when-let
    [v4883 (:sns-topic-arn m4882)]
    (. bean4881 setSnsTopicArn (clojure.core/str v4883)))
   (clojure.core/when-let
    [v4883 (:source-ids m4882)]
    (.
     bean4881
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5010] (clojure.core/str arg5010))
 v4883)))
   (clojure.core/when-let
    [v4883 (:event-categories m4882)]
    (.
     bean4881
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5011] (clojure.core/str arg5011))
 v4883)))
   (clojure.core/when-let
    [v4883 (:tags m4882)]
    (.
     bean4881
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5012] (rds/tag arg5012)) v4883)))
   (clojure.core/when-let
    [v4883 (:enabled m4882)]
    (. bean4881 setEnabled (clojure.core/boolean v4883)))
   bean4881))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest}
create-dbsecurity-group-request
  [m4885]
  (clojure.core/let
   [bean4884
    (new
     com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v4886 (:tags m4885)]
    (.
     bean4884
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5013] (rds/tag arg5013)) v4886)))
   (clojure.core/when-let
    [v4886 (:dbsecurity-group-name m4885)]
    (. bean4884 setDBSecurityGroupName (clojure.core/str v4886)))
   (clojure.core/when-let
    [v4886 (:dbsecurity-group-description m4885)]
    (.
     bean4884
     setDBSecurityGroupDescription
     (clojure.core/str v4886)))
   bean4884))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m4888]
  (clojure.core/let
   [bean4887
    (new
     com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4889 (:source-type m4888)]
    (. bean4887 setSourceType (clojure.core/str v4889)))
   (clojure.core/when-let
    [v4889 (:subscription-name m4888)]
    (. bean4887 setSubscriptionName (clojure.core/str v4889)))
   (clojure.core/when-let
    [v4889 (:sns-topic-arn m4888)]
    (. bean4887 setSnsTopicArn (clojure.core/str v4889)))
   (clojure.core/when-let
    [v4889 (:event-categories m4888)]
    (.
     bean4887
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5014] (clojure.core/str arg5014))
 v4889)))
   (clojure.core/when-let
    [v4889 (:enabled m4888)]
    (. bean4887 setEnabled (clojure.core/boolean v4889)))
   bean4887))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteOptionGroupRequest}
delete-option-group-request
  [m4891]
  (clojure.core/let
   [bean4890
    (new com.amazonaws.services.rds.model.DeleteOptionGroupRequest)]
   (clojure.core/when-let
    [v4892 (:option-group-name m4891)]
    (. bean4890 setOptionGroupName (clojure.core/str v4892)))
   bean4890))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest}
download-dblog-file-portion-request
  [m4894]
  (clojure.core/let
   [bean4893
    (new
     com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest)]
   (clojure.core/when-let
    [v4895 (:marker m4894)]
    (. bean4893 setMarker (clojure.core/str v4895)))
   (clojure.core/when-let
    [v4895 (:dbinstance-identifier m4894)]
    (. bean4893 setDBInstanceIdentifier (clojure.core/str v4895)))
   (clojure.core/when-let
    [v4895 (:log-file-name m4894)]
    (. bean4893 setLogFileName (clojure.core/str v4895)))
   (clojure.core/when-let
    [v4895 (:number-of-lines m4894)]
    (. bean4893 setNumberOfLines (clojure.core/int v4895)))
   bean4893))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventsRequest}
describe-events-request
  [m4897]
  (clojure.core/let
   [bean4896
    (new com.amazonaws.services.rds.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v4898 (:max-records m4897)]
    (. bean4896 setMaxRecords (clojure.core/int v4898)))
   (clojure.core/when-let
    [v4898 (:source-identifier m4897)]
    (. bean4896 setSourceIdentifier (clojure.core/str v4898)))
   (clojure.core/when-let
    [v4898 (:source-type m4897)]
    (. bean4896 setSourceType (clojure.core/str v4898)))
   (clojure.core/when-let
    [v4898 (:start-time m4897)]
    (.
     bean4896
     setStartTime
     (com.palletops.awaze.common/to-date v4898)))
   (clojure.core/when-let
    [v4898 (:end-time m4897)]
    (. bean4896 setEndTime (com.palletops.awaze.common/to-date v4898)))
   (clojure.core/when-let
    [v4898 (:duration m4897)]
    (. bean4896 setDuration (clojure.core/int v4898)))
   (clojure.core/when-let
    [v4898 (:event-categories m4897)]
    (.
     bean4896
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5015] (clojure.core/str arg5015))
 v4898)))
   (clojure.core/when-let
    [v4898 (:marker m4897)]
    (. bean4896 setMarker (clojure.core/str v4898)))
   bean4896))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest}
describe-reserved-dbinstances-offerings-request
  [m4900]
  (clojure.core/let
   [bean4899
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v4901 (:max-records m4900)]
    (. bean4899 setMaxRecords (clojure.core/int v4901)))
   (clojure.core/when-let
    [v4901 (:duration m4900)]
    (. bean4899 setDuration (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:offering-type m4900)]
    (. bean4899 setOfferingType (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:marker m4900)]
    (. bean4899 setMarker (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:dbinstance-class m4900)]
    (. bean4899 setDBInstanceClass (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:multi-az m4900)]
    (. bean4899 setMultiAZ (clojure.core/boolean v4901)))
   (clojure.core/when-let
    [v4901 (:reserved-dbinstances-offering-id m4900)]
    (.
     bean4899
     setReservedDBInstancesOfferingId
     (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:product-description m4900)]
    (. bean4899 setProductDescription (clojure.core/str v4901)))
   bean4899))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyOptionGroupRequest}
modify-option-group-request
  [m4903]
  (clojure.core/let
   [bean4902
    (new com.amazonaws.services.rds.model.ModifyOptionGroupRequest)]
   (clojure.core/when-let
    [v4904 (:option-group-name m4903)]
    (. bean4902 setOptionGroupName (clojure.core/str v4904)))
   (clojure.core/when-let
    [v4904 (:apply-immediately m4903)]
    (. bean4902 setApplyImmediately (clojure.core/boolean v4904)))
   (clojure.core/when-let
    [v4904 (:options-to-include m4903)]
    (.
     bean4902
     setOptionsToInclude
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5016] (rds/option-configuration arg5016))
 v4904)))
   (clojure.core/when-let
    [v4904 (:options-to-remove m4903)]
    (.
     bean4902
     setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5017] (clojure.core/str arg5017))
 v4904)))
   bean4902))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBInstancesRequest}
describe-dbinstances-request
  [m4906]
  (clojure.core/let
   [bean4905
    (new com.amazonaws.services.rds.model.DescribeDBInstancesRequest)]
   (clojure.core/when-let
    [v4907 (:max-records m4906)]
    (. bean4905 setMaxRecords (clojure.core/int v4907)))
   (clojure.core/when-let
    [v4907 (:filters m4906)]
    (.
     bean4905
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5018] (rds/filter arg5018))
 v4907)))
   (clojure.core/when-let
    [v4907 (:marker m4906)]
    (. bean4905 setMarker (clojure.core/str v4907)))
   (clojure.core/when-let
    [v4907 (:dbinstance-identifier m4906)]
    (. bean4905 setDBInstanceIdentifier (clojure.core/str v4907)))
   bean4905))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSnapshotRequest}
create-dbsnapshot-request
  [m4909]
  (clojure.core/let
   [bean4908
    (new com.amazonaws.services.rds.model.CreateDBSnapshotRequest)]
   (clojure.core/when-let
    [v4910 (:tags m4909)]
    (.
     bean4908
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5019] (rds/tag arg5019)) v4910)))
   (clojure.core/when-let
    [v4910 (:dbinstance-identifier m4909)]
    (. bean4908 setDBInstanceIdentifier (clojure.core/str v4910)))
   (clojure.core/when-let
    [v4910 (:dbsnapshot-identifier m4909)]
    (. bean4908 setDBSnapshotIdentifier (clojure.core/str v4910)))
   bean4908))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest}
remove-source-identifier-from-subscription-request
  [m4912]
  (clojure.core/let
   [bean4911
    (new
     com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest)]
   (clojure.core/when-let
    [v4913 (:source-identifier m4912)]
    (. bean4911 setSourceIdentifier (clojure.core/str v4913)))
   (clojure.core/when-let
    [v4913 (:subscription-name m4912)]
    (. bean4911 setSubscriptionName (clojure.core/str v4913)))
   bean4911))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateOptionGroupRequest}
create-option-group-request
  [m4915]
  (clojure.core/let
   [bean4914
    (new com.amazonaws.services.rds.model.CreateOptionGroupRequest)]
   (clojure.core/when-let
    [v4916 (:tags m4915)]
    (.
     bean4914
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5020] (rds/tag arg5020)) v4916)))
   (clojure.core/when-let
    [v4916 (:option-group-name m4915)]
    (. bean4914 setOptionGroupName (clojure.core/str v4916)))
   (clojure.core/when-let
    [v4916 (:engine-name m4915)]
    (. bean4914 setEngineName (clojure.core/str v4916)))
   (clojure.core/when-let
    [v4916 (:major-engine-version m4915)]
    (. bean4914 setMajorEngineVersion (clojure.core/str v4916)))
   (clojure.core/when-let
    [v4916 (:option-group-description m4915)]
    (. bean4914 setOptionGroupDescription (clojure.core/str v4916)))
   bean4914))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m4918]
  (clojure.core/let
   [bean4917
    (new
     com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/when-let
    [v4919 (:max-records m4918)]
    (. bean4917 setMaxRecords (clojure.core/int v4919)))
   (clojure.core/when-let
    [v4919 (:subscription-name m4918)]
    (. bean4917 setSubscriptionName (clojure.core/str v4919)))
   (clojure.core/when-let
    [v4919 (:filters m4918)]
    (.
     bean4917
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5021] (rds/filter arg5021))
 v4919)))
   (clojure.core/when-let
    [v4919 (:marker m4918)]
    (. bean4917 setMarker (clojure.core/str v4919)))
   bean4917))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest}
describe-orderable-dbinstance-options-request
  [m4921]
  (clojure.core/let
   [bean4920
    (new
     com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest)]
   (clojure.core/when-let
    [v4922 (:max-records m4921)]
    (. bean4920 setMaxRecords (clojure.core/int v4922)))
   (clojure.core/when-let
    [v4922 (:marker m4921)]
    (. bean4920 setMarker (clojure.core/str v4922)))
   (clojure.core/when-let
    [v4922 (:dbinstance-class m4921)]
    (. bean4920 setDBInstanceClass (clojure.core/str v4922)))
   (clojure.core/when-let
    [v4922 (:engine m4921)]
    (. bean4920 setEngine (clojure.core/str v4922)))
   (clojure.core/when-let
    [v4922 (:engine-version m4921)]
    (. bean4920 setEngineVersion (clojure.core/str v4922)))
   (clojure.core/when-let
    [v4922 (:license-model m4921)]
    (. bean4920 setLicenseModel (clojure.core/str v4922)))
   (clojure.core/when-let
    [v4922 (:vpc m4921)]
    (. bean4920 setVpc (clojure.core/boolean v4922)))
   bean4920))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m4924]
  (clojure.core/let
   [bean4923
    (new com.amazonaws.services.rds.model.ListTagsForResourceRequest)]
   (clojure.core/when-let
    [v4925 (:resource-name m4924)]
    (. bean4923 setResourceName (clojure.core/str v4925)))
   bean4923))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest}
modify-dbsubnet-group-request
  [m4927]
  (clojure.core/let
   [bean4926
    (new com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v4928 (:subnet-ids m4927)]
    (.
     bean4926
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5022] (clojure.core/str arg5022))
 v4928)))
   (clojure.core/when-let
    [v4928 (:dbsubnet-group-name m4927)]
    (. bean4926 setDBSubnetGroupName (clojure.core/str v4928)))
   (clojure.core/when-let
    [v4928 (:dbsubnet-group-description m4927)]
    (. bean4926 setDBSubnetGroupDescription (clojure.core/str v4928)))
   bean4926))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBLogFilesRequest}
describe-dblog-files-request
  [m4930]
  (clojure.core/let
   [bean4929
    (new com.amazonaws.services.rds.model.DescribeDBLogFilesRequest)]
   (clojure.core/when-let
    [v4931 (:max-records m4930)]
    (. bean4929 setMaxRecords (clojure.core/int v4931)))
   (clojure.core/when-let
    [v4931 (:marker m4930)]
    (. bean4929 setMarker (clojure.core/str v4931)))
   (clojure.core/when-let
    [v4931 (:dbinstance-identifier m4930)]
    (. bean4929 setDBInstanceIdentifier (clojure.core/str v4931)))
   (clojure.core/when-let
    [v4931 (:filename-contains m4930)]
    (. bean4929 setFilenameContains (clojure.core/str v4931)))
   (clojure.core/when-let
    [v4931 (:file-last-written m4930)]
    (. bean4929 setFileLastWritten (clojure.core/long v4931)))
   (clojure.core/when-let
    [v4931 (:file-size m4930)]
    (. bean4929 setFileSize (clojure.core/long v4931)))
   bean4929))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PromoteReadReplicaRequest}
promote-read-replica-request
  [m4933]
  (clojure.core/let
   [bean4932
    (new com.amazonaws.services.rds.model.PromoteReadReplicaRequest)]
   (clojure.core/when-let
    [v4934 (:dbinstance-identifier m4933)]
    (. bean4932 setDBInstanceIdentifier (clojure.core/str v4934)))
   (clojure.core/when-let
    [v4934 (:backup-retention-period m4933)]
    (. bean4932 setBackupRetentionPeriod (clojure.core/int v4934)))
   (clojure.core/when-let
    [v4934 (:preferred-backup-window m4933)]
    (. bean4932 setPreferredBackupWindow (clojure.core/str v4934)))
   bean4932))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest}
delete-dbsubnet-group-request
  [m4936]
  (clojure.core/let
   [bean4935
    (new com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v4937 (:dbsubnet-group-name m4936)]
    (. bean4935 setDBSubnetGroupName (clojure.core/str v4937)))
   bean4935))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest}
describe-dbsnapshots-request
  [m4939]
  (clojure.core/let
   [bean4938
    (new com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest)]
   (clojure.core/when-let
    [v4940 (:max-records m4939)]
    (. bean4938 setMaxRecords (clojure.core/int v4940)))
   (clojure.core/when-let
    [v4940 (:snapshot-type m4939)]
    (. bean4938 setSnapshotType (clojure.core/str v4940)))
   (clojure.core/when-let
    [v4940 (:filters m4939)]
    (.
     bean4938
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5023] (rds/filter arg5023))
 v4940)))
   (clojure.core/when-let
    [v4940 (:marker m4939)]
    (. bean4938 setMarker (clojure.core/str v4940)))
   (clojure.core/when-let
    [v4940 (:dbinstance-identifier m4939)]
    (. bean4938 setDBInstanceIdentifier (clojure.core/str v4940)))
   (clojure.core/when-let
    [v4940 (:dbsnapshot-identifier m4939)]
    (. bean4938 setDBSnapshotIdentifier (clojure.core/str v4940)))
   bean4938))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest}
add-source-identifier-to-subscription-request
  [m4942]
  (clojure.core/let
   [bean4941
    (new
     com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest)]
   (clojure.core/when-let
    [v4943 (:source-identifier m4942)]
    (. bean4941 setSourceIdentifier (clojure.core/str v4943)))
   (clojure.core/when-let
    [v4943 (:subscription-name m4942)]
    (. bean4941 setSubscriptionName (clojure.core/str v4943)))
   bean4941))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m4945]
  (clojure.core/let
   [bean4944
    (new
     com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest)]
   (clojure.core/when-let
    [v4946 (:tag-keys m4945)]
    (.
     bean4944
     setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5024] (clojure.core/str arg5024))
 v4946)))
   (clojure.core/when-let
    [v4946 (:resource-name m4945)]
    (. bean4944 setResourceName (clojure.core/str v4946)))
   bean4944))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBInstanceRequest}
modify-dbinstance-request
  [m4948]
  (clojure.core/let
   [bean4947
    (new com.amazonaws.services.rds.model.ModifyDBInstanceRequest)]
   (clojure.core/when-let
    [v4949 (:vpc-security-group-ids m4948)]
    (.
     bean4947
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5025] (clojure.core/str arg5025))
 v4949)))
   (clojure.core/when-let
    [v4949 (:dbparameter-group-name m4948)]
    (. bean4947 setDBParameterGroupName (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:dbinstance-class m4948)]
    (. bean4947 setDBInstanceClass (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:preferred-maintenance-window m4948)]
    (.
     bean4947
     setPreferredMaintenanceWindow
     (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:auto-minor-version-upgrade m4948)]
    (.
     bean4947
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4949)))
   (clojure.core/when-let
    [v4949 (:master-user-password m4948)]
    (. bean4947 setMasterUserPassword (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:iops m4948)]
    (. bean4947 setIops (clojure.core/int v4949)))
   (clojure.core/when-let
    [v4949 (:multi-az m4948)]
    (. bean4947 setMultiAZ (clojure.core/boolean v4949)))
   (clojure.core/when-let
    [v4949 (:preferred-backup-window m4948)]
    (. bean4947 setPreferredBackupWindow (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:apply-immediately m4948)]
    (. bean4947 setApplyImmediately (clojure.core/boolean v4949)))
   (clojure.core/when-let
    [v4949 (:option-group-name m4948)]
    (. bean4947 setOptionGroupName (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:dbsecurity-groups m4948)]
    (.
     bean4947
     setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5026] (clojure.core/str arg5026))
 v4949)))
   (clojure.core/when-let
    [v4949 (:engine-version m4948)]
    (. bean4947 setEngineVersion (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:allocated-storage m4948)]
    (. bean4947 setAllocatedStorage (clojure.core/int v4949)))
   (clojure.core/when-let
    [v4949 (:allow-major-version-upgrade m4948)]
    (.
     bean4947
     setAllowMajorVersionUpgrade
     (clojure.core/boolean v4949)))
   (clojure.core/when-let
    [v4949 (:new-dbinstance-identifier m4948)]
    (. bean4947 setNewDBInstanceIdentifier (clojure.core/str v4949)))
   (clojure.core/when-let
    [v4949 (:backup-retention-period m4948)]
    (. bean4947 setBackupRetentionPeriod (clojure.core/int v4949)))
   (clojure.core/when-let
    [v4949 (:dbinstance-identifier m4948)]
    (. bean4947 setDBInstanceIdentifier (clojure.core/str v4949)))
   bean4947))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest}
describe-dbengine-versions-request
  [m4951]
  (clojure.core/let
   [bean4950
    (new
     com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest)]
   (clojure.core/when-let
    [v4952 (:max-records m4951)]
    (. bean4950 setMaxRecords (clojure.core/int v4952)))
   (clojure.core/when-let
    [v4952 (:marker m4951)]
    (. bean4950 setMarker (clojure.core/str v4952)))
   (clojure.core/when-let
    [v4952 (:engine m4951)]
    (. bean4950 setEngine (clojure.core/str v4952)))
   (clojure.core/when-let
    [v4952 (:engine-version m4951)]
    (. bean4950 setEngineVersion (clojure.core/str v4952)))
   (clojure.core/when-let
    [v4952 (:dbparameter-group-family m4951)]
    (. bean4950 setDBParameterGroupFamily (clojure.core/str v4952)))
   (clojure.core/when-let
    [v4952 (:default-only m4951)]
    (. bean4950 setDefaultOnly (clojure.core/boolean v4952)))
   (clojure.core/when-let
    [v4952 (:list-supported-character-sets m4951)]
    (.
     bean4950
     setListSupportedCharacterSets
     (clojure.core/boolean v4952)))
   bean4950))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RebootDBInstanceRequest}
reboot-dbinstance-request
  [m4954]
  (clojure.core/let
   [bean4953
    (new com.amazonaws.services.rds.model.RebootDBInstanceRequest)]
   (clojure.core/when-let
    [v4955 (:dbinstance-identifier m4954)]
    (. bean4953 setDBInstanceIdentifier (clojure.core/str v4955)))
   (clojure.core/when-let
    [v4955 (:force-failover m4954)]
    (. bean4953 setForceFailover (clojure.core/boolean v4955)))
   bean4953))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest}
describe-option-group-options-request
  [m4957]
  (clojure.core/let
   [bean4956
    (new
     com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest)]
   (clojure.core/when-let
    [v4958 (:max-records m4957)]
    (. bean4956 setMaxRecords (clojure.core/int v4958)))
   (clojure.core/when-let
    [v4958 (:marker m4957)]
    (. bean4956 setMarker (clojure.core/str v4958)))
   (clojure.core/when-let
    [v4958 (:engine-name m4957)]
    (. bean4956 setEngineName (clojure.core/str v4958)))
   (clojure.core/when-let
    [v4958 (:major-engine-version m4957)]
    (. bean4956 setMajorEngineVersion (clojure.core/str v4958)))
   bean4956))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceRequest}
create-dbinstance-request
  [m4960]
  (clojure.core/let
   [bean4959
    (new com.amazonaws.services.rds.model.CreateDBInstanceRequest)]
   (clojure.core/when-let
    [v4961 (:vpc-security-group-ids m4960)]
    (.
     bean4959
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5027] (clojure.core/str arg5027))
 v4961)))
   (clojure.core/when-let
    [v4961 (:dbparameter-group-name m4960)]
    (. bean4959 setDBParameterGroupName (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:port m4960)]
    (. bean4959 setPort (clojure.core/int v4961)))
   (clojure.core/when-let
    [v4961 (:dbinstance-class m4960)]
    (. bean4959 setDBInstanceClass (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:preferred-maintenance-window m4960)]
    (.
     bean4959
     setPreferredMaintenanceWindow
     (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:engine m4960)]
    (. bean4959 setEngine (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:character-set-name m4960)]
    (. bean4959 setCharacterSetName (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:auto-minor-version-upgrade m4960)]
    (.
     bean4959
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4961)))
   (clojure.core/when-let
    [v4961 (:availability-zone m4960)]
    (. bean4959 setAvailabilityZone (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:license-model m4960)]
    (. bean4959 setLicenseModel (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:master-user-password m4960)]
    (. bean4959 setMasterUserPassword (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:iops m4960)]
    (. bean4959 setIops (clojure.core/int v4961)))
   (clojure.core/when-let
    [v4961 (:dbname m4960)]
    (. bean4959 setDBName (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:dbsubnet-group-name m4960)]
    (. bean4959 setDBSubnetGroupName (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:publicly-accessible m4960)]
    (. bean4959 setPubliclyAccessible (clojure.core/boolean v4961)))
   (clojure.core/when-let
    [v4961 (:multi-az m4960)]
    (. bean4959 setMultiAZ (clojure.core/boolean v4961)))
   (clojure.core/when-let
    [v4961 (:preferred-backup-window m4960)]
    (. bean4959 setPreferredBackupWindow (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:option-group-name m4960)]
    (. bean4959 setOptionGroupName (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:dbsecurity-groups m4960)]
    (.
     bean4959
     setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5028] (clojure.core/str arg5028))
 v4961)))
   (clojure.core/when-let
    [v4961 (:engine-version m4960)]
    (. bean4959 setEngineVersion (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:allocated-storage m4960)]
    (. bean4959 setAllocatedStorage (clojure.core/int v4961)))
   (clojure.core/when-let
    [v4961 (:master-username m4960)]
    (. bean4959 setMasterUsername (clojure.core/str v4961)))
   (clojure.core/when-let
    [v4961 (:backup-retention-period m4960)]
    (. bean4959 setBackupRetentionPeriod (clojure.core/int v4961)))
   (clojure.core/when-let
    [v4961 (:tags m4960)]
    (.
     bean4959
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5029] (rds/tag arg5029)) v4961)))
   (clojure.core/when-let
    [v4961 (:dbinstance-identifier m4960)]
    (. bean4959 setDBInstanceIdentifier (clojure.core/str v4961)))
   bean4959))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest}
describe-dbsubnet-groups-request
  [m4963]
  (clojure.core/let
   [bean4962
    (new
     com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest)]
   (clojure.core/when-let
    [v4964 (:max-records m4963)]
    (. bean4962 setMaxRecords (clojure.core/int v4964)))
   (clojure.core/when-let
    [v4964 (:filters m4963)]
    (.
     bean4962
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5030] (rds/filter arg5030))
 v4964)))
   (clojure.core/when-let
    [v4964 (:marker m4963)]
    (. bean4962 setMarker (clojure.core/str v4964)))
   (clojure.core/when-let
    [v4964 (:dbsubnet-group-name m4963)]
    (. bean4962 setDBSubnetGroupName (clojure.core/str v4964)))
   bean4962))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new
     com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4967 (:subscription-name m4966)]
    (. bean4965 setSubscriptionName (clojure.core/str v4967)))
   bean4965))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest}
describe-dbparameter-groups-request
  [m4969]
  (clojure.core/let
   [bean4968
    (new
     com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest)]
   (clojure.core/when-let
    [v4970 (:max-records m4969)]
    (. bean4968 setMaxRecords (clojure.core/int v4970)))
   (clojure.core/when-let
    [v4970 (:filters m4969)]
    (.
     bean4968
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5031] (rds/filter arg5031))
 v4970)))
   (clojure.core/when-let
    [v4970 (:marker m4969)]
    (. bean4968 setMarker (clojure.core/str v4970)))
   (clojure.core/when-let
    [v4970 (:dbparameter-group-name m4969)]
    (. bean4968 setDBParameterGroupName (clojure.core/str v4970)))
   bean4968))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ResetDBParameterGroupRequest}
reset-dbparameter-group-request
  [m4972]
  (clojure.core/let
   [bean4971
    (new
     com.amazonaws.services.rds.model.ResetDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4973 (:parameters m4972)]
    (.
     bean4971
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5032] (rds/parameter arg5032))
 v4973)))
   (clojure.core/when-let
    [v4973 (:reset-all-parameters m4972)]
    (. bean4971 setResetAllParameters (clojure.core/boolean v4973)))
   (clojure.core/when-let
    [v4973 (:dbparameter-group-name m4972)]
    (. bean4971 setDBParameterGroupName (clojure.core/str v4973)))
   bean4971))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest}
restore-dbinstance-to-point-in-time-request
  [m4975]
  (clojure.core/let
   [bean4974
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest)]
   (clojure.core/when-let
    [v4976 (:port m4975)]
    (. bean4974 setPort (clojure.core/int v4976)))
   (clojure.core/when-let
    [v4976 (:dbinstance-class m4975)]
    (. bean4974 setDBInstanceClass (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:engine m4975)]
    (. bean4974 setEngine (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:auto-minor-version-upgrade m4975)]
    (.
     bean4974
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4976)))
   (clojure.core/when-let
    [v4976 (:availability-zone m4975)]
    (. bean4974 setAvailabilityZone (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:license-model m4975)]
    (. bean4974 setLicenseModel (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:use-latest-restorable-time m4975)]
    (.
     bean4974
     setUseLatestRestorableTime
     (clojure.core/boolean v4976)))
   (clojure.core/when-let
    [v4976 (:iops m4975)]
    (. bean4974 setIops (clojure.core/int v4976)))
   (clojure.core/when-let
    [v4976 (:dbname m4975)]
    (. bean4974 setDBName (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:dbsubnet-group-name m4975)]
    (. bean4974 setDBSubnetGroupName (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:publicly-accessible m4975)]
    (. bean4974 setPubliclyAccessible (clojure.core/boolean v4976)))
   (clojure.core/when-let
    [v4976 (:target-dbinstance-identifier m4975)]
    (.
     bean4974
     setTargetDBInstanceIdentifier
     (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:multi-az m4975)]
    (. bean4974 setMultiAZ (clojure.core/boolean v4976)))
   (clojure.core/when-let
    [v4976 (:option-group-name m4975)]
    (. bean4974 setOptionGroupName (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:restore-time m4975)]
    (.
     bean4974
     setRestoreTime
     (com.palletops.awaze.common/to-date v4976)))
   (clojure.core/when-let
    [v4976 (:source-dbinstance-identifier m4975)]
    (.
     bean4974
     setSourceDBInstanceIdentifier
     (clojure.core/str v4976)))
   (clojure.core/when-let
    [v4976 (:tags m4975)]
    (.
     bean4974
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5033] (rds/tag arg5033)) v4976)))
   bean4974))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest}
modify-dbparameter-group-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4979 (:parameters m4978)]
    (.
     bean4977
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5034] (rds/parameter arg5034))
 v4979)))
   (clojure.core/when-let
    [v4979 (:dbparameter-group-name m4978)]
    (. bean4977 setDBParameterGroupName (clojure.core/str v4979)))
   bean4977))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBInstanceRequest}
delete-dbinstance-request
  [m4981]
  (clojure.core/let
   [bean4980
    (new com.amazonaws.services.rds.model.DeleteDBInstanceRequest)]
   (clojure.core/when-let
    [v4982 (:dbinstance-identifier m4981)]
    (. bean4980 setDBInstanceIdentifier (clojure.core/str v4982)))
   (clojure.core/when-let
    [v4982 (:skip-final-snapshot m4981)]
    (. bean4980 setSkipFinalSnapshot (clojure.core/boolean v4982)))
   (clojure.core/when-let
    [v4982 (:final-dbsnapshot-identifier m4981)]
    (. bean4980 setFinalDBSnapshotIdentifier (clojure.core/str v4982)))
   bean4980))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m4984]
  (clojure.core/let
   [bean4983
    (new
     com.amazonaws.services.rds.model.DescribeEventCategoriesRequest)]
   (clojure.core/when-let
    [v4985 (:source-type m4984)]
    (. bean4983 setSourceType (clojure.core/str v4985)))
   bean4983))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest}
authorize-dbsecurity-group-ingress-request
  [m4987]
  (clojure.core/let
   [bean4986
    (new
     com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4988 (:cidrip m4987)]
    (. bean4986 setCIDRIP (clojure.core/str v4988)))
   (clojure.core/when-let
    [v4988 (:ec2security-group-name m4987)]
    (. bean4986 setEC2SecurityGroupName (clojure.core/str v4988)))
   (clojure.core/when-let
    [v4988 (:ec2security-group-owner-id m4987)]
    (. bean4986 setEC2SecurityGroupOwnerId (clojure.core/str v4988)))
   (clojure.core/when-let
    [v4988 (:dbsecurity-group-name m4987)]
    (. bean4986 setDBSecurityGroupName (clojure.core/str v4988)))
   (clojure.core/when-let
    [v4988 (:ec2security-group-id m4987)]
    (. bean4986 setEC2SecurityGroupId (clojure.core/str v4988)))
   bean4986))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBSnapshotRequest}
copy-dbsnapshot-request
  [m4990]
  (clojure.core/let
   [bean4989
    (new com.amazonaws.services.rds.model.CopyDBSnapshotRequest)]
   (clojure.core/when-let
    [v4991 (:tags m4990)]
    (.
     bean4989
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5035] (rds/tag arg5035)) v4991)))
   (clojure.core/when-let
    [v4991 (:source-dbsnapshot-identifier m4990)]
    (.
     bean4989
     setSourceDBSnapshotIdentifier
     (clojure.core/str v4991)))
   (clojure.core/when-let
    [v4991 (:target-dbsnapshot-identifier m4990)]
    (.
     bean4989
     setTargetDBSnapshotIdentifier
     (clojure.core/str v4991)))
   bean4989))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSnapshotRequest}
delete-dbsnapshot-request
  [m4993]
  (clojure.core/let
   [bean4992
    (new com.amazonaws.services.rds.model.DeleteDBSnapshotRequest)]
   (clojure.core/when-let
    [v4994 (:dbsnapshot-identifier m4993)]
    (. bean4992 setDBSnapshotIdentifier (clojure.core/str v4994)))
   bean4992))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest}
create-dbsubnet-group-request
  [m4996]
  (clojure.core/let
   [bean4995
    (new com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v4997 (:subnet-ids m4996)]
    (.
     bean4995
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5036] (clojure.core/str arg5036))
 v4997)))
   (clojure.core/when-let
    [v4997 (:tags m4996)]
    (.
     bean4995
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5037] (rds/tag arg5037)) v4997)))
   (clojure.core/when-let
    [v4997 (:dbsubnet-group-name m4996)]
    (. bean4995 setDBSubnetGroupName (clojure.core/str v4997)))
   (clojure.core/when-let
    [v4997 (:dbsubnet-group-description m4996)]
    (. bean4995 setDBSubnetGroupDescription (clojure.core/str v4997)))
   bean4995))
 (clojure.core/defmulti
  rds
  (clojure.core/fn rds [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   rds
   :revoke-dbsecurity-group-ingress
   [m5038]
   (clojure.core/let
    [credentials5039 (:credentials m5038) args5040 (:args m5038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5041
      (com.palletops.awaze.common/aws-client :rds credentials5039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5041
       revokeDBSecurityGroupIngress
       (rds/revoke-dbsecurity-group-ingress-request
        (clojure.core/nth args5040 0)))))))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for revokeDBSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :revoke-dbsecurity-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call revokeDBSecurityGroupIngress"}
   [credentials5043 & args5044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5045
     (com.palletops.awaze.common/aws-client :rds credentials5043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5045
      revokeDBSecurityGroupIngress
      (rds/revoke-dbsecurity-group-ingress-request
       (clojure.core/nth args5044 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :add-tags-to-resource
   [m5046]
   (clojure.core/let
    [credentials5047 (:credentials m5046) args5048 (:args m5046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5049
      (com.palletops.awaze.common/aws-client :rds credentials5047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5049
       addTagsToResource
       (rds/add-tags-to-resource-request
        (clojure.core/nth args5048 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-tags-to-resource,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Call addTagsToResource"}
   [credentials5051 & args5052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5053
     (com.palletops.awaze.common/aws-client :rds credentials5051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5053
      addTagsToResource
      (rds/add-tags-to-resource-request (clojure.core/nth args5052 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsecurity-groups
   [m5054]
   (clojure.core/let
    [credentials5055 (:credentials m5054) args5056 (:args m5054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5057
      (com.palletops.awaze.common/aws-client :rds credentials5055)]
     (clojure.core/case
      (clojure.core/count args5056)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5057
        describeDBSecurityGroups
        (rds/describe-dbsecurity-groups-request
         (clojure.core/nth args5056 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5057
        describeDBSecurityGroups))))))
  (clojure.core/defn
   describe-dbsecurity-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Generate map for describeDBSecurityGroups, describeDBSecurityGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbsecurity-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Call describeDBSecurityGroups, describeDBSecurityGroups"}
   [credentials5059 & args5060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5061
     (com.palletops.awaze.common/aws-client :rds credentials5059)]
    (clojure.core/case
     (clojure.core/count args5060)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5061
       describeDBSecurityGroups
       (rds/describe-dbsecurity-groups-request
        (clojure.core/nth args5060 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5061
       describeDBSecurityGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :purchase-reserved-dbinstances-offering
   [m5062]
   (clojure.core/let
    [credentials5063 (:credentials m5062) args5064 (:args m5062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5065
      (com.palletops.awaze.common/aws-client :rds credentials5063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5065
       purchaseReservedDBInstancesOffering
       (rds/purchase-reserved-dbinstances-offering-request
        (clojure.core/nth args5064 0)))))))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Generate map for purchaseReservedDBInstancesOffering"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :purchase-reserved-dbinstances-offering,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Call purchaseReservedDBInstancesOffering"}
   [credentials5067 & args5068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5069
     (com.palletops.awaze.common/aws-client :rds credentials5067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5069
      purchaseReservedDBInstancesOffering
      (rds/purchase-reserved-dbinstances-offering-request
       (clojure.core/nth args5068 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameters
   [m5070]
   (clojure.core/let
    [credentials5071 (:credentials m5070) args5072 (:args m5070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5073
      (com.palletops.awaze.common/aws-client :rds credentials5071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5073
       describeDBParameters
       (rds/describe-dbparameters-request
        (clojure.core/nth args5072 0)))))))
  (clojure.core/defn
   describe-dbparameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for describeDBParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbparameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call describeDBParameters"}
   [credentials5075 & args5076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5077
     (com.palletops.awaze.common/aws-client :rds credentials5075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5077
      describeDBParameters
      (rds/describe-dbparameters-request
       (clojure.core/nth args5076 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-groups
   [m5078]
   (clojure.core/let
    [credentials5079 (:credentials m5078) args5080 (:args m5078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5081
      (com.palletops.awaze.common/aws-client :rds credentials5079)]
     (clojure.core/case
      (clojure.core/count args5080)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5081
        describeOptionGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5081
        describeOptionGroups
        (rds/describe-option-groups-request
         (clojure.core/nth args5080 0))))))))
  (clojure.core/defn
   describe-option-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Generate map for describeOptionGroups, describeOptionGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-option-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Call describeOptionGroups, describeOptionGroups"}
   [credentials5083 & args5084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5085
     (com.palletops.awaze.common/aws-client :rds credentials5083)]
    (clojure.core/case
     (clojure.core/count args5084)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5085
       describeOptionGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5085
       describeOptionGroups
       (rds/describe-option-groups-request
        (clojure.core/nth args5084 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance-read-replica
   [m5086]
   (clojure.core/let
    [credentials5087 (:credentials m5086) args5088 (:args m5086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5089
      (com.palletops.awaze.common/aws-client :rds credentials5087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5089
       createDBInstanceReadReplica
       (rds/create-dbinstance-read-replica-request
        (clojure.core/nth args5088 0)))))))
  (clojure.core/defn
   create-dbinstance-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstanceReadReplica"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance-read-replica,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbinstance-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstanceReadReplica"}
   [credentials5091 & args5092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5093
     (com.palletops.awaze.common/aws-client :rds credentials5091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5093
      createDBInstanceReadReplica
      (rds/create-dbinstance-read-replica-request
       (clojure.core/nth args5092 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-from-dbsnapshot
   [m5094]
   (clojure.core/let
    [credentials5095 (:credentials m5094) args5096 (:args m5094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5097
      (com.palletops.awaze.common/aws-client :rds credentials5095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5097
       restoreDBInstanceFromDBSnapshot
       (rds/restore-dbinstance-from-dbsnapshot-request
        (clojure.core/nth args5096 0)))))))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceFromDBSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-from-dbsnapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceFromDBSnapshot"}
   [credentials5099 & args5100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5101
     (com.palletops.awaze.common/aws-client :rds credentials5099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5101
      restoreDBInstanceFromDBSnapshot
      (rds/restore-dbinstance-from-dbsnapshot-request
       (clojure.core/nth args5100 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbparameter-group
   [m5102]
   (clojure.core/let
    [credentials5103 (:credentials m5102) args5104 (:args m5102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5105
      (com.palletops.awaze.common/aws-client :rds credentials5103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5105
       deleteDBParameterGroup
       (rds/delete-dbparameter-group-request
        (clojure.core/nth args5104 0)))))))
  (clojure.core/defn
   delete-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for deleteDBParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbparameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call deleteDBParameterGroup"}
   [credentials5107 & args5108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5109
     (com.palletops.awaze.common/aws-client :rds credentials5107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5109
      deleteDBParameterGroup
      (rds/delete-dbparameter-group-request
       (clojure.core/nth args5108 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances
   [m5110]
   (clojure.core/let
    [credentials5111 (:credentials m5110) args5112 (:args m5110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5113
      (com.palletops.awaze.common/aws-client :rds credentials5111)]
     (clojure.core/case
      (clojure.core/count args5112)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5113
        describeReservedDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5113
        describeReservedDBInstances
        (rds/describe-reserved-dbinstances-request
         (clojure.core/nth args5112 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Generate map for describeReservedDBInstances, describeReservedDBInstances"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Call describeReservedDBInstances, describeReservedDBInstances"}
   [credentials5115 & args5116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5117
     (com.palletops.awaze.common/aws-client :rds credentials5115)]
    (clojure.core/case
     (clojure.core/count args5116)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5117
       describeReservedDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5117
       describeReservedDBInstances
       (rds/describe-reserved-dbinstances-request
        (clojure.core/nth args5116 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsecurity-group
   [m5118]
   (clojure.core/let
    [credentials5119 (:credentials m5118) args5120 (:args m5118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5121
      (com.palletops.awaze.common/aws-client :rds credentials5119)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5121
       deleteDBSecurityGroup
       (rds/delete-dbsecurity-group-request
        (clojure.core/nth args5120 0)))))))
  (clojure.core/defn
   delete-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Generate map for deleteDBSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsecurity-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Call deleteDBSecurityGroup"}
   [credentials5123 & args5124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5125
     (com.palletops.awaze.common/aws-client :rds credentials5123)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5125
      deleteDBSecurityGroup
      (rds/delete-dbsecurity-group-request
       (clojure.core/nth args5124 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-parameters
   [m5126]
   (clojure.core/let
    [credentials5127 (:credentials m5126) args5128 (:args m5126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5129
      (com.palletops.awaze.common/aws-client :rds credentials5127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5129
       describeEngineDefaultParameters
       (rds/describe-engine-default-parameters-request
        (clojure.core/nth args5128 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials5131 & args5132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5133
     (com.palletops.awaze.common/aws-client :rds credentials5131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5133
      describeEngineDefaultParameters
      (rds/describe-engine-default-parameters-request
       (clojure.core/nth args5132 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbparameter-group
   [m5134]
   (clojure.core/let
    [credentials5135 (:credentials m5134) args5136 (:args m5134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5137
      (com.palletops.awaze.common/aws-client :rds credentials5135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5137
       createDBParameterGroup
       (rds/create-dbparameter-group-request
        (clojure.core/nth args5136 0)))))))
  (clojure.core/defn
   create-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Generate map for createDBParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbparameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Call createDBParameterGroup"}
   [credentials5139 & args5140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5141
     (com.palletops.awaze.common/aws-client :rds credentials5139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5141
      createDBParameterGroup
      (rds/create-dbparameter-group-request
       (clojure.core/nth args5140 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-event-subscription
   [m5142]
   (clojure.core/let
    [credentials5143 (:credentials m5142) args5144 (:args m5142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5145
      (com.palletops.awaze.common/aws-client :rds credentials5143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5145
       createEventSubscription
       (rds/create-event-subscription-request
        (clojure.core/nth args5144 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Call createEventSubscription"}
   [credentials5147 & args5148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5149
     (com.palletops.awaze.common/aws-client :rds credentials5147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5149
      createEventSubscription
      (rds/create-event-subscription-request
       (clojure.core/nth args5148 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsecurity-group
   [m5150]
   (clojure.core/let
    [credentials5151 (:credentials m5150) args5152 (:args m5150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5153
      (com.palletops.awaze.common/aws-client :rds credentials5151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5153
       createDBSecurityGroup
       (rds/create-dbsecurity-group-request
        (clojure.core/nth args5152 0)))))))
  (clojure.core/defn
   create-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Generate map for createDBSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsecurity-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Call createDBSecurityGroup"}
   [credentials5155 & args5156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5157
     (com.palletops.awaze.common/aws-client :rds credentials5155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5157
      createDBSecurityGroup
      (rds/create-dbsecurity-group-request
       (clojure.core/nth args5156 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-event-subscription
   [m5158]
   (clojure.core/let
    [credentials5159 (:credentials m5158) args5160 (:args m5158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5161
      (com.palletops.awaze.common/aws-client :rds credentials5159)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5161
       modifyEventSubscription
       (rds/modify-event-subscription-request
        (clojure.core/nth args5160 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials5163 & args5164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5165
     (com.palletops.awaze.common/aws-client :rds credentials5163)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5165
      modifyEventSubscription
      (rds/modify-event-subscription-request
       (clojure.core/nth args5164 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-option-group
   [m5166]
   (clojure.core/let
    [credentials5167 (:credentials m5166) args5168 (:args m5166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5169
      (com.palletops.awaze.common/aws-client :rds credentials5167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5169
       deleteOptionGroup
       (rds/delete-option-group-request (clojure.core/nth args5168 0)))))))
  (clojure.core/defn
   delete-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Generate map for deleteOptionGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-option-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-option-group
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Call deleteOptionGroup"}
   [credentials5171 & args5172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5173
     (com.palletops.awaze.common/aws-client :rds credentials5171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5173
      deleteOptionGroup
      (rds/delete-option-group-request (clojure.core/nth args5172 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :download-dblog-file-portion
   [m5174]
   (clojure.core/let
    [credentials5175 (:credentials m5174) args5176 (:args m5174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5177
      (com.palletops.awaze.common/aws-client :rds credentials5175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5177
       downloadDBLogFilePortion
       (rds/download-dblog-file-portion-request
        (clojure.core/nth args5176 0)))))))
  (clojure.core/defn
   download-dblog-file-portion-map
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Generate map for downloadDBLogFilePortion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :download-dblog-file-portion,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   download-dblog-file-portion
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Call downloadDBLogFilePortion"}
   [credentials5179 & args5180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5181
     (com.palletops.awaze.common/aws-client :rds credentials5179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5181
      downloadDBLogFilePortion
      (rds/download-dblog-file-portion-request
       (clojure.core/nth args5180 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-events
   [m5182]
   (clojure.core/let
    [credentials5183 (:credentials m5182) args5184 (:args m5182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5185
      (com.palletops.awaze.common/aws-client :rds credentials5183)]
     (clojure.core/case
      (clojure.core/count args5184)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5185
        describeEvents
        (rds/describe-events-request (clojure.core/nth args5184 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5185
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials5187 & args5188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5189
     (com.palletops.awaze.common/aws-client :rds credentials5187)]
    (clojure.core/case
     (clojure.core/count args5188)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5189
       describeEvents
       (rds/describe-events-request (clojure.core/nth args5188 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5189
       describeEvents))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances-offerings
   [m5190]
   (clojure.core/let
    [credentials5191 (:credentials m5190) args5192 (:args m5190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5193
      (com.palletops.awaze.common/aws-client :rds credentials5191)]
     (clojure.core/case
      (clojure.core/count args5192)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5193
        describeReservedDBInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5193
        describeReservedDBInstancesOfferings
        (rds/describe-reserved-dbinstances-offerings-request
         (clojure.core/nth args5192 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Generate map for describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Call describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   [credentials5195 & args5196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5197
     (com.palletops.awaze.common/aws-client :rds credentials5195)]
    (clojure.core/case
     (clojure.core/count args5196)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5197
       describeReservedDBInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5197
       describeReservedDBInstancesOfferings
       (rds/describe-reserved-dbinstances-offerings-request
        (clojure.core/nth args5196 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-option-group
   [m5198]
   (clojure.core/let
    [credentials5199 (:credentials m5198) args5200 (:args m5198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5201
      (com.palletops.awaze.common/aws-client :rds credentials5199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5201
       modifyOptionGroup
       (rds/modify-option-group-request (clojure.core/nth args5200 0)))))))
  (clojure.core/defn
   modify-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Generate map for modifyOptionGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-option-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-option-group
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Call modifyOptionGroup"}
   [credentials5203 & args5204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5205
     (com.palletops.awaze.common/aws-client :rds credentials5203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5205
      modifyOptionGroup
      (rds/modify-option-group-request (clojure.core/nth args5204 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbinstances
   [m5206]
   (clojure.core/let
    [credentials5207 (:credentials m5206) args5208 (:args m5206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5209
      (com.palletops.awaze.common/aws-client :rds credentials5207)]
     (clojure.core/case
      (clojure.core/count args5208)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5209
        describeDBInstances
        (rds/describe-dbinstances-request
         (clojure.core/nth args5208 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5209
        describeDBInstances))))))
  (clojure.core/defn
   describe-dbinstances-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]
                [credentials]]),
    :doc "Generate map for describeDBInstances, describeDBInstances"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbinstances
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]
                [credentials]]),
    :doc "Call describeDBInstances, describeDBInstances"}
   [credentials5211 & args5212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5213
     (com.palletops.awaze.common/aws-client :rds credentials5211)]
    (clojure.core/case
     (clojure.core/count args5212)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5213
       describeDBInstances
       (rds/describe-dbinstances-request
        (clojure.core/nth args5212 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5213
       describeDBInstances))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsnapshot
   [m5214]
   (clojure.core/let
    [credentials5215 (:credentials m5214) args5216 (:args m5214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5217
      (com.palletops.awaze.common/aws-client :rds credentials5215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5217
       createDBSnapshot
       (rds/create-dbsnapshot-request (clojure.core/nth args5216 0)))))))
  (clojure.core/defn
   create-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for createDBSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsnapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call createDBSnapshot"}
   [credentials5219 & args5220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5221
     (com.palletops.awaze.common/aws-client :rds credentials5219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5221
      createDBSnapshot
      (rds/create-dbsnapshot-request (clojure.core/nth args5220 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-source-identifier-from-subscription
   [m5222]
   (clojure.core/let
    [credentials5223 (:credentials m5222) args5224 (:args m5222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5225
      (com.palletops.awaze.common/aws-client :rds credentials5223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5225
       removeSourceIdentifierFromSubscription
       (rds/remove-source-identifier-from-subscription-request
        (clojure.core/nth args5224 0)))))))
  (clojure.core/defn
   remove-source-identifier-from-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for removeSourceIdentifierFromSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-source-identifier-from-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-source-identifier-from-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call removeSourceIdentifierFromSubscription"}
   [credentials5227 & args5228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5229
     (com.palletops.awaze.common/aws-client :rds credentials5227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5229
      removeSourceIdentifierFromSubscription
      (rds/remove-source-identifier-from-subscription-request
       (clojure.core/nth args5228 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-option-group
   [m5230]
   (clojure.core/let
    [credentials5231 (:credentials m5230) args5232 (:args m5230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5233
      (com.palletops.awaze.common/aws-client :rds credentials5231)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5233
       createOptionGroup
       (rds/create-option-group-request (clojure.core/nth args5232 0)))))))
  (clojure.core/defn
   create-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Generate map for createOptionGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-option-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-option-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Call createOptionGroup"}
   [credentials5235 & args5236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5237
     (com.palletops.awaze.common/aws-client :rds credentials5235)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5237
      createOptionGroup
      (rds/create-option-group-request (clojure.core/nth args5236 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-subscriptions
   [m5238]
   (clojure.core/let
    [credentials5239 (:credentials m5238) args5240 (:args m5238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5241
      (com.palletops.awaze.common/aws-client :rds credentials5239)]
     (clojure.core/case
      (clojure.core/count args5240)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5241
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5241
        describeEventSubscriptions
        (rds/describe-event-subscriptions-request
         (clojure.core/nth args5240 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials5243 & args5244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5245
     (com.palletops.awaze.common/aws-client :rds credentials5243)]
    (clojure.core/case
     (clojure.core/count args5244)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5245
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5245
       describeEventSubscriptions
       (rds/describe-event-subscriptions-request
        (clojure.core/nth args5244 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-orderable-dbinstance-options
   [m5246]
   (clojure.core/let
    [credentials5247 (:credentials m5246) args5248 (:args m5246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5249
      (com.palletops.awaze.common/aws-client :rds credentials5247)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5249
       describeOrderableDBInstanceOptions
       (rds/describe-orderable-dbinstance-options-request
        (clojure.core/nth args5248 0)))))))
  (clojure.core/defn
   describe-orderable-dbinstance-options-map
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Generate map for describeOrderableDBInstanceOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-orderable-dbinstance-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-orderable-dbinstance-options
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Call describeOrderableDBInstanceOptions"}
   [credentials5251 & args5252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5253
     (com.palletops.awaze.common/aws-client :rds credentials5251)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5253
      describeOrderableDBInstanceOptions
      (rds/describe-orderable-dbinstance-options-request
       (clojure.core/nth args5252 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :list-tags-for-resource
   [m5254]
   (clojure.core/let
    [credentials5255 (:credentials m5254) args5256 (:args m5254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5257
      (com.palletops.awaze.common/aws-client :rds credentials5255)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5257
       listTagsForResource
       (rds/list-tags-for-resource-request
        (clojure.core/nth args5256 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :list-tags-for-resource,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Call listTagsForResource"}
   [credentials5259 & args5260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5261
     (com.palletops.awaze.common/aws-client :rds credentials5259)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5261
      listTagsForResource
      (rds/list-tags-for-resource-request
       (clojure.core/nth args5260 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsubnet-group
   [m5262]
   (clojure.core/let
    [credentials5263 (:credentials m5262) args5264 (:args m5262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5265
      (com.palletops.awaze.common/aws-client :rds credentials5263)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5265
       modifyDBSubnetGroup
       (rds/modify-dbsubnet-group-request
        (clojure.core/nth args5264 0)))))))
  (clojure.core/defn
   modify-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for modifyDBSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbsubnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call modifyDBSubnetGroup"}
   [credentials5267 & args5268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5269
     (com.palletops.awaze.common/aws-client :rds credentials5267)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5269
      modifyDBSubnetGroup
      (rds/modify-dbsubnet-group-request
       (clojure.core/nth args5268 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dblog-files
   [m5270]
   (clojure.core/let
    [credentials5271 (:credentials m5270) args5272 (:args m5270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5273
      (com.palletops.awaze.common/aws-client :rds credentials5271)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5273
       describeDBLogFiles
       (rds/describe-dblog-files-request
        (clojure.core/nth args5272 0)))))))
  (clojure.core/defn
   describe-dblog-files-map
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Generate map for describeDBLogFiles"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dblog-files,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dblog-files
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Call describeDBLogFiles"}
   [credentials5275 & args5276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5277
     (com.palletops.awaze.common/aws-client :rds credentials5275)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5277
      describeDBLogFiles
      (rds/describe-dblog-files-request (clojure.core/nth args5276 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :promote-read-replica
   [m5278]
   (clojure.core/let
    [credentials5279 (:credentials m5278) args5280 (:args m5278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5281
      (com.palletops.awaze.common/aws-client :rds credentials5279)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5281
       promoteReadReplica
       (rds/promote-read-replica-request
        (clojure.core/nth args5280 0)))))))
  (clojure.core/defn
   promote-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Generate map for promoteReadReplica"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :promote-read-replica,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   promote-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Call promoteReadReplica"}
   [credentials5283 & args5284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5285
     (com.palletops.awaze.common/aws-client :rds credentials5283)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5285
      promoteReadReplica
      (rds/promote-read-replica-request (clojure.core/nth args5284 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsubnet-group
   [m5286]
   (clojure.core/let
    [credentials5287 (:credentials m5286) args5288 (:args m5286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5289
      (com.palletops.awaze.common/aws-client :rds credentials5287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5289
       deleteDBSubnetGroup
       (rds/delete-dbsubnet-group-request
        (clojure.core/nth args5288 0)))))))
  (clojure.core/defn
   delete-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Generate map for deleteDBSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsubnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Call deleteDBSubnetGroup"}
   [credentials5291 & args5292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5293
     (com.palletops.awaze.common/aws-client :rds credentials5291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5293
      deleteDBSubnetGroup
      (rds/delete-dbsubnet-group-request
       (clojure.core/nth args5292 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshots
   [m5294]
   (clojure.core/let
    [credentials5295 (:credentials m5294) args5296 (:args m5294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5297
      (com.palletops.awaze.common/aws-client :rds credentials5295)]
     (clojure.core/case
      (clojure.core/count args5296)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5297
        describeDBSnapshots
        (rds/describe-dbsnapshots-request
         (clojure.core/nth args5296 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5297
        describeDBSnapshots))))))
  (clojure.core/defn
   describe-dbsnapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeDBSnapshots, describeDBSnapshots"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbsnapshots
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeDBSnapshots, describeDBSnapshots"}
   [credentials5299 & args5300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5301
     (com.palletops.awaze.common/aws-client :rds credentials5299)]
    (clojure.core/case
     (clojure.core/count args5300)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5301
       describeDBSnapshots
       (rds/describe-dbsnapshots-request
        (clojure.core/nth args5300 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5301
       describeDBSnapshots))))))
 (do
  (clojure.core/defmethod
   rds
   :add-source-identifier-to-subscription
   [m5302]
   (clojure.core/let
    [credentials5303 (:credentials m5302) args5304 (:args m5302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5305
      (com.palletops.awaze.common/aws-client :rds credentials5303)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5305
       addSourceIdentifierToSubscription
       (rds/add-source-identifier-to-subscription-request
        (clojure.core/nth args5304 0)))))))
  (clojure.core/defn
   add-source-identifier-to-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for addSourceIdentifierToSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-source-identifier-to-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-source-identifier-to-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call addSourceIdentifierToSubscription"}
   [credentials5307 & args5308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5309
     (com.palletops.awaze.common/aws-client :rds credentials5307)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5309
      addSourceIdentifierToSubscription
      (rds/add-source-identifier-to-subscription-request
       (clojure.core/nth args5308 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-tags-from-resource
   [m5310]
   (clojure.core/let
    [credentials5311 (:credentials m5310) args5312 (:args m5310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5313
      (com.palletops.awaze.common/aws-client :rds credentials5311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5313
       removeTagsFromResource
       (rds/remove-tags-from-resource-request
        (clojure.core/nth args5312 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-tags-from-resource,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials5315 & args5316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5317
     (com.palletops.awaze.common/aws-client :rds credentials5315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5317
      removeTagsFromResource
      (rds/remove-tags-from-resource-request
       (clojure.core/nth args5316 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbinstance
   [m5318]
   (clojure.core/let
    [credentials5319 (:credentials m5318) args5320 (:args m5318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5321
      (com.palletops.awaze.common/aws-client :rds credentials5319)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5321
       modifyDBInstance
       (rds/modify-dbinstance-request (clojure.core/nth args5320 0)))))))
  (clojure.core/defn
   modify-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Generate map for modifyDBInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbinstance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Call modifyDBInstance"}
   [credentials5323 & args5324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5325
     (com.palletops.awaze.common/aws-client :rds credentials5323)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5325
      modifyDBInstance
      (rds/modify-dbinstance-request (clojure.core/nth args5324 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbengine-versions
   [m5326]
   (clojure.core/let
    [credentials5327 (:credentials m5326) args5328 (:args m5326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5329
      (com.palletops.awaze.common/aws-client :rds credentials5327)]
     (clojure.core/case
      (clojure.core/count args5328)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5329
        describeDBEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5329
        describeDBEngineVersions
        (rds/describe-dbengine-versions-request
         (clojure.core/nth args5328 0))))))))
  (clojure.core/defn
   describe-dbengine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Generate map for describeDBEngineVersions, describeDBEngineVersions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbengine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Call describeDBEngineVersions, describeDBEngineVersions"}
   [credentials5331 & args5332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5333
     (com.palletops.awaze.common/aws-client :rds credentials5331)]
    (clojure.core/case
     (clojure.core/count args5332)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5333
       describeDBEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5333
       describeDBEngineVersions
       (rds/describe-dbengine-versions-request
        (clojure.core/nth args5332 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :reboot-dbinstance
   [m5334]
   (clojure.core/let
    [credentials5335 (:credentials m5334) args5336 (:args m5334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5337
      (com.palletops.awaze.common/aws-client :rds credentials5335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5337
       rebootDBInstance
       (rds/reboot-dbinstance-request (clojure.core/nth args5336 0)))))))
  (clojure.core/defn
   reboot-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Generate map for rebootDBInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reboot-dbinstance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reboot-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Call rebootDBInstance"}
   [credentials5339 & args5340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5341
     (com.palletops.awaze.common/aws-client :rds credentials5339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5341
      rebootDBInstance
      (rds/reboot-dbinstance-request (clojure.core/nth args5340 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-group-options
   [m5342]
   (clojure.core/let
    [credentials5343 (:credentials m5342) args5344 (:args m5342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5345
      (com.palletops.awaze.common/aws-client :rds credentials5343)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5345
       describeOptionGroupOptions
       (rds/describe-option-group-options-request
        (clojure.core/nth args5344 0)))))))
  (clojure.core/defn
   describe-option-group-options-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Generate map for describeOptionGroupOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-group-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-option-group-options
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Call describeOptionGroupOptions"}
   [credentials5347 & args5348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5349
     (com.palletops.awaze.common/aws-client :rds credentials5347)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5349
      describeOptionGroupOptions
      (rds/describe-option-group-options-request
       (clojure.core/nth args5348 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance
   [m5350]
   (clojure.core/let
    [credentials5351 (:credentials m5350) args5352 (:args m5350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5353
      (com.palletops.awaze.common/aws-client :rds credentials5351)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5353
       createDBInstance
       (rds/create-dbinstance-request (clojure.core/nth args5352 0)))))))
  (clojure.core/defn
   create-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstance"}
   [credentials5355 & args5356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5357
     (com.palletops.awaze.common/aws-client :rds credentials5355)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5357
      createDBInstance
      (rds/create-dbinstance-request (clojure.core/nth args5356 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsubnet-groups
   [m5358]
   (clojure.core/let
    [credentials5359 (:credentials m5358) args5360 (:args m5358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5361
      (com.palletops.awaze.common/aws-client :rds credentials5359)]
     (clojure.core/case
      (clojure.core/count args5360)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5361
        describeDBSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5361
        describeDBSubnetGroups
        (rds/describe-dbsubnet-groups-request
         (clojure.core/nth args5360 0))))))))
  (clojure.core/defn
   describe-dbsubnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Generate map for describeDBSubnetGroups, describeDBSubnetGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbsubnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Call describeDBSubnetGroups, describeDBSubnetGroups"}
   [credentials5363 & args5364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5365
     (com.palletops.awaze.common/aws-client :rds credentials5363)]
    (clojure.core/case
     (clojure.core/count args5364)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5365
       describeDBSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5365
       describeDBSubnetGroups
       (rds/describe-dbsubnet-groups-request
        (clojure.core/nth args5364 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-event-subscription
   [m5366]
   (clojure.core/let
    [credentials5367 (:credentials m5366) args5368 (:args m5366)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5369
      (com.palletops.awaze.common/aws-client :rds credentials5367)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5369
       deleteEventSubscription
       (rds/delete-event-subscription-request
        (clojure.core/nth args5368 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials5371 & args5372]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5373
     (com.palletops.awaze.common/aws-client :rds credentials5371)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5373
      deleteEventSubscription
      (rds/delete-event-subscription-request
       (clojure.core/nth args5372 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameter-groups
   [m5374]
   (clojure.core/let
    [credentials5375 (:credentials m5374) args5376 (:args m5374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5377
      (com.palletops.awaze.common/aws-client :rds credentials5375)]
     (clojure.core/case
      (clojure.core/count args5376)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5377
        describeDBParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5377
        describeDBParameterGroups
        (rds/describe-dbparameter-groups-request
         (clojure.core/nth args5376 0))))))))
  (clojure.core/defn
   describe-dbparameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]]),
    :doc "Generate map for describeDBParameterGroups, describeDBParameterGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-dbparameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]]),
    :doc "Call describeDBParameterGroups, describeDBParameterGroups"}
   [credentials5379 & args5380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5381
     (com.palletops.awaze.common/aws-client :rds credentials5379)]
    (clojure.core/case
     (clojure.core/count args5380)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5381
       describeDBParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5381
       describeDBParameterGroups
       (rds/describe-dbparameter-groups-request
        (clojure.core/nth args5380 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbparameter-group
   [m5382]
   (clojure.core/let
    [credentials5383 (:credentials m5382) args5384 (:args m5382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5385
      (com.palletops.awaze.common/aws-client :rds credentials5383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5385
       resetDBParameterGroup
       (rds/reset-dbparameter-group-request
        (clojure.core/nth args5384 0)))))))
  (clojure.core/defn
   reset-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for resetDBParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reset-dbparameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call resetDBParameterGroup"}
   [credentials5387 & args5388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5389
     (com.palletops.awaze.common/aws-client :rds credentials5387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5389
      resetDBParameterGroup
      (rds/reset-dbparameter-group-request
       (clojure.core/nth args5388 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-to-point-in-time
   [m5390]
   (clojure.core/let
    [credentials5391 (:credentials m5390) args5392 (:args m5390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5393
      (com.palletops.awaze.common/aws-client :rds credentials5391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5393
       restoreDBInstanceToPointInTime
       (rds/restore-dbinstance-to-point-in-time-request
        (clojure.core/nth args5392 0)))))))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time-map
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceToPointInTime"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-to-point-in-time,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceToPointInTime"}
   [credentials5395 & args5396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5397
     (com.palletops.awaze.common/aws-client :rds credentials5395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5397
      restoreDBInstanceToPointInTime
      (rds/restore-dbinstance-to-point-in-time-request
       (clojure.core/nth args5396 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbparameter-group
   [m5398]
   (clojure.core/let
    [credentials5399 (:credentials m5398) args5400 (:args m5398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5401
      (com.palletops.awaze.common/aws-client :rds credentials5399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5401
       modifyDBParameterGroup
       (rds/modify-dbparameter-group-request
        (clojure.core/nth args5400 0)))))))
  (clojure.core/defn
   modify-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for modifyDBParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbparameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call modifyDBParameterGroup"}
   [credentials5403 & args5404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5405
     (com.palletops.awaze.common/aws-client :rds credentials5403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5405
      modifyDBParameterGroup
      (rds/modify-dbparameter-group-request
       (clojure.core/nth args5404 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbinstance
   [m5406]
   (clojure.core/let
    [credentials5407 (:credentials m5406) args5408 (:args m5406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5409
      (com.palletops.awaze.common/aws-client :rds credentials5407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5409
       deleteDBInstance
       (rds/delete-dbinstance-request (clojure.core/nth args5408 0)))))))
  (clojure.core/defn
   delete-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for deleteDBInstance"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbinstance,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call deleteDBInstance"}
   [credentials5411 & args5412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5413
     (com.palletops.awaze.common/aws-client :rds credentials5411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5413
      deleteDBInstance
      (rds/delete-dbinstance-request (clojure.core/nth args5412 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-categories
   [m5414]
   (clojure.core/let
    [credentials5415 (:credentials m5414) args5416 (:args m5414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5417
      (com.palletops.awaze.common/aws-client :rds credentials5415)]
     (clojure.core/case
      (clojure.core/count args5416)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5417
        describeEventCategories
        (rds/describe-event-categories-request
         (clojure.core/nth args5416 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5417
        describeEventCategories))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1649__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials5419 & args5420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5421
     (com.palletops.awaze.common/aws-client :rds credentials5419)]
    (clojure.core/case
     (clojure.core/count args5420)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5421
       describeEventCategories
       (rds/describe-event-categories-request
        (clojure.core/nth args5420 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5421
       describeEventCategories))))))
 (do
  (clojure.core/defmethod
   rds
   :authorize-dbsecurity-group-ingress
   [m5422]
   (clojure.core/let
    [credentials5423 (:credentials m5422) args5424 (:args m5422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5425
      (com.palletops.awaze.common/aws-client :rds credentials5423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5425
       authorizeDBSecurityGroupIngress
       (rds/authorize-dbsecurity-group-ingress-request
        (clojure.core/nth args5424 0)))))))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for authorizeDBSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :authorize-dbsecurity-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call authorizeDBSecurityGroupIngress"}
   [credentials5427 & args5428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5429
     (com.palletops.awaze.common/aws-client :rds credentials5427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5429
      authorizeDBSecurityGroupIngress
      (rds/authorize-dbsecurity-group-ingress-request
       (clojure.core/nth args5428 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbsnapshot
   [m5430]
   (clojure.core/let
    [credentials5431 (:credentials m5430) args5432 (:args m5430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5433
      (com.palletops.awaze.common/aws-client :rds credentials5431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5433
       copyDBSnapshot
       (rds/copy-dbsnapshot-request (clojure.core/nth args5432 0)))))))
  (clojure.core/defn
   copy-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyDBSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :copy-dbsnapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Call copyDBSnapshot"}
   [credentials5435 & args5436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5437
     (com.palletops.awaze.common/aws-client :rds credentials5435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5437
      copyDBSnapshot
      (rds/copy-dbsnapshot-request (clojure.core/nth args5436 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsnapshot
   [m5438]
   (clojure.core/let
    [credentials5439 (:credentials m5438) args5440 (:args m5438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5441
      (com.palletops.awaze.common/aws-client :rds credentials5439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5441
       deleteDBSnapshot
       (rds/delete-dbsnapshot-request (clojure.core/nth args5440 0)))))))
  (clojure.core/defn
   delete-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Generate map for deleteDBSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsnapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Call deleteDBSnapshot"}
   [credentials5443 & args5444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5445
     (com.palletops.awaze.common/aws-client :rds credentials5443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5445
      deleteDBSnapshot
      (rds/delete-dbsnapshot-request (clojure.core/nth args5444 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsubnet-group
   [m5446]
   (clojure.core/let
    [credentials5447 (:credentials m5446) args5448 (:args m5446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5449
      (com.palletops.awaze.common/aws-client :rds credentials5447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5449
       createDBSubnetGroup
       (rds/create-dbsubnet-group-request
        (clojure.core/nth args5448 0)))))))
  (clojure.core/defn
   create-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for createDBSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsubnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call createDBSubnetGroup"}
   [credentials5451 & args5452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5453
     (com.palletops.awaze.common/aws-client :rds credentials5451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5453
      createDBSubnetGroup
      (rds/create-dbsubnet-group-request
       (clojure.core/nth args5452 0))))))))
