(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11307]
  (clojure.core/let
   [bean11306
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/when-let
    [v11308 (:value m11307)]
    (. bean11306 setValue (clojure.core/str v11308)))
   bean11306))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11310]
  (clojure.core/let
   [bean11309 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/when-let
    [v11311 (:dnsname m11310)]
    (. bean11309 setDNSName (clojure.core/str v11311)))
   (clojure.core/when-let
    [v11311 (:hosted-zone-id m11310)]
    (. bean11309 setHostedZoneId (clojure.core/str v11311)))
   (clojure.core/when-let
    [v11311 (:evaluate-target-health m11310)]
    (.
     bean11309
     setEvaluateTargetHealth
     (clojure.core/boolean v11311)))
   bean11309))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11313]
  (clojure.core/let
   [bean11312
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/when-let
    [v11314 (:health-check-id m11313)]
    (. bean11312 setHealthCheckId (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:set-identifier m11313)]
    (. bean11312 setSetIdentifier (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:ttl m11313)]
    (. bean11312 setTTL (clojure.core/long v11314)))
   (clojure.core/when-let
    [v11314 (:name m11313)]
    (. bean11312 setName (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:resource-records m11313)]
    (.
     bean11312
     setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11363] (route53/resource-record arg11363))
 v11314)))
   (clojure.core/when-let
    [v11314 (:failover m11313)]
    (. bean11312 setFailover (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:region m11313)]
    (. bean11312 setRegion (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:weight m11313)]
    (. bean11312 setWeight (clojure.core/long v11314)))
   (clojure.core/when-let
    [v11314 (:type m11313)]
    (. bean11312 setType (clojure.core/str v11314)))
   (clojure.core/when-let
    [v11314 (:alias-target m11313)]
    (. bean11312 setAliasTarget (route53/alias-target v11314)))
   bean11312))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11316]
  (clojure.core/let
   [bean11315 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/when-let
    [v11317 (:action m11316)]
    (. bean11315 setAction (clojure.core/str v11317)))
   (clojure.core/when-let
    [v11317 (:resource-record-set m11316)]
    (.
     bean11315
     setResourceRecordSet
     (route53/resource-record-set v11317)))
   bean11315))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11319]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11319)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11322]
  (clojure.core/let
   [bean11321 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/when-let
    [v11323 (:comment m11322)]
    (. bean11321 setComment (clojure.core/str v11323)))
   (clojure.core/when-let
    [v11323 (:changes m11322)]
    (.
     bean11321
     setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11364] (route53/change arg11364))
 v11323)))
   bean11321))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11325]
  (clojure.core/let
   [bean11324
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/when-let
    [v11326 (:port m11325)]
    (. bean11324 setPort (clojure.core/int v11326)))
   (clojure.core/when-let
    [v11326 (:type m11325)]
    (. bean11324 setType (clojure.core/str v11326)))
   (clojure.core/when-let
    [v11326 (:resource-path m11325)]
    (. bean11324 setResourcePath (clojure.core/str v11326)))
   (clojure.core/when-let
    [v11326 (:ipaddress m11325)]
    (. bean11324 setIPAddress (clojure.core/str v11326)))
   (clojure.core/when-let
    [v11326 (:fully-qualified-domain-name m11325)]
    (.
     bean11324
     setFullyQualifiedDomainName
     (clojure.core/str v11326)))
   (clojure.core/when-let
    [v11326 (:search-string m11325)]
    (. bean11324 setSearchString (clojure.core/str v11326)))
   (clojure.core/when-let
    [v11326 (:request-interval m11325)]
    (. bean11324 setRequestInterval (clojure.core/int v11326)))
   (clojure.core/when-let
    [v11326 (:failure-threshold m11325)]
    (. bean11324 setFailureThreshold (clojure.core/int v11326)))
   bean11324))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11328]
  (clojure.core/let
   [bean11327
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/when-let
    [v11329 (:comment m11328)]
    (. bean11327 setComment (clojure.core/str v11329)))
   bean11327))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11331]
  (clojure.core/let
   [bean11330
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/when-let
    [v11332 (:id m11331)]
    (. bean11330 setId (clojure.core/str v11332)))
   bean11330))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11334]
  (clojure.core/let
   [bean11333
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/when-let
    [v11335 (:max-items m11334)]
    (. bean11333 setMaxItems (clojure.core/str v11335)))
   (clojure.core/when-let
    [v11335 (:marker m11334)]
    (. bean11333 setMarker (clojure.core/str v11335)))
   bean11333))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11337]
  (clojure.core/let
   [bean11336
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v11338 (:max-items m11337)]
    (. bean11336 setMaxItems (clojure.core/str v11338)))
   (clojure.core/when-let
    [v11338 (:hosted-zone-id m11337)]
    (. bean11336 setHostedZoneId (clojure.core/str v11338)))
   (clojure.core/when-let
    [v11338 (:start-record-name m11337)]
    (. bean11336 setStartRecordName (clojure.core/str v11338)))
   (clojure.core/when-let
    [v11338 (:start-record-type m11337)]
    (. bean11336 setStartRecordType (route53/rrtype v11338)))
   (clojure.core/when-let
    [v11338 (:start-record-identifier m11337)]
    (. bean11336 setStartRecordIdentifier (clojure.core/str v11338)))
   bean11336))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11340]
  (clojure.core/let
   [bean11339
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v11341 (:hosted-zone-id m11340)]
    (. bean11339 setHostedZoneId (clojure.core/str v11341)))
   (clojure.core/when-let
    [v11341 (:change-batch m11340)]
    (. bean11339 setChangeBatch (route53/change-batch v11341)))
   bean11339))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11343]
  (clojure.core/let
   [bean11342
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/when-let
    [v11344 (:max-items m11343)]
    (. bean11342 setMaxItems (clojure.core/str v11344)))
   (clojure.core/when-let
    [v11344 (:marker m11343)]
    (. bean11342 setMarker (clojure.core/str v11344)))
   bean11342))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11346]
  (clojure.core/let
   [bean11345
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/when-let
    [v11347 (:caller-reference m11346)]
    (. bean11345 setCallerReference (clojure.core/str v11347)))
   (clojure.core/when-let
    [v11347 (:health-check-config m11346)]
    (.
     bean11345
     setHealthCheckConfig
     (route53/health-check-config v11347)))
   bean11345))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11349]
  (clojure.core/let
   [bean11348
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/when-let
    [v11350 (:health-check-id m11349)]
    (. bean11348 setHealthCheckId (clojure.core/str v11350)))
   bean11348))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11352]
  (clojure.core/let
   [bean11351
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/when-let
    [v11353 (:id m11352)]
    (. bean11351 setId (clojure.core/str v11353)))
   bean11351))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11355]
  (clojure.core/let
   [bean11354
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/when-let
    [v11356 (:id m11355)]
    (. bean11354 setId (clojure.core/str v11356)))
   bean11354))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11358]
  (clojure.core/let
   [bean11357
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/when-let
    [v11359 (:health-check-id m11358)]
    (. bean11357 setHealthCheckId (clojure.core/str v11359)))
   bean11357))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11361]
  (clojure.core/let
   [bean11360
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/when-let
    [v11362 (:name m11361)]
    (. bean11360 setName (clojure.core/str v11362)))
   (clojure.core/when-let
    [v11362 (:caller-reference m11361)]
    (. bean11360 setCallerReference (clojure.core/str v11362)))
   (clojure.core/when-let
    [v11362 (:hosted-zone-config m11361)]
    (.
     bean11360
     setHostedZoneConfig
     (route53/hosted-zone-config v11362)))
   bean11360))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11365]
   (clojure.core/let
    [credentials11366 (:credentials m11365) args11367 (:args m11365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11368
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11368
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11367 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-hosted-zone,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getHostedZone"}
   [credentials11370 & args11371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11372
     (com.palletops.awaze.common/aws-client :route53 credentials11370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11372
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11371 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11373]
   (clojure.core/let
    [credentials11374 (:credentials m11373) args11375 (:args m11373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11376
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11374)]
     (clojure.core/case
      (clojure.core/count args11375)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11376
        listHostedZones))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11376
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11375 0))))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1649__auto__]
    {:args [],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11378 & args11379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11380
     (com.palletops.awaze.common/aws-client :route53 credentials11378)]
    (clojure.core/case
     (clojure.core/count args11379)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11380
       listHostedZones))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11380
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11379 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11381]
   (clojure.core/let
    [credentials11382 (:credentials m11381) args11383 (:args m11381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11384
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11384
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11383 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [start-record-name
                         max-items
                         general-progress-listener
                         hosted-zone-id
                         start-record-identifier
                         start-record-type]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-resource-record-sets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [start-record-name
                         max-items
                         general-progress-listener
                         hosted-zone-id
                         start-record-identifier
                         start-record-type]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11386 & args11387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11388
     (com.palletops.awaze.common/aws-client :route53 credentials11386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11388
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11387 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11389]
   (clojure.core/let
    [credentials11390 (:credentials m11389) args11391 (:args m11389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11392
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11390)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11392
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11391 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [hosted-zone-id
                         general-progress-listener
                         change-batch]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :change-resource-record-sets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [hosted-zone-id
                         general-progress-listener
                         change-batch]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11394 & args11395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11396
     (com.palletops.awaze.common/aws-client :route53 credentials11394)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11396
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11395 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11397]
   (clojure.core/let
    [credentials11398 (:credentials m11397) args11399 (:args m11397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11400
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11398)]
     (clojure.core/case
      (clojure.core/count args11399)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11400
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11399 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11400
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1649__auto__]
    {:args [],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11402 & args11403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11404
     (com.palletops.awaze.common/aws-client :route53 credentials11402)]
    (clojure.core/case
     (clojure.core/count args11403)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11404
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11403 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11404
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11405]
   (clojure.core/let
    [credentials11406 (:credentials m11405) args11407 (:args m11405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11408
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11408
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11407 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-health-check,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Call createHealthCheck"}
   [credentials11410 & args11411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11412
     (com.palletops.awaze.common/aws-client :route53 credentials11410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11412
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11411 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11413]
   (clojure.core/let
    [credentials11414 (:credentials m11413) args11415 (:args m11413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11416
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11416
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11415 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-health-check,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Call getHealthCheck"}
   [credentials11418 & args11419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11420
     (com.palletops.awaze.common/aws-client :route53 credentials11418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11420
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11419 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11421]
   (clojure.core/let
    [credentials11422 (:credentials m11421) args11423 (:args m11421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11424
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11424
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11423 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-hosted-zone,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11426 & args11427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11428
     (com.palletops.awaze.common/aws-client :route53 credentials11426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11428
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11427 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11429]
   (clojure.core/let
    [credentials11430 (:credentials m11429) args11431 (:args m11429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11432
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11430)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11432
       getChange
       (route53/get-change-request (clojure.core/nth args11431 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-change,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getChange"}
   [credentials11434 & args11435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11436
     (com.palletops.awaze.common/aws-client :route53 credentials11434)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11436
      getChange
      (route53/get-change-request (clojure.core/nth args11435 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11437]
   (clojure.core/let
    [credentials11438 (:credentials m11437) args11439 (:args m11437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11440
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11440
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11439 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-health-check,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11442 & args11443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11444
     (com.palletops.awaze.common/aws-client :route53 credentials11442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11444
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11443 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11445]
   (clojure.core/let
    [credentials11446 (:credentials m11445) args11447 (:args m11445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11448
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11448
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11447 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [name
                         hosted-zone-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-hosted-zone,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [name
                         hosted-zone-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Call createHostedZone"}
   [credentials11450 & args11451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11452
     (com.palletops.awaze.common/aws-client :route53 credentials11450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11452
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11451 0))))))))
