(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m9717]
  (clojure.core/let
   [bean9716
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/when-let
    [v9718 (:policy m9717)]
    (. bean9716 setPolicy (clojure.core/str v9718)))
   (clojure.core/when-let
    [v9718 (:duration-seconds m9717)]
    (. bean9716 setDurationSeconds (clojure.core/int v9718)))
   (clojure.core/when-let
    [v9718 (:serial-number m9717)]
    (. bean9716 setSerialNumber (clojure.core/str v9718)))
   (clojure.core/when-let
    [v9718 (:token-code m9717)]
    (. bean9716 setTokenCode (clojure.core/str v9718)))
   (clojure.core/when-let
    [v9718 (:role-arn m9717)]
    (. bean9716 setRoleArn (clojure.core/str v9718)))
   (clojure.core/when-let
    [v9718 (:role-session-name m9717)]
    (. bean9716 setRoleSessionName (clojure.core/str v9718)))
   (clojure.core/when-let
    [v9718 (:external-id m9717)]
    (. bean9716 setExternalId (clojure.core/str v9718)))
   bean9716))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m9720]
  (clojure.core/let
   [bean9719
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/when-let
    [v9721 (:policy m9720)]
    (. bean9719 setPolicy (clojure.core/str v9721)))
   (clojure.core/when-let
    [v9721 (:name m9720)]
    (. bean9719 setName (clojure.core/str v9721)))
   (clojure.core/when-let
    [v9721 (:duration-seconds m9720)]
    (. bean9719 setDurationSeconds (clojure.core/int v9721)))
   bean9719))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m9723]
  (clojure.core/let
   [bean9722
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/when-let
    [v9724 (:policy m9723)]
    (. bean9722 setPolicy (clojure.core/str v9724)))
   (clojure.core/when-let
    [v9724 (:duration-seconds m9723)]
    (. bean9722 setDurationSeconds (clojure.core/int v9724)))
   (clojure.core/when-let
    [v9724 (:role-arn m9723)]
    (. bean9722 setRoleArn (clojure.core/str v9724)))
   (clojure.core/when-let
    [v9724 (:role-session-name m9723)]
    (. bean9722 setRoleSessionName (clojure.core/str v9724)))
   (clojure.core/when-let
    [v9724 (:web-identity-token m9723)]
    (. bean9722 setWebIdentityToken (clojure.core/str v9724)))
   (clojure.core/when-let
    [v9724 (:provider-id m9723)]
    (. bean9722 setProviderId (clojure.core/str v9724)))
   bean9722))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m9726]
  (clojure.core/let
   [bean9725
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/when-let
    [v9727 (:policy m9726)]
    (. bean9725 setPolicy (clojure.core/str v9727)))
   (clojure.core/when-let
    [v9727 (:duration-seconds m9726)]
    (. bean9725 setDurationSeconds (clojure.core/int v9727)))
   (clojure.core/when-let
    [v9727 (:role-arn m9726)]
    (. bean9725 setRoleArn (clojure.core/str v9727)))
   (clojure.core/when-let
    [v9727 (:principal-arn m9726)]
    (. bean9725 setPrincipalArn (clojure.core/str v9727)))
   (clojure.core/when-let
    [v9727 (:samlassertion m9726)]
    (. bean9725 setSAMLAssertion (clojure.core/str v9727)))
   bean9725))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m9729]
  (clojure.core/let
   [bean9728
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/when-let
    [v9730 (:encoded-message m9729)]
    (. bean9728 setEncodedMessage (clojure.core/str v9730)))
   bean9728))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m9732]
  (clojure.core/let
   [bean9731
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/when-let
    [v9733 (:duration-seconds m9732)]
    (. bean9731 setDurationSeconds (clojure.core/int v9733)))
   (clojure.core/when-let
    [v9733 (:serial-number m9732)]
    (. bean9731 setSerialNumber (clojure.core/str v9733)))
   (clojure.core/when-let
    [v9733 (:token-code m9732)]
    (. bean9731 setTokenCode (clojure.core/str v9733)))
   bean9731))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m9734]
   (clojure.core/let
    [credentials9735 (:credentials m9734) args9736 (:args m9734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9737
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9737
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args9736 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Call assumeRole"}
   [credentials9739 & args9740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9741
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9741
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args9740 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m9742]
   (clojure.core/let
    [credentials9743 (:credentials m9742) args9744 (:args m9742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9745
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9743)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9745
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args9744 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-federation-token,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials9747 & args9748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9749
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9747)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9749
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args9748 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m9750]
   (clojure.core/let
    [credentials9751 (:credentials m9750) args9752 (:args m9750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9753
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9753
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args9752 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials9755 & args9756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9757
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9757
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args9756 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m9758]
   (clojure.core/let
    [credentials9759 (:credentials m9758) args9760 (:args m9758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9761
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9761
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args9760 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-saml,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials9763 & args9764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9765
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9765
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args9764 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m9766]
   (clojure.core/let
    [credentials9767 (:credentials m9766) args9768 (:args m9766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9769
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9769
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args9768 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :decode-authorization-message,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials9771 & args9772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9773
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9773
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args9772 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m9774]
   (clojure.core/let
    [credentials9775 (:credentials m9774) args9776 (:args m9774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9777
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9775)]
     (clojure.core/case
      (clojure.core/count args9776)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9777
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9777
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args9776 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1649__auto__]
    {:args [],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials9779 & args9780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9781
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9779)]
    (clojure.core/case
     (clojure.core/count args9780)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9781
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9781
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args9780 0)))))))))
