(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m1754]
  (clojure.core/let
   [bean1753 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/when-let
    [v1755 (:charset m1754)]
    (. bean1753 setCharset (clojure.core/str v1755)))
   (clojure.core/when-let
    [v1755 (:data m1754)]
    (. bean1753 setData (clojure.core/str v1755)))
   bean1753))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m1757]
  (clojure.core/let
   [bean1756 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/when-let
    [v1758 (:text m1757)]
    (. bean1756 setText (simpleemail/content v1758)))
   (clojure.core/when-let
    [v1758 (:html m1757)]
    (. bean1756 setHtml (simpleemail/content v1758)))
   bean1756))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m1760]
  (clojure.core/let
   [bean1759
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/when-let
    [v1761 (:to-addresses m1760)]
    (.
     bean1759
     setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1825] (clojure.core/str arg1825))
 v1761)))
   (clojure.core/when-let
    [v1761 (:cc-addresses m1760)]
    (.
     bean1759
     setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1826] (clojure.core/str arg1826))
 v1761)))
   (clojure.core/when-let
    [v1761 (:bcc-addresses m1760)]
    (.
     bean1759
     setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1827] (clojure.core/str arg1827))
 v1761)))
   bean1759))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m1763]
  (clojure.core/let
   [bean1762 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/when-let
    [v1764 (:body m1763)]
    (. bean1762 setBody (simpleemail/body v1764)))
   (clojure.core/when-let
    [v1764 (:subject m1763)]
    (. bean1762 setSubject (simpleemail/content v1764)))
   bean1762))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m1766]
  (clojure.core/let
   [bean1765
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/when-let
    [v1767 (:data m1766)]
    (. bean1765 setData (clojure.core/identity v1767)))
   bean1765))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.NotificationType}
notification-type
  [m1769]
  (.
   com.amazonaws.services.simpleemail.model.NotificationType
   fromValue
   (clojure.core/name m1769)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m1772]
  (clojure.core/let
   [bean1771
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/when-let
    [v1773 (:source m1772)]
    (. bean1771 setSource (clojure.core/str v1773)))
   (clojure.core/when-let
    [v1773 (:destination m1772)]
    (. bean1771 setDestination (simpleemail/destination v1773)))
   (clojure.core/when-let
    [v1773 (:message m1772)]
    (. bean1771 setMessage (simpleemail/message v1773)))
   (clojure.core/when-let
    [v1773 (:reply-to-addresses m1772)]
    (.
     bean1771
     setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1828] (clojure.core/str arg1828))
 v1773)))
   (clojure.core/when-let
    [v1773 (:return-path m1772)]
    (. bean1771 setReturnPath (clojure.core/str v1773)))
   bean1771))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m1775]
  (clojure.core/let
   [bean1774
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean1774))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m1778]
  (clojure.core/let
   [bean1777
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean1777))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m1781]
  (clojure.core/let
   [bean1780
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/when-let
    [v1782 (:email-address m1781)]
    (. bean1780 setEmailAddress (clojure.core/str v1782)))
   bean1780))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m1784]
  (clojure.core/let
   [bean1783
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/when-let
    [v1785 (:identity m1784)]
    (. bean1783 setIdentity (clojure.core/str v1785)))
   (clojure.core/when-let
    [v1785 (:dkim-enabled m1784)]
    (. bean1783 setDkimEnabled (clojure.core/boolean v1785)))
   bean1783))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m1787]
  (clojure.core/let
   [bean1786
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/when-let
    [v1788 (:identity m1787)]
    (. bean1786 setIdentity (clojure.core/str v1788)))
   (clojure.core/when-let
    [v1788 (:forwarding-enabled m1787)]
    (. bean1786 setForwardingEnabled (clojure.core/boolean v1788)))
   bean1786))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m1790]
  (clojure.core/let
   [bean1789
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/when-let
    [v1791 (:source m1790)]
    (. bean1789 setSource (clojure.core/str v1791)))
   (clojure.core/when-let
    [v1791 (:destinations m1790)]
    (.
     bean1789
     setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1829] (clojure.core/str arg1829))
 v1791)))
   (clojure.core/when-let
    [v1791 (:raw-message m1790)]
    (. bean1789 setRawMessage (simpleemail/raw-message v1791)))
   bean1789))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m1793]
  (clojure.core/let
   [bean1792
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/when-let
    [v1794 (:identities m1793)]
    (.
     bean1792
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1830] (clojure.core/str arg1830))
 v1794)))
   bean1792))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m1796]
  (clojure.core/let
   [bean1795
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/when-let
    [v1797 (:identity-type m1796)]
    (. bean1795 setIdentityType (clojure.core/str v1797)))
   (clojure.core/when-let
    [v1797 (:next-token m1796)]
    (. bean1795 setNextToken (clojure.core/str v1797)))
   (clojure.core/when-let
    [v1797 (:max-items m1796)]
    (. bean1795 setMaxItems (clojure.core/int v1797)))
   bean1795))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m1799]
  (clojure.core/let
   [bean1798
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/when-let
    [v1800 (:identities m1799)]
    (.
     bean1798
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1831] (clojure.core/str arg1831))
 v1800)))
   bean1798))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m1802]
  (clojure.core/let
   [bean1801
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/when-let
    [v1803 (:domain m1802)]
    (. bean1801 setDomain (clojure.core/str v1803)))
   bean1801))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m1805]
  (clojure.core/let
   [bean1804
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/when-let
    [v1806 (:email-address m1805)]
    (. bean1804 setEmailAddress (clojure.core/str v1806)))
   bean1804))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m1808]
  (clojure.core/let
   [bean1807
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/when-let
    [v1809 (:identity m1808)]
    (. bean1807 setIdentity (clojure.core/str v1809)))
   (clojure.core/when-let
    [v1809 (:notification-type m1808)]
    (.
     bean1807
     setNotificationType
     (simpleemail/notification-type v1809)))
   (clojure.core/when-let
    [v1809 (:sns-topic m1808)]
    (. bean1807 setSnsTopic (clojure.core/str v1809)))
   bean1807))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m1811]
  (clojure.core/let
   [bean1810
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/when-let
    [v1812 (:identities m1811)]
    (.
     bean1810
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1832] (clojure.core/str arg1832))
 v1812)))
   bean1810))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m1814]
  (clojure.core/let
   [bean1813
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/when-let
    [v1815 (:domain m1814)]
    (. bean1813 setDomain (clojure.core/str v1815)))
   bean1813))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m1817]
  (clojure.core/let
   [bean1816
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean1816))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m1820]
  (clojure.core/let
   [bean1819
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/when-let
    [v1821 (:identity m1820)]
    (. bean1819 setIdentity (clojure.core/str v1821)))
   bean1819))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m1823]
  (clojure.core/let
   [bean1822
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/when-let
    [v1824 (:email-address m1823)]
    (. bean1822 setEmailAddress (clojure.core/str v1824)))
   bean1822))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m1833]
   (clojure.core/let
    [credentials1834 (:credentials m1833) args1835 (:args m1833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1836
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1836
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args1835 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         reply-to-addresses
                         message
                         destination
                         general-progress-listener]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-email,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         reply-to-addresses
                         message
                         destination
                         general-progress-listener]}]]),
    :doc "Call sendEmail"}
   [credentials1838 & args1839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1840
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1840
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args1839 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m1841]
   (clojure.core/let
    [credentials1842 (:credentials m1841) args1843 (:args m1841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1844
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1842)]
     (clojure.core/case
      (clojure.core/count args1843)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1844
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1844
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args1843 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1649__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials1846 & args1847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1848
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1846)]
    (clojure.core/case
     (clojure.core/count args1847)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1848
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1848
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args1847 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m1849]
   (clojure.core/let
    [credentials1850 (:credentials m1849) args1851 (:args m1849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1852
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1850)]
     (clojure.core/case
      (clojure.core/count args1851)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1852
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args1851 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1852
        getSendStatistics))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1649__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials1854 & args1855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1856
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1854)]
    (clojure.core/case
     (clojure.core/count args1855)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1856
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args1855 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1856
       getSendStatistics))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m1857]
   (clojure.core/let
    [credentials1858 (:credentials m1857) args1859 (:args m1857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1860
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1860
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args1859 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-verified-email-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials1862 & args1863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1864
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1864
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args1863 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m1865]
   (clojure.core/let
    [credentials1866 (:credentials m1865) args1867 (:args m1865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1868
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1868
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args1867 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         dkim-enabled]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         dkim-enabled]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials1870 & args1871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1872
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1872
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args1871 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m1873]
   (clojure.core/let
    [credentials1874 (:credentials m1873) args1875 (:args m1873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1876
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1876
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args1875 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         forwarding-enabled]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         forwarding-enabled]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials1878 & args1879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1880
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1880
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args1879 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m1881]
   (clojure.core/let
    [credentials1882 (:credentials m1881) args1883 (:args m1881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1884
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1884
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args1883 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         raw-message
                         general-progress-listener
                         destinations]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-raw-email,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         raw-message
                         general-progress-listener
                         destinations]}]]),
    :doc "Call sendRawEmail"}
   [credentials1886 & args1887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1888
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1888
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args1887 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m1889]
   (clojure.core/let
    [credentials1890 (:credentials m1889) args1891 (:args m1889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1892
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1892
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args1891 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-notification-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials1894 & args1895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1896
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1896
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args1895 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m1897]
   (clojure.core/let
    [credentials1898 (:credentials m1897) args1899 (:args m1897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1900
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1898)]
     (clojure.core/case
      (clojure.core/count args1899)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1900
        listIdentities))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1900
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args1899 0))))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-items
                         identity-type
                         general-progress-listener]}]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1649__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-items
                         identity-type
                         general-progress-listener]}]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials1902 & args1903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1904
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1902)]
    (clojure.core/case
     (clojure.core/count args1903)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1904
       listIdentities))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1904
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args1903 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m1905]
   (clojure.core/let
    [credentials1906 (:credentials m1905) args1907 (:args m1905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1908
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1908
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args1907 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials1910 & args1911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1912
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1912
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args1911 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m1913]
   (clojure.core/let
    [credentials1914 (:credentials m1913) args1915 (:args m1913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1916
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1916
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args1915 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-dkim,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials1918 & args1919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1920
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1920
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args1919 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m1921]
   (clojure.core/let
    [credentials1922 (:credentials m1921) args1923 (:args m1921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1924
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1924
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args1923 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-address,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials1926 & args1927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1928
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1928
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args1927 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m1929]
   (clojure.core/let
    [credentials1930 (:credentials m1929) args1931 (:args m1929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1932
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1932
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args1931 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         notification-type
                         identity
                         general-progress-listener]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-notification-topic,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         notification-type
                         identity
                         general-progress-listener]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials1934 & args1935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1936
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1936
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args1935 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m1937]
   (clojure.core/let
    [credentials1938 (:credentials m1937) args1939 (:args m1937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1940
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1940
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args1939 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-verification-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials1942 & args1943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1944
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1944
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args1943 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m1945]
   (clojure.core/let
    [credentials1946 (:credentials m1945) args1947 (:args m1945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1948
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1948
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args1947 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials1950 & args1951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1952
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1952
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args1951 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m1953]
   (clojure.core/let
    [credentials1954 (:credentials m1953) args1955 (:args m1953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1956
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1954)]
     (clojure.core/case
      (clojure.core/count args1955)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1956
        getSendQuota))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1956
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args1955 0))))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1649__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials1958 & args1959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1960
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1958)]
    (clojure.core/case
     (clojure.core/count args1959)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1960
       getSendQuota))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1960
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args1959 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m1961]
   (clojure.core/let
    [credentials1962 (:credentials m1961) args1963 (:args m1961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1964
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1964
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args1963 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [identity general-progress-listener]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [identity general-progress-listener]}]]),
    :doc "Call deleteIdentity"}
   [credentials1966 & args1967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1968
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1968
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args1967 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m1969]
   (clojure.core/let
    [credentials1970 (:credentials m1969) args1971 (:args m1969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1972
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1972
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args1971 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials1974 & args1975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1976
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1976
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args1975 0))))))))
