(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1599__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m4779]
   (clojure.core/let
    [credentials4780 (:credentials m4779) args4781 (:args m4779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4782
      (com.palletops.awaze.common/aws-client :sts credentials4780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4782
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args4781 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Call assumeRole"}
   [credentials4784 & args4785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4786
     (com.palletops.awaze.common/aws-client :sts credentials4784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4786
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args4785 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m4787]
   (clojure.core/let
    [credentials4788 (:credentials m4787) args4789 (:args m4787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4790
      (com.palletops.awaze.common/aws-client :sts credentials4788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4790
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args4789 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-federation-token,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials4792 & args4793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4794
     (com.palletops.awaze.common/aws-client :sts credentials4792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4794
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args4793 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m4795]
   (clojure.core/let
    [credentials4796 (:credentials m4795) args4797 (:args m4795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4798
      (com.palletops.awaze.common/aws-client :sts credentials4796)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4798
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args4797 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials4800 & args4801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4802
     (com.palletops.awaze.common/aws-client :sts credentials4800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4802
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args4801 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m4803]
   (clojure.core/let
    [credentials4804 (:credentials m4803) args4805 (:args m4803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4806
      (com.palletops.awaze.common/aws-client :sts credentials4804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4806
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args4805 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-saml,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials4808 & args4809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4810
     (com.palletops.awaze.common/aws-client :sts credentials4808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4810
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args4809 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m4811]
   (clojure.core/let
    [credentials4812 (:credentials m4811) args4813 (:args m4811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4814
      (com.palletops.awaze.common/aws-client :sts credentials4812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4814
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args4813 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :decode-authorization-message,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials4816 & args4817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4818
     (com.palletops.awaze.common/aws-client :sts credentials4816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4818
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args4817 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m4819]
   (clojure.core/let
    [credentials4820 (:credentials m4819) args4821 (:args m4819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4822
      (com.palletops.awaze.common/aws-client :sts credentials4820)]
     (clojure.core/case
      (clojure.core/count args4821)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4822
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4822
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args4821 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1649__auto__]
    {:args [],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials4824 & args4825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4826
     (com.palletops.awaze.common/aws-client :sts credentials4824)]
    (clojure.core/case
     (clojure.core/count args4825)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4826
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4826
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args4825 0)))))))))
