/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.ParallelCompactionIterable;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    protected static long totalBytesCompacted = 0L;
    private Set<SSTableReader> toCompact;
    private CompactionManager.CompactionExecutorStatsCollector collector;

    public CompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) {
        super(cfs, sstables);
        this.gcBefore = gcBefore;
        this.toCompact = new HashSet<SSTableReader>(sstables);
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    protected int executeInternal(CompactionManager.CompactionExecutorStatsCollector collector) {
        this.collector = collector;
        this.run();
        return this.toCompact.size();
    }

    @Override
    public long getExpectedWriteSize() {
        return this.cfs.getExpectedCompactedFileSize(this.toCompact, this.compactionType);
    }

    @Override
    public boolean reduceScopeForLimitedSpace() {
        if (this.partialCompactionsAcceptable() && this.toCompact.size() > 1) {
            logger.warn("insufficient space to compact all requested files " + StringUtils.join(this.toCompact, (String)", "));
            return this.toCompact.remove(this.cfs.getMaxSizeFile(this.toCompact));
        }
        return false;
    }

    @Override
    protected void runWith(File sstableDirectory) throws Exception {
        assert (this.sstables != null && sstableDirectory != null);
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-compact-" + this.cfs.columnFamily);
        }
        for (SSTableReader sstable : this.toCompact) {
            assert (sstable.descriptor.cfname.equals(this.cfs.columnFamily));
        }
        CompactionController controller = new CompactionController(this.cfs, this.toCompact, this.gcBefore);
        logger.info("Compacting {}", this.toCompact);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        AbstractCompactionStrategy strategy = this.cfs.getCompactionStrategy();
        long estimatedTotalKeys = Math.max((long)DatabaseDescriptor.getIndexInterval().intValue(), SSTableReader.getApproximateKeyCount(this.toCompact));
        long estimatedSSTables = Math.max(1L, SSTable.getTotalBytes(this.toCompact) / strategy.getMaxSSTableSize());
        long keysPerSSTable = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + keysPerSSTable);
        }
        AbstractCompactionIterable ci = DatabaseDescriptor.isMultithreadedCompaction() ? new ParallelCompactionIterable(this.compactionType, strategy.getScanners(this.toCompact), controller) : new CompactionIterable(this.compactionType, strategy.getScanners(this.toCompact), controller);
        Iterator iter = ci.iterator();
        HashMap<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        HashMap<Descriptor, HashMap<DecoratedKey, RowIndexEntry>> cachedKeyMap = new HashMap<Descriptor, HashMap<DecoratedKey, RowIndexEntry>>();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        ArrayList<SSTableWriter> writers = new ArrayList<SSTableWriter>();
        if (this.collector != null) {
            this.collector.beginCompaction(ci);
        }
        try {
            if (!iter.hasNext()) {
                this.cfs.markCompacted(this.toCompact, this.compactionType);
                return;
            }
            SSTableWriter writer = this.cfs.createCompactionWriter(keysPerSSTable, sstableDirectory, this.toCompact);
            writers.add(writer);
            while (iter.hasNext()) {
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                if (row.isEmpty()) {
                    controller.invalidateCachedRow(row.key);
                    row.close();
                    continue;
                }
                controller.removeDeletedInCache(row.key);
                RowIndexEntry indexEntry = writer.append(row);
                ++totalkeysWritten;
                if (DatabaseDescriptor.getPreheatKeyCache()) {
                    for (SSTableReader sstable : this.toCompact) {
                        if (sstable.getCachedPosition(row.key, false) == null) continue;
                        cachedKeys.put(row.key, indexEntry);
                        break;
                    }
                }
                if (!this.newSSTableSegmentThresholdReached(writer)) continue;
                cachedKeyMap.put(writer.descriptor.asTemporary(false), cachedKeys);
                writer = this.cfs.createCompactionWriter(keysPerSSTable, sstableDirectory, this.toCompact);
                writers.add(writer);
                cachedKeys = new HashMap();
            }
            if (writer.getFilePointer() > 0L) {
                cachedKeyMap.put(writer.descriptor.asTemporary(false), cachedKeys);
            } else {
                writer.abort();
                writers.remove(writer);
            }
            long maxAge = CompactionTask.getMaxDataAge(this.toCompact);
            for (SSTableWriter completedWriter : writers) {
                sstables.add(completedWriter.closeAndOpenReader(maxAge));
            }
        }
        catch (Throwable t) {
            for (SSTableWriter writer : writers) {
                writer.abort();
            }
            for (SSTableReader sstable : sstables) {
                sstable.markCompacted();
                sstable.releaseReference();
            }
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            controller.close();
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.collector != null) {
                this.collector.finishCompaction(ci);
            }
        }
        this.cfs.replaceCompactedSSTables(this.toCompact, sstables, this.compactionType);
        for (SSTableReader sstable : sstables) {
            for (Map.Entry entry : ((Map)cachedKeyMap.get(sstable.descriptor)).entrySet()) {
                sstable.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        if (logger.isInfoEnabled()) {
            long dTime = System.currentTimeMillis() - startTime;
            long startsize = SSTable.getTotalBytes(this.toCompact);
            long endsize = SSTable.getTotalBytes(sstables);
            double ratio = (double)endsize / (double)startsize;
            StringBuilder builder = new StringBuilder();
            for (SSTableReader reader : sstables) {
                builder.append(reader.descriptor.baseFilename()).append(",");
            }
            double mbps = dTime > 0L ? (double)endsize / 1048576.0 / ((double)dTime / 1000.0) : 0.0;
            long totalSourceRows = 0L;
            long[] counts = ci.getMergedRowCounts();
            StringBuilder mergeSummary = new StringBuilder(counts.length * 10);
            for (int i = 0; i < counts.length; ++i) {
                int rows = i + 1;
                long count = counts[i];
                totalSourceRows += (long)rows * count;
                mergeSummary.append(String.format("%d:%d, ", rows, count));
            }
            logger.info(String.format("Compacted %d sstables to [%s].  %,d bytes to %,d (~%d%% of original) in %,dms = %fMB/s.  %,d total rows, %,d unique.  Row merge counts were {%s}", this.toCompact.size(), builder.toString(), startsize, endsize, (int)(ratio * 100.0), dTime, mbps, totalSourceRows, totalkeysWritten, mergeSummary.toString()));
            logger.debug(String.format("CF Total Bytes Compacted: %,d", CompactionTask.addToTotalBytesCompacted(endsize)));
        }
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return false;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }
}

