/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.thrift.IndexExpression;

public abstract class SecondaryIndexSearcher {
    protected final SecondaryIndexManager indexManager;
    protected final Set<ByteBuffer> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public abstract List<Row> search(List<IndexExpression> var1, AbstractBounds<RowPosition> var2, int var3, IDiskAtomFilter var4, boolean var5);

    public abstract boolean isIndexing(List<IndexExpression> var1);

    protected boolean isIndexValueStale(ColumnFamily liveData, ByteBuffer indexedColumnName, ByteBuffer indexedValue) {
        IColumn liveColumn = liveData.getColumn(indexedColumnName);
        if (liveColumn == null || liveColumn.isMarkedForDelete()) {
            return true;
        }
        ByteBuffer liveValue = liveColumn.value();
        return 0 != liveData.metadata().getValueValidator(indexedColumnName).compare(indexedValue, liveValue);
    }
}

