(ns bionlp.util
  "Utility methods for bionlp project")

(def regex-char-esc-smap
  (let [esc-chars "()*&^%$!+.[]?\\|{}"]
    (zipmap esc-chars
            (map #(str "\\" %) esc-chars))))

(defmacro make-fn
  "A macro to turn other macros into function. E.g. 'and'.
   So that they can be passed as argument to other functions

   Example
   ```
   (apply (make-fn or) '(false false 1))
   ```"
  [m] 
 `(fn [& args#]
    (eval 
      (cons '~m args#))))

(defn str-escape-regex-chars
  [string]
  (->> string
       (replace regex-char-esc-smap)
       (reduce str)))
