/*
 * Decompiled with CFR 0.152.
 */
package clojure;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IObj;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;

public final class core$fn__9913
extends AFunction {
    public static final AFn const__0 = (AFn)((Object)((IObj)Symbol.intern(null, "clojure.string")).withMeta(RT.map(RT.keyword(null, "doc"), "Clojure String utilities\n\nIt is poor form to (:use clojure.string). Instead, use require\nwith :as to specify a prefix, e.g.\n\n(ns your.namespace.here\n  (:require [clojure.string :as str]))\n\nDesign notes for clojure.string:\n\n1. Strings are objects (as opposed to sequences). As such, the\n   string being manipulated is the first argument to a function;\n   passing nil will result in a NullPointerException unless\n   documented otherwise. If you want sequence-y behavior instead,\n   use a sequence.\n\n2. Functions are generally not lazy, and call straight to host\n   methods where those are available and efficient.\n\n3. Functions take advantage of String implementation details to\n   write high-performing loop/recurs instead of using higher-order\n   functions. (This is not idiomatic in general-purpose application\n   code.)\n\n4. When a function is documented to accept a string argument, it\n   will take any implementation of the correct *interface* on the\n   host platform. In Java, this is CharSequence, which is more\n   general than String. In ordinary usage you will almost always\n   pass concrete strings. If you are doing something unusual,\n   e.g. passing a mutable implementation of CharSequence, then\n   thread-safety is your responsibility.", RT.keyword(null, "author"), "Stuart Sierra, Stuart Halloway, David Liebke")));

    public static Object invokeStatic() {
        Object v2;
        Namespace n__5639__auto__9915;
        Namespace namespace2 = n__5639__auto__9915 = Namespace.find((Symbol)const__0);
        if (namespace2 != null && namespace2 != Boolean.FALSE) {
            Namespace namespace3 = n__5639__auto__9915;
            n__5639__auto__9915 = null;
            namespace3.reset();
            v2 = null;
        } else {
            v2 = null;
        }
        return v2;
    }

    public Object invoke() {
        return core$fn__9913.invokeStatic();
    }
}

