/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.RT;
import clojure.lang.Util;
import clojure.lang.Var;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MultiFn
extends AFn {
    public final IFn dispatchFn;
    public final Object defaultDispatchVal;
    public final IRef hierarchy;
    final String name;
    final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
    volatile IPersistentMap methodTable;
    volatile IPersistentMap preferTable;
    volatile IPersistentMap methodCache;
    volatile Object cachedHierarchy;
    static final Var assoc = RT.var("clojure.core", "assoc");
    static final Var dissoc = RT.var("clojure.core", "dissoc");
    static final Var isa = RT.var("clojure.core", "isa?");
    static final Var parents = RT.var("clojure.core", "parents");

    public MultiFn(String name, IFn dispatchFn, Object defaultDispatchVal, IRef hierarchy) {
        this.name = name;
        this.dispatchFn = dispatchFn;
        this.defaultDispatchVal = defaultDispatchVal;
        this.methodTable = PersistentHashMap.EMPTY;
        this.methodCache = this.getMethodTable();
        this.preferTable = PersistentHashMap.EMPTY;
        this.hierarchy = hierarchy;
        this.cachedHierarchy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFn reset() {
        this.rw.writeLock().lock();
        try {
            this.methodCache = this.preferTable = PersistentHashMap.EMPTY;
            this.methodTable = this.preferTable;
            this.cachedHierarchy = null;
            MultiFn multiFn = this;
            return multiFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFn addMethod(Object dispatchVal, IFn method) {
        this.rw.writeLock().lock();
        try {
            this.methodTable = this.getMethodTable().assoc(dispatchVal, method);
            this.resetCache();
            MultiFn multiFn = this;
            return multiFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFn removeMethod(Object dispatchVal) {
        this.rw.writeLock().lock();
        try {
            this.methodTable = this.getMethodTable().without(dispatchVal);
            this.resetCache();
            MultiFn multiFn = this;
            return multiFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiFn preferMethod(Object dispatchValX, Object dispatchValY) {
        this.rw.writeLock().lock();
        try {
            if (this.prefers(dispatchValY, dispatchValX)) {
                throw new IllegalStateException(String.format("Preference conflict in multimethod '%s': %s is already preferred to %s", this.name, dispatchValY, dispatchValX));
            }
            this.preferTable = this.getPreferTable().assoc(dispatchValX, RT.conj((IPersistentCollection)RT.get(this.getPreferTable(), dispatchValX, PersistentHashSet.EMPTY), dispatchValY));
            this.resetCache();
            MultiFn multiFn = this;
            return multiFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    private boolean prefers(Object x, Object y) {
        ISeq ps;
        IPersistentSet xprefs = (IPersistentSet)this.getPreferTable().valAt(x);
        if (xprefs != null && xprefs.contains(y)) {
            return true;
        }
        for (ps = RT.seq(parents.invoke(y)); ps != null; ps = ps.next()) {
            if (!this.prefers(x, ps.first())) continue;
            return true;
        }
        for (ps = RT.seq(parents.invoke(x)); ps != null; ps = ps.next()) {
            if (!this.prefers(ps.first(), y)) continue;
            return true;
        }
        return false;
    }

    private boolean isA(Object x, Object y) {
        return RT.booleanCast(isa.invoke(this.hierarchy.deref(), x, y));
    }

    private boolean dominates(Object x, Object y) {
        return this.prefers(x, y) || this.isA(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersistentMap resetCache() {
        this.rw.writeLock().lock();
        try {
            this.methodCache = this.getMethodTable();
            this.cachedHierarchy = this.hierarchy.deref();
            IPersistentMap iPersistentMap = this.methodCache;
            return iPersistentMap;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    public IFn getMethod(Object dispatchVal) {
        IFn targetFn;
        if (this.cachedHierarchy != this.hierarchy.deref()) {
            this.resetCache();
        }
        if ((targetFn = (IFn)this.methodCache.valAt(dispatchVal)) != null) {
            return targetFn;
        }
        return this.findAndCacheBestMethod(dispatchVal);
    }

    private IFn getFn(Object dispatchVal) {
        IFn targetFn = this.getMethod(dispatchVal);
        if (targetFn == null) {
            throw new IllegalArgumentException(String.format("No method in multimethod '%s' for dispatch value: %s", this.name, dispatchVal));
        }
        return targetFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFn findAndCacheBestMethod(Object dispatchVal) {
        Object bestValue;
        this.rw.readLock().lock();
        IPersistentMap mt = this.methodTable;
        IPersistentMap pt = this.preferTable;
        Object ch = this.cachedHierarchy;
        try {
            Map.Entry bestEntry = null;
            for (Object o : this.getMethodTable()) {
                Map.Entry e = (Map.Entry)o;
                if (!this.isA(dispatchVal, e.getKey())) continue;
                if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                    bestEntry = e;
                }
                if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
                throw new IllegalArgumentException(String.format("Multiple methods in multimethod '%s' match dispatch value: %s -> %s and %s, and neither is preferred", this.name, dispatchVal, e.getKey(), bestEntry.getKey()));
            }
            if (bestEntry == null) {
                bestValue = this.methodTable.valAt(this.defaultDispatchVal);
                if (bestValue == null) {
                    IFn iFn = null;
                    return iFn;
                }
            } else {
                bestValue = bestEntry.getValue();
            }
        }
        finally {
            this.rw.readLock().unlock();
        }
        this.rw.writeLock().lock();
        try {
            IFn iFn;
            if (mt == this.methodTable && pt == this.preferTable && ch == this.cachedHierarchy && this.cachedHierarchy == this.hierarchy.deref()) {
                this.methodCache = this.methodCache.assoc(dispatchVal, bestValue);
                iFn = (IFn)bestValue;
                return iFn;
            }
            this.resetCache();
            iFn = this.findAndCacheBestMethod(dispatchVal);
            return iFn;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    @Override
    public Object invoke() {
        return this.getFn(this.dispatchFn.invoke()).invoke();
    }

    @Override
    public Object invoke(Object arg1) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1));
        Object object = arg1;
        arg1 = null;
        return iFn.invoke(Util.ret1(object, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null));
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        IFn iFn = this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args));
        Object object = arg1;
        arg1 = null;
        Object object2 = arg2;
        arg2 = null;
        Object object3 = arg3;
        arg3 = null;
        Object object4 = arg4;
        arg4 = null;
        Object object5 = arg5;
        arg5 = null;
        Object object6 = arg6;
        arg6 = null;
        Object object7 = arg7;
        arg7 = null;
        Object object8 = arg8;
        arg8 = null;
        Object object9 = arg9;
        arg9 = null;
        Object object10 = arg10;
        arg10 = null;
        Object object11 = arg11;
        arg11 = null;
        Object object12 = arg12;
        arg12 = null;
        Object object13 = arg13;
        arg13 = null;
        Object object14 = arg14;
        arg14 = null;
        Object object15 = arg15;
        arg15 = null;
        Object object16 = arg16;
        arg16 = null;
        Object object17 = arg17;
        arg17 = null;
        Object object18 = arg18;
        arg18 = null;
        Object object19 = arg19;
        arg19 = null;
        Object object20 = arg20;
        arg20 = null;
        return iFn.invoke(Util.ret1(object, null), Util.ret1(object2, null), Util.ret1(object3, null), Util.ret1(object4, null), Util.ret1(object5, null), Util.ret1(object6, null), Util.ret1(object7, null), Util.ret1(object8, null), Util.ret1(object9, null), Util.ret1(object10, null), Util.ret1(object11, null), Util.ret1(object12, null), Util.ret1(object13, null), Util.ret1(object14, null), Util.ret1(object15, null), Util.ret1(object16, null), Util.ret1(object17, null), Util.ret1(object18, null), Util.ret1(object19, null), Util.ret1(object20, null), args);
    }

    public IPersistentMap getMethodTable() {
        return this.methodTable;
    }

    public IPersistentMap getPreferTable() {
        return this.preferTable;
    }
}

