/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Agent;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Ref;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LockingTransaction {
    public static final int RETRY_LIMIT = 10000;
    public static final int LOCK_WAIT_MSECS = 100;
    public static final long BARGE_WAIT_NANOS = 10000000L;
    static final int RUNNING = 0;
    static final int COMMITTING = 1;
    static final int RETRY = 2;
    static final int KILLED = 3;
    static final int COMMITTED = 4;
    static final ThreadLocal<LockingTransaction> transaction = new ThreadLocal();
    private static final AtomicLong lastPoint = new AtomicLong();
    Info info;
    long readPoint;
    long startPoint;
    long startTime;
    final RetryEx retryex = new RetryEx();
    final ArrayList<Agent.Action> actions = new ArrayList();
    final HashMap<Ref, Object> vals = new HashMap();
    final HashSet<Ref> sets = new HashSet();
    final TreeMap<Ref, ArrayList<CFn>> commutes = new TreeMap();
    final HashSet<Ref> ensures = new HashSet();

    void getReadPoint() {
        this.readPoint = lastPoint.incrementAndGet();
    }

    long getCommitPoint() {
        return lastPoint.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(int status) {
        if (this.info != null) {
            Info info = this.info;
            synchronized (info) {
                this.info.status.set(status);
                this.info.latch.countDown();
            }
            this.info = null;
            this.vals.clear();
            this.sets.clear();
            this.commutes.clear();
        }
    }

    void tryWriteLock(Ref ref) {
        try {
            if (!ref.lock.writeLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
                throw this.retryex;
            }
        }
        catch (InterruptedException e) {
            throw this.retryex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lock(Ref ref) {
        this.releaseIfEnsured(ref);
        boolean unlocked = true;
        try {
            this.tryWriteLock(ref);
            unlocked = false;
            if (ref.tvals != null && ref.tvals.point > this.readPoint) {
                throw this.retryex;
            }
            Info refinfo = ref.tinfo;
            if (refinfo != null && refinfo != this.info && refinfo.running() && !this.barge(refinfo)) {
                ref.lock.writeLock().unlock();
                unlocked = true;
                Object object = this.blockAndBail(refinfo);
                return object;
            }
            ref.tinfo = this.info;
            Object object = ref.tvals == null ? null : ref.tvals.val;
            return object;
        }
        finally {
            if (!unlocked) {
                ref.lock.writeLock().unlock();
            }
        }
    }

    private Object blockAndBail(Info refinfo) {
        this.stop(2);
        try {
            refinfo.latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw this.retryex;
    }

    private void releaseIfEnsured(Ref ref) {
        if (this.ensures.contains(ref)) {
            this.ensures.remove(ref);
            ref.lock.readLock().unlock();
        }
    }

    void abort() throws AbortException {
        this.stop(3);
        throw new AbortException();
    }

    private boolean bargeTimeElapsed() {
        return System.nanoTime() - this.startTime > 10000000L;
    }

    private boolean barge(Info refinfo) {
        boolean barged = false;
        if (this.bargeTimeElapsed() && this.startPoint < refinfo.startPoint && (barged = refinfo.status.compareAndSet(0, 3))) {
            refinfo.latch.countDown();
        }
        return barged;
    }

    static LockingTransaction getEx() {
        LockingTransaction t = transaction.get();
        if (t == null || t.info == null) {
            throw new IllegalStateException("No transaction running");
        }
        return t;
    }

    public static boolean isRunning() {
        return LockingTransaction.getRunning() != null;
    }

    static LockingTransaction getRunning() {
        LockingTransaction t = transaction.get();
        if (t == null || t.info == null) {
            return null;
        }
        return t;
    }

    public static Object runInTransaction(Callable fn) throws Exception {
        Object ret;
        LockingTransaction t = transaction.get();
        if (t == null) {
            t = new LockingTransaction();
            transaction.set(t);
            try {
                ret = t.run(fn);
            }
            finally {
                transaction.remove();
            }
        } else {
            ret = t.info != null ? fn.call() : t.run(fn);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    Object run(Callable fn) throws Exception {
        boolean done = false;
        Object ret = null;
        ArrayList<Ref> locked = new ArrayList<Ref>();
        ArrayList<Notify> notify = new ArrayList<Notify>();
        for (int i = 0; !done && i < 10000; ++i) {
            block40: {
                Ref ref;
                this.getReadPoint();
                if (i == 0) {
                    this.startPoint = this.readPoint;
                    this.startTime = System.nanoTime();
                }
                this.info = new Info(0, this.startPoint);
                ret = fn.call();
                if (!this.info.status.compareAndSet(0, 1)) break block40;
                for (Map.Entry e : this.commutes.entrySet()) {
                    ref = (Ref)e.getKey();
                    if (this.sets.contains(ref)) continue;
                    boolean wasEnsured = this.ensures.contains(ref);
                    this.releaseIfEnsured(ref);
                    this.tryWriteLock(ref);
                    locked.add(ref);
                    if (wasEnsured && ref.tvals != null && ref.tvals.point > this.readPoint) {
                        throw this.retryex;
                    }
                    Info refinfo = ref.tinfo;
                    if (refinfo != null && refinfo != this.info && refinfo.running() && !this.barge(refinfo)) {
                        throw this.retryex;
                    }
                    Object val = ref.tvals == null ? null : ref.tvals.val;
                    this.vals.put(ref, val);
                    for (CFn f : (ArrayList)e.getValue()) {
                        this.vals.put(ref, f.fn.applyTo(RT.cons(this.vals.get(ref), f.args)));
                    }
                }
                for (Ref ref2 : this.sets) {
                    this.tryWriteLock(ref2);
                    locked.add(ref2);
                }
                for (Map.Entry e : this.vals.entrySet()) {
                    ref = (Ref)e.getKey();
                    ref.validate(ref.getValidator(), e.getValue());
                }
                long commitPoint = this.getCommitPoint();
                for (Map.Entry<Ref, Object> e : this.vals.entrySet()) {
                    Ref ref3 = e.getKey();
                    Object oldval = ref3.tvals == null ? null : ref3.tvals.val;
                    Object newval = e.getValue();
                    int hcount = ref3.histCount();
                    if (ref3.tvals == null) {
                        ref3.tvals = new Ref.TVal(newval, commitPoint);
                    } else if (ref3.faults.get() > 0 && hcount < ref3.maxHistory || hcount < ref3.minHistory) {
                        ref3.tvals = new Ref.TVal(newval, commitPoint, ref3.tvals);
                        ref3.faults.set(0);
                    } else {
                        ref3.tvals = ref3.tvals.next;
                        ref3.tvals.val = newval;
                        ref3.tvals.point = commitPoint;
                    }
                    if (ref3.getWatches().count() <= 0) continue;
                    notify.add(new Notify(ref3, oldval, newval));
                }
                done = true;
                this.info.status.set(4);
            }
            for (int k = locked.size() - 1; k >= 0; --k) {
                ((Ref)locked.get((int)k)).lock.writeLock().unlock();
            }
            locked.clear();
            for (Ref r : this.ensures) {
                r.lock.readLock().unlock();
            }
            this.ensures.clear();
            this.stop(done ? 4 : 2);
            try {
                if (!done) continue;
                for (Notify n : notify) {
                    n.ref.notifyWatches(n.oldval, n.newval);
                }
                for (Agent.Action action : this.actions) {
                    Agent.dispatchAction(action);
                }
                continue;
            }
            finally {
                notify.clear();
                this.actions.clear();
            }
            catch (RetryEx k) {
                for (int k2 = locked.size() - 1; k2 >= 0; --k2) {
                    ((Ref)locked.get((int)k2)).lock.writeLock().unlock();
                }
                locked.clear();
                for (Ref r : this.ensures) {
                    r.lock.readLock().unlock();
                }
                this.ensures.clear();
                this.stop(done ? 4 : 2);
                try {
                    if (!done) continue;
                    for (Notify n : notify) {
                        n.ref.notifyWatches(n.oldval, n.newval);
                    }
                    for (Agent.Action action : this.actions) {
                        Agent.dispatchAction(action);
                    }
                    continue;
                }
                finally {
                    notify.clear();
                    this.actions.clear();
                }
                catch (Throwable throwable) {
                    for (int k3 = locked.size() - 1; k3 >= 0; --k3) {
                        ((Ref)locked.get((int)k3)).lock.writeLock().unlock();
                    }
                    locked.clear();
                    for (Ref r : this.ensures) {
                        r.lock.readLock().unlock();
                    }
                    this.ensures.clear();
                    this.stop(done ? 4 : 2);
                    try {
                        if (done) {
                            for (Notify n : notify) {
                                n.ref.notifyWatches(n.oldval, n.newval);
                            }
                            for (Agent.Action action : this.actions) {
                                Agent.dispatchAction(action);
                            }
                        }
                    }
                    finally {
                        notify.clear();
                        this.actions.clear();
                    }
                    throw throwable;
                }
            }
        }
        if (!done) {
            throw Util.runtimeException("Transaction failed after reaching retry limit");
        }
        return ret;
    }

    public void enqueue(Agent.Action action) {
        this.actions.add(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doGet(Ref ref) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.vals.containsKey(ref)) {
            return this.vals.get(ref);
        }
        try {
            ref.lock.readLock().lock();
            if (ref.tvals == null) {
                throw new IllegalStateException(ref.toString() + " is unbound.");
            }
            Ref.TVal ver = ref.tvals;
            do {
                if (ver.point > this.readPoint) continue;
                Object object = ver.val;
                return object;
            } while ((ver = ver.prior) != ref.tvals);
        }
        finally {
            ref.lock.readLock().unlock();
        }
        ref.faults.incrementAndGet();
        throw this.retryex;
    }

    Object doSet(Ref ref, Object val) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.commutes.containsKey(ref)) {
            throw new IllegalStateException("Can't set after commute");
        }
        if (!this.sets.contains(ref)) {
            this.sets.add(ref);
            this.lock(ref);
        }
        this.vals.put(ref, val);
        return val;
    }

    void doEnsure(Ref ref) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.ensures.contains(ref)) {
            return;
        }
        ref.lock.readLock().lock();
        if (ref.tvals != null && ref.tvals.point > this.readPoint) {
            ref.lock.readLock().unlock();
            throw this.retryex;
        }
        Info refinfo = ref.tinfo;
        if (refinfo != null && refinfo.running()) {
            ref.lock.readLock().unlock();
            if (refinfo != this.info) {
                this.blockAndBail(refinfo);
            }
        } else {
            this.ensures.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doCommute(Ref ref, IFn fn, ISeq args) {
        ArrayList<CFn> fns;
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (!this.vals.containsKey(ref)) {
            Object val = null;
            try {
                ref.lock.readLock().lock();
                val = ref.tvals == null ? null : ref.tvals.val;
            }
            finally {
                ref.lock.readLock().unlock();
            }
            this.vals.put(ref, val);
        }
        if ((fns = this.commutes.get(ref)) == null) {
            fns = new ArrayList();
            this.commutes.put(ref, fns);
        }
        fns.add(new CFn(fn, args));
        Object ret = fn.applyTo(RT.cons(this.vals.get(ref), args));
        this.vals.put(ref, ret);
        return ret;
    }

    static class Notify {
        public final Ref ref;
        public final Object oldval;
        public final Object newval;

        Notify(Ref ref, Object oldval, Object newval) {
            this.ref = ref;
            this.oldval = oldval;
            this.newval = newval;
        }
    }

    static class CFn {
        final IFn fn;
        final ISeq args;

        public CFn(IFn fn, ISeq args) {
            this.fn = fn;
            this.args = args;
        }
    }

    public static class Info {
        final AtomicInteger status;
        final long startPoint;
        final CountDownLatch latch;

        public Info(int status, long startPoint) {
            this.status = new AtomicInteger(status);
            this.startPoint = startPoint;
            this.latch = new CountDownLatch(1);
        }

        public boolean running() {
            int s = this.status.get();
            return s == 0 || s == 1;
        }
    }

    static class AbortException
    extends Exception {
        AbortException() {
        }
    }

    static class RetryEx
    extends Error {
        RetryEx() {
        }
    }
}

