/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.ITransientAssociative2;
import clojure.lang.ITransientMap;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import java.util.Map;

public abstract class ATransientMap
extends AFn
implements ITransientMap,
ITransientAssociative2 {
    private static final Object NOT_FOUND = new Object();

    abstract void ensureEditable();

    abstract ITransientMap doAssoc(Object var1, Object var2);

    abstract ITransientMap doWithout(Object var1);

    abstract Object doValAt(Object var1, Object var2);

    abstract int doCount();

    abstract IPersistentMap doPersistent();

    @Override
    public ITransientMap conj(Object o) {
        this.ensureEditable();
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.assoc(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        ITransientMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Override
    public final Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    @Override
    public final Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    @Override
    public final Object valAt(Object key) {
        return this.valAt(key, null);
    }

    @Override
    public final ITransientMap assoc(Object key, Object val) {
        this.ensureEditable();
        return this.doAssoc(key, val);
    }

    @Override
    public final ITransientMap without(Object key) {
        this.ensureEditable();
        return this.doWithout(key);
    }

    @Override
    public final IPersistentMap persistent() {
        this.ensureEditable();
        return this.doPersistent();
    }

    @Override
    public final Object valAt(Object key, Object notFound) {
        this.ensureEditable();
        return this.doValAt(key, notFound);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.valAt(key, NOT_FOUND) != NOT_FOUND;
    }

    @Override
    public final IMapEntry entryAt(Object key) {
        Object v = this.valAt(key, NOT_FOUND);
        if (v != NOT_FOUND) {
            return MapEntry.create(key, v);
        }
        return null;
    }

    @Override
    public final int count() {
        this.ensureEditable();
        return this.doCount();
    }
}

