/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm.commons;

import clojure.asm.ClassVisitor;
import clojure.asm.FieldVisitor;
import clojure.asm.MethodVisitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class SerialVersionUIDAdder
extends ClassVisitor {
    private static final String CLINIT = "<clinit>";
    private boolean computeSVUID;
    private boolean hasSVUID;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields;
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors;
    private Collection<Item> svuidMethods;

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(393216, classVisitor);
        if (this.getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        boolean bl = this.computeSVUID = (access & 0x4000) == 0;
        if (this.computeSVUID) {
            this.name = name2;
            this.access = access;
            this.interfaces = new String[interfaces.length];
            this.svuidFields = new ArrayList<Item>();
            this.svuidConstructors = new ArrayList<Item>();
            this.svuidMethods = new ArrayList<Item>();
            System.arraycopy(interfaces, 0, this.interfaces, 0, interfaces.length);
        }
        super.visit(version, access, name2, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature, String[] exceptions) {
        if (this.computeSVUID) {
            if (CLINIT.equals(name2)) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if ("<init>".equals(name2)) {
                    this.svuidConstructors.add(new Item(name2, mods, descriptor2));
                } else if (!CLINIT.equals(name2)) {
                    this.svuidMethods.add(new Item(name2, mods, descriptor2));
                }
            }
        }
        return super.visitMethod(access, name2, descriptor2, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value) {
        if (this.computeSVUID) {
            if ("serialVersionUID".equals(name2)) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                int mods = access & 0xDF;
                this.svuidFields.add(new Item(name2, mods, desc));
            }
        }
        return super.visitField(access, name2, desc, signature, value);
    }

    @Override
    public void visitInnerClass(String innerClassName, String outerName, String innerName, int innerClassAccess) {
        if (this.name != null && this.name.equals(innerClassName)) {
            this.access = innerClassAccess;
        }
        super.visitInnerClass(innerClassName, outerName, innerName, innerClassAccess);
    }

    @Override
    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (IOException e2) {
                throw new IllegalStateException("Error while computing SVUID for " + this.name, e2);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSVUID;
    }

    protected void addSVUID(long svuid) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, svuid);
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeSVUID() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        long svuid = 0L;
        try (FilterOutputStream dataOutputStream = null;){
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)dataOutputStream).writeUTF(this.name.replace('/', '.'));
            int mods = this.access;
            if ((mods & 0x200) != 0) {
                mods = this.svuidMethods.isEmpty() ? mods & 0xFFFFFBFF : mods | 0x400;
            }
            ((DataOutputStream)dataOutputStream).writeInt(mods & 0x611);
            Arrays.sort(this.interfaces);
            for (String interfaceName : this.interfaces) {
                ((DataOutputStream)dataOutputStream).writeUTF(interfaceName.replace('/', '.'));
            }
            SerialVersionUIDAdder.writeItems(this.svuidFields, (DataOutput)((Object)dataOutputStream), false);
            if (this.hasStaticInitializer) {
                ((DataOutputStream)dataOutputStream).writeUTF(CLINIT);
                ((DataOutputStream)dataOutputStream).writeInt(8);
                ((DataOutputStream)dataOutputStream).writeUTF("()V");
            }
            SerialVersionUIDAdder.writeItems(this.svuidConstructors, (DataOutput)((Object)dataOutputStream), true);
            SerialVersionUIDAdder.writeItems(this.svuidMethods, (DataOutput)((Object)dataOutputStream), true);
            ((DataOutputStream)dataOutputStream).flush();
            byte[] hashBytes = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
            }
        }
        return svuid;
    }

    protected byte[] computeSHAdigest(byte[] value) {
        try {
            return MessageDigest.getInstance("SHA").digest(value);
        }
        catch (Exception e2) {
            throw new UnsupportedOperationException(e2.toString());
        }
    }

    private static void writeItems(Collection<Item> itemCollection, DataOutput dataOutputStream, boolean dotted) throws IOException {
        int size = itemCollection.size();
        Item[] items = itemCollection.toArray(new Item[size]);
        Arrays.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item item1, Item item2) {
                int result = item1.name.compareTo(item2.name);
                if (result == 0) {
                    result = item1.descriptor.compareTo(item2.descriptor);
                }
                return result;
            }
        });
        for (Item item : items) {
            dataOutputStream.writeUTF(item.name);
            dataOutputStream.writeInt(item.access);
            dataOutputStream.writeUTF(dotted ? item.descriptor.replace('/', '.') : item.descriptor);
        }
    }

    private static final class Item {
        final String name;
        final int access;
        final String descriptor;

        Item(String name2, int access, String descriptor2) {
            this.name = name2;
            this.access = access;
            this.descriptor = descriptor2;
        }
    }
}

