/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.ConditionalTransferEntropyCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.ParsedProperties;
import java.util.Vector;

public class ConditionalTransferEntropyCalculatorViaCondMutualInfo
implements ConditionalTransferEntropyCalculator {
    protected ConditionalMutualInfoCalculatorMultiVariate condMiCalc;
    protected int k = 1;
    protected int k_tau = 1;
    protected int l = 1;
    protected int l_tau = 1;
    protected int delay = 1;
    protected int[] condEmbedDims = null;
    protected int[] cond_taus = null;
    protected int[] condDelays = null;
    protected int startTimeForFirstDestEmbedding;
    protected int dimOfConditionals = 0;
    protected boolean debug = false;

    public ConditionalTransferEntropyCalculatorViaCondMutualInfo(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = (ConditionalMutualInfoCalculatorMultiVariate)clazz.newInstance();
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    public ConditionalTransferEntropyCalculatorViaCondMutualInfo(Class<ConditionalMutualInfoCalculatorMultiVariate> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = clazz.newInstance();
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    public ConditionalTransferEntropyCalculatorViaCondMutualInfo(ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate) throws Exception {
        if (conditionalMutualInfoCalculatorMultiVariate == null) {
            throw new Exception("Conditional MI calculator used to construct ConditionalTransferEntropyCalculatorViaCondMutualInfo  must have already been instantiated.");
        }
        this.construct(conditionalMutualInfoCalculatorMultiVariate);
    }

    protected void construct(ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate) {
        this.condMiCalc = conditionalMutualInfoCalculatorMultiVariate;
    }

    @Override
    public void initialise() throws Exception {
        this.initialise(this.k, this.k_tau, this.l, this.l_tau, this.delay, this.condEmbedDims, this.cond_taus, this.condDelays);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.k_tau, this.l, this.l_tau, this.delay, this.condEmbedDims, this.cond_taus, this.condDelays);
    }

    @Override
    public void initialise(int n, int n2, int n3) throws Exception {
        if (n3 == 0) {
            this.initialise(n, 1, n2, 1, 1, null, null, null);
        } else {
            int[] nArray = new int[]{n3};
            int[] nArray2 = new int[]{1};
            int[] nArray3 = new int[]{1};
            this.initialise(n, 1, n2, 1, 1, nArray, nArray2, nArray3);
        }
    }

    @Override
    public void initialise(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        if (n6 == 0) {
            this.initialise(n, n2, n3, n4, n5, null, null, null);
        } else {
            int[] nArray = new int[]{n6};
            int[] nArray2 = new int[]{n7};
            int[] nArray3 = new int[]{n8};
            this.initialise(n, n2, n3, n4, n5, nArray, nArray2, nArray3);
        }
    }

    @Override
    public void initialise(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3) throws Exception {
        int n6;
        if (n5 < 0) {
            throw new Exception("Cannot compute TE with source-destination delay < 0");
        }
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        if (nArray3 == null) {
            nArray3 = new int[]{};
        }
        if (nArray.length != nArray2.length || nArray.length != nArray3.length) {
            throw new Exception("condEmbedDims, cond_taus and condDelays must have same length in argument to ConditionalTransferEntropyCalculatorViaCondMutualInfo.initialise()");
        }
        for (n6 = 0; n6 < nArray3.length; ++n6) {
            if (nArray3[n6] >= 0) continue;
            throw new Exception("Cannot compute TE with conditional-destination delay < 0");
        }
        this.k = n;
        this.k_tau = n2;
        this.l = n3;
        this.l_tau = n4;
        this.delay = n5;
        this.condEmbedDims = nArray;
        this.cond_taus = nArray2;
        this.condDelays = nArray3;
        n6 = (n - 1) * n2;
        int n7 = (n3 - 1) * n4 + n5 - 1;
        int n8 = 0;
        this.dimOfConditionals = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            int n9 = (nArray[i] - 1) * nArray2[i] + nArray3[i] - 1;
            if (n9 > n8) {
                n8 = n9;
            }
            this.dimOfConditionals += nArray[i];
        }
        this.startTimeForFirstDestEmbedding = Math.max(n6, Math.max(n7, n8));
        this.condMiCalc.initialise(n3, 1, n + this.dimOfConditionals);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("k_HISTORY")) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("k_TAU")) {
            this.k_tau = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("l_HISTORY")) {
            this.l = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("l_TAU")) {
            this.l_tau = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("DELAY")) {
            this.delay = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("COND_EMBED_LENGTHS")) {
            this.condEmbedDims = ParsedProperties.parseStringArrayOfInts(string2);
        } else if (string.equalsIgnoreCase("COND_TAUS")) {
            this.cond_taus = ParsedProperties.parseStringArrayOfInts(string2);
        } else if (string.equalsIgnoreCase("COND_DELAYS")) {
            this.condDelays = ParsedProperties.parseStringArrayOfInts(string2);
        } else {
            this.condMiCalc.setProperty(string, string2);
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, double[][] dArray3) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2, dArray3);
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        if (this.condEmbedDims.length != 1) {
            throw new Exception("Cannot call setObservations(double[], double[], double[]) when the conditional TE calculator was not initialised for one conditional variable");
        }
        this.startAddObservations();
        this.addObservations(dArray, dArray2, dArray3);
        this.finaliseAddObservations();
    }

    @Override
    public void startAddObservations() {
        this.condMiCalc.startAddObservations();
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, double[][] dArray3) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray3 == null) {
            if (this.condEmbedDims.length > 0) {
                throw new Exception(String.format("No conditionals supplied (expected %d-dimensional conditionals", this.condEmbedDims.length));
            }
            dArray3 = new double[dArray2.length][0];
        }
        if (dArray3.length != dArray2.length) {
            throw new Exception(String.format("Conditionals and destination lengths (%d and %d) must match!", dArray3.length, dArray2.length));
        }
        if (dArray.length < this.startTimeForFirstDestEmbedding + 2) {
            return;
        }
        if (dArray3[0].length != this.condEmbedDims.length) {
            throw new Exception(String.format("Number of conditional variables %d does not match the initialised number %d", dArray3[0].length, this.condEmbedDims.length));
        }
        double[][][] dArray4 = this.embedSourceDestAndConditionalsForCondMI(dArray, dArray2, dArray3);
        this.condMiCalc.addObservations(dArray4[0], dArray4[1], dArray4[2]);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        if (this.condEmbedDims.length != 1) {
            throw new Exception("Cannot call addObservations(double[], double[], double[]) when the conditional TE calculator was not initialised for one conditional variable");
        }
        double[][] dArray4 = null;
        if (dArray3 != null) {
            dArray4 = new double[dArray3.length][1];
            MatrixUtils.copyIntoColumn(dArray4, 0, dArray3);
        }
        this.addObservations(dArray, dArray2, dArray4);
    }

    protected double[][][] embedSourceDestAndConditionalsForCondMI(double[] dArray, double[] dArray2, double[][] dArray3) throws Exception {
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray6 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray7 = new double[dArray6.length][this.k + this.dimOfConditionals];
        MatrixUtils.arrayCopy(dArray4, 0, 0, dArray7, 0, 0, dArray4.length, this.k);
        int n = this.k;
        for (int i = 0; i < this.condEmbedDims.length; ++i) {
            double[][] dArray8 = MatrixUtils.makeDelayEmbeddingVector(dArray3, i, this.condEmbedDims[i], this.cond_taus[i], this.startTimeForFirstDestEmbedding + 1 - this.condDelays[i], dArray3.length - this.startTimeForFirstDestEmbedding - 1);
            MatrixUtils.arrayCopy(dArray8, 0, 0, dArray7, 0, n, dArray8.length, this.condEmbedDims[i]);
            n += this.condEmbedDims[i];
        }
        double[][][] dArrayArray = new double[][][]{dArray6, dArray5, dArray7};
        return dArrayArray;
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, double[][] dArray3, int n, int n2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray3 == null) {
            if (this.condEmbedDims.length > 0) {
                throw new Exception(String.format("No conditionals supplied (expected %d-dimensional conditionals", this.condEmbedDims.length));
            }
            dArray3 = new double[dArray2.length][0];
        }
        if (dArray3.length != dArray2.length) {
            throw new Exception(String.format("Conditionals and destination lengths (%d and %d) must match!", dArray3.length, dArray2.length));
        }
        if (dArray.length < n + n2) {
            throw new Exception("Not enough observations to set here given startTime and numTimeSteps parameters");
        }
        this.addObservations(MatrixUtils.select(dArray, n, n2), MatrixUtils.select(dArray2, n, n2), MatrixUtils.selectRows(dArray3, n, n2));
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) throws Exception {
        if (this.condEmbedDims.length != 1) {
            throw new Exception("Cannot call addObservations(double[], double[], double[], int, int) when the conditional TE calculator was not initialised for one conditional variable");
        }
        double[][] dArray4 = null;
        if (dArray3 != null) {
            dArray4 = new double[dArray3.length][1];
            MatrixUtils.copyIntoColumn(dArray4, 0, dArray3);
        }
        this.addObservations(dArray, dArray2, dArray4, n, n2);
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.condMiCalc.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, double[][] dArray3, boolean[] blArray, boolean[] blArray2, boolean[][] blArray3) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2, blArray3);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, dArray3, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray, boolean[] blArray2, boolean[][] blArray3) throws Exception {
        int n;
        if (blArray.length != blArray2.length) {
            throw new Exception("Validity arrays must be of same length");
        }
        if (blArray3.length != blArray2.length) {
            throw new Exception("Validity arrays must be of same length");
        }
        int n2 = (this.k - 1) * this.k_tau + 1;
        int n3 = (this.l - 1) * this.l_tau + 1;
        int[] nArray = new int[this.condEmbedDims.length];
        for (n = 0; n < this.condEmbedDims.length; ++n) {
            nArray[n] = (this.condEmbedDims[n] - 1) * this.cond_taus[n] + 1;
        }
        n = 0;
        Vector<int[]> vector = new Vector<int[]>();
        boolean bl = false;
        for (int i = this.startTimeForFirstDestEmbedding; i < blArray2.length - 1; ++i) {
            int n4;
            boolean bl2;
            if (bl) {
                bl2 = true;
                for (n4 = 0; n4 < this.condEmbedDims.length; ++n4) {
                    bl2 &= blArray3[i + 1 - this.condDelays[n4]][n4];
                }
                if (bl2 && blArray2[i + 1] && blArray[i + 1 - this.delay]) continue;
                bl = false;
                int[] nArray2 = new int[]{n, i};
                vector.add(nArray2);
                continue;
            }
            if (!blArray2[i + 1]) continue;
            bl2 = true;
            for (n4 = 0; n4 < n2; ++n4) {
                if (blArray2[i - n4]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            for (n4 = this.delay - 1; n4 < this.delay - 1 + n3; ++n4) {
                if (blArray[i - n4]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            for (n4 = 0; n4 < this.condEmbedDims.length; ++n4) {
                for (int j = this.condDelays[n4] - 1; j < this.condDelays[n4] - 1 + nArray[n4]; ++j) {
                    if (blArray3[i - j][n4]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) continue;
            }
            n = i - this.startTimeForFirstDestEmbedding;
            bl = true;
        }
        if (bl) {
            bl = false;
            int[] nArray3 = new int[]{n, blArray2.length - 1};
            vector.add(nArray3);
        }
        return vector;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        return this.condMiCalc.computeAverageLocalOfObservations();
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        double[] dArray = this.condMiCalc.computeLocalOfPreviousObservations();
        if (!this.condMiCalc.getAddedMoreThanOneObservationSet()) {
            double[] dArray2 = new double[dArray.length + this.startTimeForFirstDestEmbedding + 1];
            System.arraycopy(dArray, 0, dArray2, this.startTimeForFirstDestEmbedding + 1, dArray.length);
            return dArray2;
        }
        return dArray;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, double[][] dArray3) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray3 == null) {
            if (this.condEmbedDims.length > 0) {
                throw new Exception(String.format("No conditionals supplied (expected %d-dimensional conditionals)", this.condEmbedDims.length));
            }
            dArray3 = new double[dArray2.length][0];
        }
        if (dArray3.length != dArray2.length) {
            throw new Exception(String.format("Conditionals and destination lengths (%d and %d) must match!", dArray3.length, dArray2.length));
        }
        if (dArray3[0].length != this.condEmbedDims.length) {
            throw new Exception(String.format("Number of conditional variables %d does not match the initialised number %d", dArray3[0].length, this.condEmbedDims.length));
        }
        if (dArray2.length < this.startTimeForFirstDestEmbedding + 2) {
            return new double[dArray2.length];
        }
        double[][][] dArray4 = this.embedSourceDestAndConditionalsForCondMI(dArray, dArray2, dArray3);
        double[] dArray5 = this.condMiCalc.computeLocalUsingPreviousObservations(dArray4[0], dArray4[1], dArray4[2]);
        double[] dArray6 = new double[dArray5.length + this.startTimeForFirstDestEmbedding + 1];
        System.arraycopy(dArray5, 0, dArray6, this.startTimeForFirstDestEmbedding + 1, dArray5.length);
        return dArray6;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        if (this.condEmbedDims.length != 1) {
            throw new Exception("Cannot call computeLocalUsingPreviousObservations(double[], double[], double[]) when the conditional TE calculator was not initialised for one conditional variable");
        }
        double[][] dArray4 = null;
        if (dArray3 != null) {
            dArray4 = new double[dArray3.length][1];
            MatrixUtils.copyIntoColumn(dArray4, 0, dArray3);
        }
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, dArray4);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        return this.condMiCalc.computeSignificance(1, n);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        return this.condMiCalc.computeSignificance(1, nArray);
    }

    @Override
    public double getLastAverage() {
        return this.condMiCalc.getLastAverage();
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.condMiCalc.getNumObservations();
    }

    @Override
    public boolean getAddedMoreThanOneObservationSet() {
        return this.condMiCalc.getAddedMoreThanOneObservationSet();
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
        this.condMiCalc.setDebug(bl);
    }
}

