/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.measures.continuous.kernel.TransferEntropyKernelCounts;
import infodynamics.utils.MatrixUtils;

public class KernelEstimatorTransferEntropyMultiVariate
extends KernelEstimatorMultiVariate {
    private int sourceDimensions;
    private double[] suppliedKernelWidthSource;
    private double[] kernelWidthSourceInUse;
    private double suppliedKernelWidthDestNextFixed;
    private double[] suppliedKernelWidthDestNext;
    private double[] kernelWidthDestNextInUse;
    private double[][] destNext;
    private double[][] source;
    private double[] destNextObs;
    private double[] sourceObs;
    private int countNextPast;
    private int countPastSource;
    private int countNextPastSource;

    public KernelEstimatorTransferEntropyMultiVariate() {
        this.makeCorrelatedPointAddedCallback = true;
    }

    @Override
    public void initialise(int n, double d) {
        this.initialise(n, n, d, d);
    }

    public void initialise(int n, int n2, double d, double d2) {
        super.initialise(n, d);
        this.sourceDimensions = n2;
        this.suppliedKernelWidthSource = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.suppliedKernelWidthSource[i] = d2;
        }
        this.kernelWidthSourceInUse = new double[n2];
        this.suppliedKernelWidthDestNext = null;
        this.suppliedKernelWidthDestNextFixed = d;
    }

    public void initialise(double[] dArray, double[] dArray2) {
        super.initialise(dArray);
        this.suppliedKernelWidthSource = dArray2;
        this.kernelWidthSourceInUse = new double[this.sourceDimensions];
        this.suppliedKernelWidthDestNext = dArray;
    }

    public void setObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        this.setObservations(dArray);
        if (this.normalise) {
            for (n = 0; n < this.sourceDimensions; ++n) {
                double d = MatrixUtils.stdDev(dArray3, n);
                this.kernelWidthSourceInUse[n] = this.suppliedKernelWidthSource[n] * d;
            }
        } else {
            for (n = 0; n < this.sourceDimensions; ++n) {
                this.kernelWidthSourceInUse[n] = this.suppliedKernelWidthSource[n];
            }
        }
        n = dArray2[0].length;
        if (this.suppliedKernelWidthDestNext == null) {
            this.suppliedKernelWidthDestNext = new double[n];
            for (int i = 0; i < n; ++i) {
                this.suppliedKernelWidthDestNext[i] = this.suppliedKernelWidthDestNextFixed;
            }
        }
        this.kernelWidthDestNextInUse = new double[n];
        if (this.normalise) {
            for (int i = 0; i < n; ++i) {
                double d = MatrixUtils.stdDev(dArray2, i);
                this.kernelWidthDestNextInUse[i] = this.suppliedKernelWidthDestNext[i] * d;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.kernelWidthDestNextInUse[i] = this.suppliedKernelWidthDestNext[i];
            }
        }
        this.source = dArray3;
        this.destNext = dArray2;
    }

    public synchronized TransferEntropyKernelCounts getCount(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        this.countNextPast = 0;
        this.countPastSource = 0;
        this.countNextPastSource = 0;
        this.destNextObs = dArray2;
        this.sourceObs = dArray3;
        int n2 = n < 0 ? super.getCount(dArray) : super.getCount(dArray, n);
        TransferEntropyKernelCounts transferEntropyKernelCounts = new TransferEntropyKernelCounts(n2, this.countNextPast, this.countPastSource, this.countNextPastSource);
        return transferEntropyKernelCounts;
    }

    public void setEpsSource(double[] dArray) {
        this.suppliedKernelWidthSource = dArray;
    }

    @Override
    protected void correlatedPointAddedCallback(int n) {
        boolean bl = false;
        if (this.stepKernel(this.sourceObs, this.source[n], this.kernelWidthSourceInUse) > 0) {
            ++this.countPastSource;
            bl = true;
        }
        if (this.stepKernel(this.destNextObs, this.destNext[n], this.kernelWidthDestNextInUse) > 0) {
            ++this.countNextPast;
            if (bl) {
                ++this.countNextPastSource;
            }
        }
    }

    @Override
    protected void correlatedPointRemovedCallback(int n) {
        boolean bl = false;
        if (this.stepKernel(this.sourceObs, this.source[n], this.kernelWidthSourceInUse) > 0) {
            --this.countPastSource;
            bl = true;
        }
        if (this.stepKernel(this.destNextObs, this.destNext[n], this.kernelWidthDestNextInUse) > 0) {
            --this.countNextPast;
            if (bl) {
                --this.countNextPastSource;
            }
        }
    }

    protected int stepKernel(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > dArray3[i])) continue;
            return 0;
        }
        return 1;
    }
}

