/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MultiInfoCalculatorKraskov;
import infodynamics.utils.EuclideanUtils;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Arrays;

public class MultiInfoCalculatorKraskov1
extends MultiInfoCalculatorKraskov {
    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        if (this.miComputed) {
            return this.mi;
        }
        return this.computeAverageLocalOfObservations(null);
    }

    @Override
    public double computeAverageLocalOfObservations(int[][] nArray) throws Exception {
        int n;
        if (this.V == 1) {
            this.miComputed = true;
            return 0.0;
        }
        if (!this.tryKeepAllPairsNorms || this.data.length * this.V > MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM) {
            double[][] dArray = this.data;
            if (nArray != null) {
                this.data = MatrixUtils.reorderDataForVariables(dArray, nArray);
            }
            double d = this.computeAverageLocalOfObservationsWhileComputingDistances();
            this.data = dArray;
            return d;
        }
        if (this.norms == null) {
            this.computeNorms();
        }
        double d = 0.0;
        double[] dArray = new double[this.V];
        int n2 = (int)(Math.log(this.N) / Math.log(2.0));
        for (n = 0; n < this.N; ++n) {
            int n3;
            int[] nArray2 = this.reorderedTimeStepsForEachMarginal(nArray, n);
            double[] dArray2 = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                int[] nArray3 = this.reorderedTimeStepsForEachMarginal(nArray, i);
                dArray2[i] = 0.0;
                for (int j = 0; j < this.V; ++j) {
                    double d2 = this.norms[j][nArray2[j]][nArray3[j]];
                    if (!(d2 > dArray2[i])) continue;
                    dArray2[i] = d2;
                }
            }
            double d3 = 0.0;
            if (this.k <= n2) {
                d3 = MatrixUtils.kthMin(dArray2, this.k);
            } else {
                Arrays.sort(dArray2);
                d3 = dArray2[this.k - 1];
            }
            int[] nArray4 = new int[this.V];
            for (n3 = 0; n3 < this.N; ++n3) {
                int[] nArray5 = this.reorderedTimeStepsForEachMarginal(nArray, n3);
                for (int i = 0; i < this.V; ++i) {
                    if (!(this.norms[i][nArray2[i]][nArray5[i]] < d3)) continue;
                    int n4 = i;
                    nArray4[n4] = nArray4[n4] + 1;
                }
            }
            for (n3 = 0; n3 < this.V; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + (double)nArray4[n3];
                d += MathsUtils.digamma(nArray4[n3] + 1);
            }
        }
        d /= (double)this.N;
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n6 = n;
                dArray[n6] = dArray[n6] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray[n]));
            }
            System.out.println();
        }
        this.mi = MathsUtils.digamma(this.k) - d + (double)(this.V - 1) * MathsUtils.digamma(this.N);
        this.miComputed = true;
        return this.mi;
    }

    public double computeAverageLocalOfObservationsWhileComputingDistances() throws Exception {
        int n;
        if (this.V == 1) {
            this.miComputed = true;
            return 0.0;
        }
        double d = 0.0;
        double[] dArray = new double[this.V];
        int n2 = (int)(Math.log(this.N) / Math.log(2.0));
        for (n = 0; n < this.N; ++n) {
            int n3;
            double[][] dArray2 = EuclideanUtils.computeNorms(this.data, n);
            double[] dArray3 = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                dArray3[i] = MatrixUtils.max(dArray2[i]);
            }
            double d2 = 0.0;
            if (this.k <= n2) {
                d2 = MatrixUtils.kthMin(dArray3, this.k);
            } else {
                Arrays.sort(dArray3);
                d2 = dArray3[this.k - 1];
            }
            int[] nArray = new int[this.V];
            for (n3 = 0; n3 < this.N; ++n3) {
                for (int i = 0; i < this.V; ++i) {
                    if (!(dArray2[n3][i] < d2)) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
            for (n3 = 0; n3 < this.V; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + (double)nArray[n3];
            }
            for (n3 = 0; n3 < this.V; ++n3) {
                d += MathsUtils.digamma(nArray[n3] + 1);
            }
        }
        d /= (double)this.N;
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n6 = n;
                dArray[n6] = dArray[n6] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray[n]));
            }
            System.out.println();
        }
        this.mi = MathsUtils.digamma(this.k) - d + (double)(this.V - 1) * MathsUtils.digamma(this.N);
        this.miComputed = true;
        return this.mi;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        int n;
        double[] dArray = new double[this.N];
        int n2 = (int)(Math.log(this.N) / Math.log(2.0));
        if (this.V == 1) {
            this.miComputed = true;
            return dArray;
        }
        double d = MathsUtils.digamma(this.k);
        double d2 = (double)(this.V - 1) * MathsUtils.digamma(this.N);
        double d3 = 0.0;
        double[] dArray2 = new double[this.V];
        for (n = 0; n < this.N; ++n) {
            int n3;
            double[][] dArray3 = EuclideanUtils.computeNorms(this.data, n);
            double[] dArray4 = new double[this.N];
            for (int i = 0; i < this.N; ++i) {
                dArray4[i] = MatrixUtils.max(dArray3[i]);
            }
            double d4 = 0.0;
            if (this.k <= n2) {
                d4 = MatrixUtils.kthMin(dArray4, this.k);
            } else {
                Arrays.sort(dArray4);
                d4 = dArray4[this.k - 1];
            }
            int[] nArray = new int[this.V];
            for (n3 = 0; n3 < this.N; ++n3) {
                for (int i = 0; i < this.V; ++i) {
                    if (!(dArray3[n3][i] < d4)) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
            dArray[n] = d + d2;
            for (n3 = 0; n3 < this.V; ++n3) {
                double d5 = MathsUtils.digamma(nArray[n3] + 1);
                int n5 = n;
                dArray[n5] = dArray[n5] - d5;
                d3 += d5;
                int n6 = n3;
                dArray2[n6] = dArray2[n6] + (double)nArray[n3];
            }
        }
        d3 /= (double)this.N;
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n7 = n;
                dArray2[n7] = dArray2[n7] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray2[n]));
            }
            System.out.println();
        }
        this.mi = d - d3 + d2;
        this.miComputed = true;
        return dArray;
    }

    @Override
    public String printConstants(int n) throws Exception {
        String string = String.format("digamma(k=%d)=%.3e + digamma(N=%d)=%.3e => %.3e", this.k, MathsUtils.digamma(this.k), n, MathsUtils.digamma(n), MathsUtils.digamma(this.k) + MathsUtils.digamma(n));
        return string;
    }
}

