/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.SingleAgentMeasureDiscreteInContextOfPastCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class ActiveInformationCalculatorDiscrete
extends SingleAgentMeasureDiscreteInContextOfPastCalculator {
    public static ActiveInformationCalculatorDiscrete newInstance(int n, int n2) {
        return new ActiveInformationCalculatorDiscrete(n, n2);
    }

    public ActiveInformationCalculatorDiscrete(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void addObservations(int[] nArray) {
        int n;
        int n2 = nArray.length;
        this.observations += n2 - this.k;
        int n3 = 0;
        for (n = 0; n < this.k; ++n) {
            n3 *= this.base;
            n3 += nArray[n];
        }
        for (int i = this.k; i < n2; ++i) {
            n = nArray[i];
            int[] nArray2 = this.nextPastCount[n];
            int n4 = n3;
            nArray2[n4] = nArray2[n4] + 1;
            int n5 = n3;
            this.pastCount[n5] = this.pastCount[n5] + 1;
            int n6 = n;
            this.nextCount[n6] = this.nextCount[n6] + 1;
            n3 -= this.maxShiftedValue[nArray[i - this.k]];
            n3 *= this.base;
            n3 += nArray[i];
        }
    }

    @Override
    public void addObservations(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        this.observations += (n3 - this.k) * n4;
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = 0;
            for (n = 0; n < this.k; ++n) {
                int n5 = n2;
                nArray2[n5] = nArray2[n5] * this.base;
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + nArray[n][n2];
            }
        }
        for (n = this.k; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                n2 = nArray[n][i];
                int[] nArray3 = this.nextPastCount[n2];
                int n7 = nArray2[i];
                nArray3[n7] = nArray3[n7] + 1;
                int n8 = nArray2[i];
                this.pastCount[n8] = this.pastCount[n8] + 1;
                int n9 = n2;
                this.nextCount[n9] = this.nextCount[n9] + 1;
                int n10 = i;
                nArray2[n10] = nArray2[n10] - this.maxShiftedValue[nArray[n - this.k][i]];
                int n11 = i;
                nArray2[n11] = nArray2[n11] * this.base;
                int n12 = i;
                nArray2[n12] = nArray2[n12] + nArray[n][i];
            }
        }
    }

    @Override
    public void addObservations(int[][][] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = nArray[0].length;
        if (n5 == 0) {
            return;
        }
        int n6 = nArray[0][0].length;
        this.observations += (n4 - this.k) * n5 * n6;
        int[][] nArray2 = new int[n5][n6];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                nArray2[n3][n2] = 0;
                for (n = 0; n < this.k; ++n) {
                    int[] nArray3 = nArray2[n3];
                    int n7 = n2;
                    nArray3[n7] = nArray3[n7] * this.base;
                    int[] nArray4 = nArray2[n3];
                    int n8 = n2;
                    nArray4[n8] = nArray4[n8] + nArray[n][n3][n2];
                }
            }
        }
        for (n2 = this.k; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n6; ++i) {
                    n3 = nArray[n2][n][i];
                    int[] nArray5 = this.nextPastCount[n3];
                    int n9 = nArray2[n][i];
                    nArray5[n9] = nArray5[n9] + 1;
                    int n10 = nArray2[n][i];
                    this.pastCount[n10] = this.pastCount[n10] + 1;
                    int n11 = n3;
                    this.nextCount[n11] = this.nextCount[n11] + 1;
                    int[] nArray6 = nArray2[n];
                    int n12 = i;
                    nArray6[n12] = nArray6[n12] - this.maxShiftedValue[nArray[n2 - this.k][n][i]];
                    int[] nArray7 = nArray2[n];
                    int n13 = i;
                    nArray7[n13] = nArray7[n13] * this.base;
                    int[] nArray8 = nArray2[n];
                    int n14 = i;
                    nArray8[n14] = nArray8[n14] + nArray[n2][n][i];
                }
            }
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        this.observations += n3 - this.k;
        int n4 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray[n2][n];
        }
        for (int i = this.k; i < n3; ++i) {
            n2 = nArray[i][n];
            int[] nArray2 = this.nextPastCount[n2];
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
            int n6 = n4;
            this.pastCount[n6] = this.pastCount[n6] + 1;
            int n7 = n2;
            this.nextCount[n7] = this.nextCount[n7] + 1;
            n4 -= this.maxShiftedValue[nArray[i - this.k][n]];
            n4 *= this.base;
            n4 += nArray[i][n];
        }
    }

    @Override
    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        this.observations += n4 - this.k;
        int n5 = 0;
        n5 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.base;
            n5 += nArray[n3][n][n2];
        }
        for (int i = this.k; i < n4; ++i) {
            n3 = nArray[i][n][n2];
            int[] nArray2 = this.nextPastCount[n3];
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n5;
            this.pastCount[n7] = this.pastCount[n7] + 1;
            int n8 = n3;
            this.nextCount[n8] = this.nextCount[n8] + 1;
            n5 -= this.maxShiftedValue[nArray[i - this.k][n][n2]];
            n5 *= this.base;
            n5 += nArray[i][n][n2];
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                double d4 = (double)this.pastCount[j] / (double)this.observations;
                double d5 = (double)this.nextPastCount[i][j] / (double)this.observations;
                if (d5 > 0.0) {
                    double d6 = d5 / (d3 * d4);
                    double d7 = Math.log(d6) / this.log_base;
                    d2 = d5 * d7;
                    if (d7 > this.max) {
                        this.max = d7;
                    } else if (d7 < this.min) {
                        this.min = d7;
                    }
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        this.average = d;
        return d;
    }

    public double computeAverageLocalEntropyRateOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.base; ++i) {
            for (int j = 0; j < this.base_power_k; ++j) {
                double d3 = (double)this.pastCount[j] / (double)this.observations;
                double d4 = (double)this.nextPastCount[i][j] / (double)this.observations;
                if (d4 > 0.0) {
                    double d5 = d4 / d3;
                    double d6 = -Math.log(d5) / this.log_base;
                    d2 = d4 * d6;
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        return d;
    }

    public double computeLocalFromPreviousObservations(int n, int n2) {
        double d = (double)this.nextPastCount[n][n2] / ((double)this.nextCount[n] * (double)this.pastCount[n2]);
        return Math.log(d *= (double)this.observations) / this.log_base;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[] nArray) {
        int n;
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n3 = 0;
        for (n = 0; n < this.k; ++n) {
            n3 *= this.base;
            n3 += nArray[n];
        }
        double d = 0.0;
        for (int i = this.k; i < n2; ++i) {
            n = nArray[i];
            d = (double)this.nextPastCount[n][n3] / ((double)this.nextCount[n] * (double)this.pastCount[n3]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n3 -= this.maxShiftedValue[nArray[i - this.k]];
            n3 *= this.base;
            n3 += nArray[i];
        }
        this.average /= (double)(n2 - this.k);
        return dArray;
    }

    @Override
    public double[][] computeLocalFromPreviousObservations(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        double[][] dArray = new double[n2][n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = 0;
            for (int i = 0; i < this.k; ++i) {
                int n4 = n;
                nArray2[n4] = nArray2[n4] * this.base;
                int n5 = n;
                nArray2[n5] = nArray2[n5] + nArray[i][n];
            }
        }
        double d = 0.0;
        for (int i = this.k; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                n = nArray[i][j];
                d = (double)this.nextPastCount[n][nArray2[j]] / ((double)this.nextCount[n] * (double)this.pastCount[nArray2[j]]);
                dArray[i][j] = Math.log(d *= (double)this.observations) / this.log_base;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                int n6 = j;
                nArray2[n6] = nArray2[n6] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n7 = j;
                nArray2[n7] = nArray2[n7] * this.base;
                int n8 = j;
                nArray2[n8] = nArray2[n8] + nArray[i][j];
            }
        }
        this.average /= (double)(n3 * (n2 - this.k));
        return dArray;
    }

    @Override
    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = nArray[0][0].length;
        double[][][] dArray = new double[n2][n3][n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][] nArray2 = new int[n3][n4];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                nArray2[n][i] = 0;
                for (int j = 0; j < this.k; ++j) {
                    int[] nArray3 = nArray2[n];
                    int n5 = i;
                    nArray3[n5] = nArray3[n5] * this.base;
                    int[] nArray4 = nArray2[n];
                    int n6 = i;
                    nArray4[n6] = nArray4[n6] + nArray[j][n][i];
                }
            }
        }
        double d = 0.0;
        for (int i = this.k; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    n = nArray[i][j][k];
                    d = (double)this.nextPastCount[n][nArray2[j][k]] / ((double)this.nextCount[n] * (double)this.pastCount[nArray2[j][k]]);
                    dArray[i][j][k] = Math.log(d *= (double)this.observations) / this.log_base;
                    this.average += dArray[i][j][k];
                    if (dArray[i][j][k] > this.max) {
                        this.max = dArray[i][j][k];
                    } else if (dArray[i][j][k] < this.min) {
                        this.min = dArray[i][j][k];
                    }
                    int[] nArray5 = nArray2[j];
                    int n7 = k;
                    nArray5[n7] = nArray5[n7] - this.maxShiftedValue[nArray[i - this.k][j][k]];
                    int[] nArray6 = nArray2[j];
                    int n8 = k;
                    nArray6[n8] = nArray6[n8] * this.base;
                    int[] nArray7 = nArray2[j];
                    int n9 = k;
                    nArray7[n9] = nArray7[n9] + nArray[i][j][k];
                }
            }
        }
        this.average /= (double)(n3 * n4 * (n2 - this.k));
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n4 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray[n2][n];
        }
        double d = 0.0;
        for (int i = this.k; i < n3; ++i) {
            n2 = nArray[i][n];
            d = (double)this.nextPastCount[n2][n4] / ((double)this.nextCount[n2] * (double)this.pastCount[n4]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n4 -= this.maxShiftedValue[nArray[i - this.k][n]];
            n4 *= this.base;
            n4 += nArray[i][n];
        }
        this.average /= (double)(n3 - this.k);
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        double[] dArray = new double[n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n5 = 0;
        n5 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.base;
            n5 += nArray[n3][n][n2];
        }
        double d = 0.0;
        for (int i = this.k; i < n4; ++i) {
            n3 = nArray[i][n][n2];
            d = (double)this.nextPastCount[n3][n5] / ((double)this.nextCount[n3] * (double)this.pastCount[n5]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_base;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n5 -= this.maxShiftedValue[nArray[i - this.k][n][n2]];
            n5 *= this.base;
            n5 += nArray[i][n][n2];
        }
        this.average /= (double)(n4 - this.k);
        return dArray;
    }

    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.observations, n);
        return this.computeSignificance(nArray);
    }

    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) {
        int n;
        int n2;
        double d = this.computeAverageLocalOfObservations();
        int n3 = nArray.length;
        int[] nArray2 = new int[this.observations];
        int[] nArray3 = new int[this.observations];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.pastCount.length; ++n2) {
            n = this.pastCount[n2];
            MatrixUtils.fill(nArray2, n2, n4, n);
            n4 += n;
        }
        for (n2 = 0; n2 < this.base; ++n2) {
            n = this.nextCount[n2];
            MatrixUtils.fill(nArray3, n2, n5, n);
            n5 += n;
        }
        ActiveInformationCalculatorDiscrete activeInformationCalculatorDiscrete = new ActiveInformationCalculatorDiscrete(this.base, this.k);
        activeInformationCalculatorDiscrete.initialise();
        activeInformationCalculatorDiscrete.observations = this.observations;
        activeInformationCalculatorDiscrete.pastCount = this.pastCount;
        activeInformationCalculatorDiscrete.nextCount = this.nextCount;
        n = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n3);
        for (int i = 0; i < n3; ++i) {
            double d2;
            int[] nArray4 = MatrixUtils.extractSelectedTimePoints(nArray3, nArray[i]);
            MatrixUtils.fill(activeInformationCalculatorDiscrete.nextPastCount, 0);
            for (int j = 0; j < this.observations; ++j) {
                int[] nArray5 = activeInformationCalculatorDiscrete.nextPastCount[nArray4[j]];
                int n6 = nArray2[j];
                nArray5[n6] = nArray5[n6] + 1;
            }
            empiricalMeasurementDistribution.distribution[i] = d2 = activeInformationCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n;
        }
        empiricalMeasurementDistribution.pValue = (double)n / (double)n3;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    public void writePdfs() {
        double d = 0.0;
        double d2 = 0.0;
        System.out.println("nextVal p(next) prevVal p(prev) p(joint) logTerm localVal");
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                double d4 = (double)this.nextPastCount[i][j] / (double)this.observations;
                double d5 = (double)this.pastCount[j] / (double)this.observations;
                if (d4 * d3 * d5 > 0.0) {
                    double d6 = d4 / (d3 * d5);
                    double d7 = Math.log(d6) / this.log_base;
                    d2 = d4 * d7;
                    System.out.println(String.format("%7d    %.2f %7d    %.2f     %.2f    %.2f     %.2f", i, d3, j, d5, d4, d6, d7));
                } else {
                    d2 = 0.0;
                    System.out.println(String.format("%7d    %.2f %7d    %.2f     %.2f    %.2f     %.2f", i, d3, j, d5, d4, 0.0, 0.0));
                }
                d += d2;
            }
        }
        System.out.println("Average is " + d);
    }

    @Override
    public int computePastValue(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < this.k; ++i) {
            n2 *= this.base;
            n2 += nArray[n - this.k + 1 + i];
        }
        return n2;
    }

    @Override
    public int computePastValue(int[][] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.k; ++i) {
            n3 *= this.base;
            n3 += nArray[n2 - this.k + 1 + i][n];
        }
        return n3;
    }

    @Override
    public int computePastValue(int[][][] nArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.k; ++i) {
            n4 *= this.base;
            n4 += nArray[n3 - this.k + 1 + i][n][n2];
        }
        return n4;
    }
}

