/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

public abstract class InfoMeasureCalculatorDiscrete {
    protected double average = 0.0;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double std = 0.0;
    protected int observations = 0;
    protected int base = 0;
    protected double log_base = 0.0;
    protected double log_2 = Math.log(2.0);
    protected boolean power_of_2_base = false;
    protected int log_2_base = 0;
    protected boolean debug = false;

    protected InfoMeasureCalculatorDiscrete(int n) {
        this.base = n;
        this.log_base = Math.log(n);
        if (n < 2) {
            throw new RuntimeException("Can't calculate info theoretic measures for base " + n);
        }
        this.power_of_2_base = InfoMeasureCalculatorDiscrete.isPowerOf2(n);
        if (this.power_of_2_base) {
            this.log_2_base = (int)Math.round(Math.log(n) / Math.log(2.0));
        }
    }

    public void initialise() {
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        this.std = 0.0;
        this.observations = 0;
    }

    public final double getLastAverage() {
        return this.average;
    }

    public double getLastMax() {
        return this.max;
    }

    public double getLastMin() {
        return this.min;
    }

    public final double getLastStd() {
        return this.std;
    }

    public final int getNumObservations() {
        return this.observations;
    }

    public static final boolean isPowerOf2(int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32; ++i) {
            if ((n3 & 1) > 0 && ++n2 > 1) {
                return false;
            }
            n3 >>= 1;
        }
        return n2 != 0;
    }

    public abstract double computeAverageLocalOfObservations();

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

