/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.ChannelCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class MutualInformationCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete
implements ChannelCalculatorDiscrete,
AnalyticNullDistributionComputer {
    private int timeDiff = 0;
    private int[][] jointCount = null;
    private int[] iCount = null;
    private int[] jCount = null;
    protected boolean miComputed = false;

    public MutualInformationCalculatorDiscrete(int n) throws Exception {
        this(n, 0);
    }

    public MutualInformationCalculatorDiscrete(int n, int n2) throws Exception {
        super(n);
        if (n2 < 0) {
            throw new Exception("timeDiff must be >= 0");
        }
        this.timeDiff = n2;
        this.jointCount = new int[n][n];
        this.iCount = new int[n];
        this.jCount = new int[n];
    }

    @Override
    public void initialise() {
        super.initialise();
        this.miComputed = false;
        MatrixUtils.fill(this.iCount, 0);
        MatrixUtils.fill(this.jCount, 0);
        MatrixUtils.fill(this.jointCount, 0);
    }

    @Override
    public void addObservations(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        this.observations += n - this.timeDiff;
        for (int i = this.timeDiff; i < n; ++i) {
            int n2 = nArray[i - this.timeDiff];
            int n3 = nArray2[i];
            int[] nArray3 = this.jointCount[n2];
            int n4 = n3;
            nArray3[n4] = nArray3[n4] + 1;
            int n5 = n2;
            this.iCount[n5] = this.iCount[n5] + 1;
            int n6 = n3;
            this.jCount[n6] = this.jCount[n6] + 1;
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n, int n2) {
        int n3 = nArray.length;
        this.observations += n3 - this.timeDiff;
        for (int i = this.timeDiff; i < n3; ++i) {
            int n4 = nArray[i - this.timeDiff][n];
            int n5 = nArray[i][n2];
            int[] nArray2 = this.jointCount[n4];
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n4;
            this.iCount[n7] = this.iCount[n7] + 1;
            int n8 = n5;
            this.jCount[n8] = this.jCount[n8] + 1;
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        double d3 = 0.0;
        if (this.debug) {
            System.out.println("i\tj\tp_i\tp_j\tp_joint\tlocal");
        }
        for (int i = 0; i < this.base; ++i) {
            double d4 = (double)this.iCount[i] / (double)this.observations;
            for (int j = 0; j < this.base; ++j) {
                double d5 = (double)this.jointCount[i][j] / (double)this.observations;
                double d6 = (double)this.jCount[j] / (double)this.observations;
                if (d5 * d4 * d6 > 0.0) {
                    double d7 = Math.log(d5 / (d4 * d6)) / this.log_2;
                    d2 = d5 * d7;
                    if (this.debug) {
                        System.out.printf("%d\t%d\t%.4f\t%.4f\t%.4f\t%.4f\n", i, j, d4, d6, d5, d7);
                    }
                    if (d7 > this.max) {
                        this.max = d7;
                    } else if (d7 < this.min) {
                        this.min = d7;
                    }
                    d3 += d2 * d7;
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        this.average = d;
        this.miComputed = true;
        this.std = Math.sqrt(d3 - this.average * this.average);
        return d;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.observations, n);
        return this.computeSignificance(nArray);
    }

    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) {
        MutualInformationCalculatorDiscrete mutualInformationCalculatorDiscrete;
        int n;
        double d = this.computeAverageLocalOfObservations();
        int n2 = nArray.length;
        int[] nArray2 = new int[this.observations];
        int[] nArray3 = new int[this.observations];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.base; ++i) {
            n = this.iCount[i];
            MatrixUtils.fill(nArray2, i, n3, n);
            n3 += n;
            int n5 = this.jCount[i];
            MatrixUtils.fill(nArray3, i, n4, n5);
            n4 += n5;
        }
        try {
            mutualInformationCalculatorDiscrete = new MutualInformationCalculatorDiscrete(this.base, this.timeDiff);
        }
        catch (Exception exception) {
            throw new Error("timeDiff parameter took on value < 0 after being checked at construction");
        }
        mutualInformationCalculatorDiscrete.initialise();
        mutualInformationCalculatorDiscrete.observations = this.observations;
        mutualInformationCalculatorDiscrete.iCount = this.iCount;
        mutualInformationCalculatorDiscrete.jCount = this.jCount;
        n = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n2);
        for (int i = 0; i < n2; ++i) {
            double d2;
            int[] nArray4 = MatrixUtils.extractSelectedTimePoints(nArray2, nArray[i]);
            MatrixUtils.fill(mutualInformationCalculatorDiscrete.jointCount, 0);
            for (int j = 0; j < this.observations; ++j) {
                int[] nArray5 = mutualInformationCalculatorDiscrete.jointCount[nArray4[j]];
                int n6 = nArray3[j];
                nArray5[n6] = nArray5[n6] + 1;
            }
            empiricalMeasurementDistribution.distribution[i] = d2 = mutualInformationCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n;
        }
        empiricalMeasurementDistribution.pValue = (double)n / (double)n2;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public AnalyticMeasurementDistribution computeSignificance() {
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        return new ChiSquareMeasurementDistribution(2.0 * (double)this.observations * this.average, (this.base - 1) * (this.base - 1));
    }

    public double computeLocalFromPreviousObservations(int n, int n2) throws Exception {
        double d = (double)this.jointCount[n][n2] / ((double)this.jCount[n2] * (double)this.iCount[n]);
        double d2 = Math.log(d *= (double)this.observations) / this.log_2;
        return d2;
    }

    public double[] computeLocalFromPreviousObservations(int[] nArray, int[] nArray2) throws Exception {
        if (nArray.length != nArray2.length) {
            throw new Exception("var1 and var2 must have the same number of observations");
        }
        double[] dArray = new double[nArray.length - this.timeDiff];
        double d = 0.0;
        for (int i = this.timeDiff; i < nArray.length; ++i) {
            int n = nArray[i - this.timeDiff];
            int n2 = nArray2[i];
            d = (double)this.jointCount[n][n2] / ((double)this.jCount[n2] * (double)this.iCount[n]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)this.observations;
        this.miComputed = true;
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int n2) {
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        double d = 0.0;
        for (int i = this.timeDiff; i < n3; ++i) {
            int n4 = nArray[i - this.timeDiff][n];
            int n5 = nArray[i][n2];
            d = (double)this.jointCount[n4][n5] / ((double)this.jCount[n5] * (double)this.iCount[n4]);
            dArray[i] = Math.log(d *= (double)this.observations) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)this.observations;
        return dArray;
    }

    public double[] computeLocal(int[][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }
}

