/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;

public class OctaveFileReader {
    private String filename;
    private BufferedReader br;
    private boolean isOpen = false;
    static final String SCALAR_HEADER = "# type: scalar";
    static final String GLOBAL_SCALAR_HEADER = "# type: scalar";
    static final String MATRIX_HEADER = "# type: matrix";
    static final String GLOBAL_MATRIX_HEADER = "# type: global matrix";
    static final String BOOL_MATRIX_HEADER = "# type: bool matrix";
    static final String OCTAVE_DELIMITER = "[ \t]";

    public OctaveFileReader(String string) throws FileNotFoundException {
        this.filename = string;
        this.openOctaveFile();
    }

    private void openOctaveFile() throws FileNotFoundException {
        if (this.isOpen) {
            return;
        }
        this.br = new BufferedReader(new FileReader(this.filename));
        this.isOpen = true;
    }

    private void closeOctaveFile() throws IOException {
        this.br.close();
        this.isOpen = false;
    }

    public int getInt(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!string2.equals("# type: scalar") && !string2.equals("# type: scalar")) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with int");
                    }
                    string2 = this.br.readLine();
                    this.closeOctaveFile();
                    double d = Double.parseDouble(string2);
                    return (int)d;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public double getDouble(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!string2.equals("# type: scalar") && !string2.equals("# type: scalar")) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with double");
                    }
                    string2 = this.br.readLine();
                    this.closeOctaveFile();
                    return Double.parseDouble(string2);
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public int[] getIntArray(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!(string2.equals(MATRIX_HEADER) || string2.equals(GLOBAL_MATRIX_HEADER) || string2.equals(BOOL_MATRIX_HEADER))) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with int[] - not a matrix");
                    }
                    string2 = this.br.readLine();
                    String[] stringArray = string2.split(" ");
                    int n = Integer.parseInt(stringArray[2]);
                    string2 = this.br.readLine();
                    stringArray = string2.split(" ");
                    int n2 = Integer.parseInt(stringArray[2]);
                    if (n != 1 && n2 != 1) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with int[] - not a single dimension (" + n + " x " + n2 + ")");
                    }
                    int n3 = n > n2 ? n : n2;
                    int[] nArray = new int[n3];
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        string2 = this.br.readLine();
                        String[] stringArray2 = string2.split(OCTAVE_DELIMITER);
                        if (stringArray2.length + 1 < n2) {
                            throw new Exception("Not enough values for row " + i + " of variable " + string);
                        }
                        for (int j = 0; j < n2; ++j) {
                            nArray[n4] = Integer.parseInt(stringArray2[j + 1]);
                            ++n4;
                        }
                    }
                    this.closeOctaveFile();
                    return nArray;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public long[] getLongArray(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!(string2.equals(MATRIX_HEADER) || string2.equals(GLOBAL_MATRIX_HEADER) || string2.equals(BOOL_MATRIX_HEADER))) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with long[] - not a matrix");
                    }
                    string2 = this.br.readLine();
                    String[] stringArray = string2.split(" ");
                    int n = Integer.parseInt(stringArray[2]);
                    string2 = this.br.readLine();
                    stringArray = string2.split(" ");
                    int n2 = Integer.parseInt(stringArray[2]);
                    if (n != 1 && n2 != 1) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with long[] - not a single dimension (" + n + " x " + n2 + ")");
                    }
                    int n3 = n > n2 ? n : n2;
                    long[] lArray = new long[n3];
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        string2 = this.br.readLine();
                        String[] stringArray2 = string2.split(OCTAVE_DELIMITER);
                        if (stringArray2.length + 1 < n2) {
                            throw new Exception("Not enough values for row " + i + " of variable " + string);
                        }
                        for (int j = 0; j < n2; ++j) {
                            lArray[n4] = Long.parseLong(stringArray2[j + 1]);
                            ++n4;
                        }
                    }
                    this.closeOctaveFile();
                    return lArray;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public double[] getDoubleArray(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!string2.equals(MATRIX_HEADER) && !string2.equals(GLOBAL_MATRIX_HEADER)) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with double[] - not a matrix");
                    }
                    string2 = this.br.readLine();
                    String[] stringArray = string2.split(" ");
                    int n = Integer.parseInt(stringArray[2]);
                    string2 = this.br.readLine();
                    stringArray = string2.split(" ");
                    int n2 = Integer.parseInt(stringArray[2]);
                    if (n != 1 && n2 != 1) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with double[] - not a single dimension (" + n + " x " + n2 + ")");
                    }
                    int n3 = n > n2 ? n : n2;
                    double[] dArray = new double[n3];
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        string2 = this.br.readLine();
                        String[] stringArray2 = string2.split(OCTAVE_DELIMITER);
                        if (stringArray2.length + 1 < n2) {
                            throw new Exception("Not enough values for row " + i + " of variable " + string);
                        }
                        for (int j = 0; j < n2; ++j) {
                            dArray[n4] = Double.parseDouble(stringArray2[j + 1]);
                            ++n4;
                        }
                    }
                    this.closeOctaveFile();
                    return dArray;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public int[][] getInt2DMatrix(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!(string2.equals(MATRIX_HEADER) || string2.equals(GLOBAL_MATRIX_HEADER) || string2.equals(BOOL_MATRIX_HEADER))) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with int[][]");
                    }
                    string2 = this.br.readLine();
                    String[] stringArray = string2.split(" ");
                    int n = Integer.parseInt(stringArray[2]);
                    string2 = this.br.readLine();
                    stringArray = string2.split(" ");
                    int n2 = Integer.parseInt(stringArray[2]);
                    int[][] nArray = new int[n][n2];
                    for (int i = 0; i < n; ++i) {
                        string2 = this.br.readLine();
                        String[] stringArray2 = string2.split(OCTAVE_DELIMITER);
                        int n3 = 0;
                        if (stringArray2.length > 0 && stringArray2[0].equalsIgnoreCase("")) {
                            n3 = 1;
                        }
                        if (stringArray2.length - n3 < n2) {
                            throw new Exception("Not enough values for row " + i + " of " + n + " of variable " + string + "( actual: " + (stringArray2.length - n3) + ", required: " + n2 + ")");
                        }
                        for (int j = 0; j < n2; ++j) {
                            nArray[i][j] = Integer.parseInt(stringArray2[j + n3]);
                        }
                    }
                    this.closeOctaveFile();
                    return nArray;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public double[][] getDouble2DMatrix(String string) throws Exception {
        this.openOctaveFile();
        try {
            String string2 = this.br.readLine();
            while (string2 != null) {
                if (string2.equalsIgnoreCase("# name: " + string)) {
                    string2 = this.br.readLine();
                    if (!string2.equals(MATRIX_HEADER) && !string2.equals(GLOBAL_MATRIX_HEADER)) {
                        throw new Exception("Stored Octave variable " + string + " is not of a type compatible with int[][]");
                    }
                    string2 = this.br.readLine();
                    String[] stringArray = string2.split(" ");
                    int n = Integer.parseInt(stringArray[2]);
                    string2 = this.br.readLine();
                    stringArray = string2.split(" ");
                    int n2 = Integer.parseInt(stringArray[2]);
                    double[][] dArray = new double[n][n2];
                    for (int i = 0; i < n; ++i) {
                        string2 = this.br.readLine();
                        String[] stringArray2 = string2.split(OCTAVE_DELIMITER);
                        if (stringArray2.length + 1 < n2) {
                            throw new Exception("Not enough values for row " + i + " of variable " + string);
                        }
                        for (int j = 0; j < n2; ++j) {
                            dArray[i][j] = Double.parseDouble(stringArray2[j + 1]);
                        }
                    }
                    this.closeOctaveFile();
                    return dArray;
                }
                string2 = this.br.readLine();
            }
            throw new Exception("Stored Octave variable " + string + " not found");
        }
        catch (Exception exception) {
            this.closeOctaveFile();
            throw exception;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        OctaveFileReader octaveFileReader = new OctaveFileReader("C:\\Work\\Investigations\\CATransferEntropy\\base-2\\neighbourhood-5\\rule-133976044.txt");
        int[][] nArray = octaveFileReader.getInt2DMatrix("settledExecutedRules");
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                System.out.print(" " + nArray[i][j]);
            }
            System.out.println();
        }
        System.out.println("rules has " + nArray.length + " rows and " + nArray[0].length + " columns");
        System.out.println("base = " + octaveFileReader.getInt("base"));
        System.out.println("neighbourhood = " + octaveFileReader.getInt("neighbourhood"));
        int[] nArray2 = new int[3];
        if (nArray2.getClass().isArray()) {
            System.out.println("got an array of length " + Array.getLength(nArray2));
        }
        System.out.println(nArray2.getClass() + " " + nArray2);
    }
}

