/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.MultiInfoCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.EuclideanUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Vector;

public abstract class MultiInfoCalculatorKraskov
implements MultiInfoCalculator {
    protected int k = 4;
    protected double[][] data;
    protected boolean debug;
    protected double mi;
    protected boolean miComputed;
    private Vector<double[]> individualObservations;
    protected int N;
    protected int V;
    protected EuclideanUtils normCalculator = new EuclideanUtils(2);
    protected double[][][] norms;
    protected boolean tryKeepAllPairsNorms = true;
    public static int MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM = 4000;
    public static final String PROP_K = "k";
    public static final String PROP_NORM_TYPE = "NORM_TYPE";
    public static final String PROP_TRY_TO_KEEP_ALL_PAIRS_NORM = "TRY_KEEP_ALL_PAIRS_NORM";

    @Override
    public void initialise(int n) {
        this.V = n;
        this.mi = 0.0;
        this.miComputed = false;
        this.norms = null;
        this.data = null;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase(PROP_K)) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_NORM_TYPE)) {
            this.normCalculator.setNormToUse(string2);
        } else if (string.equalsIgnoreCase(PROP_TRY_TO_KEEP_ALL_PAIRS_NORM)) {
            this.tryKeepAllPairsNorms = Boolean.parseBoolean(string2);
        }
    }

    @Override
    public void setObservations(double[][] dArray) throws Exception {
        if (dArray == null || dArray[0].length == 0) {
            throw new Exception("Computing MI with a null set of data");
        }
        if (dArray[0].length != this.V) {
            throw new Exception("Incorrect number of dimensions " + dArray[0].length + " in supplied observations (expected " + this.V + ")");
        }
        this.data = dArray;
        this.N = this.data.length;
    }

    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray == null || dArray[0].length == 0 || dArray2 == null || dArray2[0].length == 0) {
            throw new Exception("Computing MI with a null set of data");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of the time series to be joined to not match");
        }
        if (dArray[0].length + dArray2[0].length != this.V) {
            throw new Exception("Incorrect number of dimensions " + (dArray[0].length + dArray2[0].length) + " in supplied observations (expected " + this.V + ")");
        }
        this.N = dArray.length;
        this.data = new double[this.N][this.V];
        for (int i = 0; i < this.N; ++i) {
            int n;
            int n2 = 0;
            for (n = 0; n < dArray[i].length; ++n) {
                this.data[i][n2++] = dArray[i][n];
            }
            for (n = 0; n < dArray2[i].length; ++n) {
                this.data[i][n2++] = dArray2[i][n];
            }
        }
    }

    @Override
    public void startAddObservations() {
        this.individualObservations = new Vector();
    }

    @Override
    public void addObservation(double[] dArray) {
        this.individualObservations.add(dArray);
    }

    @Override
    public void addObservations(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addObservation(dArray[i]);
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        double[][] dArrayArray = new double[this.individualObservations.size()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = this.individualObservations.elementAt(i);
        }
        this.individualObservations = null;
        this.setObservations(dArrayArray);
    }

    protected void computeNorms() {
        this.norms = new double[this.V][this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            double[][] dArray = EuclideanUtils.computeNorms(this.data, i);
            for (int j = 0; j < this.N; ++j) {
                for (int k = 0; k < this.V; ++k) {
                    this.norms[k][i][j] = dArray[j][k];
                }
            }
        }
    }

    public abstract double computeAverageLocalOfObservations(int[][] var1) throws Exception;

    public synchronized EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][][] nArrayArray = new int[n][][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = randomGenerator.generateRandomPerturbations(this.data.length, this.V - 1);
        }
        return this.computeSignificance(nArrayArray);
    }

    public EmpiricalMeasurementDistribution computeSignificance(int[][][] nArray) throws Exception {
        int n = nArray.length;
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        double d = this.mi;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2;
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations(nArray[i]);
            if (this.debug) {
                System.out.println("New MI was " + d2);
            }
            if (!(d2 >= d)) continue;
            ++n2;
        }
        this.mi = d;
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        throw new Exception("Local method not implemented yet");
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.mi;
    }

    public abstract String printConstants(int var1) throws Exception;

    protected int[] reorderedTimeStepsForEachMarginal(int[][] nArray, int n) {
        int[] nArray2 = new int[this.V];
        if (nArray == null) {
            for (int i = 0; i < this.V; ++i) {
                nArray2[i] = n;
            }
        } else {
            boolean bl = nArray.length == this.V;
            int n2 = 0;
            nArray2[0] = bl ? nArray[n2++][n] : n;
            for (int i = 1; i < this.V; ++i) {
                nArray2[i] = nArray[n2++][n];
            }
        }
        return nArray2;
    }
}

