/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.MatrixUtils;
import infodynamics.utils.commonsmath3.special.Gamma;

public class MathsUtils {
    private static final double EULER_MASCHERONI_CONSTANT = 0.5772156;
    private static int highestDigammaArgCalced = 0;
    private static final int NUM_STORED_DIGAMMAS = 10000;
    private static double[] storedDigammas;

    public static int power(int n, int n2) {
        int n3 = 1;
        int n4 = Math.abs(n2);
        for (int i = 0; i < n4; ++i) {
            n3 *= n;
        }
        if (n2 < 0) {
            n3 = 1 / n3;
        }
        return n3;
    }

    public static long power(long l, long l2) {
        long l3 = 1L;
        long l4 = Math.abs(l2);
        for (long i = 0L; i < l4; ++i) {
            l3 *= l;
        }
        if (l2 < 0L) {
            l3 = 1L / l3;
        }
        return l3;
    }

    public static long factorial(int n) {
        long l = 1L;
        for (int i = 1; i <= n; ++i) {
            l *= (long)i;
        }
        return l;
    }

    public static int factorialCheckBounds(int n) throws Exception {
        long l = 1L;
        for (int i = 1; i <= n; ++i) {
            if ((l *= (long)i) <= Integer.MAX_VALUE) continue;
            throw new Exception("n! causes integer overflow");
        }
        return (int)l;
    }

    public static double factorialAsDouble(int n) {
        double d = 1.0;
        for (int i = 1; i <= n; ++i) {
            d *= (double)i;
        }
        return d;
    }

    public static double factorialAsDoubleIncludeDivisor(int n, double d) {
        double d2 = 1.0 / d;
        for (int i = 1; i <= n; ++i) {
            d2 *= (double)i;
        }
        return d2;
    }

    public static long doubleFactorial(int n) {
        long l = 1L;
        int n2 = n % 2 == 0 ? 2 : 3;
        for (int i = n2; i <= n; i += 2) {
            l *= (long)i;
        }
        return l;
    }

    public static double doubleFactorialAsDouble(int n) {
        double d = 1.0;
        int n2 = n % 2 == 0 ? 2 : 3;
        for (int i = n2; i <= n; i += 2) {
            d *= (double)i;
        }
        return d;
    }

    public static double doubleFactorialAsDoublewithDivisor(int n, double d) {
        double d2 = 1.0 / d;
        int n2 = n % 2 == 0 ? 2 : 3;
        for (int i = n2; i <= n; i += 2) {
            d2 *= (double)i;
        }
        return d2;
    }

    public static double gammaOfArgOn2Plus1(int n) {
        if (n % 2 == 0) {
            return MathsUtils.factorialAsDouble(n / 2);
        }
        return Math.sqrt(Math.PI) * MathsUtils.doubleFactorialAsDouble(n) / Math.pow(2.0, (double)(n + 1) / 2.0);
    }

    public static double gammaOfArgOn2Plus1IncludeDivisor(int n, double d) {
        if (n % 2 == 0) {
            return MathsUtils.factorialAsDoubleIncludeDivisor(n / 2, d);
        }
        return MathsUtils.doubleFactorialAsDoublewithDivisor(n, d * Math.pow(2.0, (double)(n + 1) / 2.0) / Math.sqrt(Math.PI));
    }

    public static double digamma(int n) throws Exception {
        if (n < 1) {
            return Double.NaN;
        }
        if (storedDigammas == null) {
            storedDigammas = new double[10000];
            MathsUtils.storedDigammas[0] = Double.NaN;
            MathsUtils.storedDigammas[1] = -0.5772156;
            highestDigammaArgCalced = 1;
        }
        if (n <= highestDigammaArgCalced) {
            return storedDigammas[n];
        }
        double d = storedDigammas[highestDigammaArgCalced];
        for (int i = highestDigammaArgCalced + 1; i <= n; ++i) {
            d += 1.0 / (double)(i - 1);
            if (i >= 10000) continue;
            MathsUtils.storedDigammas[i] = d;
        }
        highestDigammaArgCalced = n < 10000 ? n : 9999;
        return d;
    }

    public static double digammaByDefinition(int n) throws Exception {
        if (n < 1) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = n; i > 1; --i) {
            d += 1.0 / (double)(i - 1);
        }
        return d += -0.5772156;
    }

    public static double chiSquareCdf(double d, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("k (" + n + ") must be > 0");
        }
        return Gamma.regularizedGammaP((double)n / 2.0, d / 2.0);
    }

    public static double lowerIncompleteGammaFunctionOfArgsOn2(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("s must be > 0");
        }
        if (n == 2) {
            return 1.0 - Math.exp(-d / 2.0);
        }
        if (n == 1) {
            return Math.sqrt(Math.PI) * MathsUtils.erf(Math.sqrt(d / 2.0));
        }
        return ((double)n / 2.0 - 1.0) * MathsUtils.lowerIncompleteGammaFunctionOfArgsOn2(n - 2, d) - Math.pow(d / 2.0, (double)n / 2.0 - 1.0) * Math.exp(-d / 2.0);
    }

    public static double erf(double d) {
        boolean bl;
        double d2 = 0.3275911;
        double[] dArray = new double[]{0.254829592, -0.284496736, 1.421413741, -1.453152027, 1.061405429};
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d3 = 1.0 / (1.0 + d2 * d);
        double d4 = 0.0;
        double d5 = d3;
        for (int i = 0; i < 5; ++i) {
            d4 += dArray[i] * d5;
            d5 *= d3;
        }
        double d6 = 1.0 - d4 * Math.exp(-d * d);
        return bl ? -d6 : d6;
    }

    public static double normalPdf(double d, double d2, double d3) throws Exception {
        if (d3 < 0.0) {
            throw new Exception("Standard deviation cannot be < 0");
        }
        double d4 = (d - d2) / d3;
        d4 *= d4;
        double d5 = Math.pow(Math.PI * 2, -0.5) / d3 * Math.exp(-0.5 * d4);
        return d5;
    }

    public static double normalCdf(double d, double d2, double d3) throws Exception {
        if (d3 < 0.0) {
            throw new Exception("Standard deviation cannot be < 0");
        }
        double d4 = (d - d2) / Math.sqrt(2.0 * d3 * d3);
        double d5 = 0.5 * (1.0 + MathsUtils.erf(d4));
        return d5;
    }

    public static double normalPdf(double[] dArray, double[] dArray2, double[][] dArray3) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of observations must match means");
        }
        return MathsUtils.normalPdf(MatrixUtils.subtract(dArray, dArray2), dArray3);
    }

    public static double normalPdf(double[] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Vector length of deviations does not match the size of the covariance matrix");
        }
        double d = MatrixUtils.determinant(dArray2);
        double[][] dArray3 = MatrixUtils.invertSymmPosDefMatrix(dArray2);
        double d2 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray, dArray3), dArray);
        double d3 = Math.pow(Math.PI * 2, (double)(-dArray.length) / 2.0) / Math.sqrt(d) * Math.exp(-0.5 * d2);
        return d3;
    }

    public static int numOfSets(int n, int n2) throws Exception {
        long l = n;
        long l2 = 1L;
        for (int i = 1; i <= n2; ++i) {
            l2 *= l;
            if ((l2 /= (long)i) > Integer.MAX_VALUE) {
                throw new Exception("nCp causes integer overflow");
            }
            --l;
        }
        return (int)l2;
    }

    public static int[][] generateAllSets(int n, int n2) throws Exception {
        int n3 = MathsUtils.numOfSets(n, n2);
        int[][] nArray = new int[n3][n2];
        int[] nArray2 = new int[n2];
        MathsUtils.writeSetsIn(n, n2, 0, 0, nArray2, nArray, 0);
        return nArray;
    }

    private static int writeSetsIn(int n, int n2, int n3, int n4, int[] nArray, int[][] nArray2, int n5) {
        for (int i = n4; i < n - n2 + n3 + 1; ++i) {
            nArray[n3] = i;
            if (n3 == n2 - 1) {
                System.arraycopy(nArray, 0, nArray2[n5++], 0, n2);
                continue;
            }
            n5 = MathsUtils.writeSetsIn(n, n2, n3 + 1, i + 1, nArray, nArray2, n5);
        }
        return n5;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 10;
        System.out.println("chi2cdf(1," + n + ")= " + MathsUtils.chiSquareCdf(1.0, n));
        System.out.println("chi2cdf(2," + n + ")= " + MathsUtils.chiSquareCdf(2.0, n));
        System.out.println("chi2cdf(3," + n + ")= " + MathsUtils.chiSquareCdf(3.0, n));
        for (int i = 0; i < 100; ++i) {
            System.out.println("chi2cdf(" + (double)i * 0.1 + "," + n + ")= " + MathsUtils.chiSquareCdf((double)i * 0.1, n));
        }
    }
}

