/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.indexers;

import com.cloudant.couchdbjavaserver.SearchView;
import com.cloudant.index.CouchIndexUtils;
import com.cloudant.index.IndexType;
import com.cloudant.index.IndexUtilities;
import com.cloudant.index.SingleDocumentIndex;
import com.stinkyteddy.utils.StDateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MyCustomSearch
implements SearchView {
    private Map<String, FieldOption> fieldsToStore = null;
    private Map<Pattern, String> regexps = null;
    private Map<String, FieldOption> matches = null;
    private HashSet<String> misses = null;
    private Analyzer analyzer = null;
    private List<SimpleDateFormat> dateFormats = null;

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            return new StandardAnalyzer(Version.LUCENE_30);
        }
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void Log(String string) {
    }

    public JSONArray MapDoc(JSONObject jSONObject) {
        JSONArray jSONArray;
        block21: {
            jSONArray = new JSONArray();
            try {
                Analyzer analyzer = this.getAnalyzer();
                SingleDocumentIndex singleDocumentIndex = new SingleDocumentIndex();
                Map<String, List<Object>> map = CouchIndexUtils.MapJSONObject2Object(jSONObject, null);
                if (map == null) {
                    return jSONArray.put((Object)new JSONArray());
                }
                for (String string : map.keySet()) {
                    try {
                        FieldOption fieldOption = this.findField(string);
                        if (fieldOption == null) continue;
                        List<Object> list = map.get(string);
                        for (Object object : list) {
                            if (object == null) continue;
                            IndexType indexType = fieldOption.getType();
                            float f = (float)fieldOption.getBoost();
                            String string2 = fieldOption.getFieldName();
                            if (string2 == null) {
                                string2 = string;
                            }
                            switch (indexType) {
                                case STRING: {
                                    singleDocumentIndex.addField(string2, IndexUtilities.ObjectToString(object), analyzer, f);
                                    break;
                                }
                                case KEYWORD: {
                                    singleDocumentIndex.addField(string2, (Object)IndexUtilities.ObjectToString(object), f);
                                    break;
                                }
                                case BOOLEAN: {
                                    singleDocumentIndex.addField(string2, object, f);
                                    break;
                                }
                                case INT: {
                                    singleDocumentIndex.addField(string2, (Long)object, f);
                                    break;
                                }
                                case LONG: {
                                    singleDocumentIndex.addField(string2, (Long)object, f);
                                    break;
                                }
                                case FLOAT: {
                                    singleDocumentIndex.addField(string2, (Float)object, f);
                                    break;
                                }
                                case DOUBLE: {
                                    singleDocumentIndex.addField(string2, (Double)object, f);
                                    break;
                                }
                                case DATE: {
                                    Date date = null;
                                    date = this.parseDate((String)object);
                                    if (date != null) {
                                        singleDocumentIndex.addField(string2, date.getTime(), f);
                                        break;
                                    }
                                    singleDocumentIndex.addField(string2, (Object)IndexUtilities.ObjectToString(object), f);
                                    break;
                                }
                                case JSONOBJECT: {
                                    singleDocumentIndex.addField(string2, object, f);
                                    break;
                                }
                                case NULL: {
                                    singleDocumentIndex.addField(string2, JSONObject.NULL, f);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                jSONArray = singleDocumentIndex.jsonMap();
            }
            catch (Exception exception) {
                jSONArray.put((Object)new JSONArray());
                if (exception == null) break block21;
                this.Log("Map Exception: " + exception.toString());
            }
        }
        return jSONArray;
    }

    public FieldOption findField(String string) {
        if (this.fieldsToStore == null || string == null) {
            return null;
        }
        if (this.misses.contains(string)) {
            return null;
        }
        if (this.fieldsToStore.containsKey(string)) {
            return this.fieldsToStore.get(string);
        }
        if (this.matches.containsKey(string)) {
            return this.matches.get(string);
        }
        if (this.regexps == null) {
            return null;
        }
        for (Pattern pattern : this.regexps.keySet()) {
            Matcher matcher = pattern.matcher(string);
            if (matcher == null || !matcher.matches()) continue;
            FieldOption fieldOption = this.fieldsToStore.get(this.regexps.get(pattern));
            this.matches.put(string, fieldOption);
            return fieldOption;
        }
        this.misses.add(string);
        return null;
    }

    public void Configure(String string) {
        block12: {
            this.matches = new HashMap<String, FieldOption>();
            this.misses = new HashSet();
            if (string == null || string.length() == 0) {
                this.fieldsToStore = new HashMap<String, FieldOption>();
                this.fieldsToStore.put(".*", new FieldOption(null, IndexType.STRING, 1.0, true));
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                this.fieldsToStore = new HashMap<String, FieldOption>();
                JSONArray jSONArray = jSONObject.optJSONArray("fields");
                if (jSONArray == null) {
                    this.fieldsToStore.put(".*", new FieldOption(null, IndexType.STRING, 1.0, true));
                    break block12;
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    String string2;
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string3 = jSONObject2.optString("lucenename", string2 = jSONObject2.getString("name"));
                    if (string3 == null) {
                        string2 = null;
                    }
                    double d = jSONObject2.optDouble("boost", 1.0);
                    boolean bl = jSONObject2.optBoolean("regexp", false);
                    String string4 = jSONObject2.optString("type", "string");
                    IndexType indexType = IndexType.getIndexTypeFromString(string4);
                    if (indexType == IndexType.DATE) {
                        try {
                            String string5 = jSONObject2.getString("dateformat");
                            if (string5 != null) {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
                                this.dateFormats.add(simpleDateFormat);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    this.fieldsToStore.put(string2, new FieldOption(string3, indexType, d, bl));
                    if (!bl) continue;
                    if (this.regexps == null) {
                        this.regexps = new HashMap<Pattern, String>();
                    }
                    this.regexps.put(Pattern.compile(string2), string2);
                }
            }
            catch (JSONException jSONException) {
                this.Log("CustomSearch.Configure error parsing configuration string: " + string);
            }
        }
    }

    public JSONArray ReReduce(JSONArray jSONArray) {
        return new JSONArray();
    }

    public JSONArray Reduce(JSONArray jSONArray) {
        return new JSONArray();
    }

    public Date parseDate(String string) {
        Date date = null;
        if (this.dateFormats != null) {
            for (SimpleDateFormat simpleDateFormat : this.dateFormats) {
                try {
                    date = simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {}
            }
        }
        if (date == null) {
            date = StDateUtils.parseDateString(string);
        }
        return date;
    }

    public class FieldOption {
        private IndexType type;
        private double boost;
        private String fieldName;
        private boolean isRegexp;

        public FieldOption(String string, IndexType indexType, float f) {
            this.setType(indexType);
            this.setBoost(f);
            this.setFieldName(string);
            this.setRegexp(false);
        }

        public FieldOption(String string, IndexType indexType, double d, boolean bl) {
            this.setType(indexType);
            this.setBoost(d);
            this.setFieldName(string);
            this.setRegexp(bl);
        }

        public void setType(IndexType indexType) {
            this.type = indexType;
        }

        public IndexType getType() {
            return this.type;
        }

        public void setBoost(double d) {
            this.boost = d;
        }

        public double getBoost() {
            return this.boost;
        }

        public void setFieldName(String string) {
            this.fieldName = string;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setRegexp(boolean bl) {
            this.isRegexp = bl;
        }

        public boolean isRegexp() {
            return this.isRegexp;
        }
    }
}

