/*
 * Decompiled with CFR 0.152.
 */
package com.stinkyteddy.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;

public class StDateUtils {
    public static long MILLIS_PER_YEAR = 31536000000L;
    public static long MILLIS_PER_MONTH = 2592000000L;
    public static long MILLIS_PER_WEEK = 604800000L;
    public static long MILLIS_PER_DAY = 86400000L;
    public static long MILLIS_PER_HOUR = 3600000L;
    public static long MILLIS_PER_MINUTE = 60000L;
    public static long MILLIS_PER_SECOND = 1000L;

    public static Date parseBingDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return StDateUtils.parseDateString(string, simpleDateFormat);
    }

    public static Date parseBossDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd kk:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return StDateUtils.parseDateString(string, simpleDateFormat);
    }

    public static Date parseTwitterDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        return StDateUtils.parseDateString(string, simpleDateFormat);
    }

    public static Date parseCollectaDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
        return StDateUtils.parseDateString(string, simpleDateFormat);
    }

    public static Date parseUnixDate(String string) {
        try {
            long l = Long.parseLong(string);
            return new Date(l);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Date parseVideoSurfDate(String string) {
        if (string == null || !string.contains("ago")) {
            return null;
        }
        Date date = null;
        Calendar calendar = Calendar.getInstance();
        String[] stringArray = string.split(" ");
        if (stringArray.length > 1) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                String string2 = stringArray[1];
                if (string2.contains("yr")) {
                    calendar.add(6, -(365 * n));
                } else if (string2.contains("mo")) {
                    calendar.add(6, -(30 * n));
                } else if (string2.contains("da")) {
                    calendar.add(6, -n);
                } else if (string2.contains("wk")) {
                    calendar.add(6, -(7 * n));
                } else if (string2.contains("hr")) {
                    calendar.add(11, -n);
                } else if (string2.contains("mi")) {
                    calendar.add(12, -n);
                }
                return calendar.getTime();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return date;
    }

    public static Date parseDateString(String string) {
        Date date = null;
        date = StDateUtils.parseBingDate(string);
        if (date != null) {
            return date;
        }
        date = StDateUtils.parseBossDate(string);
        if (date != null) {
            return date;
        }
        date = StDateUtils.parseTwitterDate(string);
        if (date != null) {
            return date;
        }
        date = StDateUtils.parseVideoSurfDate(string);
        if (date != null) {
            return date;
        }
        date = StDateUtils.parseCollectaDate(string);
        if (date != null) {
            return date;
        }
        date = StDateUtils.parseUnixDate(string);
        if (date != null) {
            return date;
        }
        return date;
    }

    public static Date parseDateString(String string, DateFormat dateFormat) {
        if (string == null || dateFormat == null) {
            return null;
        }
        try {
            Date date = dateFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String makeIndexString(Date date) {
        if (date == null) {
            return "";
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        if (l / MILLIS_PER_YEAR > 0L) {
            return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.YEAR);
        }
        if (l / MILLIS_PER_MONTH > 0L) {
            return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MONTH);
        }
        if (l / MILLIS_PER_DAY > 0L) {
            return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY);
        }
        if (l / MILLIS_PER_HOUR > 0L) {
            return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.HOUR);
        }
        if (l / MILLIS_PER_MINUTE > 0L) {
            return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MINUTE);
        }
        return DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND);
    }

    public static String makePrintedString(String string) {
        if (string == null || string == "") {
            return "";
        }
        Date date = new Date();
        try {
            long l = DateTools.stringToTime((String)string);
            long l2 = date.getTime() - l;
            long l3 = 0L;
            String string2 = "";
            if (l2 / MILLIS_PER_YEAR > 0L) {
                l3 = l2 / MILLIS_PER_YEAR;
                string2 = "year";
            } else if (l2 / MILLIS_PER_MONTH > 0L) {
                l3 = l2 / MILLIS_PER_MONTH;
                string2 = "month";
            } else if (l2 / MILLIS_PER_WEEK > 0L) {
                l3 = l2 / MILLIS_PER_WEEK;
                string2 = "week";
            } else if (l2 / MILLIS_PER_DAY > 0L) {
                l3 = l2 / MILLIS_PER_DAY;
                string2 = "day";
            } else if (l2 / MILLIS_PER_HOUR > 0L) {
                l3 = l2 / MILLIS_PER_HOUR;
                string2 = "hour";
            } else if (l2 / MILLIS_PER_MINUTE > 0L) {
                l3 = l2 / MILLIS_PER_MINUTE;
                string2 = "minute";
            } else if (l2 / MILLIS_PER_SECOND > 0L) {
                l3 = l2 / MILLIS_PER_SECOND;
                string2 = "second";
            } else {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.valueOf(l3));
            stringBuilder.append(" " + string2);
            if (l3 != 1L) {
                stringBuilder.append("s");
            }
            stringBuilder.append(" ago");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static long getAgeInMillis(String string) {
        if (string == null) {
            return 0L;
        }
        Date date = new Date();
        try {
            long l = DateTools.stringToTime((String)string);
            long l2 = date.getTime() - l;
            return l2;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String convertMillisToString(long l) {
        if (l == 0L) {
            return "";
        }
        try {
            long l2 = 0L;
            String string = "";
            if (l / MILLIS_PER_YEAR > 0L) {
                l2 = l / MILLIS_PER_YEAR;
                string = "year";
            } else if (l / MILLIS_PER_MONTH > 0L) {
                l2 = l / MILLIS_PER_MONTH;
                string = "month";
            } else if (l / MILLIS_PER_WEEK > 0L) {
                l2 = l / MILLIS_PER_WEEK;
                string = "week";
            } else if (l / MILLIS_PER_DAY > 0L) {
                l2 = l / MILLIS_PER_DAY;
                string = "day";
            } else if (l / MILLIS_PER_HOUR > 0L) {
                l2 = l / MILLIS_PER_HOUR;
                string = "hour";
            } else if (l / MILLIS_PER_MINUTE > 0L) {
                l2 = l / MILLIS_PER_MINUTE;
                string = "minute";
            } else if (l / MILLIS_PER_SECOND > 0L) {
                l2 = l / MILLIS_PER_SECOND;
                string = "second";
            } else {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.valueOf(l2));
            stringBuilder.append(" " + string);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String convertMillisToFrequency(long l) {
        if (l == 0L) {
            return "";
        }
        try {
            long l2 = 0L;
            String string = "";
            if (MILLIS_PER_SECOND / l > 0L) {
                l2 = MILLIS_PER_SECOND / l;
                string = "second";
            } else if (MILLIS_PER_MINUTE / l > 0L) {
                l2 = MILLIS_PER_MINUTE / l;
                string = "minute";
            } else if (MILLIS_PER_HOUR / l > 0L) {
                l2 = MILLIS_PER_HOUR / l;
                string = "hour";
            } else if (MILLIS_PER_DAY / l > 0L) {
                l2 = MILLIS_PER_DAY / l;
                string = "day";
            } else if (MILLIS_PER_WEEK / l > 0L) {
                l2 = MILLIS_PER_WEEK / l;
                string = "week";
            } else if (MILLIS_PER_MONTH / l > 0L) {
                l2 = MILLIS_PER_MONTH / l;
                string = "month";
            } else if (MILLIS_PER_YEAR / l > 0L) {
                l2 = MILLIS_PER_YEAR / l;
                string = "year";
            } else {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.valueOf(l2));
            stringBuilder.append(" " + string);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

