package me.shenfeng.http.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SSLTest {

    public static void main(String[] args) throws Exception {
        SSLContext context = SslContextFactory.getClientContext();
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(true);

        SocketChannel channel = SocketChannel.open();
        // channel.configureBlocking(false);
        channel.connect(new InetSocketAddress("trakrapp.com", 443));
        // channel.con
        // SocketChannel channel = SocketChannel.open();

        // channel.configureBlocking(true);

        while (!channel.finishConnect()) {
            // System.out.println("-=----");
        }
        // System.out.println("=--=========================");

        // Create byte buffers to use for holding application and encoded data
        SSLSession session = engine.getSession();
        ByteBuffer myAppData = ByteBuffer.allocate(session
                .getApplicationBufferSize());
        ByteBuffer myNetData = ByteBuffer.allocate(session
                .getPacketBufferSize());
        ByteBuffer peerAppData = ByteBuffer.allocate(session
                .getApplicationBufferSize());
        ByteBuffer peerNetData = ByteBuffer.allocate(session
                .getPacketBufferSize());
        doHandshake(channel, engine, myNetData, peerNetData);

    }

    static void doHandshake(SocketChannel socketChannel, SSLEngine engine,
            ByteBuffer myNetData, ByteBuffer peerNetData) throws Exception {

        // Create byte buffers to use for holding application data
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);

        // Begin handshake
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();

        // Process handshaking message
        while (hs != SSLEngineResult.HandshakeStatus.FINISHED
                && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {

            switch (hs) {

            case NEED_UNWRAP:
                // Receive handshaking data from peer
                if (socketChannel.read(peerNetData) < 0) {
                    // Handle closed channel
                }

                // Process incoming handshaking data
                peerNetData.flip();
                SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
                System.out.println("================uwrap===="
                        + res.getStatus());
                switch (res.getStatus()) {
                case BUFFER_OVERFLOW:

                    break;
                case BUFFER_UNDERFLOW:
                    break;
                default:
                    break;
                }
                peerNetData.compact();
                hs = res.getHandshakeStatus();
                System.out.println("================handl====" + hs);
                // Check status
                switch (res.getStatus()) {
                case OK:
                    // Handle OK status
                    break;

                // Handle other status: BUFFER_UNDERFLOW, BUFFER_OVERFLOW,
                // CLOSED
                // ...
                }
                break;

            case NEED_WRAP:
                // Empty the local network packet buffer.
                myNetData.clear();

                // Generate handshaking data
                res = engine.wrap(myAppData, myNetData);
                System.out.println("==========wrap===" + res.getStatus());
                hs = res.getHandshakeStatus();

                // Check status
                switch (res.getStatus()) {
                case OK:
                    myNetData.flip();

                    // Send the handshaking data to peer
                    while (myNetData.hasRemaining()) {
                        if (socketChannel.write(myNetData) < 0) {
                            // Handle closed channel
                        }
                    }
                    break;

                // Handle other status: BUFFER_OVERFLOW, BUFFER_UNDERFLOW,
                // CLOSED
                // ...
                }
                break;

            case NEED_TASK:
                Runnable task;
                while ((task = engine.getDelegatedTask()) != null) {
                    // task.run();
                    new Thread(task).start();
                }
                // System.out.println("===================");
                // Handle blocking tasks
                break;

            // Handle other status: // FINISHED or NOT_HANDSHAKING
            // ...
            }
        }

        // Processes after handshaking
        // ...
    }
}
