/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import clojure.lang.IFn;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.PrefixThreafFactory;
import me.shenfeng.http.server.ClojureRing;
import me.shenfeng.http.server.HttpRequest;
import me.shenfeng.http.server.IHandler;
import me.shenfeng.http.server.IListenableFuture;
import me.shenfeng.http.server.ResponseCallback;
import me.shenfeng.http.ws.CloseFrame;
import me.shenfeng.http.ws.TextFrame;
import me.shenfeng.http.ws.WSFrame;
import me.shenfeng.http.ws.WsCon;

public class RingHandler
implements IHandler {
    final ExecutorService execs;
    final IFn handler;

    public RingHandler(int thread, IFn handler, String prefix) {
        PrefixThreafFactory factory = new PrefixThreafFactory(prefix);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(386);
        this.execs = new ThreadPoolExecutor(thread, thread, 0L, TimeUnit.MILLISECONDS, queue, factory);
        this.handler = handler;
    }

    @Override
    public void handle(final HttpRequest req, final ResponseCallback cb) {
        this.execs.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Map resp = (Map)RingHandler.this.handler.invoke((Object)ClojureRing.buildRequestMap(req));
                    if (resp != null) {
                        final Map headers = (Map)resp.get(ClojureRing.HEADERS);
                        Object body = resp.get(ClojureRing.BODY);
                        final int status = ClojureRing.getStatus(resp);
                        if (body instanceof IListenableFuture) {
                            final IListenableFuture future = (IListenableFuture)body;
                            future.addListener(new Runnable(){

                                @Override
                                public void run() {
                                    Object r = future.get();
                                    if (r instanceof Map) {
                                        Map resp2 = (Map)r;
                                        Map headers2 = (Map)resp2.get(ClojureRing.HEADERS);
                                        int status2 = ClojureRing.getStatus(resp2);
                                        Object body2 = resp2.get(ClojureRing.BODY);
                                        cb.run(ClojureRing.encode(status2, headers2, body2));
                                    } else {
                                        cb.run(ClojureRing.encode(status, headers, r));
                                    }
                                }
                            });
                        } else {
                            cb.run(ClojureRing.encode(status, headers, body));
                        }
                    } else {
                        cb.run(ClojureRing.encode(404, null, null));
                    }
                }
                catch (Throwable e) {
                    cb.run(ClojureRing.encode(500, null, e.getMessage()));
                    HttpUtils.printError("ring handler", e);
                }
            }
        });
    }

    @Override
    public void close() {
        this.execs.shutdownNow();
    }

    @Override
    public void handle(final WsCon con, final WSFrame frame) {
        this.execs.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (frame instanceof TextFrame) {
                        con.messageRecieved(((TextFrame)frame).getText());
                    } else if (frame instanceof CloseFrame) {
                        con.clientClosed(((CloseFrame)frame).getStatus());
                    }
                }
                catch (Throwable e) {
                    HttpUtils.printError("handle websocket frame " + frame, e);
                }
            }
        });
    }
}

