/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.LineTooLargeException;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.client.ClientDecoderState;
import me.shenfeng.http.client.IRespListener;

public class ClientDecoder {
    private Map<String, String> headers = new TreeMap<String, String>();
    IRespListener listener;
    private static byte[] bodyBuffer = new byte[65536];
    byte[] lineBuffer = new byte[2048];
    int lineBufferCnt = 0;
    int readRemaining = 0;
    ClientDecoderState state = ClientDecoderState.READ_INITIAL;

    public ClientDecoder(IRespListener listener) {
        this.listener = listener;
    }

    private void parseInitialLine(String sb) throws ProtocolException {
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString(sb))) {
            int status = Integer.parseInt(sb.substring(bStart, bEnd));
            HttpStatus s = HttpStatus.valueOf(status);
            HttpVersion version = HttpVersion.HTTP_1_1;
            if ("HTTP/1.0".equals(sb.substring(aStart, cEnd))) {
                version = HttpVersion.HTTP_1_0;
            }
            this.state = this.listener.onInitialLineReceived(version, s) != -1 ? ClientDecoderState.READ_HEADER : ClientDecoderState.ABORTED;
        } else {
            throw new ProtocolException("not http prototol");
        }
    }

    public ClientDecoderState decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException {
        while (buffer.hasRemaining() && this.state != ClientDecoderState.ALL_READ && this.state != ClientDecoderState.ABORTED) {
            switch (this.state) {
                case READ_INITIAL: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.parseInitialLine(line);
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = ClientDecoderState.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.state = ClientDecoderState.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    int toRead = Math.min(buffer.remaining(), this.readRemaining);
                    buffer.get(bodyBuffer, 0, toRead);
                    if (this.listener.onBodyReceived(bodyBuffer, toRead) == -1) {
                        this.state = ClientDecoderState.ABORTED;
                        break;
                    }
                    this.readRemaining -= toRead;
                    if (this.readRemaining != 0) break;
                    this.state = ClientDecoderState.ALL_READ;
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    int toRead = Math.min(buffer.remaining(), this.readRemaining);
                    buffer.get(bodyBuffer, 0, toRead);
                    if (this.listener.onBodyReceived(bodyBuffer, toRead) == -1) {
                        this.state = ClientDecoderState.ABORTED;
                        break;
                    }
                    this.readRemaining -= toRead;
                    if (this.readRemaining != 0) break;
                    this.state = ClientDecoderState.READ_CHUNK_DELIMITER;
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.state = ClientDecoderState.ALL_READ;
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = ClientDecoderState.READ_CHUNK_SIZE;
                    break;
                }
                case READ_VARIABLE_LENGTH_CONTENT: {
                    int toRead = buffer.remaining();
                    buffer.get(bodyBuffer, 0, toRead);
                    if (this.listener.onBodyReceived(bodyBuffer, toRead) != -1) break;
                    this.state = ClientDecoderState.ABORTED;
                }
            }
        }
        return this.state;
    }

    public IRespListener getListener() {
        return this.listener;
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13) {
            buffer.get();
        }
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException {
        String line = this.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        if (this.listener.onHeadersReceived(this.headers) != -1) {
            String te = this.headers.get("Transfer-Encoding");
            if ("chunked".equals(te)) {
                this.state = ClientDecoderState.READ_CHUNK_SIZE;
            } else {
                String cl = this.headers.get("Content-Length");
                if (cl != null) {
                    this.readRemaining = Integer.parseInt(cl);
                    this.state = this.readRemaining == 0 ? ClientDecoderState.ALL_READ : ClientDecoderState.READ_FIXED_LENGTH_CONTENT;
                } else {
                    this.state = ClientDecoderState.READ_VARIABLE_LENGTH_CONTENT;
                }
            }
        } else {
            this.state = ClientDecoderState.ABORTED;
        }
    }

    String readLine(ByteBuffer buffer) throws LineTooLargeException {
        boolean more = true;
        while (buffer.hasRemaining() && more) {
            byte b = buffer.get();
            if (b == 13) {
                if (buffer.get() != 10) continue;
                more = false;
                continue;
            }
            if (b == 10) {
                more = false;
                continue;
            }
            this.lineBuffer[this.lineBufferCnt] = b;
            ++this.lineBufferCnt;
            if (this.lineBufferCnt < 2048) continue;
            throw new LineTooLargeException("exceed max line 2048");
        }
        String line = null;
        if (!more) {
            line = new String(this.lineBuffer, 0, this.lineBufferCnt);
            this.lineBufferCnt = 0;
        }
        return line;
    }

    public void reset() {
        this.headers.clear();
        this.state = ClientDecoderState.READ_INITIAL;
    }
}

