/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import me.shenfeng.http.client.HttpClient;
import me.shenfeng.http.client.HttpClientConfig;
import me.shenfeng.http.client.TextHandler;
import me.shenfeng.http.client.TextRespListener;
import org.junit.Before;
import org.junit.Test;

public class HttpClientTest {
    HttpClient client;
    Map<String, String> emptyHeader;
    Proxy socksProxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", 3128));

    public HttpClientTest() throws IOException {
        String userAgent = "Mozilla/5.0 (compatible; Rssminer/1.0; +http://rssminer.net)";
        HttpClientConfig cfg = new HttpClientConfig(45000, userAgent);
        this.client = new HttpClient(cfg);
    }

    @Before
    public void setup() throws IOException {
        this.emptyHeader = new TreeMap<String, String>();
    }

    @Test
    public void testGetpythonServer() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://wiki.nginx.org/Main"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(4000L, TimeUnit.SECONDS));
    }

    @Test
    public void testSocksProxy() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://feeds2.feedburner.com/dwahlin"), this.emptyHeader, this.socksProxy, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(4000L, TimeUnit.SECONDS));
    }

    @Test
    public void testGetGzipped() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://en.wikipedia.org/wiki/HTTP"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(1000L, TimeUnit.SECONDS));
    }

    @Test
    public void testDecodeSinaGzipped() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://www.sina.com.cn/"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(4L, TimeUnit.SECONDS));
    }

    @Test
    public void testAprotocolException() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://weblogs.asp.net/scottgu/rss.aspx"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(400L, TimeUnit.SECONDS));
    }

    @Test
    public void testDecodeNoLength() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://127.0.0.1:8089"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(4L, TimeUnit.SECONDS));
    }

    @Test
    public void testProtocolException() throws UnknownHostException, URISyntaxException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(1);
        this.client.get(new URI("http://127.0.0.1:8089"), this.emptyHeader, Proxy.NO_PROXY, new TextRespListener(new TextHandler(cd)));
        Assert.assertTrue((boolean)cd.await(400L, TimeUnit.SECONDS));
    }
}

